$ def := define/system/exec/nolog
$ def samba_exe samba_root:[bin.'f$getsyi("ARCH_NAME")'],samba_root:[bin]
$ s = f$trnlnm("samba_root") - ".]" + "]"
$ def samba_crtl samba_exe:decc_crtl.exe
$ def samba_log 's'
$!
$! Special VMS options
$!
$!	SAMBA_SWAP_FILE_TIMES
$!
$!		If present, swap VMS Creation Time and VMS Modification Time
$!		when presenting them to the client.
$!
$!	SAMBA_ALTERNATE_DIRECTORY_PROTECTION
$!
$!		If present, ignore VMS directory protection policy and
$!		unconditionally use samba specific settings from SMB.CONF
$!		This allows directories created with Delete-bit set.
$!
$!	SAMBA_FILESPEC_ENCODE
$!
$!		Controls encoding of file specification:
$!
$!		0 or CHECK	- no encoding if EFS is present (ODS5)
$!				  not possible on VAX or VMS before V7.2
$!				  default on Alpha
$!		1 or ALWAYS	- always use encoding
$!				  default on VAX
$!		2 or NEVER	- never use encoding (disks must be ODS5)
$!
$!	SAMBA_CASE_ENCODE
$!
$!		If present, case is encoded in the filespec so that it is
$!		preserved as seen by the client.
$!
$!	SAMBA_SMBD_OPTIONS
$!
$!		Option to any SMBD process (in UNIX format, so enclose in
$!		double quotes).
$!
$ def samba_swap_file_times 1
$ def samba_alternate_directory_protection 1
$ def samba_smbd_options "-d1"
$!$ def samba_case_encode 1
$!
$! Note that no SMBD daemon process is started. SMBD processes are
$! started on client request for each session via TCP/IP's server
$! (like UNIX inetd).
$!
$! Start NMBD
$!
$ run/detached -
	/input=samba_exe:nmbd_startup.com -
	/output=samba_root:[var]nmbd_startup.log -
	/uic=system -
	/process_name=NMBD -
	sys$system:loginout.exe
