/* 
   Unix SMB/Netbios implementation.
   Version 2.0.
   Copyright (C) Andrew Tridgell 1994-1999

   This file is part of the port to OpenVMS
   Routines to set user environment
   Copyright (C) Eckart Meyer 1996-1999
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*	setuid.c
 *	V2.0			16-Mar-1999		IfN/Mey
 *
 *	Copyright E. Meyer <meyer@ifn.ing.tu-bs.de>
 *
 *	This module only contains the entry points of setuid() and seteuid()
 *	and the call to the kernel mode macro code to actually set
 *	username and uic. All other code is in PWD.C where all the data
 *	structures are defined. This way, this module and the kernel code
 *	is only forced into the image if setuid() or seteuid() is really
 *	needed.
 *+
 * Setting the UID in VMS involves:
 *
 *	- setting process and job UIC to that value
 *	- setting process username to the corresponding user
 *	- setting user's privileges
 *	- setting user's rights identifiers
 *-
 */

#include <types.h>
#include <ssdef.h>
#include <starlet.h>
#include <string.h>

int vms_setuid_1(uid_t uid, char **new_username, uid_t *new_uid);
int vms_setuid_2();
long sys_set_username(void *);		/* These are the ... */
long sys_set_uic(unsigned int *);	/* ...kernel hacking routines */




/****************************************************************************
 setuid - set user
 ***************************************************************************/
int vms_setuid(uid_t uid)
{
	int st;
	uid_t new_uid;
	char *new_username;
	struct {
		int size;
		char *ptr;
	} userdesc;

	st = vms_setuid_1(uid, &new_username, &new_uid);
	if (st <= 0) return(st);
/*
 *	- set username/uic - this is kernel mode hacking!
 */
	userdesc.size = strlen(new_username);
	userdesc.ptr  = new_username;
	st = sys_set_username(&userdesc);
	if (st != SS$_NORMAL) return(-1);
	st = sys_set_uic(&new_uid); /* do this after $GRANTID */
	if (st != SS$_NORMAL) return(-1);

	return(vms_setuid_2());
}




/****************************************************************************
 seteuid - dummy
 ***************************************************************************/
int vms_seteuid(gid_t uid)
{
	return(vms_setuid(uid));
}
