/*
 *  Versioner 2 Development Code
 *  Copyright (C) 1999 Kirby Kuehl (vacuum@technotronic.com)
 *
 *  Link with kernel32.lib version.lib user32.lib 
 *
 *  The MD5 portion of this code is based of code that is  
 *  Copyright (C) 1990-2, RSA Data Security, Inc. Created 1990. All
 *  rights reserved.
 *
 *  RSA Data Security, Inc. makes no representations concerning either
 *  the merchantability of this software or the suitability of this
 *  software for any particular purpose. It is provided "as is"
 *  without express or implied warranty of any kind.
 *
 *  These notices must be retained in any copies of any part of this
 *  documentation and/or software.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */	  



#include <stdio.h>
#include <time.h>
#include <string.h>
#include <iostream.h> 
#include <windows.h>
#include <shlwapi.h>

#define VERSION "Versioner 0.5"

// Taken from global.h and refined.
#define PROTOTYPES 0

/* POINTER defines a generic pointer type */
typedef unsigned char *POINTER;

/* UINT2 defines a two byte word */
typedef unsigned short int UINT2;

/* UINT4 defines a four byte word */
typedef unsigned long int UINT4;

typedef HRESULT CALLBACK DllGetVersion(DLLVERSIONINFO *dvi);


/* PROTO_LIST is defined depending on how PROTOTYPES is defined above.
If using PROTOTYPES, then PROTO_LIST returns the list, otherwise it
returns an empty list.
*/
#define PROTO_LIST(list) list

/* Constants for MD5Transform routine.
 */


#define S11 7
#define S12 12
#define S13 17
#define S14 22
#define S21 5
#define S22 9
#define S23 14
#define S24 20
#define S31 4
#define S32 11
#define S33 16
#define S34 23
#define S41 6
#define S42 10
#define S43 15
#define S44 21


/* Length of test block, number of test blocks.
 */
#define TEST_BLOCK_LEN 1000
#define TEST_BLOCK_COUNT 1000

static void MDFile (char *, FILE *);
static void MDFilter PROTO_LIST ((void));
static void MDPrint (unsigned char [16], FILE *);


#define MD5_CTX MD5_CTX
#define MDInit MD5Init
#define MDUpdate MD5Update
#define MDFinal MD5Final

typedef struct {
  UINT4 state[4];                                   /* state (ABCD) */
  UINT4 count[2];        /* number of bits, modulo 2^64 (lsb first) */
  unsigned char buffer[64];                         /* input buffer */
} MD5_CTX;

void MD5Init PROTO_LIST ((MD5_CTX *));
void MD5Update PROTO_LIST
  ((MD5_CTX *, unsigned char *, unsigned int));
void MD5Final PROTO_LIST ((unsigned char [16], MD5_CTX *));


static void MD5Transform PROTO_LIST ((UINT4 [4], unsigned char [64]));
static void Encode PROTO_LIST ((unsigned char *, UINT4 *, unsigned int));
static void Decode PROTO_LIST ((UINT4 *, unsigned char *, unsigned int));
static void MD5_memcpy PROTO_LIST ((POINTER, POINTER, unsigned int));
static void MD5_memset PROTO_LIST ((POINTER, int, unsigned int));

static unsigned char PADDING[64] = {
  0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

/* F, G, H and I are basic MD5 functions.
 */
#define F(x, y, z) (((x) & (y)) | ((~x) & (z)))
#define G(x, y, z) (((x) & (z)) | ((y) & (~z)))
#define H(x, y, z) ((x) ^ (y) ^ (z))
#define I(x, y, z) ((y) ^ ((x) | (~z)))

/* ROTATE_LEFT rotates x left n bits.
 */
#define ROTATE_LEFT(x, n) (((x) << (n)) | ((x) >> (32-(n))))

/* FF, GG, HH, and II transformations for rounds 1, 2, 3, and 4.
Rotation is separate from addition to prevent recomputation.
 */
#define FF(a, b, c, d, x, s, ac) { \
 (a) += F ((b), (c), (d)) + (x) + (UINT4)(ac); \
 (a) = ROTATE_LEFT ((a), (s)); \
 (a) += (b); \
  }
#define GG(a, b, c, d, x, s, ac) { \
 (a) += G ((b), (c), (d)) + (x) + (UINT4)(ac); \
 (a) = ROTATE_LEFT ((a), (s)); \
 (a) += (b); \
  }
#define HH(a, b, c, d, x, s, ac) { \
 (a) += H ((b), (c), (d)) + (x) + (UINT4)(ac); \
 (a) = ROTATE_LEFT ((a), (s)); \
 (a) += (b); \
  }
#define II(a, b, c, d, x, s, ac) { \
 (a) += I ((b), (c), (d)) + (x) + (UINT4)(ac); \
 (a) = ROTATE_LEFT ((a), (s)); \
 (a) += (b); \
  }






// prints information about a file in text format

void PrintFindData(FILE *stream, FILE *stream2, WIN32_FIND_DATA *findData, char *dirName)
{	
  FILETIME ft;
  SYSTEMTIME st;
  DWORD   dwVerInfoSize;        
  DWORD   dwVerHnd=0;
  BOOL    bRetCode;
  LPSTR   lpBuffer;
  UINT*    dwBytes = new UINT;
  char *fileName;
  char fullName[256];
  char *name;
  // int ret;

  if(!GetFullPathName(findData->cFileName,
                      256,
					  fullName,
					  &fileName))
					  // return;
    	
  
  fprintf(stream, "__________________________________________________________________________\n");
  printf("%s\n",fullName);
  fprintf(stream, "Filename: %s\nSize: %d bytes\n",fullName, findData->nFileSizeLow);
  fprintf(stream2, "%s, %d, ",fullName, findData->nFileSizeLow);
    // ftCreation Time
    FileTimeToLocalFileTime(&findData->ftCreationTime, &ft);
	FileTimeToSystemTime(&ft, &st);
	fprintf(stream, "Creation Time: %d/%d/%d %d:%d\n", st.wMonth, st.wDay, st.wYear, st.wHour, st.wMinute);
    fprintf(stream2, "%d/%d/%d %d:%d, ", st.wMonth, st.wDay, st.wYear, st.wHour, st.wMinute);
	// ftLastAccessTime
	FileTimeToLocalFileTime(&findData->ftLastAccessTime , &ft);
	FileTimeToSystemTime(&ft, &st);
	fprintf(stream, "Last Access Time: %d/%d/%d %d:%d\n", st.wMonth, st.wDay, st.wYear, st.wHour, st.wMinute);
    fprintf(stream2, "%d/%d/%d %d:%d, ", st.wMonth, st.wDay, st.wYear, st.wHour, st.wMinute);
	// ftLastWriteTime 
	FileTimeToLocalFileTime(&findData->ftLastWriteTime, &ft);
	FileTimeToSystemTime(&ft, &st);
    fprintf(stream, "Last Write Time: %d/%d/%d %d:%d\n", st.wMonth, st.wDay, st.wYear, st.wHour, st.wMinute);
    fprintf(stream2, "%d/%d/%d %d:%d, ", st.wMonth, st.wDay, st.wYear, st.wHour, st.wMinute);


	dwVerInfoSize = GetFileVersionInfoSize(findData->cFileName, &dwVerHnd);
	if (dwVerInfoSize)
	{
		 LPTSTR   lpstrVffInfo;
		 VS_FIXEDFILEINFO* pinfo;	
		 
		 HANDLE  hMem;
            hMem = GlobalAlloc(GMEM_MOVEABLE, dwVerInfoSize);
            lpstrVffInfo  = (char *)GlobalLock(hMem);
            GetFileVersionInfo(findData->cFileName, dwVerHnd, dwVerInfoSize, lpstrVffInfo);

                 
			// Company Name
			bRetCode = VerQueryValue((LPVOID)lpstrVffInfo,
                TEXT("\\StringFileInfo\\040904E4\\CompanyName"),
                (LPVOID *)&lpBuffer,                dwBytes);
            if(bRetCode)
            {
                fprintf(stream, "Company Name: %s\n",lpBuffer);
				fprintf(stream2, "%s, ",lpBuffer);
            }
			else
			{
				fprintf(stream, "Company Name:\n");
				fprintf(stream2,", ");
			}

			// File Description		
			bRetCode = VerQueryValue((LPVOID)lpstrVffInfo, 
              TEXT("\\StringFileInfo\\040904E4\\FileDescription"), 
              (LPVOID *)&lpBuffer, dwBytes);
			if(bRetCode)
            {
                fprintf(stream, "File Description: %s\n",lpBuffer);
			    fprintf(stream2, "%s, ",lpBuffer);
			}
			else
			{
			fprintf(stream, "File Description: \n");
			fprintf(stream2, ", ");
			}
			
			// File Version
			bRetCode = VerQueryValue((LPVOID)lpstrVffInfo,	// address of buffer for version resource
									"\\",				    // address of value to retrieve, "\\" = Get it all
									(void**)&pinfo,         // address of buffer for version value pointer
									dwBytes					// address of length buffer
									);

            if(bRetCode)
				{
					//pinfo structure(VS_FIXEDFILEINFO) contains everything you need to know
					//type pinfo-> to see it all
					//version info is stored like this:
					//if the version is: 8.4.3.2 
					// 0x00080004 = dwFileVersionMS
					// 0x00030002 = dwFileVersionLS

			
				
				// FileVersion
				    WORD A,B,C,D;
					A = static_cast<WORD>((pinfo->dwFileVersionMS  & 0xffff0000) >> 16);
					B = static_cast<WORD>(pinfo->dwFileVersionMS & 0x0000ffff);
					C = static_cast<WORD>((pinfo->dwFileVersionLS & 0xffff0000) >> 16);
					D = static_cast<WORD>(pinfo->dwFileVersionLS & 0x0000ffff);
			  
					fprintf(stream, "FileVersion:  %d.%d.%d.%d",A,B,C,D);
				    fprintf(stream2, " %d.%d.%d.%d ,",A,B,C,D);


			}
            else
			{
					fprintf(stream, "FileVersion: \n");
					fprintf(stream2, ", ");
			}

			// Internal Name
            bRetCode = VerQueryValue((LPVOID)lpstrVffInfo,
				TEXT("\\StringFileInfo\\040904E4\\InternalName"),
				(LPVOID *)&lpBuffer , dwBytes);

            if(bRetCode)
			{
				fprintf(stream, "InternalName: %s\n",lpBuffer);
				fprintf(stream2, "%s, ", lpBuffer);
			}
			else
			{
				fprintf(stream, "InternalName: \n");
				fprintf(stream2, ", ");
			}
            // LegalCopyright
			bRetCode = VerQueryValue((LPVOID)lpstrVffInfo,
				TEXT("\\StringFileInfo\\040904E4\\LegalCopyright"),
				(LPVOID *)&lpBuffer , dwBytes);

            if(bRetCode)
			{
				fprintf(stream, "LegalCopyright: %s\n",lpBuffer);
				fprintf(stream2, "%s, ", lpBuffer);
			}
			else
			{
	            fprintf(stream, "LegalCopyright:\n");
				fprintf(stream2, ", ");
			}
			// OriginalFilename 

			bRetCode = VerQueryValue((LPVOID)lpstrVffInfo,
				TEXT("\\StringFileInfo\\040904E4\\OriginalFilename"),
				(LPVOID *)&lpBuffer , dwBytes);

            if(bRetCode)
			{
				fprintf(stream, "OriginalFilename: %s\n",lpBuffer);
				fprintf(stream2, "%s, ", lpBuffer);
			}
			else
			{
				fprintf(stream, "OriginalFilename: \n");
				fprintf(stream2, ", ");
			}
				// ProductName 

			bRetCode = VerQueryValue((LPVOID)lpstrVffInfo,
				TEXT("\\StringFileInfo\\040904E4\\ProductName"),
				(LPVOID *)&lpBuffer , dwBytes);
			
            if(bRetCode)
			{
				fprintf(stream, "ProductName: %s\n",lpBuffer);
				fprintf(stream2, "%s, ", lpBuffer);
			}
			else
			{
				fprintf(stream, "ProductName: \n");
				fprintf(stream2, ", ");
			}
			// ProductVersion
			bRetCode = VerQueryValue((LPVOID)lpstrVffInfo,
				TEXT("\\StringFileInfo\\040904E4\\ProductVersion"),
				(LPVOID *)&lpBuffer , dwBytes);

            if(bRetCode)
			{
				fprintf(stream, "ProductVersion: %s\n",lpBuffer);
				fprintf(stream2, "%s, ", lpBuffer);
			}
			else
			{
				fprintf(stream, "ProductVersion: \n");
				fprintf(stream2, ", ");
			}
            // Comments
			            
            bRetCode = VerQueryValue((LPVOID)lpstrVffInfo,
                TEXT("\\StringFileInfo\\040904E4\\Comments"),
                (LPVOID *)&lpBuffer,                dwBytes);
            if(bRetCode)
            {
                fprintf(stream, "Comments: %s\n",lpBuffer);
				fprintf(stream2, "%s, ",lpBuffer);
			}
			else
			{
				fprintf(stream, "Comments: \n");
				fprintf(stream2, ", ");
			}
			// LegalTrademarks 
	        
			bRetCode = VerQueryValue((LPVOID)lpstrVffInfo,
                TEXT("\\StringFileInfo\\040904E4\\LegalTrademarks"),
                (LPVOID *)&lpBuffer,                dwBytes);
            if(bRetCode)
            {
             	fprintf(stream, "LegalTrademarks: %s\n",lpBuffer);
				fprintf(stream2, "%s, ", lpBuffer);
			}
			else
			{
				fprintf(stream, "LegalTrademarks: \n");
				fprintf(stream2, ", ");
			}
			// PrivateBuild 
	
			bRetCode = VerQueryValue((LPVOID)lpstrVffInfo,
                TEXT("\\StringFileInfo\\040904E4\\PrivateBuild"),
                (LPVOID *)&lpBuffer,                dwBytes);
            if(bRetCode)
            {
             	fprintf(stream, "PrivateBuild: %s\n",lpBuffer);
				fprintf(stream2, "%s, ", lpBuffer);
			}
			else
			{
				fprintf(stream, "PrivateBuild: \n");
				fprintf(stream2, ", ");
			}
			// SpecialBuild 
			bRetCode = VerQueryValue((LPVOID)lpstrVffInfo,
                TEXT("\\StringFileInfo\\040904E4\\SpecialBuild"),
                (LPVOID *)&lpBuffer,                dwBytes);
            if(bRetCode)
            {
             	fprintf(stream, "SpecialBuild: %s\n",lpBuffer);
				fprintf(stream2, "%s, ", lpBuffer);
			}
		    else
			{
				fprintf(stream, "SpecialBuild: \n");
				fprintf(stream2, ", ");
			}

  
			name = fullName;
			
			
			MDFile(name, stream);
			MDFile(name, stream2);
			fprintf(stream, "\n");
			fprintf(stream2, "\n");
			return; 
	}
	else
		fprintf(stream2, ", , , , , , , , , , , , ");

			fprintf (stream, "MD5 Hash: ");	
	        name = fullName;
  			MDFile(name, stream);
			MDFile(name, stream2);
			fprintf(stream, "\n\n");
			fprintf(stream2, "\n");



}



// Recursively lists directories

void ListDirectoryContents(FILE *stream, FILE *stream2, char *dirName, char *fileMask)

{

	char curDir[ 256 ];

	char printDir[ 256 ];

	HANDLE fileHandle;

	WIN32_FIND_DATA findData;



	// save current dir so it can restore it

	if( !GetCurrentDirectory( 256, curDir) ) 

		return;

	

	// if the directory name is neither . or .. then

	// change to it, otherwise ignore it

	if( strcmp( dirName, "." ) && 

		strcmp( dirName, ".." ) )

	{

		if( !SetCurrentDirectory( dirName ) ) 

			return;

		if( !GetCurrentDirectory( 256, printDir) ) 

			return;

	}

	else 

		return;



	// Loop through all files looking for 

	// the file name of interest.

	fileHandle = FindFirstFile( fileMask, 

		&findData );

	while ( fileHandle != INVALID_HANDLE_VALUE )

	{

		PrintFindData(stream, stream2, &findData, printDir );
  		// loop thru remaining entries in the dir

		if (!FindNextFile( fileHandle, &findData ))

			break;

 	}

	FindClose( fileHandle );



	// Loop through all files in the directory

	// looking for other directories

	fileHandle = FindFirstFile( "*.*", 

		&findData );

	while ( fileHandle != INVALID_HANDLE_VALUE )

	{

		// If the name is a directory,

		// recursively walk it. 

		if( findData.dwFileAttributes &

			FILE_ATTRIBUTE_DIRECTORY )

		{

			ListDirectoryContents(stream, stream2, findData.cFileName, fileMask );

		}

  		// loop thru remaining entries in the dir

		if (!FindNextFile( fileHandle, &findData ))

			break;

 	}

	

	// clean up and restore directory

	FindClose( fileHandle );

	SetCurrentDirectory( curDir );

}



int main(int argc, char *argv[])
{
    char *curDir, *findName, *output, *csv;
	FILE *stream, *stream2;
	if (argc!=5)
	{
	printf("\nusage : %s <starting directory> <filemask> <output.txt> <output.csv>\n\n",VERSION);
	printf("vacuum@technotronic.com\n");
	exit(0);
	}
	curDir = argv[1];
	findName = argv[2];
	output = argv[3];
	csv = argv[4];

	if( (stream = fopen(output, "w" )) == NULL ) 
    printf( "The file '%s' was not opened\n",output), exit(-1);

	if( (stream2 = fopen(csv, "w" )) == NULL ) 
    printf( "The file '%s' was not opened\n",csv), exit(-1);

	// CVS Headings
  fprintf(stream2, "Filename:, Size:, Creation Time:, Last Access Time:, Last Write Time:, ");
  fprintf(stream2, "Company Name:, File Description:, File Version:, Internal Name:, Legal Copyright:, ");
  fprintf(stream2, "Original File Name:, Product Name:, Product Version:, Comments:, Legal Trademark:, ");
  fprintf(stream2, "Private Build:, Special Build:, MD5 Hash:\n");

 if (!SetCurrentDirectory(curDir))
	{
		printf("Couldn't get the starting directory.\n");
		return(-1);
	}
 else
 {
	ListDirectoryContents(stream, stream2, curDir, findName);
	
}	
   fclose(stream);
   fclose(stream2);
	return(0);
}


// Start MD5 routines.

/* MD5 initialization. Begins an MD5 operation, writing a new context.
 */
void MD5Init (MD5_CTX *context)
                                       /* context */
{
  context->count[0] = context->count[1] = 0;
  /* Load magic initialization constants.
*/
  context->state[0] = 0x67452301;
  context->state[1] = 0xefcdab89;
  context->state[2] = 0x98badcfe;
  context->state[3] = 0x10325476;
}

/* MD5 block update operation. Continues an MD5 message-digest
  operation, processing another message block, and updating the
  context.
 */
void MD5Update (MD5_CTX *context, unsigned char *input, unsigned int inputLen)                   /* length of input block */
{
  unsigned int i, index, partLen;

  /* Compute number of bytes mod 64 */
  index = (unsigned int)((context->count[0] >> 3) & 0x3F);

  /* Update number of bits */
  if ((context->count[0] += ((UINT4)inputLen << 3))
   < ((UINT4)inputLen << 3))
 context->count[1]++;
  context->count[1] += ((UINT4)inputLen >> 29);

  partLen = 64 - index;

  /* Transform as many times as possible.
*/
  if (inputLen >= partLen) {
 MD5_memcpy
   ((POINTER)&context->buffer[index], (POINTER)input, partLen);
 MD5Transform (context->state, context->buffer);

 for (i = partLen; i + 63 < inputLen; i += 64)
   MD5Transform (context->state, &input[i]);

 index = 0;
  }
  else
 i = 0;

  /* Buffer remaining input */
  MD5_memcpy
 ((POINTER)&context->buffer[index], (POINTER)&input[i],
  inputLen-i);
}

/* MD5 finalization. Ends an MD5 message-digest operation, writing the
  the message digest and zeroizing the context.
 */
void MD5Final (unsigned char digest[16], MD5_CTX *context)
{
  unsigned char bits[8];
  unsigned int index, padLen;

  /* Save number of bits */
  Encode (bits, context->count, 8);

  /* Pad out to 56 mod 64.
*/
  index = (unsigned int)((context->count[0] >> 3) & 0x3f);
  padLen = (index < 56) ? (56 - index) : (120 - index);
  MD5Update (context, PADDING, padLen);

  /* Append length (before padding) */
  MD5Update (context, bits, 8);

  /* Store state in digest */
  Encode (digest, context->state, 16);

  /* Zeroize sensitive information.
*/
  MD5_memset ((POINTER)context, 0, sizeof (*context));
}

/* MD5 basic transformation. Transforms state based on block.
 */
static void MD5Transform (UINT4 state[4], unsigned char block[64])
{
  UINT4 a = state[0], b = state[1], c = state[2], d = state[3], x[16];

  Decode (x, block, 64);

  /* Round 1 */
  FF (a, b, c, d, x[ 0], S11, 0xd76aa478); /* 1 */
  FF (d, a, b, c, x[ 1], S12, 0xe8c7b756); /* 2 */
  FF (c, d, a, b, x[ 2], S13, 0x242070db); /* 3 */
  FF (b, c, d, a, x[ 3], S14, 0xc1bdceee); /* 4 */
  FF (a, b, c, d, x[ 4], S11, 0xf57c0faf); /* 5 */
  FF (d, a, b, c, x[ 5], S12, 0x4787c62a); /* 6 */
  FF (c, d, a, b, x[ 6], S13, 0xa8304613); /* 7 */
  FF (b, c, d, a, x[ 7], S14, 0xfd469501); /* 8 */
  FF (a, b, c, d, x[ 8], S11, 0x698098d8); /* 9 */
  FF (d, a, b, c, x[ 9], S12, 0x8b44f7af); /* 10 */
  FF (c, d, a, b, x[10], S13, 0xffff5bb1); /* 11 */
  FF (b, c, d, a, x[11], S14, 0x895cd7be); /* 12 */
  FF (a, b, c, d, x[12], S11, 0x6b901122); /* 13 */
  FF (d, a, b, c, x[13], S12, 0xfd987193); /* 14 */
  FF (c, d, a, b, x[14], S13, 0xa679438e); /* 15 */
  FF (b, c, d, a, x[15], S14, 0x49b40821); /* 16 */

 /* Round 2 */
  GG (a, b, c, d, x[ 1], S21, 0xf61e2562); /* 17 */
  GG (d, a, b, c, x[ 6], S22, 0xc040b340); /* 18 */
  GG (c, d, a, b, x[11], S23, 0x265e5a51); /* 19 */
  GG (b, c, d, a, x[ 0], S24, 0xe9b6c7aa); /* 20 */
  GG (a, b, c, d, x[ 5], S21, 0xd62f105d); /* 21 */
  GG (d, a, b, c, x[10], S22,  0x2441453); /* 22 */
  GG (c, d, a, b, x[15], S23, 0xd8a1e681); /* 23 */
  GG (b, c, d, a, x[ 4], S24, 0xe7d3fbc8); /* 24 */
  GG (a, b, c, d, x[ 9], S21, 0x21e1cde6); /* 25 */
  GG (d, a, b, c, x[14], S22, 0xc33707d6); /* 26 */
  GG (c, d, a, b, x[ 3], S23, 0xf4d50d87); /* 27 */
  GG (b, c, d, a, x[ 8], S24, 0x455a14ed); /* 28 */
  GG (a, b, c, d, x[13], S21, 0xa9e3e905); /* 29 */
  GG (d, a, b, c, x[ 2], S22, 0xfcefa3f8); /* 30 */
  GG (c, d, a, b, x[ 7], S23, 0x676f02d9); /* 31 */
  GG (b, c, d, a, x[12], S24, 0x8d2a4c8a); /* 32 */

  /* Round 3 */
  HH (a, b, c, d, x[ 5], S31, 0xfffa3942); /* 33 */
  HH (d, a, b, c, x[ 8], S32, 0x8771f681); /* 34 */
  HH (c, d, a, b, x[11], S33, 0x6d9d6122); /* 35 */
  HH (b, c, d, a, x[14], S34, 0xfde5380c); /* 36 */
  HH (a, b, c, d, x[ 1], S31, 0xa4beea44); /* 37 */
  HH (d, a, b, c, x[ 4], S32, 0x4bdecfa9); /* 38 */
  HH (c, d, a, b, x[ 7], S33, 0xf6bb4b60); /* 39 */
  HH (b, c, d, a, x[10], S34, 0xbebfbc70); /* 40 */
  HH (a, b, c, d, x[13], S31, 0x289b7ec6); /* 41 */
  HH (d, a, b, c, x[ 0], S32, 0xeaa127fa); /* 42 */
  HH (c, d, a, b, x[ 3], S33, 0xd4ef3085); /* 43 */
  HH (b, c, d, a, x[ 6], S34,  0x4881d05); /* 44 */
  HH (a, b, c, d, x[ 9], S31, 0xd9d4d039); /* 45 */
  HH (d, a, b, c, x[12], S32, 0xe6db99e5); /* 46 */
  HH (c, d, a, b, x[15], S33, 0x1fa27cf8); /* 47 */
  HH (b, c, d, a, x[ 2], S34, 0xc4ac5665); /* 48 */

  /* Round 4 */
  II (a, b, c, d, x[ 0], S41, 0xf4292244); /* 49 */
  II (d, a, b, c, x[ 7], S42, 0x432aff97); /* 50 */
  II (c, d, a, b, x[14], S43, 0xab9423a7); /* 51 */
  II (b, c, d, a, x[ 5], S44, 0xfc93a039); /* 52 */
  II (a, b, c, d, x[12], S41, 0x655b59c3); /* 53 */
  II (d, a, b, c, x[ 3], S42, 0x8f0ccc92); /* 54 */
  II (c, d, a, b, x[10], S43, 0xffeff47d); /* 55 */
  II (b, c, d, a, x[ 1], S44, 0x85845dd1); /* 56 */
  II (a, b, c, d, x[ 8], S41, 0x6fa87e4f); /* 57 */
  II (d, a, b, c, x[15], S42, 0xfe2ce6e0); /* 58 */
  II (c, d, a, b, x[ 6], S43, 0xa3014314); /* 59 */
  II (b, c, d, a, x[13], S44, 0x4e0811a1); /* 60 */
  II (a, b, c, d, x[ 4], S41, 0xf7537e82); /* 61 */
  II (d, a, b, c, x[11], S42, 0xbd3af235); /* 62 */
  II (c, d, a, b, x[ 2], S43, 0x2ad7d2bb); /* 63 */
  II (b, c, d, a, x[ 9], S44, 0xeb86d391); /* 64 */

  state[0] += a;
  state[1] += b;
  state[2] += c;
  state[3] += d;

  /* Zeroize sensitive information.
   */
  MD5_memset ((POINTER)x, 0, sizeof (x));
}

/* Encodes input (UINT4) into output (unsigned char). Assumes len is
  a multiple of 4.
 */
static void Encode (unsigned char *output, UINT4 *input, unsigned int len)
{
  unsigned int i, j;

  for (i = 0, j = 0; j < len; i++, j += 4) {
 output[j] = (unsigned char)(input[i] & 0xff);
 output[j+1] = (unsigned char)((input[i] >> 8) & 0xff);
 output[j+2] = (unsigned char)((input[i] >> 16) & 0xff);
 output[j+3] = (unsigned char)((input[i] >> 24) & 0xff);
  }
}

/* Decodes input (unsigned char) into output (UINT4). Assumes len is
  a multiple of 4.
 */
static void Decode (UINT4 *output, unsigned char *input, unsigned int len)
{
  unsigned int i, j;

  for (i = 0, j = 0; j < len; i++, j += 4)
 output[i] = ((UINT4)input[j]) | (((UINT4)input[j+1]) << 8) |
   (((UINT4)input[j+2]) << 16) | (((UINT4)input[j+3]) << 24);
}

/* Note: Replace "for loop" with standard memcpy if possible.
 */

static void MD5_memcpy (POINTER output, POINTER input, unsigned int len)
{
  unsigned int i;

  for (i = 0; i < len; i++)
    output[i] = input[i];
}

/* Note: Replace "for loop" with standard memset if possible.
 */
static void MD5_memset (POINTER output, int value, unsigned int len)
{
  unsigned int i;

  for (i = 0; i < len; i++)
 ((char *)output)[i] = (char)value;
}

/* Digests a file and prints the result.
 */
//static void MDFile (char *filename)
static void MDFile (char *filename, FILE *stream)
{
  FILE *file;
  MD5_CTX context;
  int len;
  unsigned char buffer[1024], digest[16];

  if ((file = fopen (filename, "rb")) == NULL)
 // printf ("%s can't be opened\n", filename);
  return;
  else {
 MDInit (&context);
 while (len = fread (buffer, 1, 1024, file))
   MDUpdate (&context, buffer, len);
 MDFinal (digest, &context);

 fclose (file);

 //printf ("MD5(%s) = ", filename);
 MDPrint (digest, stream);
 // printf ("\n");
  }
}

/* Prints a message digest in hexadecimal.
 */

//static void MDPrint (unsigned char digest[16])
static void MDPrint (unsigned char digest[16], FILE *stream)
{

  unsigned int i;

  
  for (i = 0; i < 16; i++){
 // printf ("%02x", digest[i]);
 fprintf (stream, "%02x", digest[i]);
  }
}

