# A VMS MMS description file to build the pcal program.
# This has been tested with VAX OpenVMS v5.5-2 & VAX C v3.2-044
# and with Alpha OpenVMS v6.2 & DEC C v5.2-3.
#
# Written by: Rick Dyson (richard-dyson@uiowa.edu) for pcal v4.5
#              6-OCT-1994 
#             27-DEC-1996 updated for v4.6
#             31-JUL-1997 updated for v4.7
#              4-JAN-2000 updated for v4.8
#
# To use this 'makefile' on a  VAX, type
#           MMS /Macro = (VAX=1)
#
# To use this 'makefile' on an Alpha, just type
#           MMS 
#
# To build the TMJD version, execute the following sequence:
#           MMS 
#           MMS Clean
#           MMS /Macro = (TMJD=1)

.ifdef TMJD
DEFS = /Define = ("TIMEZONE=""6 [Iowa City]""", EPS, TMJD)
EXE = pcal_tmjd.exe
.else
DEFS = /Define = ("TIMEZONE=""6 [Iowa City]""", EPS)
EXE = pcal.exe
.endif

.ifdef VAX
CFLAGS	= $(CFLAGS) $(DEFS) /NoList /Optimize /NoDebug
OPTS	= ,VAXCRTL.OPT /Option
.else
CFLAGS	= $(CFLAGS) $(DEFS) /NoList /Optimize /NoDebug /Standard = VAXC
OPTS	= 
.endif

OBJECTS = exprpars.obj moonphas.obj pcalutil.obj readfile.obj writefil.obj
OBJLIST = exprpars,moonphas,pcalutil,readfile,writefil

.last
	@- Set Message /Facility /Severity /Identification /Text

pcal :	$(EXE) pcal.hlb
	@ !
.ifdef TMJD
	@ Write Sys$Output "pcal (v4.8-tmjd) is now ready for use.  Use @setup to define variables"
.else
	@ Write Sys$Output "pcal (v4.8) is now ready for use.  Use @setup to define variables"
.endif

help :	pcal.hlb
	@ !

pcal_tmjd.exe :	pcal.obj $(OBJECTS) pcalinit.h
	$(LINK) $(LINKFLAGS) pcal,$(OBJLIST)$(OPTS)

pcal.exe :	pcal.obj $(OBJECTS) pcalinit.h
	$(LINK) $(LINKFLAGS) pcal,$(OBJLIST)$(OPTS)

pcalinit.exe :	pcalinit.obj
	$(LINK) $(LINKFLAGS) pcalinit$(OPTS)

pcalinit.h :	pcalinit.exe pcalinit.ps
.ifdef TMJD
	MCR Sys$Disk:[]pcalinit pcalinit_tmjd.ps pcalinit.h header
.else
	MCR Sys$Disk:[]pcalinit pcalinit.ps pcalinit.h header
.endif

pcal.hlb :	pcal.hlp
exprpars.obj :	exprpars.c pcaldefs.h
moonphas.obj :	moonphas.c pcaldefs.h pcalglob.h
pcal.obj :	pcal.c pcaldefs.h pcalglob.h pcallang.h protos.h
pcalutil.obj :	pcalutil.c pcaldefs.h pcalglob.h pcallang.h protos.h
readfile.obj :	readfile.c pcaldefs.h pcalglob.h pcallang.h protos.h
writefil.obj :	writefil.c pcaldefs.h pcalglob.h pcallang.h pcalinit.h protos.h
pcalinit :	pcalinit.exe

clean :
	@- Set Message /NoFacility /NoSeverity /NoIdentification /NoText
	@- Set Protection = Owner:RWED *.*;-1,*.obj,pcalinit.h,pcalinit.exe
	@- Purge /NoLog /NoConfirm
	@- Delete /NoLog /NoConfirm *.obj;*,pcalinit.h;,pcalinit.exe;

clobber : clean
	@- Purge /NoLog /NoConfirm
	@- Delete /NoLog /NoConfirm *.exe;,pcal.hlb;

fresh :	clobber pcal
	@- Continue
