$! 'f$verify(0)'
$!			EchoDT.COM for the OSU DECthreads server
$!
$!	14-MAY-1995	F.Macrides (macrides@sci.wfeb.edu)
$!			HTbin script for reporting symbols set
$!			by Set_DCL_Env.c and/or available via
$!			<DNETfoo> calls.  Call it as an aid
$!			when developing Forms or Search scripts.
$!
$!	22-APR-1995	F.Macrides (macrides@sci.wfeb.edu)
$!			Added complete parsing of the <DNETID2> fields.
$!			Added reporting of the WWW_ACCEPT_LANGUAGE symbol
$!			 set that is now created by Set_DCL_Env.c.
$!			Added <DNETXLATE> of <DNETPATH>.
$!			Expanded the Explicitly Sought Symbol list.
$!
$!	28-APR-1995	F.Macrides (macrides@sci.wfeb.edu)
$!			Make clear that symbols should not be
$!			set globally.
$!
$!----------------------------------------------------------------------------
$ set noon
$!
$! Never set global symbols in CGI scripts for the OSU
$! server (i.e., *always* use '=' and *not* '==') so
$! they won't persist into subsequent DECNET tasks.
$!
$! Set utility symbols for net_link writes and reads.
$!
$ say = "write net_link"
$ get = "read net_link"
$ put = "create net_link"	! Not used here (and requires <DNETRECMODE>).
$ crlf = f$fao("!/")
$!----------------------------------------------------------------------------
$!
$! If it's a HEAD request, just send the Content-type and exit.
$!
$ if P1 .eqs. "HEAD"
$ then
$   say "<DNETCGI>"
$   say "Content-type: text/html", crlf, crlf	 ! CGI header
$   say "</DNETCGI>"
$   exit
$ endif
$!----------------------------------------------------------------------------
$!
$! Get info from <DNETfoo> calls.  All calls which are followed
$! by reads must be done before setting CGI output mode.
$!
$ say "<DNETID>"
$ get id
$ say "<DNETID2>"
$ get id2
$ server_software = f$element(0," ",id2)
$ server_name     = f$element(1," ",id2)
$ server_port     = f$element(2," ",id2)
$ remote_port     = f$element(3," ",id2)
$ remote_addr_num = f$element(4," ",id2)
$ remote_addr_int = f$integer(remote_addr_num)
$ remote_addr_tmp = remote_addr_int .and. %x7FFFFFFF
$ msb = 0
$ if remote_addr_int .ne. remote_addr_tmp then msb = 128
$ remote_addr_dot = f$fao("!UB.!UB.!UB.!UB",-
			  remote_addr_tmp,-
			  remote_addr_tmp/256,-
			  remote_addr_tmp/%x010000,-
			  remote_addr_tmp/%x1000000+msb)
$ remote_user     = f$element(5," ",id2)
$ remote_host     = f$element(6," ",id2)
$!
$ say "<DNETARG2>"	! (<DNETARG> clipped at 255 if necessary)
$ get arg2		! (QUERY_STRING)
$!
$ say "<DNETPATH>"
$ get script_path
$!
$ If script_path .nes. ""
$ Then
$   say "<DNETXLATE>"
$   say "''script_path'"
$   get script_path_xlate
$ Else
$   script_path_xlate := ""
$ EndIf
$!
$ say "<DNETRQURL>"
$ get rqurl
$!
$ say "<DNETBINDIR>"
$ get bindir
$!
$ say "<DNETHOST>"
$ get host	! (SERVER_NAME)
$!
$ num = 0
$ say "<DNETHDR>"
$hdr_loop:
$ num = num + 1
$ get hdr'num'
$ if hdr'num' .nes. "" then goto hdr_loop
$!
$!----------------------------------------------------------------------------
$!
$! Set up full CERN DCL symbol environment and CGI output mode.
$!
$! Note that setting <DNETRECMODE> is optional, and can cause
$! spurious newlines due to record blocking if the output strings
$! are long, but otherwise it's nice because you don't have to bother
$! adding explicit crlf's to every say (only when you want a second
$! newline)
$!
$ say "<DNETRECMODE>"	! Set implied carriage control
$ mcr 'f$parse("SET_DCL_ENV.EXE;",f$environment("PROCEDURE")) "WWW_"
$ say "Content-type: text/html", crlf	 ! CGI header
$!
$!----------------------------------------------------------------------------
$!
$! Report DNET variables and CGI symbols
$!
$ say "<TITLE>EchoDT for the OSU DECthreads server.</TITLE>", crlf
$!
$ say "<H1>EchoDT for the OSU DECthreads server.</H1>"
$!
$ say "The following variables and symbols are available to DCL."
$ say "<PRE>"
$!
$ say "PARAMETERS (P1, P2, P3)"
$ say "======================="
$ say "    method: ''P1'"
$ say " URL-ident: ''P2'"
$ say "  protocol: ''P3'"
$ say ""
$!
$ say "DNET variables"
$ say "=============="
$ say "    DNETID: ''id'"
$ say "   DNETID2: ''id2'"
$ say "   server_software: ''server_software'"
$ say "       server_name: ''server_name'"
$ say "       server_port: ''server_port'"
$ say "       remote_port: ''remote_port'"
$ say "   remote_addr_num: ''remote_addr_num'"
$ say "   remote_addr_dot: ''remote_addr_dot'"
$ say "       remote_user: ''remote_user'"
$ say "       remote_host: ''remote_host'"
$ say ""
$ say "   DNETAR2: ''arg2'"
$ say "DNETBINDIR: ''bindir'"
$ say "  DNETHOST: ''host'"
$ say "  DNETPATH: ''script_path'"
$ say " DNETXLATE: ''script_path_xlate'"
$ say " DNETRQURL: ''rqurl'"
$ say ""
$!
$ count = 0
$show_hdr:
$ count = count + 1
$ if count .lt. num
$ then
$  current = hdr'count'
$  say "   DNETHDR: ''current'"
$  goto show_hdr
$ endif
$!
$ say ""
$ say "CGI Symbols reported via: $ show sym WWW_*"
$ say "=========================================="
$ define sys$output net_link
$ show sym WWW_*
$ deass sys$output
$ say ""
$!
$ say "Explicitly sought CGI symbols (if not set, will be reported as NULL)"
$ say "===================================================================="
$ say "   WWW_AUTH_TYPE = ""''WWW_AUTH_TYPE'"""
$ say "   WWW_CONTENT_LENGTH = ""''WWW_CONTENT_LENGTH'"""
$ say "   WWW_CONTENT_TYPE = ""''WWW_CONTENT_TYPE'"""
$ say "   WWW_GATEWAY_INTERFACE = ""''WWW_GATEWAY_INTERFACE'"""
$ say "   WWW_HTTP_ACCEPT = ""''WWW_HTTP_ACCEPT'"""
$ say "   WWW_HTTP_ACCEPT_COUNT = ""''WWW_HTTP_ACCEPT_COUNT'"""
$!
$ num = 0
$ if f$type(WWW_HTTP_ACCEPT_COUNT) .eqs. "INTEGER" then -
    num = WWW_HTTP_ACCEPT_COUNT
$ count = 0
$show_accept:
$ count = count + 1
$ if count .le. num
$ then
$  current = WWW_HTTP_ACCEPT_'count'
$  say "   WWW_HTTP_ACCEPT_''count' = ""''current'"""
$  goto show_accept
$ endif
$!
$ say "   WWW_HTTP_ACCEPT_LANGUAGE = ""''WWW_HTTP_ACCEPT_LANGUAGE'"""
$ say "   WWW_HTTP_ACCEPT_LANGUAGE_COUNT = ",-
				     """''WWW_HTTP_ACCEPT_LANGUAGE_COUNT'"""
$!
$ num = 0
$ if f$type(WWW_HTTP_ACCEPT_LANGUAGE_COUNT) .eqs. "INTEGER" then -
    num = WWW_HTTP_ACCEPT_LANGUAGE_COUNT
$ count = 0
$show_accept_language:
$ count = count + 1
$ if count .le. num
$ then
$  current = WWW_HTTP_ACCEPT_LANGUAGE_'count'
$  say "   WWW_HTTP_ACCEPT_LANGUAGE_''count' = ""''current'"""
$  goto show_accept_language
$ endif
$!
$ say "   WWW_HTTP_AUTHORIZATION = ""''WWW_HTTP_AUTHORIZATION'"""
$ say "   WWW_HTTP_FROM = ""''WWW_HTTP_FROM'"""
$ say "   WWW_HTTP_REFERER = ""''WWW_HTTP_REFERER'"""
$ say "   WWW_HTTP_USER_AGENT = ""''WWW_HTTP_USER_AGENT'"""
$ say "   WWW_KEY_COUNT = ""''WWW_KEY_COUNT'"""
$!
$ num = 0
$ if f$type(WWW_KEY_COUNT) .eqs. "INTEGER" then -
    num = WWW_KEY_COUNT
$ count = 0
$ Show_Key:
$ count = count + 1
$ if count .le. num
$ then
$  if f$type(WWW_KEY_'count'_COUNT) .eqs. "INTEGER"
$  then
$    numlines = WWW_KEY_'count'_COUNT
$    say "   WWW_KEY_''count'_COUNT = ""''numlines'"""
$    line = 0
$    Show_Line:
$    line = line + 1
$    if line .le. numlines
$    then
$      current = WWW_KEY_'count'_'line'
$      say "   WWW_KEY_''count'_''line' = ""''current'"""
$      goto Show_Line
$    endif
$  else
$    current = WWW_KEY_'count'
$    say "   WWW_KEY_''count' = ""''current'"""
$  endif
$  goto Show_Key
$ endif
$!
$ say "   WWW_PATH_INFO = ""''WWW_PATH_INFO'"""
$ say "   WWW_PATH_TRANSLATED = ""''WWW_PATH_TRANSLATED'"""
$ say "   WWW_QUERY_STRING = ""''WWW_QUERY_STRING'"""
$ say "   WWW_REMOTE_ADDR = ""''WWW_REMOTE_ADDR'"""
$ say "   WWW_REMOTE_HOST = ""''WWW_REMOTE_HOST'"""
$ say "   WWW_REMOTE_IDENT = ""''WWW_REMOTE_IDENT'"""
$ say "   WWW_REMOTE_PORT = ""''WWW_REMOTE_PORT'"""
$ say "   WWW_REMOTE_USER = ""''WWW_REMOTE_USER'"""
$ say "   WWW_REQUEST_METHOD = ""''WWW_REQUEST_METHOD'"""
$ say "   WWW_SCRIPT_NAME = ""''WWW_SCRIPT_NAME'"""
$ say "   WWW_SCRIPT_PATH = ""''WWW_SCRIPT_PATH'"""
$ say "   WWW_SERVER_NAME = ""''WWW_SERVER_NAME'"""
$ say "   WWW_SERVER_PORT = ""''WWW_SERVER_PORT'"""
$ say "   WWW_SERVER_PROTOCOL = ""''WWW_SERVER_PROTOCOL'"""
$ say "   WWW_SERVER_SOFTWARE = ""''WWW_SERVER_SOFTWARE'"""
$ say "</PRE>"
$ exit
