$! v = 'f$verify(0)'
$!
$!			HTTP_INDEXUSER.COM for the CERN and OSU servers.
$!
$!	25-APR-1995	F.Macrides (macrides@sci.wfeb.edu)
$!			Example command procedure for indexing all
$!			foo.html files in a user's public (userdir)
$!			subdirectory.  Assumes that the program
$!			BUILD_INDEX.EXE, and the files SEQIDX.FDL,
$!			SEQSEL.FDL and NOISE_WORDS.DAT are in your
$!			server's dev:[dir.VMSIndex] directory, with
$!			read access (edit dev and dir appropriately,
$!			below), and that the subdirectory:
$!				device:[...username.WWWIndex]
$!			for holding the .IDX and .SEL files has been
$!			created in username's account, parallel to the:
$!				device:[...username.userdir]
$!			public dirctory.  This script should reside
$!			in the user's WWWIndex subdirectory and be
$!			executed there.  Change public_html in the
$!			indexing command, below, to the userdir name
$!			for your server.
$!
$!			The .html files must have <title> at the
$!			beginning of a line (case doesn't matter),
$!			e.g.:
$!
$!			<HTML>
$!			<HEAD>
$!			<TITLE>Welcome to Fote's Public Directory</TITLE>
$!			<link rev=made href="mailto:macrides@sci.wfeb.edu">
$!			</HEAD>
$!
$!			MyIndex.html is included as an example ISINDEX
$!			file.  It assumes that WWWsearch.com has been
$!			installed as the server's Search script.
$!			WWWsearch.com automatically will invoke 
$!			UserSearch.com for handling /~username/ ISINDEX
$!			files (via the WWWquery.EXE engine).
$!
$!			You also can use UserSearch.com as an Exec (htbin)
$!			procedure via links in non-ISINDEX files, by
$!			appending the /~username/path as PATH_INFO, e.g.,
$!
$!			  <A HREF="/htbin/usersearch/~username/myindex.html"
$!			  >Search MYINDEX file set</A>.
$!
$!			Also, you can use code like that in UserSearch.com
$!			to create a form interface to the search engine,
$!
$!----------------------------------------------------------------------------
$ v = f$verify(1)
$!
$! Create the Sequential files
$!
$ index := $dev:[dir.VMSIndex]build_index.exe
$ index /sequential/whole/noversion -
	/noise=dev:[dir.VMSIndex]noise_words.dat -
	/nodefault_topic -
        /topic=(text="<TITLE>", exclude) -
	/output=myindex -
	[-.public_html...]*.html;0
$!
$! Sort and Convert the SEQIDX to an IDX file
$!
$ sort myindex.seqidx myindex.seqidx
$ convert/fdl=dev:[dir.VMSIndex]seqidx myindex.seqidx myindex.idx
$!
$! Sort and Convert the SEQSEL to an SEL file
$!
$ sort myindex.seqsel myindex.seqsel
$ convert/fdl=dev:[dir.VMSIndex]seqsel myindex.seqsel myindex.sel
$!
$! Clean up
$!
$ purge /nolog/noconfirm  myindex.idx
$ rename/nolog/noconfirm  myindex.idx ;1
$ delete/nolog/noconfirm  myindex.seqidx;*
$ purge /nolog/noconfirm  myindex.sel
$ rename/nolog/noconfirm  myindex.sel ;1
$ delete/nolog/noconfirm  myindex.seqsel;*
$ set file/prot=w:re myindex.idx
$ set file/prot=w:re myindex.sel
$ v = 'f$verify(0)'
$ WRITE SYS$OUTPUT ""
$exit
