$! 'f$verify(0)'
$!			VMSGopherServer.COM
$!
$!	27-APR-1994	F.Macrides (macrides@sci.wfeb.edu)
$!			Example htbin script interface to the
$!			VMSIndex search engine (WWWquery).
$!			For use with CERN or OSU httpds.
$!			Should be placed where your htbin scripts
$!			have been mapped.
$!
$!	22-AUG-1994	Modified to return complete URL's in cover page. - FM
$!	16-OCT-1994	Added lots of symbol options (see below). - FM
$!	17-JAN-1995	Minor mods of cover page. - FM
$!	13-APR-1995	Added WWW_VMSINDEX_TITLE string. - FM
$!	30-APR-1995	Mods to support searches of sectional databases
$!			in either the server's or users' WWW directories
$!			based on appending of PATH_INFO to the URL. - FM
$!
$!	WWWquery.c is my modification of Bruce Tanner's query.c for accessing
$!	foo.doc;*, foo.IDX;*, foo.SEL;* filesets.  The doc file(s) is(are)
$!	indexed with BUILD_INDEX.EXE, yielding the IDX and SEL filesets.
$!	This search engine was develeped by Bruce and colleagues associated
$!	with the VMSGopher-L@trln.lib.unc.edu list for use with the
$!	VMSGopherServer.  It is similar to WAIS, but uses native indexing
$!	facilities of the VMS Record Management System (RMS).
$!
$!	Build BUILD_INDEX.EXE, WWWquery.EXE (and QUERY.EXE, for the Gopher
$!	Server), by executing MAKE.COM.  It will check out your system and
$!	then use MMS or command files, and the appropriate foo.OPT files.
$!
$!	Read BUILD_INDEX.DOC for information about the indexer.  The IDX and
$!	SEL files built by the indexer are the same whether they're intended
$!	for use by the Gopher or HTTP Server, or from the DCL command line.
$!
$!	An example HTML anchor and an example gopher tuple for invoking this
$!	script are included in BUILD_INDEX.DOC.
$!	
$!	This example script is for use with the HTML version of the VMS
$!	Gopher Server documentation, VMSGopherServer.doc, and assumes that
$!	it has been placed either in a doc/gopher/ subdirectory of your
$!	httpd data tree, or the device:[...username.WWWDoc] subdirectory
$!	of user accounts, or both.  The indexes (.IDX and .SEL file pairs)
$!	should be build with the HTTP_INDEXDOC.COM and HTTP_INDEXUSERDOC.COM
$!	interfaces to the BUILD_INDEX.EXE indexing program (be sure to read
$!	their headers).  If no PATH_INFO in included in the HREF, /www/ is
$!	assumed (i.e, as if you had used HREF="/htbin/vmsgopherserver/www/).
$!	If HREF="/htbin/vmsgopherserver/~username/" is used, the search will
$!	performed for the database and index in username's account.
$!
$!	If no query was included in the client's request, a "database cover
$!	page" is returned.  Modify that section, below, to indicate yourself
$!	and your host as the "database maintainer".  The cover page assumes
$!	that the searchwords.html HELP file resides in the /www/doc/ logical
$!	subdirectory.
$!
$!	VMSGopherServer.doc has an anchor pointing to egrep.html, which also
$!	is assumed to reside in the /www/doc/ logical subdirectory.
$! 
$!	The symbol WWW_SHOW_FILETYPE can be made non-NULL (e.g., "YES") to
$!	have icons (or ALT text) indicating the file types to be inserted
$!	into the hit lists returned from searches.
$!
$!	If the symbol WWW_MAXIMUM_HITS is made non-NULL (i.e., set equal to
$!	a number), then the hit lists returned by searches will be abridged,
$!	if necessary, so as not to exceed that number.
$!
$!	The symbol WWW_SHOW_SIZE can be made non-NULL (e.g., "YES") to have
$!	the size of each file or database section indicated in the hit lists.
$!
$!	The symbol WWW_SHOW_DATE can be made non-NULL to have the date of the
$!	database indicated in the hit lists (DD-MMM-YY).  If WWW_SHOW_TIME
$!	also is made non-NULL, for the current year the hour and minute will
$!	be indicated instead of the year (DD-MMM HH:MM).  If WWW_USE_MDATE is
$!	made non-NULL, the date of the last modification (e.g., from an
$!	APPEND) will be used.  The default is the file creation date (i.e.,
$!	of the highest version).
$!
$!	The symbol WWW_VMSINDEX_TITLE can be set to a string for the TITLE
$!	tag in hit lists and section fetches.  Otherwise, the TITLE defaults
$!	to "VMS Indexed Database Search".
$!
$!	See the header of WWWquery.c for additional regulatory symbols.
$!
$!	Set up the foreign command definition for WWWquery, below (or define
$!	it in the CERN server's SpawnInit.COM).  This script must be in the
$!	server's htbin directory, but WWWquery.EXE can be anywhere that is
$!	accessible to the server (e.g., where you broke out and built the
$!	VMSIndex distribution).
$!
$!	For the OSU server, you also must have Set_DCL_Env.EXE in its htbin
$!      directory.
$!
$!----------------------------------------------------------------------------
$! WWWquery := "$device:[directory]WWWquery"
$!--------------------------------------------
$ database = "VMSGopherServer"
$!--------------------------------------------
$ INDEX_DIR = "WWW_Root:[Index]"	! Location of server data tree indexes
$   DOC_REF = "doc/gopher/"		! Server data tree subdir for database
$!----------------------------------------------------------------------------
$ INDEX_SUBDIR = "WWWIndex"	! Homolog of Userdir configuration variable.
$   DOC_SUBDIR = "WWWDoc"	! Homolog of Userdir configuration variable.
$!----------------------------------------------------------------------------
$ crlf = f$fao("!/") 
$!
$ If f$trnlnm("WWW_OUT") .nes. ""
$ Then						! CERN server
$    WWW_IPATH_INFO = "/www/"			! Default Document Directory
$    WWW_IPATH_TRANSLATED = "/WWW_Root/000000/"	! Default Translation
$    say = "write WWW_OUT"
$    put = "create WWW_OUT"
$    define_output   = "!"
$    deassign_output = "!"
$ Else						! OSU server
$    WWW_IPATH_INFO = "/www/"			! Default Document Directory
$    WWW_IPATH_TRANSLATED = "/WWW_Root/documents/" ! Default Translation
$    say = "write net_link"
$    put = "create net_link"
$    define_output   = "define/nolog sys$output net_link"
$    deassign_output = "deassign sys$output"
$    say "<DNETRECMODE>"	! Set implied carriage control
$    mcr 'f$parse("SET_DCL_ENV.EXE;",f$environment("PROCEDURE")) "WWW_"
$ EndIf
$!----------------------------------------------------------------------------
$!
$! If PATH_INFO was included in the URL, replace the IPATH defaults.
$!
$ If "''WWW_PATH_INFO'" .nes. "" .and. "''WWW_PATH_TRANSLATED'" .nes. "" -
	.and. "''WWW_PATH_INFO'" .nes. "''WWW_PATH_TRANSLATED'"
$ Then
$    WWW_IPATH_INFO = WWW_PATH_INFO
$    WWW_IPATH_TRANSLATED = WWW_PATH_TRANSLATED
$ EndIf
$!----------------------------------------------------------------------------
$!
$! Check whether we have a query string.
$!
$ If WWW_KEY_COUNT .eq. 0
$ Then
$!
$!  No query string.  Send Cover Page and exit.
$!  ===========================================
$   access = "http://" + f$edit(WWW_SERVER_NAME, "COLLAPSE,LOWERCASE")
$   if WWW_SERVER_PORT .ne. 80 then access = access + ":" + WWW_SERVER_PORT
$   script = WWW_SCRIPT_NAME + WWW_PATH_INFO
$!
$   say "Content-Type: text/html", crlf		! Send the Header.
$!
$!***** Change the Cover Page, appropriately for your site. *****
$!      ---------------------------------------------------
$!
$   put		! Example of writing via create.
<HTML>
<HEAD>
<TITLE>Search the VMSGopherServer v1.2VMS-1 Documentation</TITLE>
<ISINDEX>
</HEAD>
<BODY>
<H1>VMSGopherServer</H1>
This database is maintained by macrides@sci.wfeb.edu
on host sci.wfeb.edu.
<p>
The search matches your words against full document text.
Access to this index is provided by the WWW to VMSIndex gateway.
$! Now use say to permit symbol insertions.
$! ----------------------------------------
$   say "Please specify <A HREF=""''access'/www/doc/searchwords.html"""
$   say ">search words</A> to find documents."
$   say "Click <A HREF=""''access'''script'?gopher"""
$! Go back to writing via create.
$! ------------------------------
$   put
>here</A> or use <em>gopher</em> as the search word to fetch
a menu for all 33 sections of this database.
</BODY>
</HTML>
$ exit
$ EndIf
$!----------------------------------------------------------------------------
$!
$!  We have a query.  Check if it's a /~username/ database.
$!
$ If f$locate("/~",WWW_IPATH_INFO) .eq. 0
$ Then
$!  It's a /~username/ database.
$!  ============================
$   gosub USER_DATABASE_SETUP
$ Else
$!  It's a server data tree database.
$!  =================================
$   gosub SERVER_DATABASE_SETUP
$ EndIf
$!----------------------------------------------------------------------------
$!
$!  Set up WWWquery options.
$!
$!  Hit list options:
$!  =================
$!  WWW_SHOW_FILETYPE = "YES"	! All text, so don't bother
$!  WWW_MAXIMUM_HITS = 250	! Only 33 sections, so don't bother
$   WWW_SHOW_SIZE = "YES"	! Bytes or KB
$!  WWW_SHOW_DATE = "YES"	! DD-MMM-YY, not worthwhile for databases
$!  WWW_SHOW_TIME = "YES"	! Replace -YY with HH:MM for current year
$!  WWW_USE_MDATE = "YES"	! Use last modified date (default is creation)
$!  WWW_VIA_FORM = "YES"	! Not relevant here.  See header of WWWquery.c
$!  WWW_OMIT_IPATH_CONVERSION = "YES"	! See header of WWWquery.c
$!
$!  Document options:
$!  =================
$!  WWW_OMIT_PRE_TAG = "YES"			! See header of WWWquery.c
$!  WWW_DATADIRECTORY = "HTTP_Root"		! See header of WWWquery.c
$!  WWW_FORBIDDEN = "HTTP_Root:[000000]"	! See header of WWWquery.c
$   WWW_VMSINDEX_TITLE = "Search the VMSGopherServer v1.2VMS-1 Documentation"
$!
$!  Script options:
$!  ===============
$!  WWW_OMIT_CONTENT_TYPE = "YES"		! See header of WWWquery.c
$!  WWW_OMIT_HEAD = "YES"			! See header of WWWquery.c
$!  WWW_OMIT_FOOT = "YES"			! See header of WWWquery.c
$!
$!----------------------------------------------------------------------------
$!
$! Reconstruct the query (unescaped).
$!
$   query = WWW_KEY_1
$   num = 2
$   Loop:
$   If (WWW_KEY_COUNT - num) .ge. 0 
$   Then
$     query = query + " " + WWW_KEY_'num'
$     num = num + 1
$     goto Loop
$   EndIf
$!----------------------------------------------------------------------------
$!
$! Do the search or RANGE fetch
$!
$   define_output
$   WWWquery "''database'" "''query'"
$   deassign_output
$ exit
$!
$!***************** USER_DATABASE_SETUP SUBROUTINE ***************************
$! Convert database to device:[...username.INDEX_SUBDIR]database
$! Convert WWW_IPATH_TRANSLATED to device:[...username.DOC_SUBDIR]docfile
$!   if it's a fetch, or /device/.../username/DOC_SUBDIR/ if it's a search
$!
$ USER_DATABASE_SETUP:
$ username = f$edit(f$extract(2,f$length(f$element(1,"/",WWW_IPATH_INFO))-1,-
		    WWW_IPATH_INFO), "UPCASE")
$ length = f$locate(username,WWW_IPATH_TRANSLATED)+f$length(username)
$ WWW_IPATH_TRANSLATED = f$extract(0,length,WWW_IPATH_TRANSLATED)
$ INDEX_DIR = f$extract(1,f$length(WWW_IPATH_TRANSLATED)-1,-
			  WWW_IPATH_TRANSLATED)
$ num = 0
$ indexdir = f$element(num,"/",INDEX_DIR) + ":["
$ subdir_loop:
$ num = num + 1
$ subdir = f$element(num,"/",INDEX_DIR)
$ If subdir .nes. "/" .and. subdir .nes. ""
$ Then
$   indexdir = indexdir + subdir + "."
$   goto subdir_loop
$ EndIf
$ INDEX_DIR = indexdir + "''INDEX_SUBDIR']"
$ database = INDEX_DIR + database
$!
$ If f$locate("TEXT=R",WWW_QUERY_STRING) .eq. 0
$ Then
$!  It's a fetch.
$!  =============
$   offset = f$locate(WWW_IPATH_INFO,WWW_QUERY_STRING)+ -
			f$length(WWW_IPATH_INFO)
$   docfile = f$extract(offset,f$length(WWW_QUERY_STRING)-offset, -
			WWW_QUERY_STRING)
$   WWW_IPATH_TRANSLATED = f$extract(0,f$locate("''INDEX_SUBDIR]",INDEX_DIR),-
			INDEX_DIR) + "''DOC_SUBDIR']" + docfile
$ Else
$!  It's a search.
$!  ==============
$   WWW_IPATH_TRANSLATED = WWW_IPATH_TRANSLATED+"/''DOC_SUBDIR'/"
$ EndIf
$ RETURN   
$!************************ END USER_DATABASE_SETUP ***************************
$!
$!***************** SERVER_DATABASE_SETUP SUBROUTINE *************************
$! Prefix INDEX_SUBDIR to database
$! If it's a fetch, convert WWW_IPATH_TRANSLATED to the full VMS pathspec
$!   for the docfile.  Otherwise, don't change the IPATH symbols.
$!
$ SERVER_DATABASE_SETUP:
$ database = INDEX_DIR + database
$ If f$locate("TEXT=R",WWW_QUERY_STRING) .eq. 0
$ Then
$!  It's a fetch.
$!  =============
$   offset = f$locate("''DOC_REF'", WWW_QUERY_STRING)+f$length("''DOC_REF'")
$   docfile = f$extract(offset,f$length(WWW_QUERY_STRING)-offset, -
			WWW_QUERY_STRING)
$   DOC_DIR = WWW_IPATH_TRANSLATED + DOC_REF
$   num = 1
$   docdir = f$element(num,"/",DOC_DIR) + ":["
$ docdir_loop:
$   num = num + 1
$   subdir = f$element(num,"/",DOC_DIR)
$   If subdir .nes. "/" .and. subdir .nes. ""
$   Then
$      docdir = docdir + subdir + "."
$      goto docdir_loop
$   EndIf
$   DOC_DIR = f$extract(0,f$length(docdir)-1,docdir) + "]"
$   WWW_IPATH_TRANSLATED = DOC_DIR + docfile
$ EndIf
$ RETURN   
$!*********************** END SERVER_DATABASE_SETUP **************************
