/******************************************************************************
 *
 * Copyright (c) 1998,99 by Mindbright Technology AB, Stockholm, Sweden.
 *                 www.mindbright.se, info@mindbright.se
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 *****************************************************************************
 * $Author: mats $
 * $Date: 1999/08/11 11:55:02 $
 * $Name: rel0-99 $
 *****************************************************************************/
package mindbright.ssh;

import java.io.File;

public class SSHClientUserAdaptor implements SSHClientUser {

  protected String sshHost;
  protected int    sshPort;

  public SSHClientUserAdaptor(String server, int port) {
    this.sshHost = server;
    this.sshPort = port;
  }

  public SSHClientUserAdaptor(String server) {
    this(server, SSH.DEFAULTPORT);
  }

  public String getSrvHost() {
    return sshHost;
  }

  public int getSrvPort() {
    return sshPort;
  }

  public String getDisplay() {
    return "";
  }

  public int getMaxPacketSz() {
    return 0;
  }

  public boolean wantX11Forward() {
    return false;
  }

  public boolean wantPrivileged() {
    return false;
  }

  public boolean wantPTY() {
    return false;
  }

  public void open(SSHClient client) {
  }

  public void connected(SSHClient client) {
  }

  public void disconnected(SSHClient client, boolean graceful) {
  }

  public void report(String msg) {
  }

  public void alert(String msg) {
  }

}
