;CAT.ASM by Jonathan McDowell.
;Copyright 1997 Jonathan McDowell for Project Purple.
;Written sometime in 1993.
;01/06/93 - Changed FormatName to put filespec in last 3 char spaces of name.
;05/07/93 - Fixed directory error in name formatting routine.
;         - Added colour support for COM & 8 files.
;13/07/93 - Changed colours to dark instead of bright.
;         - Added size display on files.
;         - Added free disk space info.
;14/07/93 - Added number of files display.
;         - Added file spec on command line.
;15/07/93 - Fixed problems with filespec.
;17/07/93 - Added CrLf after No volume Label message & before it.
;20/07/93 - Changed name to CAT from XDIR after Joe FastChated to Chris Smith.
;         - Added /? option.
;         - Added recognition of PAS, EXE, BAK, SYS & BIN files.
;         - Added /M option.
;21/07/93 - Fixed stats problem in Mono mode - extra ANSI code.
;27/07/93 - Fixed two of the filespec problems.
;         - Added FileSpec printing.
;22/08/93 - Added checking for number/bytes/cluster as only worked on
;           floppies.
;14/09/93 - Added checking to see if ANSI.SYS installed.
;12/11/93 - Fixed MKbytes bug.
;13/11/93 - Fixed 56KBytes bug.
;07/04/94 - Changed method of writing to screen - prepared.
;         - Updated copyright from (c)1993-ish StarGate Programming.
;09/04/94 - Fixed bug when displaying drive size - wouldn't write Mbytes,
;           used Kbytes with Mbytes reading.
;06/05/94 - Added total space used by files but in 1k blocks - wierd on RAM
;           drive.
;18/05/94 - Added version number for Micky.
;20/05/94 - Fixed spaces bug in volume label display.
;06/08/94 - Fixed bug in command line parsing that wouldn't list single files.
;11/12/94 - Changed printing routine to BIOS call. Only works on AT's up.
;26/12/94 - Changed file size routine. On files over 99Mb (Encarta) the first
;           digit was left behind. Whole routine needs re-written by ME.
;09/10/95 - Must do some fixing.
;         - Changed copyright to Kel Ka Prise.
;10/10/95 - Changed PrintString to print ASCIIZ string, not $ terminated.
;09/01/96 - Changed BAT to green and added ASM colours. All EXEC files are
;           now green.
;           REMed out colour bit and changed to assemble under TASM.
;11/01/96 - Altered colour routine to use a table and added back in.
;         - Added ARJ, RAR and ZIP files in pink.
;25/10/96 - Added SQZ files in pink.
;         - Changed copyright to 1996 Project Purple.
;09/03/97 - Added Z and GZ files in pink.
;         - Changed copyright to 1997 Project Purple and version to 1.0d
;12/10/97 - Added TGZ files in pink. Version 1.0e
;11/04/99 - Changed source format to compile under NASM for release. v1.0.0
;         - Changed some colours to make more like colour ls.

                org 100h
Start:          jmp Main
                db 13,'Copyright 1997 Project Purple.',1Ah

Drive		EQU 5Ch				;Drive of 1st param in PSP

FileData:       times 21 db 0			;Used by DOS
Attr            db 00                           ;File attribute
Time            dw 0000                         ;File time
Date            dw 0000                         ;File data
Size1           dw 0
Size2           dw 0				;File size
FName           times 13 db ' '			;Filename (ASCIIZ)
FNamEnd         equ $-1

FileSpec        dw StarDot
StarDot         db '*.*',0
Dir             db '  DIR'
LfCrLf          db 10
CrLf            db 13,10,0
Blue            equ 01h
Green           equ 02h
Cyan            equ 03h
Red             equ 04h
Magenta         equ 05h
Brown           equ 06h
LightBlue       equ 09h
LightGreen	equ 0Ah
Pink            equ 0Ch
Yellow          equ 0Eh
White           equ 0Fh
FileCount       dw 0
File            db 0
TotalDirSize    dw 0
Stats           db 13,10
NumOfFiles      db '       files'
TotalSize       db '       KBytes '
FreeDsk         db '       Kbytes free',0Dh,0Ah,0
Spaces:         db 13,'    ',13,0
FileName:       times 8 db ' '
                db ' '
FileExt:        times 3 db ' '
FileSpaceBit    db ' '
FileISDir:      times 4 db ' '
FileSizeA       equ $-1
                db 'k  '
ColourTable:    db '8  ',Blue
                db 'ARJ',Pink
                db 'ASM',Blue
                db 'BAK',Cyan
                db 'BAT',LightGreen
                db 'BIN',Magenta
                db 'COM',LightGreen
                db 'EXE',LightGreen
                db 'GZ ',Pink
                db 'PAS',Brown
                db 'RAR',Pink
                db 'SQZ',Pink
                db 'SYS',Magenta
                db 'TGZ',Pink
                db 'Z  ',Pink
                db 'ZIP',Pink
                db 0FFh

Help:           mov dx,HelpMsg
                mov ah,9
                int 21h
                mov ax,4C00h
                int 21h

Main:           mov dl,BYTE [Drive]		;Pick up drive specified
                mov BYTE [DriveSize],dl
                mov al,dl
                or al,al                        ;Is it "default"?
                jnz KnowDr                      ;No - we know the drive
                mov ah,19h                      ;Get set to find the default
                int 21h
                inc al                          ;Bump up for this function
KnowDr:         add al,'A' - 1                  ;Convert to a letter
                mov BYTE [DrvName],al
                mov ah,1Ah
                mov dx,FileData
                int 21h
                mov WORD [FileCount],0
                mov si,80h                      ;Start at command tail
GetFileSpec:    inc si
                cmp BYTE [si],' '
                jb NoTail
                jz GetFileSpec
                cmp WORD [si],'/?'
                jz Help
                mov [FileSpec],si
GetFileSpec10:  lodsb
                cmp al,' '
                ja GetFileSpec10
                cmp BYTE [si-2],'\'
                jz GetFileSpec30
                cmp BYTE [si-2],':'
                jz GetFileSpec20
                mov WORD [si-1],0+256*'$'
                mov ax,4300h
                mov dx,[FileSpec]
                int 21h
                jc NoTail
                and cx,10h
                jz NoTail
                inc si
                jmp GetFileSpec30
GetFileSpec20:  mov BYTE [si-1],'\'
                mov ah,47h
                mov dl,BYTE [DrvName]
                sub dl,'A'-1
                int 21h
                mov si,[FileSpec]
                jmp GetFileSpec10
GetFileSpec30:  mov WORD [si-2],'\*'
                mov WORD [si],'.*'
                mov WORD [si+2],0+256*'$'
NoTail:         call GetLabel
                call PrintFileSpec
                mov cx,10h
                mov ah,4Eh
                mov dx,[FileSpec]
Main1:          int 21h
                cmp ax,0
                jnz Finish
                inc WORD [FileCount]
                mov bx,FName-1
                call FormatName
                mov BYTE [FNamEnd],0
                call Colour
                mov si,FName
                call PrintZ
                mov ah,4Fh
                jmp Main1

Finish:         mov di,NumOfFiles+5
                mov ax,[FileCount]
                call Calcul
                mov ax,[TotalDirSize]
                xor dx,dx
                mov di,TotalSize+5
                call KorM1
                mov dl,0
DriveSize       equ $-1
                mov ax,3600h                    ;get free disk space
                int 21h
                mul cx                          ;Get bytes/cluster in AX
                mov bp,ax
                push bx                         ;stack FREE clusters
                pop ax                          ;unstack "free" clusters
                mul bp                          ;calculate as bytes
                mov di,FreeDsk + 5		;point to "free" count
                call KorM                       ;determine if "k" or "M"
                mov dx,Stats			;Point to computed results
                mov BYTE [CurrentColour],White	;Set text colour
                call PrintString                ;Print stats
                xor ax,ax
                mov ah,4Ch
                int 21h                         ;return to DOS

;ͻ
; KORM Ŀ
;ͼ    calculate whether "k" or "M" notation is best      
;                                                              
;      i/p  DX\AX = HOW\LOW of binary number                   
;           ES:DI = addr of RHS of decimal destination         
; 
KorM:           call divbyk                     ;divide by 1024 (to get "k")
                cmp BYTE [File],1
                jnz korm01
                add [TotalDirSize],ax
korm01:         or dx,dx                        ;is result still too big ?
                jz KorM1                        ;No - jump
;                cmp ax,1024
;                jc korm10
;                call divbyk
;                mov B [di+1],'G'
                jmp korm10
KorM1:          cmp ax,1024                     ;is it small enough for "k" ?
                jc Calcul                       ;yes- exit
korm10:         cmp BYTE [di + 2],'K'
                jnz korm11
                mov BYTE [di + 2],'M'		;change to "Megabytes"
korm11:         cmp BYTE [di+1],'k'
                jnz korm12
                mov BYTE [di+1],'M'
korm12:         mov BYTE [di - 1],'.'
                mov cl,10                       ;multiply by 10 (to get dec.)
                push dx                         ;save high multiplicand
                mul cx                          ;multiply * 10
                mov si,ax                       ;low result saved
                pop ax                          ;get 2nd multiplicand
                push dx                         ;save overflow
                mul cx                          ;multiply * 10
                pop dx                          ;retrieve overflow
                add dx,ax                       ;add to get high result
                mov ax,si                       ;low result restored
                call divbyk                     ;divide by 1024
;(fall through!)
;ͻ
; CALCUL Ŀ
;ͼ      calculate "printable" decimal value            
;                                                              
;      i/p  DX\AX = HOW\LOW of binary number                   
;           ES:DI = addr of RHS of decimal destination         
; 
Calcul:         mov bx,10               ;we will use ten as divisor
calcul20:       xor dx,dx               ;empty DX
                div bx                  ;divide LOW by ten
                or dl,30h               ;convert to BCD digit
                cmp BYTE [di],'.'
                jnz calcul30
                dec di
calcul30:       mov BYTE [di],dl	;move digit to output
                dec di                  ;move left one column
                or ax,ax                ;is AX = 0 ?
                jnz calcul20            ;no - repeat
genret:         ret                     ;finished the whole routin                        e

;ͻ
; DIVBYK Ŀ
;ͼ           divide AX|DX by 1024                      
; 
divbyk:         mov cx,10
                add ax,1023
                adc dx,0
divbyk10:       clc
                rcr dx,1
                rcr ax,1
                loop divbyk10
                ret

Colour:         mov BYTE [CurrentColour],White
                push bx
                mov bx,ColourTable-4
ColourLoop:     add bx,4
                cmp BYTE [bx],0FFh
                jz NoColour
                mov ax,WORD [CS:FNamEnd-3]
                cmp ax,[bx]
                jnz ColourLoop
                mov al,BYTE [CS:FNamEnd-1]
                cmp al,[bx+2]
                jnz ColourLoop
                mov al,[bx+3]
                mov [CurrentColour],al
NoColour:       mov al,[Attr]
                and al,10h
                cmp al,10h
                jnz ColourEnd
                mov BYTE [CurrentColour],LightBlue
ColourEnd:      pop bx
                ret

FileTyp         dw 0
FormatName:     inc bx
                mov al,[bx]
                cmp al,'.'
                jz FormatName1
                cmp al,0
                jnz FormatName
Pad:            cmp bx,FNamEnd
                jz FormatEnd
                mov BYTE [bx],32
                inc bx
                jmp Pad
FormatName1:    mov [FileTyp],bx
GetToEnd:       inc bx
                cmp BYTE [bx],0
                jnz GetToEnd
FormatName2:    cmp bx,FNamEnd
                jz FormatName3
                mov BYTE [bx],32
                inc bx
                jmp FormatName2
FormatName3:    cmp BYTE [FName],'.'
                jz FormatEnd
FormatName4:    mov si,[FileTyp]
                mov di,FNamEnd-1
                mov cx,3
                inc si
                inc si
                inc si
                std
                rep movsb
                mov si,[FileTyp]
FormatName5:    cmp si,FNamEnd-3
                jz FormatEnd
                mov BYTE [si],32
                inc si
                jmp FormatName5
FormatEnd:      ret

PrintZ:         cld
                mov di,FileName
                mov cx,12
                rep movsb
WriteSize:      mov di,FileISDir
                mov ax,'  '
                stosw
                stosw
                mov BYTE [di],'k'
                mov al,[Attr]
                test al,10h
                jnz WriteDir
                mov di,FileSizeA
                mov ax,[Size1]
                mov dx,[Size2]
                push cs
                pop es
                mov BYTE [FileSpaceBit],' '
                mov BYTE [File],1
                call KorM
                mov BYTE [File],0
L1:             mov cx,20
                mov si,FileName
L2:             mov al,[si]
                call PrintChar
                inc si
                loop L2
                ret
WriteDir:       mov si,Dir
                mov di,FileISDir
                mov cx,5
                rep movsb
                jmp L1

GetLabel:       mov ah,4Eh
                mov cx,8
                mov dx,LabelName
                int 21h
                cmp ax,0
                jnz NoLabel
                mov dx,VolMsg
                call PrintString
                mov cx,11
                mov si,FName
                mov bx,8
GetLabel1:      lodsb
                cmp al,'.'
                je GetLabel3
                call PrintChar
                dec bx
                loop GetLabel1
                ret
GetLabel3:      cmp bx,0
                jbe GetLabel1
                mov al,' '
                call PrintChar
                dec bx
                jmp GetLabel3

NoLabel:        mov dx,NoLabelMsg
                call PrintString
                ret
LabelName:      db 'B:\*.*',0
DrvName         equ $ - 7
VolMsg          db 13,10,' Volume label is ',0
NoLabelMsg:     db 13,10,' No volume label',0

PrintFileSpec:  mov dx,DirMsg
                call PrintString
                mov dx,[FileSpec]
                call PrintString
                mov dx,LfCrLf
                call PrintString
                ret
DirMsg:         db 13,10,' Directory of ',0

PrintString:    mov bx,dx
                mov al,[bx]
                cmp al,0
                jz PrintStringEnd
                call PrintChar
                inc dx
                jmp PrintString
PrintStringEnd: ret

PrintChar:      mov [Char2Print],al
                pusha
                mov ah,03h
                mov bh,0
                int 10h
                mov ah,13h
                mov al,1
                mov bl,[CurrentColour]
                mov bh,0
                mov cx,1
                push cs
                pop es
                mov bp,Char2Print
                int 10h
                popa
                ret

Char2Print      db ' '
CurrentColour   db White

HelpMsg:        db 13,10,'CAT.COM v1.0.0 Written by Jonathan McDowell.'
                db 13,10,'Copyright 1997 Project Purple.'
                db 13,10,'Needs a 286 or higher.'
                db 13,10,'An enhanced version of DIR with colour coding for files.'
                db 13,10,10,9,'CAT [/?] [filespec]'
                db 13,10,10,'/? - Displays this help screen$'
