$! Program Name            : PS2DRIVER.COM
$!   Original Author       : J.Lauret
$!   Program Description   : PS2DRIVER format a .PS file into a different
$!                         : GhostScript format.
$! References
$!   Files open for Input  :
$!   Files open for Output :
$!   Modules Referenced    :
$! Revision History follows
$! ----------------------- :
$!   Date of Revision      : 25-JUL-1997
$!   Change Author         : NUCMGR (i.e. J.lauret's management account)
$!   Purpose of Revision   :  Modified to fit GS 5.01 option line changes
$!                         :
$! ----------------------- : 
$!   Date of Revision      : 24-JUL-1998 
$!   Change Author         : NUCMGR
$!   Purpose of Revision   : Added some comments. 
$!                         : 
$
$ ! In SYSMAN, nothing is defined ... same for NETWORK mode
$ if f$trnlnm("SYS$SCRATCH").eqs."" then define SYS$SCRATCH []
$ ws := write sys$output
$ if P1.eqs."-D" 
$ then	P1 = P3
$	P3 = P4
$	P4 = P5
$ endif
$ if P1.eqs."?".or.P1.eqs."" then goto lhelp
$
$	
$ if f$search(P1).eqs.""
$ then	ws "File ''P1' does not exist !!"
$ 	exit
$ endif
$
$ ! Now we start
$ out	= f$parse(P1,"","","NAME")	! Base name for outfile
$ if P2.eqs."" 
$ then P2 = "gif8"  			! Default driver
$ else P2 = f$edit(P2,"LOWERCASE")	! Prepare for GS args
$ endif
$
$
$ extend = f$extract(0,3,P2)		! Extension treatment
$ if extend.eqs."jpe"	then extend = "jpg"
$ if extend.eqs."t46"	then extend = "tek"
$ if extend.eqs."pai"	then extend = "pjet"
$
$ if P3.nes."" 
$ then out = P3
$ else out = out + "." + extend
$ endif
$ tmpfile = "SYS$SCRATCH:PS2D"+F$GETJPI("","PID")+".TMP"
$
$
$ 					! Driver shortcut fixes
$ if p2.eqs."pdf" then p2 = "pdfwrite"
$ if p2.eqs."gif" then p2 = "gif8"
$ if p2.eqs."png" then p2 = "png256"
$ if p2.eqs."eps" then p2 = "epswrite"
$ if p2.eqs."jpg" then p2 = "jpeg"
$
$ 
$ 
$ t1	= F$CVTIME(f$time(),"COMPARISON") ! get starting time
$ extra	= ""
$
$ ws "-- Running GS Driver=''P2' --"
$ if P4.nes."" 
$ then	extra = P4
$	ws "gs ""-q"" ""-dNOPAUSE"" ""-dBATCH"" ''extra' ""-sDEVICE=''P2'"" ""-sOutputFile=''tmpfile'"" ''P1'"
$ endif
$
$ gs "-q" "-dNOPAUSE" "-dBATCH" 'extra' "-sDEVICE=''P2'" "-sOutputFile=''tmpfile'" 'P1'
$
$ 
$ if f$search(tmpfile).eqs.""		! Check if the file has been created
$ then	ws ""
$  	ws "	[1;4mInvalid driver[0m[1;3m choice [1;4m''p2'[0m[1;3m or GS [1;4mdid not produced[0m[1;3m the expected file[0m"
$	ws ""
$ else	
$	copy/nolog/noconfirm 'tmpfile' 'out' ! Copy to target
$	delete/nolog/noconfirm 'tmpfile';*   ! Clean temp file	
$
$	t2 = F$CVTIME(F$FILE(OUT,"RDT"),"COMPARISON") ! Get final time
$  	if t2.GES.t1
$  	then	ws "''OUT' ready."
$  	else	ws "[1;5m''OUT' not created nor updated[0m"
$  	endif
$ endif
$ exit

$ lhelp:
$ ! This help reflects our GS implementation.
$ type sys$input:

 Usage  : $ PS2DRIVER fileName [Driver] [OutputFileName] [Gs options]
          Default driver=gif8
 or (no default driver)
	  $ PS2DRIVER -d driver fileName [OutputFileName] [Gs options]

 Intermediate file will be created in SYS$SCRATCH.

 Convert a PS or EPS* file into a new format known by GhostScript.
 Compiled drivers are (on AXP)
   x11 x11alpha x11cmyk x11mono deskjet djet500 laserjet ljetplus ljet2p
   ljet3 ljet4 cdeskjet cdjcolor cdjmono cdj550 pj pjxl pjxl300 bj10e bj200
   bjc600 bjc800 faxg3 faxg32d faxg4 pcxmono pcxgray pcx16 pcx256 pcx24b
   pcxcmyk pbm pbmraw pgm pgmraw pgnm pgnmraw pnm pnmraw ppm ppmraw tiffcrle
   tiffg3 tiffg32d tiffg4 tifflzw tiffpack tiff12nc tiff24nc psmono psgray
   bit bitrgb bitcmyk pngmono pnggray png16 png256 png16m jpeg jpeggray
   pdfwrite pswrite epswrite pxlmono pxlcolor gifmono gif8 bmpmono bmp16
   bmp256 bmp16m ln03 la50 la75 lj250 paintjet pjetxl cdj500 declj250
   dnj650c lj4dith lbp8 lips3 escp escpc tek4696 t4693d2 t4693d4 t4693d8
   stcolor nullpage

 Also usable (shortcuts):    pdf eps gif png jpg

$ exit
