!---------------------------------------------------------------------------- 
!  Written by J.Hasstedt, (manager@nuclear.physics.sunysb.edu)
!  Modified J.Lauret 24-Jul-97 
!	(PostScript encapsulation, sed independance, file creation check ...)
!		
!  PS2EPSI use GS to convert .PS file to .EPSI file
!---------------------------------------------------------------------------- 
$ IF (P1 .EQS. "")
$ THEN
$   TYPE/NOPAGE SYS$INPUT:

    Usage: PS2EPSI input-file [output-file]

    The default extension for input-file is .PS ; the default for output-file
    the input file name with .EPSI.

$   EXIT
$ ENDIF
$ 
$ INFILE	= F$PARSE (P1, ".PS")
$ OUTFILE	= F$PARSE (P2, ".EPSI", INFILE)
$ TMPFILE	= "PS2EPSI" + F$GETJPI("","PID") + ".TMP"
$ TITLE		= "%%Title: " + F$PARSE (INFILE,,, "NAME", "SYNTAX_ONLY")
$ CREATOR	= "%%Creator: Ghostscript ps2epsi from " + INFILE
$ DATE		= "%%CreationDate: " + F$CVTIME(,"ABSOLUTE","DATE")
$ FOR		= "%%For: " + F$EDIT(F$GETJPI("","USERNAME"),"TRIM")
$ 
$ OPEN/READ IN 'INFILE'
$TITLELOOP:
$ READ/END=TITLEDONE IN REC
$ IF (F$EXTRACT(0,1,REC) .NES. "%") THEN GOTO TITLEDONE
$ TAG = F$ELEMENT(0,":",REC)
$ IF (TAG .EQS. "%%Title")	THEN TITLE = REC
$ IF (TAG .EQS. "%%Creator")	THEN CREATOR = REC
$ IF (TAG .EQS. "%%CreationDate") THEN DATE = REC
$ IF (TAG .EQS. "%%For")	THEN FOR = REC
$ GOTO TITLELOOP
$TITLEDONE:
$ CLOSE IN
$ CREATE/FDL=SYS$INPUT 'TMPFILE'
RECORD
FORMAT STREAM_LF
$ OPEN/APPEND OUT 'TMPFILE'
$ WRITE OUT "/ps2edict 30 dict def"
$ WRITE OUT "ps2edict begin"
$ WRITE OUT "/epsititle (", TITLE, "\n) def"
$ WRITE OUT "/epsicreator (", CREATOR, "\n) def"
$ WRITE OUT "/epsicrdt (", DATE, "\n) def"
$ WRITE OUT "/epsifor (", FOR, "\n) def"
$ WRITE OUT "end"
$ CLOSE OUT
$ DEFINE/USER SYS$INPUT 'INFILE'
$ DEFINE/USER OUTFILE 'OUTFILE'
$ GS "-q" "-dNOPAUSE" "-r72" "-sDEVICE=bit" "-sOutputFile=NLA0:" -
     'TMPFILE' GS_LIB:PS2EPSI.PS 'TMPFILE' "-c quit"
$ SET FILE/PROT=S:RWED 'TMPFILE';*	! In case of GRPPRV privs
$ DELETE 'TMPFILE';*
$ OPEN/APPEND OUT 'OUTFILE'
$ COPY SYS$INPUT OUT
/InitDictCount countdictstack def gsave save mark newpath
%%EndProlog
%%Page 1 1
$ 
$ ! Either SED fix (bof!) or copy 
$!  SED -f SYS$INPUT 'INFILE' >OUT
!$!s/
!$!//g
!$!/^%%BeginPreview:/,/%%EndPreview$/d
!$!/^%!PS-Adobe/d
!$!/^%%[A-Za-z][A-Za-z]*$/d
!$!/^%%[A-Za-z][A-Za-z]*: /d
$! 
$
$ cop 'INFILE' OUT
$
$ COPY SYS$INPUT OUT
%%Trailer
countdictstack InitDictCount sub { end } repeat
cleartomark restore grestore
showpage
%%EOF
$ CLOSE OUT
$
$ if f$search(OUTFILE).eqs.""
$ then	ws "File not created - "
$ else 	t1 = F$CVTIME(F$FILE(INFILE,"RDT"),"COMPARISON")
$ 	t2 = F$CVTIME(F$FILE(OUTFILE,"RDT"),"COMPARISON")
$ 	if t2.GES.t1	! One minute difference
$ 	then	ws outfile," created"
$ 	else	ws " WARNING :: ''OUTFILE' not created/updated !!"
$ 	endif
$ endif
$ EXIT
