#  ------------------------------------------------------------------------
#  Those will emulate some of the DCL lexical functions
#  Written J.Lauret 1995 - Updated 96 for Perl 5.002
#  Updated 04-Jan-98 . f_edit() may have as many options as needed.
#  ------------------------------------------------------------------------
package	lexical							        ;
require 5.000								;
use Exporter								;
@ISA = (Exporter)							;
@EXPORT=qw(f_edit f_belement f_element f_extract f_time f_user)	        ;



sub f_edit{
 local(@tmp) = @_							;
 local($mode,$i,$j,$rvrs,$tmp)						;

 for($j=1 ; $j <= $#tmp ; $j++){
	$mode = $tmp[$j]						;

	# Take care of lowercase/upper right away
	if( $mode =~ /UPCASE/ ){
		$tmp[0] = uc($tmp[0])					;
	}
	if( $mode =~ /LOWERCASE/ ){
		$tmp[0] = lc($tmp[0])					;
	}

	# Uncomment - f$edit() uncoment DCL/TPU kind of comment
	if( $mode =~ /UNCOMMENT/ ){
		$tmp[0] =~ s/!.*$/$1/					;
	}

	if( $mode =~ /UNQUOTE/ ){
		$tmp[0] =~ s/["']//g					;
	}


	# If we do use COLLAPSE, then none of the others above are needed
	if( $mode =~ /COLLAPSE/ ){
		$tmp[0] =~ s/\s*/$1/g					;
	} else {
	  if( $mode =~ /COMPRESS/ ){
		$tmp[0] =~ s/\s+/ /g					;
	  }
	  if( $mode =~ /TRIM/ ){
		  if( $mode =~ /_TRAILING/){
		  	$tmp[0] =~ s/^(.*?)\s*$/$1/			;
		  } elsif( $mode =~ /_LEADING/){
		  	$tmp[0] =~ s/^\s*(.*?)$/$1/			;
		  } else {
		  	$tmp[0] =~ s/^\s*(.*?)\s*$/$1/			;
		  }
	  }
	}

	# Reverse will reverse the string
	if( $mode =~ /REVERSE/ ){
		$rvrs = ""						;
		for($i = 0 ; $i < length($tmp[0]) ; $i++){
			$rvrs = substr($tmp[0],$i,1).$rvrs		;
		}
		$tmp[0] = $rvrs					        ;
	}

	# Invert will change character-cases
	if( $mode =~ /INVERT/ ){
		$rvrs = ""						;
		for($i = 0 ; $i < length($tmp[0]) ; $i++){
			$tmp	= substr($tmp[0],$i,1)			;
			if (ord($tmp) >= 97){
				$rvrs .= uc($tmp)			;
			} else {
				$rvrs .= lc($tmp)			;
			}
		}
		$tmp[0] = $rvrs					        ;
	}
 }

 $tmp[0]								;
}



#  Emulates f$element(element_num,separator,line)
sub f_element{
	local(@tmp) = @_						;
	local(@item)							;
	my($val)							;


#  This routine will not work with "." (???) . It will if replaced
#  by /\./ . Something to do with pattern ???

	if($tmp[1] eq "."){
	 @item = split(/\./,$tmp[2])					;
	} else {
	 @item = split($tmp[1],$tmp[2])				        ;
	}
	$item[$tmp[0]]							;
}



# This routine is not part of the f$ routines but I found it very
# convenient in my implementation of the f$ in EVE+ to have a way to go in
# reverse direction.
sub	f_belement{
	local(@tmp) = @_						;

	if($tmp[1] eq "."){
	 @item = split(/\./,$tmp[2])					;
	} else {
	 @item = split($tmp[1],$tmp[2])				        ;
	}
	$item[$#item-$tmp[0]]						;
}



# Not really usefull but for f$* addicted ...
sub f_extract{
	local($start,$len,$line) = @_					;
	substr($line,$start,$len)					;
}
sub f_user
{	# Preceding version did accept $ENV{USER}
	$ENV{USER} = getlogin						;
	$ENV{USER}							;
}
sub f_time
{ # VMS like time string
	local($line)							;

	$line = uc(localtime)						;
	# New Perl5.0002 and up return locatime with extra space.
	$line =~ s/\s+/ /g						;
	f_element(2," ",$line)."-".f_element(1," ",$line)."-".
	f_element(4," ",$line)." ".f_element(3," ",$line)		;
}



1									;


#  ----------------------- : 
#    Date of Revision      :  7-JAN-1999 
#    Change Author         : NUCMGR (i.e. J.Lauret)
#    Purpose of Revision   :  Adedd f_belement()
#                          : 
