" #define module_name VMSTAR_CMDLINE #define module_ident "02-007"  /* ** **  Facility:	VMSTAR ** **  Module:	VMSTAR_CMDLINE **6 **  Author:	Hunter Goatley <goathunter@WKUVX1.WKU.EDU> ** **  Date:	April 27, 1994 **I **  Abstract:	Routines to handle a VMS CLI interface for VMSTAR.  The CLI < **		command line is parsed and a new argc/argv are built and **		returned to VMSTAR.  ** **  Modified by: **. **	02-007		Martin Stiftinger	14-FEB-1995 17:14& **		A comment was not correctly ended.1 **	02-006		Richard Levitte		 5-NOV-1994 01:02 CET . **		Corrected bogus settings of found_options.1 **	02-005		Richard Levitte		18-OCT-1994 10:42 CET 0 **		Now handles /FORCE, /PADDING, /BLOCK_FACTOR.1 **	02-004		Richard Levitte		12-SEP-1994 10:09 CET 7 **		Initialised len in get_list() to 0 if *str is NULL. 1 **	02-003		Richard Levitte		 1-SEP-1994 14:42 CET # **		Initialised found_options to 0. 1 **	02-002		Richard Levitte		 1-SEP-1994 23:23 CET 8 **		/DATE_POLICY values are only handled if /DATE_POLICY **		is present. 1 **	02-001		Richard Levitte		 1-SEP-1994 22:58 CET % **		Added processing of /DATE_POLICY. 1 **	02-000		Richard Levitte		 1-SEP-1994 11:43 CET < **		Moved the Unix command line option parsing to this file.1 **	01-003		Richard Levitte		 1-JUL-1994 00:23 CET , **		Added processing of the /HELP qualifier.1 **	01-002		Richard Levitte		28-APR-1994 22:50 CET 4 **		Made a change, so users are not required to have% **		a dash to get the Un*x interface. 1 **	01-001		Richard Levitte		28-APR-1994 22:25 CET % **		Simplified the handling of /DOTS. , **	01-000		Hunter Goatley		27-APR-1994 10:05' **		Original version (for VMSTAR V2.0).  ** */    
 #ifdef __DECC ' #pragma module module_name module_ident  #else   #module module_name module_ident #endif   #include <stdio.h> #include <ssdef.h> #include <descrip.h> #include <climsgdef.h> #include <clidef.h>  #include <stdlib.h>  #include <string.h>  #include <dvidef.h>  #include <ttdef.h> #include <lib$routines.h>  #include <ots$routines.h>  #include <str$routines.h>    #include "vmstar_cmdline.h"    #ifndef CLI$_COMMA globalvalue CLI$_COMMA;  #endif   /* Function flags, options */   # int help = 0,		/* h option, help */ (     extract = 0,	/* x option, extract */1     list = 0,		/* t option, list tape contents */ /     verbose = 0,	/* v option, report actions */ (     the_wait = 0,	/* w option, prompt */4     dot = 0,		/* d option, suppress dots (creation),5 			   or keep dots in directory names (extraction) */ '     create = 0,		/* c option, create */ ,     binmode = 0,	/* b option, binary mode */0     automode = 0,	/* z option, automatic mode */0     foption = 0;	/* f option, specify tarfile */ char tarfile[32767];A unsigned long date_policy = dp_both; /* /DATE_POLICY qualifier */ ' int force = 0;			/* /FORCE qualifier */ * int padding = 0;		/* /PADDING qualifier */5 int block_factor = 20;		/* /BLOCK_FACTOR qualifier */    /*6 **  "Macro" to initialize a dynamic string descriptor. */ #define init_dyndesc(dsc) {\ 	dsc.dsc$w_length = 0;\ " 	dsc.dsc$b_dtype = DSC$K_DTYPE_T;\" 	dsc.dsc$b_class = DSC$K_CLASS_D;\ 	dsc.dsc$a_pointer = 0;}   /*D **  Define descriptors for all of the CLI parameters and qualifiers. */$ $DESCRIPTOR(cli_tarfile,	"TARFILE");# $DESCRIPTOR(cli_infile,		"INFILE"); $ $DESCRIPTOR(cli_extract,	"EXTRACT"); $DESCRIPTOR(cli_help,		"HELP");  $DESCRIPTOR(cli_list,		"LIST"); # $DESCRIPTOR(cli_create,		"CREATE"); $ $DESCRIPTOR(cli_verbose,	"VERBOSE");$ $DESCRIPTOR(cli_confirm,	"CONFIRM");# $DESCRIPTOR(cli_binary,		"BINARY"); ( $DESCRIPTOR(cli_automatic,	"AUTOMATIC"); $DESCRIPTOR(cli_dots,		"DOTS"); ! $DESCRIPTOR(cli_force,		"FORCE"); $ $DESCRIPTOR(cli_padding,	"PADDING");. $DESCRIPTOR(cli_block_factor,	"BLOCK_FACTOR");, $DESCRIPTOR(cli_date_policy,	"DATE_POLICY");5 $DESCRIPTOR(cli_date_policy_all,		"DATE_POLICY.ALL"); 7 $DESCRIPTOR(cli_date_policy_none,		"DATE_POLICY.NONE"); ? $DESCRIPTOR(cli_date_policy_creation,		"DATE_POLICY.CREATION"); F $DESCRIPTOR(cli_date_policy_modification,	"DATE_POLICY.MODIFICATION"); $DESCRIPTOR(cli_yyz,		"YYZ"); ' $DESCRIPTOR(vmstar_command, "vmstar ");   
 #ifdef __DECC  extern void *vmstar_clitables; #else ! globalref void *vmstar_clitables;  #endif  E /* extern unsigned long LIB$GET_INPUT(void), LIB$SIG_TO_RET(void); */   & extern unsigned long cli$dcl_parse ();$ extern unsigned long cli$present ();& extern unsigned long cli$get_value ();  4 unsigned long unix_vmstar_cmdline (int *, char ***);I static unsigned long get_list (struct dsc$descriptor_s *, char **, char); ; static unsigned long check_cli (struct dsc$descriptor_s *);      static3 one_line(char *text, int *this_line, int max_lines)  { &     if ((*this_line)++ == max_lines-1)     { / 	printf("Press return for more..."); getchar();  	*this_line = 1;     }  #ifdef DEBUG(     printf("(###DEBUG %d)", *this_line); #endif     printf("%s\n",text);
     return 0;  }    /* Usage of this program. */ usage()  {      static char buf[255]; (     $DESCRIPTOR(dev_descr,"SYS$OUTPUT");     unsigned long status;      int this_line = 0;- #if 1 || (!defined(__VAXC) && !defined(VAXC))      union ttdef ttydef;  #else      variant_union ttdef ttydef;  #endif" #define max_lines ttydef.tt$v_page  H     if (((status = lib$getdvi(&DVI$_DEVDEPEND,0,&dev_descr,&ttydef,0,0)) 	 & 1) == 0) 	max_lines = 24;   #ifdef DEBUG8     sprintf(buf, "###DEBUG: max_lines = %d", max_lines);)     one_line(buf, &this_line, max_lines);  #endif6     sprintf(buf,"VMS TAR %s (%s)", VERSION, __DATE__);)     one_line(buf, &this_line, max_lines); P     one_line("usage (VMS style):  TAR tarfile file[,...]",&this_line,max_lines);\     one_line("   Options: /HELP         -- Print this text and exits",&this_line,max_lines);[     one_line("            /LIST         -- List contents of tarfile",&this_line,max_lines); S     one_line("            /CREATE       -- Create a tarfile",&this_line,max_lines); ]     one_line("            /EXTRACT      -- Extract files from tarfile",&this_line,max_lines); ^     one_line("            /VERBOSE      -- Display processed file info",&this_line,max_lines);^     one_line("            /CONFIRM      -- Prompt before store/extract",&this_line,max_lines);V     one_line("            /BINARY       -- Create binary files",&this_line,max_lines);d     one_line("            /AUTOMATIC    -- Automatically determine file type",&this_line,max_lines);W     one_line("            /DOTS         -- Maintain \".\" usage",&this_line,max_lines); m     one_line("            /FORCE        -- Forces copying of unsupported file formats",&this_line,max_lines); p     one_line("            /PADDING      -- Adds padding block at the end of the tar file",&this_line,max_lines);l     one_line("            /BLOCK_FACTOR -- Amount of 512 byte records in a tar block",&this_line,max_lines);g     one_line("            /DATE_POLICY  -- Decide what times of extracted files",&this_line,max_lines); O     one_line("                             will be set:",&this_line,max_lines); S     one_line("                                 [NO]CREATION",&this_line,max_lines); W     one_line("                                 [NO]MODIFICATION",&this_line,max_lines); &     one_line("",&this_line,max_lines);i     one_line("usage (UNIX style): tar -h|x|t|c[vwbzd][f tarfile] [file [file...]]",&this_line,max_lines); =     one_line("   Options: h  =  /HELP",&this_line,max_lines); =     one_line("            t  =  /LIST",&this_line,max_lines); ?     one_line("            c  =  /CREATE",&this_line,max_lines); @     one_line("            x  =  /EXTRACT",&this_line,max_lines);@     one_line("            v  =  /VERBOSE",&this_line,max_lines);@     one_line("            w  =  /CONFIRM",&this_line,max_lines);?     one_line("            b  =  /BINARY",&this_line,max_lines); B     one_line("            z  =  /AUTOMATIC",&this_line,max_lines);=     one_line("            d  =  /DOTS",&this_line,max_lines); E     one_line("            b  =  /BLOCK_FACTOR",&this_line,max_lines); p     one_line("            f file     -- Specify a tar file or magtape.  Default is $TAPE",&this_line,max_lines);     exit(SS$_NORMAL);  }   
 unsigned long , vmstar_cmdline (int *argc_p, char ***argv_p) {  /* **  Routine:	vmstar_cmdline  **
 **  Function:  **@ **	Parse the DCL command line and set option values accordingly. **D **	NOTE:  Upon return, the argument list will only contain the final
 **	file list.  ** */     register status;     int found_options = 0;$     char *the_cmd_line = NULL, *ptr;     int  x;        int new_argc;      char **new_argv;  %     struct dsc$descriptor_d work_str;        init_dyndesc (work_str);       /*E     **  See if the program was invoked by the CLI (SET COMMAND) or by A     **  a foreign command definition.  Check for /YYZ, which is a 5     **  valid default qualifier solely for this test.      */"     status = check_cli (&cli_yyz);     if (!(status & 1)) { 	lib$get_foreign (&work_str);  	/* B 	**  If nothing was returned or the first character is a "-", then1 	**  assume it's a UNIX-style command and return.  	*/ H 	if ((work_str.dsc$w_length == 0) || (*(work_str.dsc$a_pointer) == '-'))0 	    return unix_vmstar_cmdline(argc_p, argv_p);  4 	str$concat (&work_str, &vmstar_command, &work_str);D 	status = cli$dcl_parse(&work_str, &vmstar_clitables, lib$get_input, 			lib$get_input, 0); # 	if (!(status & 1)) return(status);      }        /*I     **  First, check to see if any of the regular options were specified.      */  %     status = cli$present (&cli_dots);      if (status & 1)  	found_options = 1, dot = 1;  '     status = cli$present (&cli_binary);      if (status & 1)   	found_options = 1, binmode = 1;  %     status = cli$present (&cli_list);      if (status & 1)  	found_options = 1, list = 1;   (     status = cli$present (&cli_confirm);     if (status & 1) ! 	found_options = 1, the_wait = 1;   (     status = cli$present (&cli_extract);     if (status & 1)   	found_options = 1, extract = 1;  (     status = cli$present (&cli_verbose);     if (status & 1)   	found_options = 1, verbose = 1;  '     status = cli$present (&cli_create);      if (status & 1)  	found_options = 1, create = 1;   *     status = cli$present (&cli_automatic);     if (status & 1)7! 	found_options = 1, automode = 1;*  &     status = cli$present (&cli_force);     if (status & 1)o 	found_options = 1, force = 1;     else( 	found_options |= status != CLI$_ABSENT;  @     /* This one has special handling, since it is on by default.?        to set found_options, we really want it to be present onT        the command line.  */(     status = cli$present (&cli_padding);     if (status & 1) 8 	found_options |= status != CLI$_DEFAULTED, padding = 1;     else: 	found_options = 1;	/* it must be present to be negated */  -     status = cli$present (&cli_block_factor);      if (status & 1)E     {I 	register status; " 	struct dsc$descriptor_d work_str;   	init_dyndesc(work_str);   	found_options = 1;oA 	if ((status = cli$get_value (&cli_block_factor, &work_str)) & 1)  	{5 	    status = ots$cvt_tu_l (&work_str, &block_factor,a# 				   sizeof (block_factor),0x11);* 	}     }I  ,     status = cli$present (&cli_date_policy);     if (status & 1) {	 #ifdef DEBUGH 	printf ("/DATE_POLICY is apparently present, according to status %d\n",
 		status); #endif   	found_options = 1;  	date_policy = dp_none;a  - 	status = cli$present (&cli_date_policy_all);R 	if (status & 1) 	    date_policy = dp_both;e     . 	status = cli$present (&cli_date_policy_none); 	if (status & 1) 	    date_policy = dp_none;c     2 	status = cli$present (&cli_date_policy_creation); 	if (status & 1)  	    date_policy |= dp_creation;  6 	status = cli$present (&cli_date_policy_modification); 	if (status & 1)$ 	    date_policy |= dp_modification;     }l #ifdef DEBUG@     printf ("date_policy: %d\ncreation: %s\nmodification: %s\n", 	    date_policy, . 	    date_policy & dp_creation ? "yes" : "no",3 	    date_policy & dp_modification ? "yes" : "no");e #endif  %     status = cli$present (&cli_help);l     if (status & 1)t     {          if (found_options)1 	    printf("tar: ignoring all other options\n");$	 	usage();  	exit(SS$_NORMAL);     }   D     /* If the user didn't give any DCL qualifier, assume he uses the        Un*x interface */     if (!found_options)F- 	return unix_vmstar_cmdline (argc_p, argv_p);        /*     **A     **  OK.  We've done all the regular options, so check for thei1     **	tarfile and the files to store or extract.p     **     */(     status = cli$present (&cli_tarfile);     if (status & 1) {	 	unsigned long len; 2 	status = cli$get_value (&cli_tarfile, &work_str); 	len = work_str.dsc$w_length;e/ 	strncpy(tarfile, work_str.dsc$a_pointer, len);/ 	tarfile[len] = '\0';      }   '     status = cli$present (&cli_infile);/     if (status & 1) { 5 	status = get_list (&cli_infile, &the_cmd_line, ' ');n$ 	if (!(status & 1)) return (status);     }Y       /*H     **  Now that we've gotten everything off the command line, count the/     **  number of args and build an argv array.C     */  # #if defined(TEST) || defined(DEBUG)i      printf("%s\n",the_cmd_line); #endif /* TEST */t  :     new_argc = the_cmd_line != NULL && *the_cmd_line != 0;     for (ptr = the_cmd_line;. 	 ptr != 0 && (ptr = strchr(ptr,' ')) != NULL; 	 ptr++, new_argc++);r  <     /* There must be one extra place for the final NULL.  */O     if ((new_argv = (char **) calloc (new_argc + 1, sizeof(char *))) == NULL) {( 	perror("Memory exhausted"); 	return(SS$_ABORT);E     }   8     for (ptr = the_cmd_line, x = 0; x < new_argc; x++) { 	new_argv[x] = ptr;O' 	if ((ptr = strchr (ptr, ' ')) != NULL)l 	    *ptr++ = '\0';;     }R     new_argv[x] = NULL;Y  # #if defined(TEST) || defined(DEBUG)A+     printf("new_argc    = %d\n", new_argc);S"     for (x = 0; x < new_argc; x++)/ 	printf("new_argv[%d] = %s\n", x, new_argv[x]);_ #endif /* TEST */K       *argc_p = new_argc;_     *argv_p = new_argv;"       return(SS$_NORMAL);l }_   	 #if 0O static unsigned longC set_boolean (struct dsc$descriptor_s *qual, struct bool_desc *desc)e {l     register status;%     struct dsc$descriptor_d work_str;e       init_dyndesc(work_str);I        status = cli$present (qual);     if (status & 1) {P   	unsigned long len, old_len;   	len = strlen(*str);9 	while ((status = cli$get_value (qual, &work_str)) & 1) {c 	    if (*str == NULL) {" 		len = work_str.dsc$w_length + 1; 		}L+ 		strncpy(*str,work_str.dsc$a_pointer,len);o
 	    } else {e 		char *src, *dst; int x;c 		old_len = len;# 		len += work_str.dsc$w_length + 1; 
 		if ((*str = + 			(char *) realloc (*str, len)) == NULL) {c! 		    perror("Memory exhausted");$ 		    return(SS$_ABORT); 		}  		/*= 		**  Copy the string to the buffer, converting to lowercase.  		*/ 		src = work_str.dsc$a_pointer;l 		dst = *str+old_len; / 		for (x = 0; x < work_str.dsc$w_length; x++) { ) 		    if ((*src >= 'A') && (*src <= 'Z'))r 			*dst++ = *src++ + 32;
 		    else 			*dst++ = *src++;# 		}U /*. 		strncpy(*str+old_len,work_str.dsc$a_pointer, 			work_str.dsc$w_length); */ 	    } 	    if (status == CLI$_COMMA) 		(*str)[len-1] = c;	 	    elseS 		(*str)[len-1] = '\0';T   	}     }n       return (SS$_NORMAL);   }s #endif   i static unsigned long< get_list (struct dsc$descriptor_s *qual, char **str, char c) {i     register status;%     struct dsc$descriptor_d work_str;$       init_dyndesc(work_str);b        status = cli$present (qual);     if (status & 1) {=   	unsigned long len, old_len;  ' 	len = *str == NULL ? 0 : strlen(*str);e9 	while ((status = cli$get_value (qual, &work_str)) & 1) {e 	    if (*str == NULL) {" 		len = work_str.dsc$w_length + 1;6 		if ((*str = (char *) malloc (work_str.dsc$w_length))
 			== NULL) { ! 		    perror("Memory exhausted");] 		    return(SS$_ABORT); 		}n+ 		strncpy(*str,work_str.dsc$a_pointer,len);i
 	    } else {s 		char *src, *dst; int x;  		old_len = len;# 		len += work_str.dsc$w_length + 1;o
 		if ((*str =s+ 			(char *) realloc (*str, len)) == NULL) { ! 		    perror("Memory exhausted");& 		    return(SS$_ABORT); 		}_ 		/*= 		**  Copy the string to the buffer, converting to lowercase.l 		*/ 		src = work_str.dsc$a_pointer;  		dst = *str+old_len;s/ 		for (x = 0; x < work_str.dsc$w_length; x++) { ) 		    if ((*src >= 'A') && (*src <= 'Z'))P 			*dst++ = *src++ + 32;
 		    else 			*dst++ = *src++;_ 		}" /*. 		strncpy(*str+old_len,work_str.dsc$a_pointer, 			work_str.dsc$w_length); */ 	    } 	    if (status == CLI$_COMMA) 		(*str)[len-1] = c;	 	    else_ 		(*str)[len-1] = '\0';_   	}     }        return (SS$_NORMAL);   }\   g static unsigned long) check_cli (struct dsc$descriptor_s *qual)  {- /* **  Routine:	check_cli **C **  Function:	Check to see if a CLD was used to invoke the program.I ** */D     lib$establish(lib$sig_to_ret);	/* Establish condition handler */F     return (cli$present(qual));		/* Just see if something was given */ }n   r
 unsigned longi0 unix_vmstar_cmdline(int *argc_p, char ***argv_p) {Y char *cp, c; register int argindex = 2; int argc = *argc_p;) char **argv = *argv_p;       if (argc == 1)         usage();       strcpy(tarfile,"$TAPE");       cp = argv[1];      while(c = *cp++)     {&         switch(c))	         {_
 	case 'h': 	    help=1; 	    break;[         case 't':h             list=1;              break;         case 'x':              extract=1;             break;         case 'c':]             create=1;s             break;         case 'v':t             verbose=1;             break;         case 'w':              the_wait=1;l             break;         case 'd':              dot=1;             break;         case 'b':              binmode=1;             break;
 	case 'z': 	    automode=1; 	    break;O         case 'f':l 	    if (*cp != '\0') { 6 		printf("tar: no other options may follow \"f\".\n");
 		usage(); 		exit(SS$_NORMAL);& 	    } 	    foption = 1;  	    break;          case '-':M             break;         default:J             printf("tar: option '%c' not recognized.  Continuing...\n",c);             usage(); 	    exit(SS$_NORMAL);	         }n     }"  
     if (help)e     { 8         if (extract + list + create + verbose + the_wait  	    + binmode + automode + dot)1 	    printf("tar: ignoring all other options\n");a	 	usage();  	exit(SS$_NORMAL);     }t       if (foption)         if (argc < 3)* 	{5 	    printf("tar: tar file missing, using $TAPE.\n");d #if 0 
 	    usage();p #endif 	} 	elsem 	{ 	    strcpy(tarfile,argv[2]);l 	    argindex = 3; 	}    /* Check options are coherent */  ,     if (extract + list + create + help == 0)     { .         printf("tar: no action specified.\n");         exit(SS$_NORMAL);s     }_     if (extract + create == 2)     {sE         printf("tar: incompatible options 'x' and 'c' specified.\n");C         exit(SS$_NORMAL);o     }o     if (list + create == 2)/     {iE         printf("tar: incompatible options 't' and 'c' specified.\n");/         exit(SS$_NORMAL);c     };      if (binmode + automode == 2)     {i> 	printf("tar: incompatible options 'b' and 'z' specified.\n");         exit(SS$_NORMAL);      }s     *argc_p -= argindex;     *argv_p += argindex;     return(SS$_NORMAL);  }0   ( #ifdef TESTc
 unsigned long' main(int argc, char **argv)_ {l     register status;*     return (vmstar_cmdline(&argc, &argv)); }k #endif /* TEST */l  