/******************************************************************************
 *                                                                            *
 *	VAX/VMS descriptor macros.                                            *
 *                                                                            *
 *	Author:                                                               *
 *	    Terence Lee (DEC/HKO), 18-Oct-1989                                *
 *                                                                            *
 *	Modification history:                                                 *
 *                                                                            *
 ******************************************************************************/

#include <descrip.h>

/*
 *      descrS - make up a string descriptor.
 *      A total of 32 string descriptor can be created at the same time.
 *      The address of the created descriptor will be returned.
 */

#define MAX_descriptorS		32		/* Number of descriptors. */

int	descrS_index = 0;
struct dsc$descriptor_s descriptorS[MAX_descriptorS];

#define descrS(string,len) ( \
	descrS_index = (descrS_index == MAX_descriptorS) ? 0 : descrS_index, \
	descriptorS[descrS_index].dsc$a_pointer = (string), \
	descriptorS[descrS_index].dsc$w_length = (len) ? len : strlen(string), \
	descriptorS[descrS_index].dsc$b_dtype = DSC$K_DTYPE_T, \
	descriptorS[descrS_index].dsc$b_class = DSC$K_CLASS_S, \
	&descriptorS[descrS_index++])

/*
 *	descrA - make up an array descriptor.
 *	    At the time being, only one dimension character string array can
 *	    be described by this macro.
 *	    The address of the created descriptor will be returned.
 */

struct {
	struct dsc$descriptor_a array;
	char    *array_address;
	int	multi;
	int	lower_bound;
	int	upper_bound;
} descriptorA;

#define descrA(string,field_size,number_of_items) ( \
	descriptorA.array.dsc$w_length = field_size, \
	descriptorA.array.dsc$b_dtype = DSC$K_DTYPE_T, \
	descriptorA.array.dsc$b_class = DSC$K_CLASS_A, \
	descriptorA.array.dsc$a_pointer = string, \
	descriptorA.array.dsc$b_scale = 0, \
	descriptorA.array.dsc$b_digits = 0, \
	descriptorA.array.dsc$b_aflags.dsc$v_fl_binscale = 0, \
	descriptorA.array.dsc$b_aflags.dsc$v_fl_redim = 0, \
	descriptorA.array.dsc$b_aflags.dsc$v_fl_column = 0, \
	descriptorA.array.dsc$b_aflags.dsc$v_fl_coeff = 1, \
	descriptorA.array.dsc$b_aflags.dsc$v_fl_bounds = 1, \
	descriptorA.array.dsc$b_dimct = 1, \
	descriptorA.array.dsc$l_arsize = field_size * number_of_items, \
	descriptorA.array_address = string, \
	descriptorA.multi = 1, \
	descriptorA.lower_bound = 0, \
	descriptorA.upper_bound = number_of_items - 1, \
	&descriptorA)

