$! Everything in this file should be OK, but can be changed.
$!
$! The following logicals should be defined by IUPOP3_STARTUP.COM
$!
$! define /system /tran=conc iupop3_root dev:[dir.]
$! define /system            iupop3_exe  iupop3_root:[bin]
$! define /system            iupop3_log  iupop3_root:[log]
$!
$ on warning   then goto final_exit
$ on control_y then goto final_exit
$!
$!************************
$! Initialize
$!************************
$!
$! Recipients of error messages. Normally defined in IUPOP3_STARTUP.COM.
$ mail_recipients = ""
$!
$! "default_type" is the type of a message which "From:" line
$! can't be interpreted correctly.
$! Possible values for default_type are smtp or decnet
$! (will be overwritten by IUPOP3_DEFAULT_TO_SMTP).
$ default_type = "smtp"
$!
$! define the version limit of the log files here.
$ log_version_limit = 10
$!
$! Specify client timeout in minutes. Use a value from 1 to 23*60+59 .
$! For RFC 1939 compability use 10 minutes or more, default is 2 minutes.
$ timeout = 10  
$!
$! Using the name part of this file as part of the process and logfile names.
$! This makes it easy to use different instances of this program 
$! on the same node (e.g. for testing purposes).
$ proc_name =  f$parse(f$environment("PROCEDURE"),,,"NAME","SYNTAX_ONLY")
$ proc_name =  f$extract(0,8,proc_name)
$ set process/name="''proc_name' start"
$ x = f$parse("Z.Z;",f$environment("PROCEDURE")) - "Z.Z;"
$ y = x - "]"
$ node = f$getsyi("NODENAME")
$ if f$trnlnm("sys$scratch") .eqs "" then $ define sys$scratch  'x'
$ log_file = f$parse("IUPOP3_LOG:","''proc_name'-''node'.LOG","''y'.LOG]")
$ define pop_log 'log_file'
$!
$!
$! The standard port of a pop3 server is 110.
$ if f$trnlnm("''proc_name'_port") .nes. ""
$ then
$   pop_port = f$trnlnm("''proc_name'_port")
$ else
$   pop_port = 110
$ endif
$! -------------------------------------------------------------------------------
$! Everything below this line should be OK, but can be changed.
$ set process/priority=4
$!
$ if (f$getsyi("HW_MODEL") .gt. 1024)
$ then
$   arch = "ALPHA"
$ else
$   arch = "VAX"
$ endif
$!
$!************************
$! Start the Server
$!************************
$ if (f$search("pop_log") .eqs. "") then create pop_log
$ set file/version='log_version_limit' pop_log
$!
$ errorcount = 0
$ restart_count = 0
$ iupop3 := $iupop3_exe:iupop3_'arch'.exe
$!
$! Start of the server loop
$!
$ restartserver:
$ on warning then goto error_trap
$ on error   then goto error_trap
$ set process/name="''proc_name' Server"
$ set noverify
$ iupop3 -port 'pop_port'                 -
         -logfile pop_log                 -
         -xtnd iupop3_exe:pop_xtnd.dat    - 
         -default_type 'default_type'     -
         -timeout 'timeout'               -
         -purge_reclaim
$ goto final_exit
$!
$!************************
$! Error Trap
$!************************
$ error_trap:
$ ss_status = $status
$ on warning then continue
$ error_message = f$message(ss_status)
$ node = f$getsyi("nodename")
$!
$ set verify
$ restart_count = restart_count + 1
$ set process/name="''proc_name' start"
$! Check for restart request
$ if (f$locate("%SYSTEM-F-OPRABORT",error_message) .eq. 0) -
     then goto operator_restart
$ errorcount = errorcount + 1
$ mail_recipients = f$trnlnm("IUPOP3_MAIL_RECIPIENTS")
$ if (mail_recipients .eqs. "") then goto error_trap_nomail
$ mail sys$input "''mail_recipients'" -
                 /subject="''node' - ''error_message'" -
                 /pers="''proc_name' Server, error count ''errorcount'"
The IUPOP3 server has experienced a runtime error.  The reason
for the error should appear on the subject line of this message.

Please investigate this problem as quickly as possible.  
Thank you.
$!
$ error_trap_nomail:
$ if (f$locate("%SYSTEM-F-CONNECFAIL",error_message) .eq. 0)
$ then
$   wait 00:00:30     ! probably a timeout problem (or network down)
$   errorcount = errorcount + 30 ! max. 2 tries
$ endif
$!  if insufficient privilege restart would never help
$ if (f$locate("%SYSTEM-F-NOPRIV",error_message) .eq. 0) then goto final_exit
$! wrong parameters - do never restart
$ if (f$locate("%CLI-E-INVQUA",error_message) .eq. 0) then goto final_exit
$ if (errorcount .le. 50) then goto restartserver
$ goto final_exit
$!
$!************************
$! Operator restart
$!************************
$ operator_restart:
$ mail_recipients = f$trnlnm("IUPOP3_MAIL_RECIPIENTS")
$ if (mail_recipients .eqs. "") then goto operator_restart_nomail
$ mail sys$input "''mail_recipients'" -
                 /subject="''node' - error count was ''errorcount'" -
                 /pers="''proc_name' Server restart count is ''restart_count'"
The IUPOP3 server has been restarted by operator request.
The error count is reset to zero.

Regards.
$
$ operator_restart_nomail:
$ errorcount = 0
$ goto restartserver
$!
$!************************
$! Final Exit
$!************************
$ final_exit:
$ exit
