#ifndef IUPOP3_GENERAL_H
#define IUPOP3_GENERAL_H
/*
 ===========================================================================
 = (C) Copyright 1997,1998 Michael Stenns                                  =
 =                                                                         =
 =  Permission to use, copy, modify, and distribute this program for       =
 =  non-commercial use and without fee is hereby granted.                  =
 =                                                                         =
 =  This software is distributed in the hope that it will be useful,       =
 =  but WITHOUT ANY WARRANTY; without even the implied warranty of         =
 =  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                   =
 =                                                                         =
 ===========================================================================
 =                                                                         =
 =  (C) Copyright 1991-1994 The Trustees of Indiana University             =
 =                                                                         =
 =  Permission to use, copy, modify, and distribute this program for       =
 =  non-commercial use and without fee is hereby granted, provided that    =
 =  this copyright and permission notice appear on all copies and          =
 =  supporting documentation, the name of Indiana University not be used   =
 =  in advertising or publicity pertaining to distribution of the program  =
 =  without specific prior permission, and notice be given in supporting   =
 =  documentation that copying and distribution is by permission of        =
 =  Indiana University.                                                    =
 =                                                                         =
 =  Indiana University makes no representations about the suitability of   =
 =  this software for any purpose. It is provided "as is" without express  =
 =  or implied warranty.                                                   =
 =                                                                         =
 ===========================================================================
 =                                                                         =
 = File:                                                                   =
 =   IUPOP3_GENERAL.H                                                      =
 =                                                                         =
 = Authors:                                                                =
 =   Jacob Levanon & Larry Hughes                                          =
 =   Indiana University                                                    =
 =   University Computing Services, Network Applications                   =
 =                                                                         =
 = Credits:                                                                =
 =   This software is based on the Post Office Protocol version 3,         =
 =   as implemented by the University of California at Berkeley.           =
 =                                                                         =
 ===========================================================================
*/

#if defined UCX && !(defined ALPHA && defined __GNUC__)
#  include <in.h>
#elif defined NETLIB
#  include "netlib_dir:netlibdef.h"
#elif defined MULTINET   /* obsolete, usually UCX-comp. mode used */
#  include "multinet_root:[multinet.include.netinet]in.h"
#else
#  include <netinet/in.h>
#endif


#define MAX_THREADS 30  /* VMS callable mail limit minus one */

#define TRUE            1
#define FALSE           0
#define NEGATIVE	-1
#define ENDMULTLINTRANS ".\r\n"

#define MAXHOSTNAMELEN  255
#define MAXUSERNAMELEN  12
#define MAXLINELEN      1024
#define MAXMSGLINELEN   1024
#define MAXRECORDLEN    65535 /* max. record length which could be processed */
#define MAXARGCOUNT     10
#define MAXARGLEN       10

/* Version, Compiler, Threadnumber, Hostname, Time */
#define TIMESTAMP_FORMAT "<V%s/(%s)/%02.2d@%s at %s>"

#if defined  MAIL_FOLDER || defined USE_MAIL_FOLDER
#   define MAX_MESSAGES    8192
#   ifndef USE_MAIL_FOLDER
#	define USE_MAIL_FOLDER
#   endif
#   ifdef MAIL_FOLDER
#	undef MAIL_FOLDER
#   endif
#else /* !USE_MAIL_FOLDER */
#   define MAX_MESSAGES    20
#endif /* MAIL_FOLDER */

#define DEFAULT_PURGE_MESSAGES 5  /* num. of messages to purge at once */

#define  NEWMAIL_FOLDER       "NEWMAIL"
#define  MAIL_FOLDER          "MAIL"
#define  TEMP_WASTE_FOLDER    "IUPOP3_TEMP_Wastebasket"

#define DECNET_MESSAGE 1
#define SMTP_MESSAGE 2

#define MAX_AUTHENTICATION_ATTEMPTS 2

#define APOP_FILENAME "POP_SECRET.DAT"   /* filename containing the shared secret */
                                         /* in the users mail directory */

/* 
 * MAX_MAIL_HEADER_SIZE defines max. supported length of smtp headers .
 * The send buffer can be enlarged up to this value.
 */

#define MAX_MAIL_HEADER_SIZE (512*1024)

/*
 * DEFAULT_SEND_BUFFERSIZE defines the default length of the send buffer.
 * The send buffer will be allocated for each active thread.
 * The minimum length is MAXLINELEN + line and multiline terminators.
 * The maximum length is INT_MAX.
 */

#define DEFAULT_SENDBUFFER_SIZE (4*1024)
#define MIN_SENDBUFFER_SIZE (MAXLINELEN + sizeof ENDMULTLINTRANS + sizeof "\r\n")
#define MAX_SENDBUFFER_SIZE MAX_MAIL_HEADER_SIZE

/*
 *  The callable mail routines reads the whole file into memory.
 *  READ_DIRECT_THRESHOLD defines the maximum file size callable mail
 *  is used to process the file. For larger files normal ANSI-C routines
 *  are used.
 *  A value of 0 means no threshold, 1-2048 means every file, any larger
 *  value is used as the threshold in bytes.
 */

#define DEFAULT_READ_DIRECT_THRESHOLD 0

/*
 * The following values should not be changed.
 */

#define MIN_PASSWORD_LENGTH 8

#define ATTN_SLEEP      0
#define ATTN_CONNECT    1
#define ATTN_DISCONNECT 2
#define ATTN_TIMEOUT    3
#define ATTN_DATA       4
#define ATTN_UNBLOCK    5
#define ATTN_PURGE      6

#ifdef KERBEROS
#   define RFC_PORT        1109
#else
#   define RFC_PORT        110
#endif

#define POP_OK          "+OK "
#define POP_ERR         "-ERR "
#define POP_SUCCESS     1
#define POP_FAILURE     0
#define POP_TERMINATE   '.'
#define LOG_ERROR  0
#define LOG_INFO   1
#define LOG_THREAD 2
#define LOG_DEBUG  3

#define ITEM_LENGTH 255
#define MAX_FOLDER_LENGTH 39
#define READ_BUFFERSIZE 128

#define ENV_BOOL      0
#define ENV_NUMERICAL 1
#define ENV_STRING    2
#define ENV_DELTATIME 3

#define AUTH_NONE     0
#define AUTH_USER     1
#define AUTH_APOP     2
#define AUTH_ALL      3

#define MSG_DEL_FLAG             1      /* msg marked as deleted          */
#define MSG_RETR_FLAG            2      /* msg marked as retrieved        */
#define MSG_FOREIGN_FLAG         4      /* msg is foreign                 */
#define MSG_UNAVAILABLE_FLAG     8      /* msg out of sync. with maildrop */

#define RETR_IN_PROGRESS_FLAG    1
#define RETR_COMPLETED_FLAG      2
#define RETR_IS_EXTERNAL_FLAG    4
#define RETR_IS_RETRIEVE_FLAG    8       /* retr or top command */
#define RETR_RESTORE_FLAG       16
#define RETR_USE_ANSIC_FLAG     32

#define SERVER_SHUTDOWN 1
#define SERVER_RESTART  2

#define JPI_ASTCNT       0
#define JPI_BIOCNT       (JPI_ASTCNT + 1)
#define JPI_BYTCNT       (JPI_BIOCNT + 1)
#define JPI_DIOCNT       (JPI_BYTCNT + 1)
#define JPI_ENQCNT       (JPI_DIOCNT + 1)
#define JPI_FILCNT       (JPI_ENQCNT + 1)
#define JPI_GPGCNT       (JPI_FILCNT + 1)
#define JPI_PAGFILCNT    (JPI_GPGCNT + 1)
#define JPI_PPGCNT       (JPI_PAGFILCNT + 1)
#define JPI_MAX          (JPI_PPGCNT + 1)


/* min. values for some of the quotas */
#define MIN_ASTCNT        1     /* minimum remaining AST quota          */
#define MIN_ENQCNT        5     /* minimum remaining lock request quota */
#define MIN_FILCNT        2     /* minimum remaining open file quota    */
#define MIN_PAGFILCNT   500     /* minimum remaining paging file quota  */

#define SCAN_NORMAL 0
#define SCAN_INVALID_USER 1
#define SCAN_INVALID_PASS 2

#define Min(a,b) ((a) < (b) ? (a) : (b))
#define Max(a,b) ((a) > (b) ? (a) : (b))

#define pop_command         pop_args[0]	     /*  1st arg is a POP command   */
#define pop_subcommand      pop_args[1]      /*  if 1st token was XTND, then
					         the 2nd is a subcommand    */

typedef struct dsc$descriptor_s STR_DESCR;

#if defined __ALPHA && defined __DECC_VER && (__DECC_VER >= 50090003)
#   define HAVE_64BIT_INTEGER
    typedef __int64   bintime_type;
#elif defined __GNUC__
#   define HAVE_64BIT_INTEGER
    typedef long long   bintime_type;
#else
#   pragma nostandard
#   pragma member_alignment __save
#   pragma nomember_alignment
    typedef struct {unsigned int low; int hi;}  bintime_type;
#   pragma standard
#   pragma member_alignment __restore
#endif

typedef enum {					/*  POP processing states */
    auth1,					/*  Authorization	  */
    auth2,					/*  Authorization	  */
    trans,					/*  Transaction	          */
    update,					/*  Update		  */
    halt,					/*  Halt		  */
    disabled,                                   /*  Command disabled      */
    error					/*  Error		  */
} state;

typedef struct {                                /*  POP command state info    */
    state       ValidCurrentState;              /*  Command's operating state */
    char	*command;                       /*  The POP command	      */
    int         min_args;                       /*  Minimum args for command  */
    int         max_args;                       /*  Maximum args for command  */
    int         (*function) ();                 /*  Function for command      */
    state       PostState[2];                   /*  Post-command state	      */
} state_table;

typedef struct {                                /*  Table of extensions       */
    char	*subcommand;                    /*  The POP XTND subcommand   */
    int         min_args;                       /*  Minimum args to xtnd comm.*/
    int         max_args;                       /*  Maximum args to xtnd comm.*/
    int         (*function) ();                 /*  Function for command      */
    char        *validate;                      /*  Validation string         */
} xtnd_table;

typedef struct {                                /*  Message information       */
    bintime_type bindate;                       /*  Message arrival date      */
    int         number;                         /*  Message number	      */
    int         nummbx;                         /*  Msg. number in maildrop   */
    long        length;                         /*  Length of message (bytes) */
    int         lines;                          /*  Number of lines/message   */
    int		msg_flags;                      /*  del, retr and foreign     */
} Message;

typedef struct { char   *name;                  /*  Name of the env. var.     */
                 int    type;                   /*  Kind of variable          */
                 void   *varptr;                /*  Pointer to global var.    */
                 int    min;                    /*  Min. value if applicable  */
                 int    max;                    /*  Max. value if applicable  */
               } environ_var_type ;

struct IOSB
{
  unsigned short status;
  unsigned short count;
  int device_specific;
};

typedef struct 
{
  int   cur [JPI_MAX];
  int   min [JPI_MAX];
  int   max [JPI_MAX];
  int   count;
  float cpu;
} proc_info_type;

/*
 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

 In order to retrieve lines longer than 256 bytes from the callable mail
 subsystem, we use an undocumented item code (MAIL$_MESSAGE_BUFFER) that
 returns a pointer to the in-memory text. This text has a particular block
 structure and the following definitions simplify the handling of that
 structure.

 In essence:

  Type			OffSet from	Description
			Block Start
					+------------------------------+
  Longword pointer	0		+ Link to next block           +
					+------------------------------+
  Unsigned longword	4		+ Size of data in this block   +
					+------------------------------+
  Unsigned longword	8		+ Length of this block         +
					+------------------------------+
					+ Text records, in a format    +
  Text records,prefixed	12		: similar to variable length   :
  by unsigned word			+ files                        +
  containing length			+------------------------------+
       

  This information was supplied by Hunter Goatley.

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
*/

# pragma member_alignment __save
# pragma nomember_alignment
typedef struct TEXTBLOCKHEADER			/* Structure of a message block */
{ struct TEXTBLOCKHEADER *next;
    unsigned int    size;
    unsigned int    length;
    char            first;
} TEXTBLOCKHEADER;

typedef struct 			/* Structure of a message record */
{
    unsigned short int length;
} RECORDHEADER;

# pragma member_alignment __restore

/*
 * The thread's private data structure
 */
typedef struct 
{                                               /*  POP parameter block	      */
    bintime_type        start_time;             /*  Thread start time         */
    bintime_type        timeout;                /*  Client timeout            */
    char                user[MAXUSERNAMELEN+1]; /*  Name of the POP user      */
    char		*pop_args[MAXARGCOUNT]; /*  Parse POP parameter list  */
    char		*client;                /*  Client's name	      */
    char		ipaddr[16];             /*  Client's IP address	      */
    unsigned short      ipport;                 /*  Client's port	      */
    unsigned short	channel;		/*  VMS channel number        */
    unsigned short      msg_count;              /*  Number of new messages    */
    struct IOSB         read_iosb;              /*  read I/O status block     */
    struct IOSB         write_iosb;             /*  write I/O status block    */
    char                read_buffer[32];        /*  typical command length    */
    char                command_buffer[READ_BUFFERSIZE]; /* max. command len  */
    char                *command_pointer;
    state               CurrentState;           /*  The current POP state     */
    Message		*mptr;                  /*  Message information list  */
    int                 msgs_deleted;           /*  Number mesgs for deletion */
    int                 last_msg;               /*  Last message processed    */
    long                bytes_deleted;          /*  Number of bytes to delete */
    long                newmail_size;           /*  Size of NEWMAIL in bytes  */
    int                 arg_count;              /*  Number of args to parse   */
    int                 sockfd;                 /*  socket file descriptor    */
    int                 decnet;                 /*  FALSE, if from internet,
                                                    ever TRUE, if 
                                                    IGNORE_MAIL11_HEADERS 
						    not set                   */
    char 		*folder_name;		/*  current folder name       */
    unsigned int        user_context;           /*  VMS Mail specific */
    unsigned int        file_context;           /*  VMS Mail specific */
    unsigned int        message_context;        /*  VMS Mail specific */
    int                 newmail_selected;       /*  VMS Mail specific */
    char                mail_directory[256];    /*  VMS Mail specific */
    int                 has_no_mail_file;       /*  VMS Mail specific */
    int                 in_use;                 /*  Multithread specific */
    int                 threadnum;              /*  Multithread specific */
    int                 connected;              /*  Multithread specific */
    int                 attn_state;             /*  State of current thread   */
    int                 memory_usage;           /*  Estimated memory usage 
                                                    of current thread         */
    int                 authentication_attempts;/*  Number of login attempts  */
    struct
    {
      bintime_type start_time;     /* Start time of last transfer           */
      int  (*function) ();/* f. to be called for completion after asyn. I/O */
      FILE *ext_file;              /* Pointer to external file or NULL      */
      char *ext_file_buf;          /* Buffer associated with the ext. file  */
      TEXTBLOCKHEADER *tbh;        /* Address of current message block      */
      char *dataptr;               /* Address of next record block          */
      char *line;                  /* Pointer to current record             */
      char *send_buffer;           /* Address of allocated send buffer      */
      Message *mp;                 /* pointer to entry in msg inform. list  */
      int  enable_long_lines;      /* true if supported file format         */
      int  flags;                  /* Status bits of current message        */
      int  send_buffer_length;     /* Currend length of send buffer         */
      int  send_bufsize;           /* Used octets in send buffer            */
      int  send_count;             /* Octets already sent from send buffer  */
      int  send_octets;            /* Octets send during session            */
      int  message_lines;          /* Number of lines to sent               */
      int  lines_sent;             /* Sent lines of current message         */
      int  bufsize;                /* Used octets in buffer or line length  */
      char buffer[ITEM_LENGTH+4];  /* Buffer array for temp. storage        */
    } retrieve;
#ifdef NETLIB
    struct SINDEF sin;
#else
    struct sockaddr_in sin;
#endif
#ifdef KERBEROS
    AUTH_DAT            kdata;
    Key_schedule        schedule;
    KTEXT_ST            ticket;
    char                instance[INST_SZ];
    char                version[9];
#endif /* KERBEROS */
} POP;

#ifdef KERBEROS
char local_realm[REALM_SZ];
#endif /* KERBEROS */


/*
** Function Prototypes
*/

/* 
** Prototypes for functions in PASSWD_V5*.c
*/
int PWDcheck(char *username, char *password);

/* 
** Prototypes for functions in iupop3_commands.c
*/
int         pop_dele (POP *p);
int         pop_last (POP *p);
int         pop_list (POP *p);
int         pop_uidl (POP *p);
int         pop_parse (POP *p, char *buf);
int         pop_pass (POP *p);
int         pop_quit (POP *p);
int         pop_rset (POP *p);
int         pop_send (POP *p);
int         pop_stat (POP *p);
int         pop_noop (POP *p);
int         pop_updt (POP *p);
int         pop_user (POP *p);
int         pop_apop (POP *p);
int	    pop_auth (POP *p);
int         pop_xtnd (POP *p);
int         pop_xtnd_client (POP *p);
int         pop_xtnd_shutdown (POP *p);
int	    pop_xtnd_restart (POP *p);
int         pop_xtnd_internals (POP *p);
int         pop_xtnd_stats (POP *p);
int         pop_xtnd_loglevel (POP *p);
int	    pop_xtnd_options (POP *p);
int	    pop_xtnd_help (POP *p);
int	    pop_xtnd_validate (char *user, char *command);
int         display_runtime_options (POP *p);
int         pop_authcheck (POP *p, int status);
xtnd_table  *get_pop_subcommand (POP *p);
state_table *pop_get_command(POP *p, char *mp);
void	    set_auth_commands (int option);

/* 
** Prototypes for functions in iupop3_utility.c
*/
char    *get_date (char *date_str);
char    *get_time (char *time_str);
void	make_argv(char *string, int *argc, char *argv[], char *delimiters);
int	pop_build_info (POP *p);
void	patch_from_line (POP *p, char *from_line);
void	pop_log (int log_level, POP * p, const char *format, ...);
int	pop_msg(POP *p, int stat, const char *format, ...);
void	system_log (int log_level, char *format, ...);
int	netprintf (POP *p, char *format, ...);
int	netbprintf (POP *p, char *format, ...);
int	netbputs (POP *p, char * string, size_t length, int bytestuff);
int	netb_end (POP *p);
int	my_strncasecmp (char *str1, char *str2, int len);
int	allocate_send_buffer (POP *p);
int	enlarge_send_buffer (POP *p);
char    *lower (char *str);
char    *upper (char *str);
char    *replace_tabs (char * string);
int	check_digest (bintime_type *start_timeptr, int threadnum, 
                      char *secret, char *digest_client);
void    process_environment_options (void);
int	check_external_file (POP * p, char * name);
char    *vms_strerror (int error_number);
STR_DESCR *desz (char *String);
STR_DESCR *des (char *Buffer, size_t buflen);
/* routines only for netlib: */
int	async_write_netlib  (POP *p, void *astadr, int astparam);
int	write_netlib (int socket, char *message, int buflen);


/* 
** Prototypes for functions in iupop3_vms.c
*/
float	get_cpu (void);
proc_info_type * get_process_information (void);
int	close_external_file (POP *p);
int	mail_close_file_context (POP *p);
int	mail_close_message_context (POP *p);
int	mail_close_user_context (POP *p);
int	mail_delete_message (POP *p,int message_id);
int	mail_folder_select (POP *p,char *folder_name, int *num_messages);
int	mail_message_info (POP *p,int *message_id);
int	mail_open_file_context(POP *p);
int	mail_open_message_context(POP *p);
int	mail_open_user_context(POP *p);
int	mail_retrieve_message(POP *p);
int	mail_retrieve_message_headers (POP *p);
int	mail_retrieve_message_text(POP *p);
int	mail_user_info(POP *p);
int	valid_vms_user(POP *p);
int	mail_message_move (POP *p, char *target_folder, int message_id);
int	mail_message_new_count (POP *p, int moved_mail_count);
int	mail_purge_waste(POP *p);
int	get_shared_secret (POP *p, char *shared_secret, int len);
char	*vms_message(unsigned int code);
char	*get_timezone (void);
char    *time_from_bintime (bintime_type *bintimeptr, int mode);
char    *logtime (bintime_type *bintimeptr);
char	*stamptime (bintime_type *bintimeptr);
int	check_scan_intrusion (POP * p, char * password, int option);


/* 
** Prototypes for functions in iupop3.c
*/
void	client_read_ast (int threadnum);
void	client_unblock_ast (int threadnum);
void	client_purge_ast (int *attn_state);
void	new_connect_ast (int *accept_socket_ptr) ;
void	logfile_flush_ast (void);
int	close_pop_thread (POP *p);
int	create_initial_socket (int pop_port);
int     process_new_connect (POP *p);
int	init_pop_thread (POP *p);
int	client_authenticated (POP *p);
int	netwrite_async (POP *p, char * message, int buflen);
int     netwrite_sync (POP *p, char * message, int buflen);
int	issue_client_read_qio (POP *p);
int	issue_client_timeout_timer (POP *p);
int	issue_client_purge_timer (POP *p);
int	issue_new_connect_qio (void);
int	open_log_file (int modus);
int	issue_logfile_flush_timer (void);
void	process_thread (POP *p);
int	pop_xtnd_kill (POP *p);
POP	*get_pop_array (void);
const	environ_var_type *get_environment_list (void);
int     set_delta_time (int minutes, bintime_type *deltatime);
#endif /* IUPOP3_GENERAL_H */
