#ifndef IUPOP3_GLOBAL_H
#define IUPOP3_GLOBAL_H
/*
 ===========================================================================
 = (C) Copyright 1997,1998 Michael Stenns                                  =
 =                                                                         =
 =  Permission to use, copy, modify, and distribute this program for       =
 =  non-commercial use and without fee is hereby granted.                  =
 =                                                                         =
 =  This software is distributed in the hope that it will be useful,       =
 =  but WITHOUT ANY WARRANTY; without even the implied warranty of         =
 =  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                   =
 =                                                                         =
 ===========================================================================
 =                                                                         =
 =  (C) Copyright 1991-1994 The Trustees of Indiana University             =
 =                                                                         =
 =  Permission to use, copy, modify, and distribute this program for       =
 =  any purpose and without fee is hereby granted, provided that this      =
 =  copyright and permission notice appear on all copies and supporting    =
 =  documentation, the name of Indiana University not be used in           =
 =  advertising or publicity pertaining to distribution of the program     =
 =  without specific prior permission, and notice be given in supporting   =
 =  documentation that copying and distribution is by permission of        =
 =  Indiana University.                                                    =
 =                                                                         =
 =  Indiana University makes no representations about the suitability of   =
 =  this software for any purpose. It is provided "as is" without express  =
 =  or implied warranty.                                                   =
 =                                                                         =
 ===========================================================================
 =                                                                         =
 = File:                                                                   =
 =   IUPOP3_GLOBAL.H                                                      =
 =                                                                         =
 = Authors:                                                                =
 =   Jacob Levanon & Larry Hughes                                          =
 =   Indiana University                                                    =
 =   University Computing Services, Network Applications                   =
 =                                                                         =
 = Credits:                                                                =
 =   This software is based on the Post Office Protocol version 3,         =
 =   as implemented by the University of California at Berkeley.           =
 =                                                                         =
 ===========================================================================
*/
#include "iupop3_general.h"
#include "iupop3_vms.h"


#ifdef MAIN_MODULE

#ifdef PERSONAL_NAME
  int  personal_name             = TRUE;
#else
  int  personal_name             = FALSE;
#endif

#ifdef IGNORE_MAIL11_HEADERS
  int  ignore_mail11_headers     = TRUE;
#else
  int  ignore_mail11_headers     = FALSE;
#endif

#ifdef SEND_ORIG_HEADER      /* support old option name */
#  ifndef USE_BOTTOM_HEADERS
#    define USE_BOTTOM_HEADERS
#  endif
#endif

#ifdef USE_BOTTOM_HEADERS
  int  use_bottom_headers        = TRUE;
#else
  int  use_bottom_headers        = FALSE;
#endif

#ifdef USE_MAIL_FOLDER
  int  use_mail_folder           = TRUE;
#else
  int  use_mail_folder           = FALSE;
#endif

#ifdef IGNORE_EXPIRED_PASSWORDS
  int  ignore_expired_passwords  = TRUE;
#else
  int  ignore_expired_passwords  = FALSE;
#endif

#ifdef FAST_SCAN
  int  fast_scan                 = TRUE;
#else
  int  fast_scan                 = FALSE;
#endif

#ifdef SCAN_INTRUSION
  int  scan_intrusion            = TRUE;
#else
  int  scan_intrusion            = FALSE;
#endif

#ifdef ENABLE_LONG_LINES
  int  enable_long_lines         = TRUE;
#else
  int  enable_long_lines         = FALSE;
#endif

#ifdef APOP_CHECK_DUPLICATE
  int  apop_check_duplicate      = TRUE;
#else
  int  apop_check_duplicate      = FALSE;
#endif

#ifdef DEFAULT_TO_SMTP
  int  default_to_smtp           = TRUE;
#else
  int  default_to_smtp           = FALSE;
#endif

#ifdef PURGE_MAILBOXES
  int  purge_mailboxes           = TRUE;
#else
  int  purge_mailboxes           = FALSE;
#endif

#if defined PURGE_RECLAIM || defined PURGE_RECLAIM_THRESHOLD
  int  purge_reclaim		 = TRUE;
  int  purge_reclaim_threshold   = 32167;
#else
  int  purge_reclaim		 = FALSE;
  int  purge_reclaim_threshold   = 0;
#endif

  /* max. length of async. network I/O and default sendbuffer size  */
  int  default_sendbuffer_size   = DEFAULT_SENDBUFFER_SIZE;   
  int  read_direct_threshold     = DEFAULT_READ_DIRECT_THRESHOLD;
  int  max_purge_messages        = DEFAULT_PURGE_MESSAGES;

  int  total_threads        = 0;
  int  current_threads      = 0;
  int  maximum_threads      = 0;
  int  too_many_threads     = 0;
  int  retrieved_messages   = 0;
  int  retrieved_octets     = 0;
  int  minimum_octets       = INT_MAX;
  int  maximum_octets       = 0;
  int  normal_disconnects   = 0;
  int  abnormal_disconnects = 0;
  int  timeouts             = 0;
  int  blocked_count        = 0;
  int  server_shutdown      = FALSE;
  int  authentication_failures = 0;
  int  master_log_level     = LOG_THREAD;
  int  max_messages         = MAX_MESSAGES;
  int  reset_runtime_options= FALSE;

  unsigned long net_bytes_written  = 0;
  unsigned long net_bytes_read     = 0;
  unsigned long net_write_count    = 0;
  unsigned long net_read_count     = 0;
  unsigned long main_loop_count    = 0;
  unsigned long hibernation_count  = 0;
  unsigned long commands_processed = 0;
  bintime_type  server_start_time;
  char myhostname[MAXHOSTNAMELEN+1];
  char *xtnd_filename       = NULL;
  char *log_filename        = NULL;
  FILE *log_file;
  ITEMLIST nullist[1] = { {0,0,0,0} };
  ITEMLIST inlist[MAX_ITEMS];
  ITEMLIST *inlist_ptr;
  ITEMLIST outlist[MAX_ITEMS];
  ITEMLIST *outlist_ptr;
#else
  extern int  personal_name;
  extern int  ignore_mail11_headers;
  extern int  use_bottom_headers;
  extern int  use_mail_folder;
  extern int  ignore_expired_passwords;
  extern int  fast_scan;
  extern int  scan_intrusion;

  extern int  purge_mailboxes;
  extern int  purge_reclaim_threshold;
  extern int  apop_check_duplicate;
  extern int  enable_long_lines;

  extern int  default_sendbuffer_size;
  extern int  read_direct_threshold;
  extern int  max_purge_messages;

  extern int  total_threads;
  extern int  current_threads;
  extern int  maximum_threads;
  extern int  too_many_threads;
  extern int  retrieved_messages;
  extern int  retrieved_octets;
  extern int  minimum_octets;
  extern int  maximum_octets;
  extern int  normal_disconnects;
  extern int  abnormal_disconnects;
  extern int  timeouts;
  extern int  server_shutdown;
  extern int  blocked_count;
  extern int  authentication_failures;
  extern int  master_log_level;
  extern int  max_messages;
  extern int  purge_reclaim;
  extern int  default_to_smtp;
  extern int  reset_runtime_options;
  extern bintime_type server_start_time;
  extern char myhostname[];
  extern char *xtnd_filename;
  extern char *log_filename;
  extern FILE *log_file;
  extern unsigned long net_bytes_written;
  extern unsigned long net_bytes_read;
  extern unsigned long net_write_count;
  extern unsigned long net_read_count;
  extern unsigned long main_loop_count;
  extern unsigned long hibernation_count;
  extern unsigned long commands_processed;
  extern ITEMLIST nullist[];
  extern ITEMLIST inlist[];
  extern ITEMLIST *inlist_ptr;
  extern ITEMLIST outlist[];
  extern ITEMLIST *outlist_ptr;
#endif
#endif /* IUPOP3_GLOBAL_H */
