$on error then goto error_exit
$ say = "write sys$output"
$! -----------------------------------------------------------------------
$! IUPOP3 can send a mail message after a program crash or a restart.
$! Specify a list of people who should get mail as a comma separated list.
$! Default recipient is the owner running this file.
$! -----------------------------------------------------------------------
$  mail_recipients = F$EDIT(F$GETJPI("","USERNAME"),"COLLAPSE")
$!
$! -----------------------------------------------------------------------
$! The following variable need only to be set on old OpenVMS
$! versions, where SYS$TIMEZONE_DIFFERENTIAL is not already defined.
$! It should contain the offset of your timezone to UTC in hours.
$! -----------------------------------------------------------------------
$  offset_hour = -5    ! EST (eastern standard time)
$!
$! -----------------------------------------------------------------------
$! You may want to define one or more of the following logicals:
$! The define_logical subroutine will automatically prefix each logical
$! with "IUPOP3_".
$! -----------------------------------------------------------------------
$!
$! - boolean logicals -
$ call define_logical IGNORE_MAIL11_HEADERS            TRUE
$ call define_logical DEFAULT_TO_SMTP                  TRUE
$ call define_logical USE_BOTTOM_HEADERS               FALSE
$ call define_logical PERSONAL_NAME                    TRUE
$ call define_logical USE_MAIL_FOLDER                  FALSE
$ call define_logical FAST_SCAN                        TRUE
$ call define_logical SCAN_INTRUSION                   TRUE
$ call define_logical APOP_CHECK_DUPLICATE             TRUE
$ call define_logical IGNORE_EXPIRED_PASSWORDS         TRUE
$ call define_logical PURGE_MAILBOXES                  TRUE
$ call define_logical ENABLE_LONG_LINES                TRUE
$!
$! - numerical logicals -
$ call define_logical PURGE_RECLAIM_THRESHOLD          32000
$ call define_logical MAX_MESSAGES                     4096
$ call define_logical CLIENT_TIMEOUT                   10
$ call define_logical DEFAULT_SENDBUFFER_SIZE          8000
$! 
$! READ_DIRECT_THRESHOLD becomes defined in IUPOP3_STARTUP.COM if
$! not defined here.
$! call define_logical READ_DIRECT_THRESHOLD            0
$!
$! - string logicals -
$!                values for AUTH_COMMANDS:
$!                     "user"  - use only user/pass authorization
$!                     "apop"  - use only apop authorization
$!                     "all"   - allow both commands (default)
$!
$ call define_logical AUTH_COMMANDS                "user,apop"
$!
$!                Name of the folder foreign messages should be moved to.
$!                Without this logical defined foreign messages are not moved.
$! call define_logical FOREIGN_FOLDER                "FOREIGN-MAIL"
$!
$  call define_logical MAIL_RECIPIENTS               "''mail_recipients'"
$! - node mapping logicals -
$! -----------------------------------------------------------------------
$! Node mapping via logical names IUPOP3_NODE_xxx:
$! This is very useful for building meaningful reply addresses.
$! Mapping without this logical defined:
$!       nodename::username   --->  username@nodename
$! Mapping with this logical defined:
$! $ call define_logical NODE_nodename  "node.subdom.dom"
$!       nodename::username   --->  username@node.subdom.dom
$! -----------------------------------------------------------------------
$!
$! $ call define_logical  NODE_xxx  "xxx.xxx.xxx"
$! $ call define_logical  NODE_xxx  "xxx.xxx.xxx"
$! $ call define_logical  NODE_xxx  "xxx.xxx.xxx"
$!
$!
$! -----------------------------------------------------------------------
$! check for SYS$TIMEZONE_DIFFERENTIAL
$! this logical should contain the offset to UTC in seconds.
$! On OpenVMS > 6.x this logical should already be defined.
$!
$if (f$trnlnm("SYS$TIMEZONE_DIFFERENTIAL") .eqs. "") 
$then 
$   offset = offset_hour * 3600
$   define /system /nolog  SYS$TIMEZONE_DIFFERENTIAL 'offset'
$endif    
$!
$exit:
$exit
$!
$! All logicals used by IUPOP3 are prefixed with "IUPOP3_"
$ define_logical: subroutine
$ if ("''p1'" .nes. "" .and. "''p2'" .nes. "") 
$ then
$    define /system /nolog IUPOP3_'p1' "''p2'"
$ endif
$ exit
$ endsubroutine
$!
$! come here on any error
$error_exit:
$ say "============================================================"
$ say "  The logicals for IUPOP3 cannot be defined."
$ say "  Please check your privileges (sysprv or sysnam required)."
$ say "============================================================"
$ goto exit
