$! -----------------------------------------------------------------------
$! This file defines it's current location as IUPOP3_ROOT:[000000].
$! IUPOP3_ROOT:[BIN] becomes IUPOP3_EXE and IUPOP3_ROOT:[log] IUPOP3_LOG.
$! IUPOP3.COM and IUPOP3_arch.EXE should be copied to IUPOP3_EXE.
$! -----------------------------------------------------------------------
$!
$ on warning   then goto exit
$ on error     then goto exit
$ on control_y then goto exit
$ return_status = 0
$!
$! -----------------------------------------------------------------------
$! These next lines are the lines you need to customize.
$! -----------------------------------------------------------------------
$!
$! -----------------------------------------------------------------------
$! If scan_intrusion is not available, the security privilege is not needed.
$! For CMU PHY_IO privilege may be required for opening 
$! well known ports (like 110)!
$! -----------------------------------------------------------------------
$!
$ required_privileges = "tmpmbx,netmbX,cmkrnl,sysprv,bypass,altpri"
$ vms_version = f$getsyi("VERSION")
$ vms_version_num = -
        10000000 * -
        f$integer(f$extract(1,f$locate(".",vms_version)-1,vms_version))  -
        + 100000 * -
        f$integer(f$extract(0,1,f$element(1,".",vms_version)))
$!
$ is_alpha = (f$getsyi("HW_MODEL") .gt. 1024)
$ if ((is_alpha) .and. (vms_version_num .ge. 60200000)) .or. -
     ((.not. is_alpha) .and. (vms_version_num .ge. 60100000))
$ then 
$   required_privileges = required_privileges + ",security"
$ endif
$ if f$getdvi("IP:","EXISTS")     ! check for OpenCMU
$ then 
$   required_privileges = required_privileges + ",phy_io"
$ endif
$ prev_privs = f$setprv(required_privileges)
$ if .not. f$privilege(required_privileges) then goto no_privileges
$!
$ call def_iupop3_dirs
$! -----------------------------------------------------------------------
$! Adjust the resources IUPOP3 should use.
$! -----------------------------------------------------------------------
$!
$ page_file_quota = 80000      ! paging file quota in pagelets
$ maximum_working_set = 2048   ! maximum working set quota
$!
$! -----------------------------------------------------------------------
$! IUPOP3_LOGICALS.COM should be already executed or located in
$! IUPOP3_ROOT (Same location as this file).
$! -----------------------------------------------------------------------
$ if (f$search("IUPOP3_ROOT:[000000]IUPOP3_LOGICALS.COM") .nes. "")
$ then
$   @IUPOP3_ROOT:[000000]IUPOP3_LOGICALS
$ endif
$! -----------------------------------------------------------------------
$! Defining the READ_DIRECT_THRESHOLD to 1/30 of the page file quota
$! prevents the POP3 server from running out of memory even if
$! every thread (max. 30) accesses a very large mail message.
$! Values already set in IUPOP3_LOGICALS.COM will not be overwritten.
$ threshold = (('page_file_quota'/30)*512)
$ call check_logical READ_DIRECT_THRESHOLD   "''threshold'"
$!
$! -----------------------------------------------------------------------
$! Everything below this line should be OK, but can be changed.
$! -----------------------------------------------------------------------
$! The following logical is recognized only by IUPOP3.COM:
$  mail_recipients = F$EDIT(F$GETJPI("","USERNAME"),"COLLAPSE")
$!
$  call check_logical  MAIL_RECIPIENTS "''mail_recipients'"
$! -----------------------------------------------------------------------
$! To run another instance of the server (e.g. for testing purpose) only
$! the "pop_port" and "name" symbols have to adjusted and the 
$! iupop3_exe:iupop3.com start file has to be copied to 'name'.com.
$!
$ pop_port = 110
$ name     = "IUPOP3"         !name of startup commandfile in iupop3_exe
$!
$ uic      = "SYSTEM"
$ node     = f$getsyi("NODENAME")
$ infile   = "iupop3_exe:''name'.com"
$ outfile  = "iupop3_log:''node'_''name'.LOG"
$!
$! The following logical is not needed if server runs on standard port 110
$ if pop_port .ne. 110 then call check_logical port 'pop_port' 'name'_
$!
$ if (F$SEARCH(infile) .eqs. "") then goto no_infile
$ if (F$SEARCH("iupop3_exe:iupop3_*.exe") .eqs. "") then goto no_exefile
$ if (F$PARSE(outfile) .eqs. "") then goto no_logdir
$!
$ purge/nolog/keep=5 'outfile'
$!
$ run/detached         -
     /uic=['uic']     -
     /privilege=('required_privileges') -
     /input='infile'   -
     /output='outfile' -
     /error='outfile'  -
     /ast_limit=90     -
     /io_buffered=65   -
     /io_direct=60     -
     /time=0           -
     /file=64          -
     /buffer=90000     -
     /queue_limit=20   -
     /enqueue_limit=50 -
     /page_file='page_file_quota'  -
     /maximum_working_set='maximum_working_set' -
     SYS$SYSTEM:LOGINOUT.EXE
$!
$ return_status = $status
$exit:
$ prev_privs = f$setprv(prev_privs)
$ exit return_status
$!
$! -----------------------------------------------------------------------
$! define only new logicals
$! -----------------------------------------------------------------------
$ check_logical: subroutine
$ if ("''p3'" .nes. "")
$ then
$    prefix = "''p3'"
$ else
$    prefix = "IUPOP3_"
$ endif
$ if ("''p1'" .nes. "" .and. "''p2'" .nes. "") 
$ then
$    if (f$trnlnm(p1) .eqs. "" .or. "''p3'" .nes. "") then -
        $define /system /nolog  'prefix''p1' "''p2'"
$ endif
$ exit
$ endsubroutine
$!
$! -----------------------------------------------------------------------
$! redefine logicals
$! -----------------------------------------------------------------------
$ define_logical: subroutine
$ if ("''p3'" .nes. "")
$ then
$    prefix = "''p3'"
$ else
$    prefix = "IUPOP3_"
$ endif
$ if ("''p1'" .nes. "" .and. "''p2'" .nes. "") 
$ then
$    define /system /nolog 'prefix''p1' "''p2'"
$ endif
$ exit
$ endsubroutine
$!
$! -----------------------------------------------------------------------
$! define target_dir with the systax dev:[dir.]
$! -----------------------------------------------------------------------
$ def_iupop3_dirs : subroutine
$ env=f$environment("PROCEDURE")
$ target_dir = f$parse("Z.Z;", env,,,"NO_CONCEAL") - "Z.Z;"
$ if f$locate("][000000]",target_dir) .lt. f$length(target_dir) then -
     target_dir = target_dir - ".][000000]" + "]"
$ target_dir = target_dir - "]["
$ logvolnam = f$getdvi(target_dir,"LOGVOLNAM")
$ if logvolnam .nes. "" then $ target_dir = f$parse(logvolnam,target_dir)
$ target_dir = target_dir - "].;" + ".]"
$!
$ define /system  /nolog /tran=conc iupop3_root 'target_dir'
$ define /system  /nolog            iupop3_exe  iupop3_root:[bin]
$ define /system  /nolog            iupop3_log  iupop3_root:[log]
$!
$ endsubroutine
$!
$no_privileges:
$ return_status = %x10000000
$ write sys$output "Insufficient privileges to start IUPOP3."
$ write sys$output "IUPOP3 requires ",required_privileges," privileges."
$ goto exit
$no_infile:
$ return_status = 2320  !no such file
$ write sys$output "Required file IUPOP3_EXE:IUPOP3.COM is not found."
$ goto exit
$no_exefile:
$ return_status = 2320  !no such file
$ write sys$output "No executable found in IUPOP3_EXE!"
$ goto exit
$no_logdir:
$ return_status = 2320  !no such file
$ write sys$output "Logfile directorie IUPOP3_LOG does not exist"
$ goto exit
