#ifndef IUPOP3_VMS_H
#define IUPOP3_VMS_H
/*
 ===========================================================================
 = (C) Copyright 1997,1998 Michael Stenns                                  =
 =                                                                         =
 =  Permission to use, copy, modify, and distribute this program for       =
 =  non-commercial use and without fee is hereby granted.                  =
 =                                                                         =
 =  This software is distributed in the hope that it will be useful,       =
 =  but WITHOUT ANY WARRANTY; without even the implied warranty of         =
 =  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                   =
 =                                                                         =
 ===========================================================================
 =                                                                         =
 =  (C) Copyright 1991-1994 The Trustees of Indiana University             =
 =                                                                         =
 =  Permission to use, copy, modify, and distribute this program for       =
 =  any purpose and without fee is hereby granted, provided that this      =
 =  copyright and permission notice appear on all copies and supporting    =
 =  documentation, the name of Indiana University not be used in           =
 =  advertising or publicity pertaining to distribution of the program     =
 =  without specific prior permission, and notice be given in supporting   =
 =  documentation that copying and distribution is by permission of        =
 =  Indiana University.                                                    =
 =                                                                         =
 =  Indiana University makes no representations about the suitability of   =
 =  this software for any purpose. It is provided "as is" without express  =
 =  or implied warranty.                                                   =
 =                                                                         =
 ===========================================================================
 =                                                                         =
 = File:                                                                   =
 =   IUPOP3_GENERAL.H                                                      =
 =                                                                         =
 = Authors:                                                                =
 =   Jacob Levanon & Larry Hughes                                          =
 =   Indiana University                                                    =
 =   University Computing Services, Network Applications                   =
 =                                                                         =
 = Credits:                                                                =
 =   This software is based on the Post Office Protocol version 3,         =
 =   as implemented by the University of California at Berkeley.           =
 =                                                                         =
 ===========================================================================
*/

/* ======================================================================== */
/* Defines/Types */
/* ======================================================================== */
#define vms_error(status) (!(status & 1))

#ifndef MAIL$_MESSAGE_HEADER
#   define MAIL$_MESSAGE_HEADER    2132
#endif
#ifndef MAIL$_MESSAGE_TEXT
#   define MAIL$_MESSAGE_TEXT      2133
#endif
#ifndef MAIL$_NOTEXIST
#   define MAIL$_NOTEXIST       8290522
#endif
#ifndef MAIL$_NOMOREREC
#   define MAIL$_NOMOREREC      8314792
#endif
#ifndef MAIL$V_MARKED
#   define MAIL$V_MARKED              7
#endif

#define NO_CONTEXT 0


/* ======================================================================== */
/* The following three macros are used to manipulate itmlst_3 type item lists */
/* ======================================================================== */
#define itemopen(ptr,itm) ptr = itm
#define itemadd(p,a,b,c,d) p->buffer_length = (short) a;\
			   p->item_code = (short) b; \
                           p->buffer_address =  c; \
			   p->return_length_address =  d; \
                           p++;
#define itemclose(ptr) itemadd(ptr,0,0,0,0);

#define MAX_ITEMS 10

typedef struct
{
  short buffer_length;
  short item_code;
  void * buffer_address;
  void * return_length_address;
} ITEMLIST;


/* ======================================================================== */
/* The following macros are used to manipulate bintime_type variables:      */
/* BINTIME_INIT_ZERO   -  inits to zero in a variable declaration.          */
/* BINTIME_TO_ZERO(a)  -  sets to zero in a statement.                      */
/* BINTIME_IS_ZERO(a)  -  true, if the binary time is zero.                 */
/* BINTIME_COMPARE(a,b)-  compares two absolute binary times; returns zero  */
/*                        if equal, pos. value if a > b, neg. value else.   */
/* ======================================================================== */
#ifdef HAVE_64BIT_INTEGER
# define BINTIME_INIT_ZERO      0
# define BINTIME_TO_ZERO(a)     (a = 0);
# define BINTIME_IS_ZERO(a)     (!(a))
# define BINTIME_COMPARE(a,b)   ((a) - (b))
#else
# define BINTIME_INIT_ZERO      {0,0}
# define BINTIME_TO_ZERO(a)     ((a).low = 0, (a).hi = 0);
# define BINTIME_IS_ZERO(a)     ((!(a).low && !(a).hi))
# define BINTIME_COMPARE(a,b) \
         ((((a).hi == (b).hi) && ((a).low == (b).low)) ? 0 : \
          (((a).hi > (b).hi) || \
           (((a).hi == (b).hi) && ((a).low > (b).low))) ? 1 : -1 \
         )
#endif



#define FROM_LINE       1
#define TO_LINE         2
#define CC_LINE         3
#define SUBJECT_LINE    4
#define MAXHEADERS      4

#ifdef UCX
#define netclose close
#endif

#ifdef MULTINET
#define netclose socket_close
#endif

#ifdef NETLIB
#   if defined ALPHA && defined __GNUC__
#	define netclose(a) NETLIB_CLOSE ((void *)& a)
#   else
#	define netclose(a) netlib_close ((void *)& a)
#   endif
#endif

#ifdef __GNUC__
/* this structure from <uaidef.h> needs to be patched for GNU C */
typedef union {   
  unsigned int uai_space;
    struct {                          /* user flags longword              */
    unsigned uai$v_disctly : 1;         /* no user control-y                */
    unsigned uai$v_defcli : 1;          /* only allow user default CLI      */
    unsigned uai$v_lockpwd : 1;         /* disable SET PASSWORD command     */
    unsigned uai$v_restricted : 1;      /* restricted account (pre-V5.2 CAPTIVE)  */
    unsigned uai$v_disacnt : 1;         /* no interactive login             */
    unsigned uai$v_diswelcom : 1;       /* skip welcome message             */
    unsigned uai$v_dismail : 1;         /* skip new mail message            */
    unsigned uai$v_nomail : 1;          /* disable mail delivery            */
    unsigned uai$v_genpwd : 1;          /* passwords must be generated      */
    unsigned uai$v_pwd_expired : 1;     /* password has expired             */
    unsigned uai$v_pwd2_expired : 1;    /* 2nd password has expired         */
    unsigned uai$v_audit : 1;           /* audit all actions                */
    unsigned uai$v_disreport : 1;       /* skip last login messages         */
    unsigned uai$v_disreconnect : 1;    /* inhibit reconnections            */
    unsigned uai$v_autologin : 1;       /* auto-login only                  */
    unsigned uai$v_disforce_pwd_change : 1; /* disable forced password change */
    unsigned uai$v_captive : 1;         /* captive account (no overrides)   */
    unsigned uai$v_disimage : 1;        /* disable arbitrary image activation */
    unsigned uai$v_dispwddic : 1;       /* disable password dictionary filter */
    unsigned uai$v_dispwdhis : 1;       /* disable password history search  */
    unsigned uai$v_defclsval : 1;       /* default classification is valid  */
    unsigned uai$v_fill_20 : 3;
    } bit;
} uai_flags_u ;

#define FLAGS_DISUSER_DISMAIL \
        (uai_flags.bit.uai$v_disacnt || uai_flags.bit.uai$v_nomail)
#define FLAGS_EXPIRED_PASSWORD \
        (uai_flags.bit.uai$v_pwd_expired || uai_flags.bit.uai$v_pwd2_expired)

#else /* VAXC or DECC */

#define FLAGS_DISUSER_DISMAIL \
        (uai_flags.uai$v_disacnt || uai_flags.uai$v_nomail)
#define FLAGS_EXPIRED_PASSWORD \
        (uai_flags.uai$v_pwd_expired || uai_flags.uai$v_pwd2_expired)
typedef struct flags uai_flags_u;
#endif /* GNUC or VAXC/DECC */

#endif  /* IUPOP3_VMS_H */
