$ on control_y then goto final_exit
$ on error     then continue
$ say     := write SYS$OUTPUT
$!
$!***************************
$! Process Arguments
$!***************************
$ make_type = ""
$ make_options = ""
$ mms_options = ""
$ compiler = ""
$ cc = "cc"
$ C_FLAGS == "/LIS/OPT"
$ tcpip = ""
$ tcpip_info = ""
$ tcpip_emulation = "UCX"
$ link_only = "F"
$!
$!***************************
$! Initialize
$!***************************
$ say     := write SYS$OUTPUT
$ facility = "%IUPOP3MAKE"
$ putopt := write /error=error_exit optfile
$!
$ is_alpha = (f$getsyi("HW_MODEL") .gt. 1024)
$ if (is_alpha)
$ then
$   arch = "ALPHA"
$ else
$   arch = "VAX"
$ endif
$!
$!
$!***************************
$! Main Program
$!***************************
$ gosub scan_parameters
$ if link_only
$ then
$    say facility,"-I-LINKONLY, do not compile any source files "
$    gosub check_pw_version
$    gosub check_parameters
$    gosub check_make_type
$ else
$    gosub open_optfile
$    gosub check_compiler
$    gosub check_pw_version
$    gosub check_parameters
$    gosub check_make_type
$    gosub prepare_'tcpip'
$    gosub final_options
$ endif
$ gosub compile_'make_type'
$!
$ say facility,"-I-SUCCESS, IUPOP3 successfully made"

$ if (tcpip .eqs. "MULTINET") .or. (tcpip .eqs. "UCX")
$ then
$   say ""
$   say "IMPORTANT: You may need to remove ''tcpip''s POP3 server from the"
$   say "           network configuration, before you can start IUPOP3."
$   say ""
$ endif
$ goto  final_exit
$!
$!***************************
$! Final Options
$!***************************
$ final_options:
$ say facility,"-I-TCPTYPE,  making IUPOP3 for ",tcpip_info, " TCP/IP"
$ if (compiler .eqs. "GNUC")
$ then
$   make_options = ",GNUC" + make_options
$   if "''GCC'" .nes. ""
$   then
$     cc = "''gcc'"
$   else
$     cc = "gcc"
$   endif
$   if (.not. is_alpha)
$   then
$      C_FLAGS == C_FLAGS + "/NOPLUS_PLUS"
$   endif
$   putopt "!GNU C library"
$   if (f$search("gnu_cc:[000000]gcclib.olb") .nes. "")
$   then
$      putopt "gnu_cc:[000000]gcclib/lib"
$   else if (f$search("GNU_CC_LIBRARY:LIBGCC.OLB") .nes. "")
$   then
$     putopt "GNU_CC_LIBRARY:LIBGCC/lib      ! gnu c compiler utility routines"
$     putopt "sys$library:VAXCRTL/lib        ! standard C routines"
$     putopt "!sys$share:mailshr/share        ! mail routines"
$     putopt "GNU_CC_LIBRARY:crt0.obj        ! startup file"
$   else
$     putopt "!cannot locate library"
$   endif
$   endif
$ else if (compiler .eqs. "DECC")
$ then
$   C_FLAGS == "/DECC" + C_FLAGS
$ endif  ! DECC
$ endif  ! GNUC
$ C_FLAGS == C_FLAGS + "/define=(''tcpip_emulation',''arch'''make_options')"
$ close optfile
$ return
$!***************************
$! Open Option File
$!***************************
$ open_optfile:
$ open /write /error=final_exit optfile iupop3.opt
$ putopt "!linker options file for IUPOP3"
$ return
$!
$!***************************
$! Check password version
$!***************************
$!
$ check_pw_version:
$ vms_version = f$getsyi("VERSION")
$ vms_version_num = -
        10000000 * -
        f$integer(f$extract(1,f$locate(".",vms_version)-1,vms_version))  -
        + 100000 * -
        f$integer(f$extract(0,1,f$element(1,".",vms_version)))
$!
$! if either SCAN_INTRUSION or NO_SCAN_INTRUSION is specified, do not check
$! anything. The user knows what he is doing...
$ if (.not. link_only .and. -
      f$locate("SCAN_INTRUSION",make_options) .eq. f$length(make_options))
$ then
$   if ((is_alpha) .and. (vms_version_num .lt. 60200000)) .or. -
       ((.not. is_alpha) .and. (vms_version_num .lt. 60100000))
$   then 
$      make_options = ",NO_SCAN_INTRUSION" + make_options
$   else     ! ciadef.h may be missing
$      if ((compiler .eqs. "DECC" .and. -
           (f$search("sys$library:sys$starlet_c.tlb") .eqs. "" .and.  -
            f$search("sys$common:[decc$lib.reference.decc$rtldef]ciadef.h") .eqs. "")) -
           .or. -
           (.not. (compiler .eqs. "GNUC" .and. is_alpha) .and. -
            compiler .nes. "DECC" .and. f$search("sys$library:ciadef.h") .eqs. ""))
$      then
$         say facility,"-W-NOFILE,   definition file CIADEF.H probably missing "
$         say facility,"-I-HINT,     on compilation errors add NO_SCAN_INTRUSION make parameter"
$      endif
$   endif
$ endif
$ if (f$locate("NO_SCAN_INTRUSION",make_options) .ne. f$length(make_options))
$ then
$   say facility,"-I-NOINTR,   making IUPOP3 without intrusion scan possibility"
$ endif
$ if ((.not. is_alpha) .and. (vms_version_num .lt. 50400000))
$ then
$   password_version = "53"
$ else
$   password_version = "54"
$ endif
$ say facility,"-I-PASS,     making IUPOP3 with password version ",password_version
$return
$!
$!***************************
$! Check Compiler
$!***************************
$!
$ check_compiler:
$ if (compiler .eqs. "" .and. f$search("sys$system:decc$compiler.exe") .nes. "")
$ then
$   compiler = "DECC"
$ endif
$ if (compiler .eqs. "" .and. f$search("sys$system:vaxc.exe") .nes. "")
$ then
$   compiler = "VAXC"
$ endif
$ if (compiler .eqs. "" .and. f$trnlnm("GNU_CC_VERSION") .nes. "")
$ then
$   compiler = "GNUC"
$   cc = "gcc"
$ endif
$ if (compiler .eqs. "" .and. (.not. is_alpha))
$ then
$   compiler = "VAXC"
$ endif
$ if (compiler .eqs. "VAXC" .or. -
     (.not. is_alpha .and. compiler .eqs. "GNUC"))
$ then
$   putopt "!VAXC runtime library"
$   putopt "sys$share:vaxcrtl/share"
$ endif
$ if ((compiler .eqs. "DECC") .or. -
      (compiler .eqs. "VAXC")  .or. -
      (compiler .eqs. "GNUC"))
$   then
$     say facility,"-I-CCTYPE,   making IUPOP3 with ",compiler," for ",arch
$   else
$     say facility,"-F-INVCC,    ",compiler," compiler is not supported"
$     exit
$ endif
$ if (compiler .eqs. "GNUC" .and. is_alpha)
$ then
$    badfile = "gnu_cc_include:[sys]types.h"
$    if (f$search(badfile) .nes. "")
$    then
$       search 'badfile' "typedef short dev_t;" /out=nl:
$       if $STATUS .eq. %X00000001
$       then
$          say ""
$          say "  There is a bug in ''badfile' (wrong definition for dev_t)!"
$          say "  Please replace this file with a fixed version from "
$          say "  ftp://ftp.progis.de/pub/vms/gnu/include/sys/types.h"
$          say "  and run this procedure again"
$          say ""
$          say facility,"-F-ABORT,    Installation aborted"
$          goto final_exit
$       endif
$    else
$       say facility,"-F-MISFILE,  ",badfile," is missing, check your gcc installation"
$       goto final_exit
$    endif
$ endif
$return
$!***************************
$! Check Parameters
$!***************************
$ check_parameters:
$!
$ if (tcpip .eqs. "")
$ then
$   if (f$trnlnm("UCX$DEVICE") .nes. "") then tcpip = "UCX"
$   if (f$trnlnm("MULTINET")   .nes. "") then tcpip = "MULTINET"
$   if (f$trnlnm("TWG$TCP")    .nes. "") then tcpip = "WINS"
$   if (f$trnlnm("TCPWARE")    .nes. "") then tcpip = "TCPWARE"
$ endif
$ if (tcpip .eqs. "")
$ then
$   if (f$trnlnm("NETLIB_SHR")    .nes. "") then tcpip = "NETLIB"
$ endif
$!
$ if ((tcpip .eqs. "WINS") .or. -
      (tcpip .eqs. "UCX")  .or. -
      (tcpip .eqs. "NETLIB")  .or. -
      (tcpip .eqs. "TCPWARE")  .or. -
      (tcpip .eqs. "MULTINET"))
$   then
$     !say facility,"-I-TCPTYPE,  making IUPOP3 for ",tcpip_info, " TCP/IP"
$   else
$     say facility,"-F-INVTCP, '",tcpip,"' TCP/IP is not supported"
$     exit
$ endif
$!
$ return
$!
$!***************************
$! Check make type
$!***************************
$ check_make_type:
$ if (make_type .eqs. "")
$ then
$   on error then continue
$   define sys$output nl:
$   define sys$error nl:
$   mms
$   ss_status = $status
$   deassign sys$output 
$   deassign sys$error
$   on error then continue
$   if (ss_status .eq. %X00038090)
$   then
$     on error then continue
$     define sys$output nl:
$     define sys$error nl:
$     mmk
$     ss_status = $status
$     deassign sys$output 
$     deassign sys$error
$     on error then continue
$     if (ss_status .eq. %X00038090)
$     then
$       make_type = "NOMMS"
$     else
$       make_type = "MMK"
$     endif
$   else
$     make_type = "MMS"
$   endif
$ endif
$!
$ if ((make_type .eqs. "MMS") .or. (make_type .eqs. "NOMMS") -
                              .or. (make_type .eqs. "MMK"))
$ then
$   say facility,"-I-MAKETYPE, making IUPOP3 with ",make_type
$ else
$   say facility,"-F-INVMAKE, make type must be MMS, MMK or NOMMS"
$   exit
$ endif
$!
$ return
$!
$!***************************
$! Compile MMS
$!***************************
$ compile_mms:
$ say "$mms/description=iupop3.mms ''mms_options'"
$ mms/description=iupop3.mms 'mms_options'
$ return
$!
$!***************************
$! Compile MMK
$!***************************
$ compile_mmk:
$ say "$mmk/description=iupop3.mms ''mms_options'"
$ mmk/description=iupop3.mms 'mms_options'
$ return
$!
$!***************************
$! Compile NOMMS
$!***************************
$ compile_nomms:
$ if (f$edit("''mms_options'","TRIM,LOWERCASE") .eqs. "clean")
$ then
$    delete/log *.obj;*,iupop3*.exe;*,*.lis;*
$    goto compile_nomms_exit
$ endif
$ compile := 'cc' 'c_flags'
$ verify = f$verify(1)
$ if .not. link_only
$ then
$    'compile' iupop3
$    'compile' iupop3_commands
$    'compile' iupop3_utility
$    'compile' iupop3_vms
$    'compile' md5c
$    'compile' passwd_v'password_version'
$ endif
$ link -
    /executable=iupop3_'arch'.exe -
    iupop3, -
    iupop3_commands, -
    iupop3_utility, -
    iupop3_vms, -
    md5c, -
    passwd_v'password_version', -
    iupop3.opt/opt
$ verify = f$verify('verify')
$ compile_nomms_exit:
$ return
$!
$!***************************
$! Prepare UCX
$!***************************
$ prepare_ucx:
$ define/nolog vaxc$include sys$common:[syslib]
$ define/nolog sys          sys$common:[syslib]
$ define/nolog netinet      sys$common:[syslib]
$ define/nolog arpa         sys$common:[syslib]
$ define/nolog vms          sys$common:[syslib]
$!
$ tcpip_emulation = "UCX"
$ tcpip_info      = "UCX"
$ if (compiler .eqs. "DECC")
$ then
$   C_FLAGS == C_FLAGS + "/PREFIX=ALL_ENTRIES"
$   if (.not. is_alpha)
$   then
$     putopt "!UCX shareable image or UCX socket library"
$     putopt "!sys$library:UCX$IPC_Shr.Exe/Share"
$     putopt "sys$library:ucx$ipc.olb/lib"
$   endif
$ endif
$ if (compiler .eqs. "VAXC" .or. -
     (.not. is_alpha .and. compiler .eqs. "GNUC"))
$ then
$   putopt "!UCX socket library"
$   putopt "sys$library:ucx$ipc.olb/lib"
$ endif
$!
$ return
$!
$!***************************
$! Prepare WINS
$!***************************
$ prepare_wins:
$ tcpip_emulation = "WINS"
$ tcpip_info = "WINS"
$ putopt "!WINS socket library"
$ putopt "twg$tcp:[netdist.lib]twglib/lib"
$ if (compiler .eqs. "DECC")
$ then
$    C_FLAGS == C_FLAGS + -
     "/PREFIX=EXCEPT=(socket,bind,listen,accept,getpeername,setsockopt)"
$ endif
$ define/nolog vaxc$include sys$common:[syslib], twg$tcp:[netdist.include]
$ define/nolog sys          twg$tcp:[netdist.include.sys]
$ define/nolog netinet      twg$tcp:[netdist.include.netinet]
$ define/nolog arpa         twg$tcp:[netdist.include.arpa]
$ define/nolog vms          twg$tcp:[netdist.include.vms]
$ return
!$
$!***************************
$! Prepare TCPWARE
$!***************************
$ prepare_tcpware:
$ tcpip_info = "TCPWARE (UCX emulation)"
$ putopt "!TCPWARE for UCX emulation"
$ if (.not. is_alpha)
$ then
$    putopt "tcpware:ucx$ipc.olb/lib"
$ endif
$ return
!$
$!***************************
$! Prepare MULTINET
$!***************************
$ prepare_multinet:
$ define/nolog vaxc$include multinet_root:[multinet.include], -
                            sys$common:[syslib]
$ define/nolog sys     multinet_root:[multinet.include.sys], sys$common:[syslib]
$ define/nolog arpa    multinet_root:[multinet.include.arpa]
$ define/nolog netinet multinet_root:[multinet.include.netinet]
$ define/nolog vms     multinet_root:[multinet.include.vms]
$!
$ if (tcpip_emulation .eqs. "UCX")
$ then
$    tcpip_info = "MULTINET (UCX emulation)"
$    putopt "!MULTINET for UCX emulation"
$    if (.not. is_alpha)
$    then
$       putopt "multinet_root:[multinet.library]ucx$ipc.olb/lib"
$    endif
$ else
$    tcpip_info = "MULTINET"
$    putopt "!MULTINET socket library"
$    putopt "multinet_socket_library/share"
$ endif
$!
$ if (compiler .eqs. "DECC")
$ then
$    prefix = ""
$    if (tcpip_emulation .eqs. "UCX")
$    then
$       prefix = "ALL"
$    else
$       prefix = "EXCEPT=(socket,bind,listen,accept,getpeername,setsockopt)"
$    endif
$    C_FLAGS == C_FLAGS + "/PREFIX=''prefix'"
$ endif
$ return
$!***************************
$! Prepare NETLIB
$!***************************
$ prepare_netlib:
$ tcpip_emulation = "NETLIB"
$ tcpip_info      = "NETLIB"
$ putopt "!NETLIB shared image"
$ putopt "netlib_dir:netlib_shrxfr/share"
$ if (compiler .eqs. "DECC")
$ then
$   C_FLAGS == C_FLAGS + "/PREFIX=ALL_ENTRIES"
$ endif
$ return
$!
$!***************************
$! Help Message
$!***************************
$ print_help_message:
$ say facility,"-I-INFO, IUPOP3 make options"
$ say ""
$ say "supported parameters for make.com:"
$ say "===================================================="
$ say "TCP/IP options   : UCX  | MULTINET | TCPWARE | NETLIB"
$ say "                   (MULTINET and TCPWARE uses UCX emulation)"
$ say "make utility     : mms  | mmk   | nomms"
$ say "compiler options : DECC | VAXC  | GNUC"
$ say "parameter for mms: ""/param"""
$ say ""
$ say "make options:"
$ say "[NO]SCAN_INTRUSION         : create intrusion records"
$ say "IGNORE_MAIL11_HEADERS      : create headers _only_ for DECNET mails"
$ say "PERSONAL_NAME              : use MAIL11 personal name (if available)"
$ say "USE_BOTTOM_HEADERS         : copy headers from the bottom of the message"
$ say "USE_MAIL_FOLDER            : use MAIL instead of NEWMAIL folder"
$ say "FAST_SCAN                  : stimate file size from number of records"
$ say "IGNORE_EXPIRED_PASSWORDS   : do not check for expired passwords"
$ say ""
$ say "link_only                  : relink image from object files"
$ say "clean                      : remove object, list and executable files"
$ say ""
$ say "Examples:"
$ say "$@make"
$ say "$@make gnuc,/from_source"
$ say "$@make ucx mms ignore_mail11_headers, personal_name ""/from_source"""
$ say "$@make IGNORE_MAIL11_HEADERS,MAIL_FOLDER,USE_BOTTOM_HEADERS PERSONAL_NAME "
$ say "$@make link_only"
$ return
$!
$!***************************
$! Process Parameters
$!***************************
$ scan_parameters:
$ n = 1
$ elem = 0
$ delim = ","
$ makeoptions = ""
$   scan_loop:
$   if (n .gt. 8) then goto scan_parameters_exit
$   param = f$edit(f$element(elem,delim,p'n'),"UPCASE")
$   elem = elem + 1
$   if (param .nes. delim)
$   then
$     if ((param .eqs. "HELP") .or. (param .eqs. "?")) 
$     then 
$       gosub print_help_message
$       exit
$     endif
$     if (param .eqs. "MMK") 
$     then 
$       make_type = "MMK"
$       goto end_param_check
$     endif
$     if (param .eqs. "MMS") 
$     then 
$       make_type = "MMS"
$       goto end_param_check
$     endif
$     if (param .eqs. "NOMMS") 
$     then 
$       make_type = "NOMMS"
$       goto end_param_check
$     endif
$     if (param .eqs. "NOMMK") 
$     then 
$       make_type = "NOMMS"
$       goto end_param_check
$     endif
$     if (param .eqs. "UCX") 
$     then 
$       tcpip = "UCX"
$       goto end_param_check
$     endif
$     if (param .eqs. "MULTINET" .or. param .eqs. "MULTINET_UCX") 
$     then 
$       tcpip = "MULTINET"
$       tcpip_emulation = "UCX"
$       goto end_param_check
$     endif
$     if (param .eqs. "MULTINET_NATIVE") 
$     then 
$       tcpip = "MULTINET"
$       tcpip_emulation = "MULTINET"
$       goto end_param_check
$     endif
$     if (param .eqs. "TCPWARE_UCX" .or. param .eqs. "TCPWARE")
$     then
$       tcpip = "TCPWARE"
$       tcpip_emulation = "UCX"
$       goto end_param_check
$     endif
$     if (param .eqs. "WINS") 
$     then 
$       tcpip = "WINS"
$       goto end_param_check
$     endif
$     if (param .eqs. "NETLIB") 
$     then 
$       tcpip = "NETLIB"
$       goto end_param_check
$     endif
$     if (param .eqs. "DECC") 
$     then 
$       compiler = "DECC"
$       goto end_param_check
$     endif
$     if (param .eqs. "VAXC") 
$     then 
$       compiler = "VAXC"
$       goto end_param_check
$     endif
$     if (param .eqs. "GNUC") 
$     then 
$       compiler = "GNUC"
$       goto end_param_check
$     endif
$     if (param .eqs. "NOSCAN_INTRUSION")
$     then
$       param = "NO_SCAN_INTRUSION"
$       goto end_param_check
$     endif
$     if (F$EXTRACT(0,1,param) .eqs. "/") 
$     then 
$       mms_options = mms_options + " " + f$edit(param,"LOWERCASE")
$       goto end_param_check
$     endif
$     if (F$EXTRACT(0,4,param) .eqs. "LINK") 
$     then 
$       link_only = "T"
$       mms_options = mms_options + " link_only"
$       goto end_param_check
$     endif
$     if (param .eqs. "CLEAN")
$     then
$       link_only = "T"
$       mms_options = " clean"
$       goto end_param_check
$     endif
$     if (param .nes. "") 
$     then 
$       if (F$EXTRACT(0,1,param) .nes. ",")
$       then
$         param = ",''param'"
$       endif
$       makeoptions = makeoptions + param
$     endif
$     end_param_check:
$   else
$     n = n + 1
$     elem = 0
$   endif
$   goto scan_loop
$ scan_parameters_exit:
$ if (makeoptions .nes. "") 
$ then 
$   n = 0
$     opt_loop:
$     param = f$element (n, ",", makeoptions)
$     if (param .eqs. ",") then goto opt_loop_exit
$     if (param .nes. "") then make_options = make_options + "," + param
$     n = n + 1
$     goto opt_loop
$   opt_loop_exit:
$ endif
$!
$! check for binary distribution
$ if (.not. link_only) .and. (f$search("iupop3.c") .eqs. "") .and. -
     (f$search("iupop3.obj") .nes. "")
$ then
$   link_only = "T"
$   mms_options = mms_options + " link_only"
$ endif
$ return
$!***************************
$! Final Exit
$!***************************
$ final_exit:
$ if (f$search("*.opt") .nes "") then purge *.opt
$ set noverify 
$ exit
$!***************************
$! Error Exit
$!***************************
$ error_exit:
$ close optfile
$ goto final_exit
