/*
 ===========================================================================
 =                                                                         =
 =  (C) Copyright 1991-1994 The Trustees of Indiana University             =
 =                                                                         =
 =  Permission to use, copy, modify, and distribute this program for       =
 =  non-commercial use and without fee is hereby granted, provided that    =
 =  this copyright and permission notice appear on all copies and          =
 =  supporting documentation, the name of Indiana University not be used   =
 =  in advertising or publicity pertaining to distribution of the program  =
 =  without specific prior permission, and notice be given in supporting   =
 =  documentation that copying and distribution is by permission of        =
 =  Indiana University.                                                    =
 =                                                                         =
 =  Indiana University makes no representations about the suitability of   =
 =  this software for any purpose. It is provided "as is" without express  =
 =  or implied warranty.                                                   =
 =                                                                         =
 ===========================================================================
 =                                                                         =
 = File:                                                                   =
 =   PASSWD_V54.C                                                          =
 =                                                                         =
 = Synopsis:                                                               =
 =   This file contains functions that implement password checking.        =
 =                                                                         =
 = Authors:                                                                =
 =   Jacob Levanon & Larry Hughes                                          =
 =   Indiana University                                                    =
 =   University Computing Services, Network Applications                   =
 =                                                                         =
 = Credits:                                                                =
 =   This software is based on the Post Office Protocol version 3,         =
 =   as implemented by the University of California at Berkeley.           =
 =                                                                         =
 ===========================================================================
*/

/*
 PWDcheck - Verify password using VMS 5.4 sys$hash_password

 Returns:
   0     - Password is invalid
   1     - Password is valid
   Other - VMS error status
*/

#include <string.h>
#include <starlet.h>
#include <uaidef.h>
#include <descrip.h>

#define vms_error(status) (!(status & 1))

int PWDcheck(char *username, char *password)
{
  int   status;
  static short salt;
  static unsigned char algorithm;
  static long  uafhash[2] = {0,0};
  long  tmphash[2] = {0,0};
  struct dsc$descriptor_s user_desc = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};
  struct dsc$descriptor_s pwd_desc  = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};

  struct
  {
    short buffer_length;
    short item_code;
    long  buffer_address;
    long return_length_address;
  } inlist[] =
  {
    { sizeof(salt),      UAI$_SALT,   (long) &salt,      0 },
    { sizeof(uafhash),   UAI$_PWD,    (long) uafhash,    0 },
    { sizeof(algorithm), UAI$_ENCRYPT,(long) &algorithm, 0 },
    { 0, 0, 0, 0 }
  };

  user_desc.dsc$a_pointer = username;
  user_desc.dsc$w_length  = strlen(username);
  pwd_desc.dsc$a_pointer  = password;
  pwd_desc.dsc$w_length   = strlen(password);

  status = sys$getuai(0, 0, &user_desc, inlist, 0, 0, 0);
  if (!vms_error(status))
  {
    status = sys$hash_password(&pwd_desc, algorithm, salt, &user_desc, &tmphash);
    if (!vms_error(status))
      status = ((tmphash[0] == uafhash[0]) && (tmphash[1] == uafhash[1]));
  }
  return status;
}
