import vms_sys, vms_uaidef

# UAI$_ACCOUNT = 8 characters + 24 trailing ' '
t_account   = 'SU_NEW                          '
#              12345678901234567890123456789012

# UAI$_CPUTIM is expressed in 10ms steps
#   SYS$BINTIM returns a granularity of 100ns steps
q_cputim    = vms_sys.bintim ('33 11:44:22.55')
l_cputim    = int(abs(q_cputim)/100000)

q_def_priv  = 0x1374L # @@ make reference to module vms_prvdef
q_priv      = 0xe51aL       

q_expdat    = vms_sys.bintim ('28-FEB-1999 21:43:45.78')
l_flags     = vms_uaidef.UAI_M_CAPTIVE + \
              vms_uaidef.UAI_M_DISMAIL + \
              vms_uaidef.UAI_M_RESTRICTED

# bits that are set indicate the secondary days!
b_primedays = vms_uaidef.UAI_M_MONDAY + \
              vms_uaidef.UAI_M_TUESDAY + \
              vms_uaidef.UAI_M_FRIDAY

q_pwd_date  = vms_sys.bintim ('1-JAN-1998 01:01:01.01')
q_pwd2_date = vms_sys.bintim ('2-JAN-1998 02:02:02.02')
q_pwdlife   = vms_sys.bintim ('9 19:29:39.49')

# build new UIC from group and member
w_grp = 015432 # 0nn is OCTAL notation
w_mem = 017253
l_uic = (w_grp * 65536) + w_mem

dict = vms_sys.setuai (None,None,'SETUAI_TST',
(('UAI$_ACCOUNT'          ,t_account     )
,('UAI$_ASTLM'            ,315           )
,('UAI$_BIOLM'            ,313           )
,('UAI$_BYTLM'            ,3111          )
,('UAI$_CLITABLES'        ,'SU_NEWCLITAB')
,('UAI$_CPUTIM'           ,l_cputim      )
,('UAI$_DEFCLI'           ,'SU_NEWCLI'   )
,('UAI$_DEFDEV'           ,'SU_NEWDEV:'  )
,('UAI$_DEFDIR'           ,'[SU_NEWDIR'  )
,('UAI$_DEF_PRIV'         ,q_def_priv    )
,('UAI$_DFWSCNT'          ,3114          )
,('UAI$_DIOLM'            ,314           )
,('UAI$_ENQLM'            ,317           )
,('UAI$_EXPIRATION'       ,q_expdat      )
,('UAI$_FILLM'            ,311           )
,('UAI$_FLAGS'            ,l_flags       )
,('UAI$_JTQUOTA'          ,3113          )
,('UAI$_LGICMD'           ,'SU_NEWLGICMD')
,('UAI$_LOGFAILS'         ,77            )
,('UAI$_MAXACCTJOBS'      ,32            )
,('UAI$_MAXDETACH'        ,39            )
,('UAI$_MAXJOBS'          ,31            )
,('UAI$_OWNER'            ,'SU_NEW_OWNER')
,('UAI$_PBYTLM'           ,3112          )
,('UAI$_PGFLQUOTA'        ,3117          )
,('UAI$_PRCCNT'           ,33            )
,('UAI$_PRI'              ,31            )
,('UAI$_PRIMEDAYS'        ,b_primedays   )
,('UAI$_PRIV'             ,q_priv        )
,('UAI$_PWD_DATE'         ,q_pwd_date    )
,('UAI$_PWD2_DATE'        ,q_pwd2_date   )
,('UAI$_PWD_LENGTH'       ,32            )
,('UAI$_PWD_LIFETIME'     ,q_pwdlife     )
,('UAI$_QUEPRI'           ,35            )
,('UAI$_SALT'             ,111           )
,('UAI$_SHRFILLM'         ,312           )
,('UAI$_TQCNT'            ,316           )
,('UAI$_UIC'              ,l_uic         )
,('UAI$_USER_DATA'        ,'USER-DATA'   )
,('UAI$_WSEXTENT'         ,3116          )
,('UAI$_WSQUOTA'          ,3115          )
))
print dict.get('status')




q_li_i = vms_sys.bintim ('1-MAR-1996 01:02:03.45')
q_li_n = vms_sys.bintim ('2-APR-1997 10:20:30.54')

dict = vms_sys.setuai (None,None,'SETUAI_TST',
(('UAI$_LASTLOGIN_I',      q_li_i)
,('UAI$_LASTLOGIN_N',      q_li_n)
,('UAI$_BATCH_ACCESS_P',   (85,  85,  85))
,('UAI$_BATCH_ACCESS_S',   (170, 170, 170))
,('UAI$_DIALUP_ACCESS_P',  (68,  68,  68))
,('UAI$_DIALUP_ACCESS_S',  (136, 136, 136))
,('UAI$_LOCAL_ACCESS_P',   (34,  34,  34))
,('UAI$_LOCAL_ACCESS_S',   (153, 153, 153))
,('UAI$_NETWORK_ACCESS_P', (1,   1,   1))
,('UAI$_NETWORK_ACCESS_S', (8,   8,   8))
,('UAI$_REMOTE_ACCESS_P',  (254, 254, 254))
,('UAI$_REMOTE_ACCESS_S',  (128, 128, 128))
))
print dict.get('status')

