$!+
$! create 'module__METHODS.MAR' from 'module__METHODS.DAT'
$!-
$!
$!
$ _D = 0
$ close/nolog FIL_VER		! VMSDAT_VMSVER.DAT
$!
$ close/nolog FIL_INP
$ close/nolog FIL_OUT
$ close/nolog FIL_TMP
$!
$! ----------
$ if (F$GETSYI("HW_MODEL").ge.1024)
$ then
$   _ARCH = "A"
$ else
$   _ARCH = "V"
$ endif
$! ----------
$! -- P1 - filename
$ if (P1 .eqs. "")
$ then
$   write SYS$ERROR "%MODULEMETHODS2MAR-F-BADP1, parameter 1 - module__METHODS.DAT file"
$   write SYS$ERROR " or use HELP"
$   exit %X2C
$ endif
$ if (P1 .eqs. "HELP")
$ then
$   goto SHOW_HELP
$ endif
$! ----------
$! -- P2 - architecture (VAX/Alpha)
$ if (P2 .eqs. ".")
$ then
$   !_ARCH = current_value
$ else
$   if (P2 .nes. "A") .and. (P2 .nes. "V")
$   then
$     write SYS$ERROR "%MODULEMETHODS2MAR-F-BADP2, parameter 2 - hardware architecture"
$     write SYS$ERROR " or ""A"",""V"" or ""."""
$     exit %X2C
$   endif
$   _ARCH = P2
$ endif
$! ----------
$! -- P3 - OpenVMS version number
$ if (P3 .eqs. ".")
$ then
$   gosub GET_VMS_VERSION_NUMBER
$ else
$   if (.not. (F$TYPE (P3) .eqs. "INTEGER"))
$   then
$     write SYS$ERROR "%MODULEMETHODS2MAR-F-BADP3, parameter 3 - VMS version number"
$     write SYS$ERROR " must be number-only"
$     exit %X2C
$   endif
$   _VN = F$INTEGER (P3)
$ endif
$! ----------
$ T_NAM = F$PARSE(P1,,,"NAME")
$ T_FIL_INP = T_NAM+ ".DAT"
$ T_FIL_OUT = T_NAM+ ".MAR"
$!
$ _ALQ_INP = F$FILE_ATTRIBUTES(T_FIL_INP,"EOF")	! pre-allocate .MAR file
$ _ALQ_OUT = _ALQ_INP
$ _ALQ_TMPTXT = _ALQ_INP * 2
$!
$ T_TITLE  = ""
$ TAB[0,8] = 9
$!
$ open/read  FIL_INP 'T_FIL_INP' ! 'P1'
$!-- open/write FIL_OUT 'T_FIL_OUT'	!
$ copy /nolog _NLA0: /ALLOCATION='_ALQ_OUT' 'T_FIL_OUT'
$ open/append FIL_OUT 'T_FIL_OUT'
$ T_NOW = F$TIME()
$ T_DATE = F$CVTIME(T_NOW,"COMPARISON","YEAR")  + -
	   F$CVTIME(T_NOW,"COMPARISON","MONTH") + -
	   F$CVTIME(T_NOW,"COMPARISON","DAY")   !!!
$ write FIL_OUT "; NOW=", T_NOW , -
		" USR=",F$EDIT(F$GETJPI(0,"USERNAME"),"COLLAPSE")
$ write FIL_OUT ";"
$ write FIL_OUT TAB,".title ",T_NAM," table"
$ write FIL_OUT TAB,".ident '", T_DATE, "'"
$ write FIL_OUT ";"
$! -----
$! -- look for label marker
$LABEL_LOOP:
$ read /END_OF_FILE= LABEL_EOF FIL_INP T_RECORD
$ if (F$EXTRACT(0,1,T_RECORD) .eqs. ";")
$ then
$   write FIL_OUT T_RECORD		! -- copy comment into output file
$   goto LABEL_LOOP
$ endif
$ T_RECORD = F$EDIT(T_RECORD,"COLLAPSE,UNCOMMENT,UPCASE")
$ if (F$EXTRACT(0,6,T_RECORD) .nes. "LABEL=")
$ then
$   goto LABEL_LOOP			! not yet found, next line
$ endif
$ goto LABEL_DONE			! found line 'LABEL='
$!
$LABEL_EOF:
$ write SYS$ERROR "%MODULEMETHODS2MAR-F-NOLABEL, missing 'LABEL=' line in input file"
$ write SYS$ERROR " \",T_NAM,".DAT\"
$ close/nolog FIL_INP
$ close/nolog FIL_OUT
$ close/nolog FIL_TMP
$ exit %X2C
$!
$! ----------
$LABEL_DONE:
$ T_LABEL = F$ELEMENT(1,"=",T_RECORD)
$! -- write label
$ write FIL_OUT ";"
$ write FIL_OUT "METH_VARARGS = 1"
$ write FIL_OUT ";"
$ write FIL_OUT T_LABEL,"::"
$! -- now start processing method lines
$! ----------------------------------------
$ L_ADDRESS_COUNT = 1
$ T_ASCIZ_TMP = "SYS$SCRATCH:MODULEMETHODS2MAR_ASCIZ_''F$GETJPI(0,"PID")'.TMP"
$!-- open/write FIL_TMP 'T_ASCIZ_TMP'
$ copy /nolog _NLA0: /ALLOCATION='_ALQ_TMPTXT' 'T_ASCIZ_TMP'
$ open/append FIL_TMP 'T_ASCIZ_TMP'
$!
$METH_LOOP:
$ read /END_OF_FILE= METH_EOF FIL_INP T_RECORD
$ if (F$EXTRACT(0,1,T_RECORD) .eqs. ";")
$ then
$   write FIL_OUT T_RECORD		! -- copy comment into output file
$   goto METH_LOOP
$ endif
$ T_RECORD = F$EDIT(T_RECORD,"COMPRESS,UNCOMMENT")
$ if (T_RECORD .eqs. "")
$ then
$   goto METH_LOOP
$ endif
$ _METH_NAME   = F$ELEMENT(0," ",T_RECORD)
$ _METH_CFUNC  = F$ELEMENT(1," ",T_RECORD)
$ _METH_FLAGS  = F$ELEMENT(2," ",T_RECORD)
$ _METH_DOCSTR = F$ELEMENT(3," ",T_RECORD)
$ _METH_VMSVER = F$ELEMENT(4," ",T_RECORD)	! "VAX/ALPHA"
$   _VER_V = F$ELEMENT(0,"/",_METH_VMSVER)	! VAX
$   _VER_A = F$ELEMENT(1,"/",_METH_VMSVER)	! ALPHA
$! -----
$ if (_ARCH .eqs. "A")
$ then
$   _VMSVER = _VER_A
$ else
$   _VMSVER = _VER_V
$ endif
$ _VMSVER = F$INTEGER (_VMSVER)
$! -----
$ if (_VMSVER .gt. _VN)
$ then
$   goto METH_LOOP			! version inappropriate - next record
$ endif
$! ----------------------------------------
$! - char *ml_name;
$ write FIL_TMP T_LABEL,"__''L_ADDRESS_COUNT':''TAB'.asciz '",_METH_NAME ,"'"
$ write FIL_OUT TAB,".address ",T_LABEL,"__''L_ADDRESS_COUNT'",TAB,"; ",_METH_NAME
$! - PyCFunction ml_meth;
$ write FIL_OUT TAB,".address ",_METH_CFUNC
$! - int ml_flags;
$ if (_METH_FLAGS .eqs. "MV")
$ then
$   write FIL_OUT TAB,".long",TAB," METH_VARARGS"
$ else
$   write FIL_OUT TAB,".long",TAB," 0"
$ endif
$ if (_METH_DOCSTR .eqs. "NULL")	! no doc-string
$ then
$   write FIL_OUT TAB,".long",TAB," 0",TAB,TAB,TAB,"; no docstring"
$ else
$   write FIL_OUT TAB,".address ",_METH_DOCSTR
$ endif
$ write FIL_OUT TAB,";"
$!
$! sh symb t_fil_*
$! sh symb _alq_*
$! exit 2
$!
$! -----
$ L_ADDRESS_COUNT = L_ADDRESS_COUNT + 1
$ goto METH_LOOP
$!
$METH_EOF:
$!+
$! terminate list
$!-
$ write FIL_OUT TAB,";"
$ write FIL_OUT TAB,".long", TAB, "0, 0, 0, 0"
$ write FIL_OUT ";"
$!
$ close/nolog FIL_INP
$ close/nolog FIL_OUT
$ write FIL_TMP TAB,"; no termination necessary"
$ close/nolog FIL_TMP
$!
$ append 'T_ASCIZ_TMP' 'T_FIL_OUT'
$ delete 'T_ASCIZ_TMP';*
$!
$ open/append FIL_OUT 'T_FIL_OUT'
$ write FIL_OUT ";"
$ write FIL_OUT TAB,".end"
$ close/nolog FIL_OUT
$!
$ exit
$! ----------------------------------------------------------------------------
$GET_VMS_VERSION_NUMBER:
$ _VERS = F$GETSYI("VERSION")	! 8 characters, trailing blanks
$!
$ open /read FIL_VER VMSDAT_VMSVER.DAT
$READ_VER:
$ read /end= VER_EOF  FIL_VER  T_RECORD
$ if (F$EXTRACT(0,1,T_RECORD) .eqs. "!")
$ then
$   goto READ_VER		! comment line
$ endif
$ T_RECORD = F$EDIT(T_RECORD,"COMPRESS,UNCOMMENT")
$ _VS = F$ELEMENT (0," ",T_RECORD)	! version string
$ _VS = F$FAO ("!8AS", _VS)		!  pad with spaces
$ if (_VS .nes. F$GETSYI("VERSION"))
$ then
$   goto READ_VER		! version strings do not match, next line
$ endif
$ _AR = F$ELEMENT (1," ",T_RECORD)	! architecture
$   _AR_A = F$LOCATE(_AR,"A") .ne. F$LENGTH(_AR)
$   _AR_V = F$LOCATE(_AR,"V") .ne. F$LENGTH(_AR)
$ _VN = F$ELEMENT (2," ",T_RECORD)	! version number
$ close /noLOG FIL_VER
$ goto VER_DONE
$!
$VER_EOF:
$ close /noLOG FIL_VER
$   write SYS$ERROR "%MODULEMETHODS2MAR-F-VERNOTFND, version number not found in file"
$   write SYS$ERROR " \VMSDEF_VMSVER.DAT\"
$   exit %X2C
$!
$VER_DONE:
$ return
$! ----------------------------------------------------------------------------
$SHOW_HELP:
$ WRO = "write SYS$OUTPUT"
$ WRO ""
$ WRO " MODULEMETHODS2MAR HELP"
$ WRO ""
$ WRO " Parameter 1: name of input file (e.g. VMS_SYS__METHODS.DAT)"
$ WRO ""
$ WRO " Parameter 2: Hardware Architecture"
$ WRO "    A = Alpha"
$ WRO "    V = VAX"
$ WRO "    . = default - use current system"
$ WRO ""
$ WRO " Parameter 3: operating system version number (e.g. 06100)"
$ WRO "    . = use current system"
$ WRO ""
$ exit 1
