/* PYVMS__CRTL_ROUTINES.C -- 06-FEB-1999 Uwe Zessin

06-FEB-1999 ZE. -- move pyvms_crtl_open(), (31-DEC-1998) from PYVMSMODULE.C
		-- add pyvms_crtl_from_vms() + pyvms_crtl_to_vms()
07-JUL-1999 ZE. -- improved message in pyvms_crtl_open() - PyErr_Format()

   doc strings in PYVMSMODULE.C
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>		/* DSC$...	 */
#include <lib$routines.h>	/* LIB$name	 */
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

#ifdef __DECC
#pragma __nostandard	/* non-ANSI-Standard feature */
int decc$from_vms(...);
int decc$to_vms(...);
#pragma __standard
#endif /* __DECC */

/* ------------------------------------------------------------------------- */
extern PyObject *pyvms_gr_error;		/* exception pyvms.error */

/* ------------------------------------------------------------------------- */
/* number_files, unix_filespec = pyvms.crtl_from_vms
		(vms_filespec, action_routine, wild_flag)
*/

static PyObject * pyvms__crtl_fv_uspec; /* list of UNIX style filenames */
static PyObject * pyvms__crtl_fv_pyactrtn;  /* Python callback routine */
/* ---------------------------------------- */

/* default, if action_routine = None */
static unsigned long pyvms__crtl_fv_defact (char * at_unix_filespec)
{
	PyObject * ar_unix_filespec;

	/* -------------------- */
	ar_unix_filespec = PyString_FromString (at_unix_filespec);
	if (ar_unix_filespec == NULL)
	{
	    Py_DECREF(pyvms__crtl_fv_uspec);
	    pyvms__crtl_fv_uspec = NULL;	/* indicate error */
	    return 0;				/* stop further translation */
	}
	if (PyList_Append(pyvms__crtl_fv_uspec, ar_unix_filespec) != 0)
	{
	    Py_DECREF(ar_unix_filespec);
	    Py_DECREF(pyvms__crtl_fv_uspec);
	    pyvms__crtl_fv_uspec = NULL;	/* indicate error */
	    return 0;				/* stop further translation */
	}
	Py_DECREF(ar_unix_filespec);
	return 1;				/* continue translation */
} /* pyvms__crtl_fv_defact() */

/* ---------------------------------------- */

/* used, if action_routine != None */
static unsigned long pyvms__crtl_fv_actrtn (char * at_unix_filespec)
{
	PyObject * ar_unix_filespec;

	/* data from Python callback routine */
	PyObject	* ar_py_return_tuple;
	PyObject	* ar_py_return_status;
	unsigned long	  l_return_status;
	PyObject	* ar_py_return_data;

	/* -------------------- */
	/* put string into tuple to pass as argument to Python action_routine */
	ar_unix_filespec = Py_BuildValue ("(s)", at_unix_filespec);
	if (ar_unix_filespec == NULL)
	{
	    Py_DECREF(pyvms__crtl_fv_uspec);
	    pyvms__crtl_fv_uspec = NULL;	/* indicate error */
	    return 0;				/* stop further translation */
	}

	/* feed unix_filespec object (as tuple) into Python action routine */
	ar_py_return_tuple = PyObject_CallObject
		   (pyvms__crtl_fv_pyactrtn, ar_unix_filespec);

	Py_DECREF(ar_unix_filespec);
	if (ar_py_return_tuple == NULL)
	{
	    Py_DECREF(pyvms__crtl_fv_uspec);
	    pyvms__crtl_fv_uspec = NULL;	/* indicate error */
	    return 0;				/* stop further translation */
	}

	if (!PyTuple_Check(ar_py_return_tuple))
	{
	    PyErr_SetString(PyExc_TypeError,
		"the action_routine must return tuple (integer,object)");
	    Py_DECREF(pyvms__crtl_fv_uspec);
	    pyvms__crtl_fv_uspec = NULL;	/* indicate error */
	    return 0;				/* stop further translation */
	}
	else
	{
	  unsigned long l_tuplesize;

	  l_tuplesize = PyTuple_Size(ar_py_return_tuple);
	  if (l_tuplesize != 2)
	  {
	    PyErr_SetString(PyExc_TypeError,
		"the action_routine must return tuple (integer,object)");
	    Py_DECREF(ar_py_return_tuple);
	    Py_DECREF(pyvms__crtl_fv_uspec);
	    pyvms__crtl_fv_uspec = NULL;	/* indicate error */
	    return 0;				/* stop further translation */
	  }	  
	}

	ar_py_return_status = PyTuple_GetItem(ar_py_return_tuple, 0);
	if (!PyInt_Check(ar_py_return_status))
	{
	    PyErr_SetString(PyExc_TypeError,
		"the action_routine must return tuple (@integer,object)");
	    Py_DECREF(pyvms__crtl_fv_uspec);
	    pyvms__crtl_fv_uspec = NULL;	/* indicate error */
	    return 0;				/* stop further translation */
	}
	l_return_status = PyInt_AsLong(ar_py_return_status);
	if (PyErr_Occurred())
	{
	    Py_DECREF(ar_py_return_tuple);
	    Py_DECREF(pyvms__crtl_fv_uspec);
	    pyvms__crtl_fv_uspec = NULL;	/* indicate error */
	    return 0;				/* stop further translation */
	}

	/* any Python type is allowed in (integer,@object) */
	ar_py_return_data = PyTuple_GetItem(ar_py_return_tuple, 1);
	Py_XINCREF(ar_py_return_data);
	if (PyList_Append(pyvms__crtl_fv_uspec, ar_py_return_data) != 0)
	{
	    Py_DECREF(ar_py_return_tuple);
	    Py_XDECREF(ar_py_return_data);
	    Py_DECREF(pyvms__crtl_fv_uspec);
	    pyvms__crtl_fv_uspec = NULL;	/* indicate error */
	    return 0;				/* stop further translation */
	}
	Py_XDECREF(ar_py_return_data);

	Py_DECREF(ar_py_return_tuple);
	return (l_return_status); /* routine decided if translation continues */
} /* pyvms__crtl_fv_actrtn() */

/* ---------------------------------------- */

PyObject *
pyvms_crtl_from_vms (PyObject *self, PyObject *args)
{
	char			* at_vms_filespec;
	struct dsc$descriptor_s   r_vms_filespec;
	struct dsc$descriptor_s * ar_vms_filespec;
	unsigned long		  l_vms_filespec_len;

	PyObject		* ar_action_routine;
	unsigned long		  l_action_routine;
	unsigned long		* al_action_routine;

	unsigned long		  l_wild_flag;

	unsigned long		  l_status;

	/* -------------------- */
	ar_action_routine = Py_None;	/* use default action_routine */
	l_wild_flag       = 0;		/* default = no wildcards */

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#|Oi"
		,&at_vms_filespec,   &l_vms_filespec_len
		,&ar_action_routine
		,&l_wild_flag ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: vms_filespec */
	if (l_vms_filespec_len != strlen (at_vms_filespec))
	{
	    PyErr_SetString(PyExc_ValueError,
		"argument 1: vms_filespec - strlen() <> object size");
	    return NULL;
	}

	/* -------------------- */
	/* argument 2: action_routine */
	if (ar_action_routine == Py_None)
	{
	    /* If argument 2 is None, then the builtin-routine is used */
	    al_action_routine = (unsigned long *)&pyvms__crtl_fv_defact;
	    pyvms__crtl_fv_pyactrtn = NULL;
	}
	else
	{
	    /* argument must be a Python function object */
	    if (!PyFunction_Check (ar_action_routine ))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: action_routine - must be function or None");
		return NULL;
	    }
	    al_action_routine = (unsigned long *)&pyvms__crtl_fv_actrtn;
	    pyvms__crtl_fv_pyactrtn = ar_action_routine; /* store object */
	}

	/* -------------------- */
	/* argument 3: wild_flag */
	/* already done by PyArg_ParseTuple() */

	/* -------------------- */
	/* create list object for action_routine */
	pyvms__crtl_fv_uspec = PyList_New(0);
	if (pyvms__crtl_fv_uspec == NULL)
	{
	    return NULL;		/* error */
	}

	/* -------------------- */
	Py_XINCREF(pyvms__crtl_fv_pyactrtn);

	/* -------------------- */
	l_status = decc$from_vms
		(at_vms_filespec
		,al_action_routine
		,l_wild_flag);

	/* -------------------- */
        /* release Python function object */
	Py_XDECREF(pyvms__crtl_fv_pyactrtn);

	/* -------------------- */
	if (pyvms__crtl_fv_uspec == NULL)
	{
	    return NULL;	    /* error occured in action routine */
	}

	return (pyvms__crtl_fv_uspec); /* list of filenames */
} /* pyvms_crtl_from_vms () */

/* ------------------------------------------------------------------------- */
/* crtl_open(filename, flag [, mode=0777] [,'RMS arguments']) -> fd
   Open a file (for low level IO).
*/

/* code is based on that from POSIXMODULE.C */
PyObject *
pyvms_crtl_open (PyObject *self, PyObject *args)
{
	char		* file;
	int		  flag;
	PyObject	* ar_mode;
	int		  mode;
	int		  fd;
	PyObject	* ar_filarg;

	unsigned long	* al_arguments;

	/* -------------------- */
	ar_mode   = Py_None;
	ar_filarg = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "si|OO",
		&file,
		&flag,
		&ar_mode,
		&ar_filarg))
	{
	    return NULL;
	}

	/* -------------------- */
	if (ar_mode == Py_None)
	{
	    mode = 0777;	/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_mode))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 3: mode - must be integer or None");
		return NULL;
	    }
	    mode = PyInt_AsLong(ar_mode);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 4: file attributes - tuple of strings */
	if (ar_filarg != Py_None)
	{
	    unsigned long	  l_tuple_size;
	    unsigned long	  l_tuple_index;
	    unsigned long	* al_arguments_ptr;
	    PyObject		* ar_tuple_element;
	    unsigned long	  l_malloc_bytes;

	    if (!PyTuple_Check(ar_filarg))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 4: must be a tuple of strings");
		return NULL;
	    }

	    l_tuple_size = PyTuple_Size(ar_filarg);

	    /* allocate memory for argument array */
	    /* '+4', because the first element is the argument count and */
	    /*  then arguments 'file', 'flag' + 'mode' */
	    l_malloc_bytes = (l_tuple_size+4) * sizeof(al_arguments_ptr);
	    al_arguments = malloc (l_malloc_bytes);
	    if (al_arguments == NULL)
	    {
		return PyErr_NoMemory();
	    }

	    al_arguments_ptr = al_arguments;

	    /* store argument count */  /* 3= file,flag,mode - arguments */
	    *al_arguments_ptr = 3 + l_tuple_size;
	    al_arguments_ptr++;
	    *al_arguments_ptr = (int)file;
	    al_arguments_ptr++;
	    *al_arguments_ptr = (int)flag;
	    al_arguments_ptr++;
	    *al_arguments_ptr = (int)mode;
	    al_arguments_ptr++;		/* next argument is RMS string */

	    /* Py_INCREF(ar_filarg) */
	    for (l_tuple_index = 0; l_tuple_index < l_tuple_size; l_tuple_index++)
	    {
		ar_tuple_element = PyTuple_GetItem(ar_filarg, l_tuple_index);
		if (ar_tuple_element == NULL)
		{
		    (void) free (al_arguments);
		    /* Py_DECREF(ar_filarg) */
		    return NULL;
		}
		if (!PyString_Check(ar_tuple_element))
		{
		    (void) free (al_arguments);
		    /* Py_DECREF(ar_filarg) */
		    return PyErr_Format(PyExc_TypeError,
			"argument 4: tuple-element:%d is not a string",
			l_tuple_index);
		}

		*al_arguments_ptr = (int)PyString_AS_STRING(ar_tuple_element);
		al_arguments_ptr++;
	    } /* loop over tuple */
	} /* (ar_filarg != Py_None) */

	/* -------------------- */
/*	Py_BEGIN_ALLOW_THREADS */
	if (ar_filarg == Py_None)
	{
	    fd = open(file, flag, mode);
	}
	else
	{
	    fd = lib$callg (al_arguments, open);
	    /* Py_DECREF(ar_filarg) */
	    (void) free (al_arguments);
	}
/*	Py_END_ALLOW_THREADS */

	/* -------------------- */
	if (fd < 0)
	{
	    if (errno == EVMSERR)
	    {
		return PyVMS_ErrSetVal(pyvms_gr_error, 1, vaxc$errno); /* error */
	    }
	    else
	    {
		return PyErr_SetFromErrno(pyvms_gr_error);
	    }
	}

	/* -------------------- */
	return PyInt_FromLong((long)fd);
} /* pyvms_crtl_open () */

/* ------------------------------------------------------------------------- */
/* vms_filespec = pyvms.crtl_to_vms
		(unix_filespec, action_routine, allow_wild, no_directory)
   Convert UNIX style filespec into OpenVMS filespec.
*/

static PyObject * pyvms__crtl_tv_uspec; /* list of VMS style filenames */
static PyObject * pyvms__crtl_tv_pyactrtn;  /* Python callback routine */
/* ---------------------------------------- */

/* default, if action_routine = None */
static unsigned long pyvms__crtl_tv_defact
	(char * at_vms_filespec, int l_filtyp)
{
	PyObject * ar_vms_filespec;

	/* -------------------- */
	/* return both, the VMS filespecification and DECC$K_name */
	ar_vms_filespec = Py_BuildValue ("(si)", at_vms_filespec, l_filtyp);
	if (ar_vms_filespec == NULL)
	{
	    Py_DECREF(pyvms__crtl_tv_uspec);
	    pyvms__crtl_tv_uspec = NULL;	/* indicate error */
	    return 0;				/* stop further translation */
	}
	if (PyList_Append(pyvms__crtl_tv_uspec, ar_vms_filespec) != 0)
	{
	    Py_DECREF(ar_vms_filespec);
	    Py_DECREF(pyvms__crtl_tv_uspec);
	    pyvms__crtl_tv_uspec = NULL;	/* indicate error */
	    return 0;				/* stop further translation */
	}
	Py_DECREF(ar_vms_filespec);
	return 1;				/* continue translation */
} /* pyvms__crtl_tv_defact() */

/* ---------------------------------------- */

/* used, if action_routine != None */
static unsigned long pyvms__crtl_tv_actrtn
	(char * at_vms_filespec, int l_filtyp)
{
	PyObject * ar_vms_filespec;

	/* data from Python callback routine */
	PyObject	* ar_py_return_tuple;
	PyObject	* ar_py_return_status;
	unsigned long	  l_return_status;
	PyObject	* ar_py_return_data;

	/* -------------------- */
	/* put both, the VMS filespecification and DECC$K_name into tuple */
	/*  to pass as argument to Python action_routine */
	ar_vms_filespec = Py_BuildValue ("(si)", at_vms_filespec, l_filtyp);
	if (ar_vms_filespec == NULL)
	{
	    Py_DECREF(pyvms__crtl_tv_uspec);
	    pyvms__crtl_tv_uspec = NULL;	/* indicate error */
	    return 0;				/* stop further translation */
	}

	/* feed (vms_filespec + filtyp) object (as tuple) into */
	/*  Python action routine */
	ar_py_return_tuple = PyObject_CallObject
		   (pyvms__crtl_tv_pyactrtn, ar_vms_filespec);

	Py_DECREF(ar_vms_filespec);
	if (ar_py_return_tuple == NULL)
	{
	    Py_DECREF(pyvms__crtl_tv_uspec);
	    pyvms__crtl_tv_uspec = NULL;	/* indicate error */
	    return 0;				/* stop further translation */
	}

	if (!PyTuple_Check(ar_py_return_tuple))
	{
	    PyErr_SetString(PyExc_TypeError,
		"the action_routine must return tuple (integer,object)");
	    Py_DECREF(pyvms__crtl_tv_uspec);
	    pyvms__crtl_tv_uspec = NULL;	/* indicate error */
	    return 0;				/* stop further translation */
	}
	else
	{
	  unsigned long l_tuplesize;

	  l_tuplesize = PyTuple_Size(ar_py_return_tuple);
	  if (l_tuplesize != 2)
	  {
	    PyErr_SetString(PyExc_TypeError,
		"the action_routine must return tuple (integer,object)");
	    Py_DECREF(ar_py_return_tuple);
	    Py_DECREF(pyvms__crtl_tv_uspec);
	    pyvms__crtl_tv_uspec = NULL;	/* indicate error */
	    return 0;				/* stop further translation */
	  }	  
	}

	ar_py_return_status = PyTuple_GetItem(ar_py_return_tuple, 0);
	if (!PyInt_Check(ar_py_return_status))
	{
	    PyErr_SetString(PyExc_TypeError,
		"the action_routine must return tuple (@integer,object)");
	    Py_DECREF(pyvms__crtl_tv_uspec);
	    pyvms__crtl_tv_uspec = NULL;	/* indicate error */
	    return 0;				/* stop further translation */
	}
	l_return_status = PyInt_AsLong(ar_py_return_status);
	if (PyErr_Occurred())
	{
	    Py_DECREF(ar_py_return_tuple);
	    Py_DECREF(pyvms__crtl_tv_uspec);
	    pyvms__crtl_tv_uspec = NULL;	/* indicate error */
	    return 0;				/* stop further translation */
	}

	/* any Python type is allowed in (integer,@object) */
	ar_py_return_data = PyTuple_GetItem(ar_py_return_tuple, 1);
	Py_XINCREF(ar_py_return_data);
	if (PyList_Append(pyvms__crtl_tv_uspec, ar_py_return_data) != 0)
	{
	    Py_DECREF(ar_py_return_tuple);
	    Py_XDECREF(ar_py_return_data);
	    Py_DECREF(pyvms__crtl_tv_uspec);
	    pyvms__crtl_tv_uspec = NULL;	/* indicate error */
	    return 0;				/* stop further translation */
	}
	Py_XDECREF(ar_py_return_data);

	Py_DECREF(ar_py_return_tuple);
	return (l_return_status); /* routine decided if translation continues */
} /* pyvms__crtl_tv_actrtn() */

/* ---------------------------------------- */

PyObject *
pyvms_crtl_to_vms (PyObject *self, PyObject *args)
{
	char			* at_unix_filespec;
	struct dsc$descriptor_s   r_unix_filespec;
	struct dsc$descriptor_s * ar_unix_filespec;
	unsigned long		  l_unix_filespec_len;

	PyObject		* ar_action_routine;
	unsigned long		  l_action_routine;
	unsigned long		* al_action_routine;

	unsigned long		  l_allow_wild;

	unsigned long		  l_no_directory;

	unsigned long		  l_status;

	/* -------------------- */
	ar_action_routine = Py_None;	/* use default action_routine */
	l_allow_wild      = 0;		/* default = no wildcards */
	l_no_directory    = 0;		/* default = prevent expansion */
	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#|Oii"
		,&at_unix_filespec,   &l_unix_filespec_len
		,&ar_action_routine
		,&l_allow_wild
		,&l_no_directory ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: unix_filespec */
	if (l_unix_filespec_len != strlen (at_unix_filespec))
	{
	    PyErr_SetString(PyExc_ValueError,
		"argument 1: unix_filespec - strlen() <> object size");
	    return NULL;
	}

	/* -------------------- */
	/* argument 2: action_routine */
	if (ar_action_routine == Py_None)
	{
	    /* If argument 2 is None, then the builtin-routine is used */
	    al_action_routine = (unsigned long *)&pyvms__crtl_tv_defact;
	    pyvms__crtl_tv_pyactrtn = NULL;
	}
	else
	{
	    /* argument must be a Python function object */
	    if (!PyFunction_Check (ar_action_routine ))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: action_routine - must be function or None");
		return NULL;
	    }
	    al_action_routine = (unsigned long *)&pyvms__crtl_tv_actrtn;
	    pyvms__crtl_tv_pyactrtn = ar_action_routine; /* store object */
	}

	/* -------------------- */
	/* argument 3: allow_wild */
	/* already done by PyArg_ParseTuple() */

	/* -------------------- */
	/* argument 4: no_directory */
	/* already done by PyArg_ParseTuple() */

	/* -------------------- */
	/* create list object for action_routine */
	pyvms__crtl_tv_uspec = PyList_New(0);
	if (pyvms__crtl_tv_uspec == NULL)
	{
	    return NULL;		/* error */
	}

	/* -------------------- */
	Py_XINCREF(pyvms__crtl_tv_pyactrtn);

	/* -------------------- */
	l_status = decc$to_vms
		(at_unix_filespec
		,al_action_routine
		,l_allow_wild
		,l_no_directory );

	/* -------------------- */
        /* release Python function object */
	Py_XDECREF(pyvms__crtl_tv_pyactrtn);

	/* -------------------- */
	if (pyvms__crtl_tv_uspec == NULL)
	{
	    return NULL;	    /* error occured in action routine */
	}

	return (pyvms__crtl_tv_uspec); /* list of filenames */
} /* pyvms_crtl_to_vms () */

/* ------------------------------------------------------------------------- */

/* EOF: PYVMS__CRTL_ROUTINES.C */
