/* PYVMS__UAF_ROUTINES.C -- 14-NOV-1998 Uwe Zessin

14-NOV-1998 ZE. uaf_get_usernames() - return list of usernames from SYSUAF.DAT
		- called from PYVMSMODULE.C
	(code of RMS access to UAF snatched from  Hein 'RMS' van den Heuvel)

@@ improve error handling in uaf_get_usernames()

   doc string (pyvms_uaf_get_usernames__doc[]) in PYVMSMODULE.C
*/


#include "python.h"
#include "vmsdef.h"

#include <rms.h>
#include <rmsdef.h>		/* RMS$_name	 */
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
extern PyObject *pyvms_gr_error;		/* exception pyvms.error */

/* ------------------------------------------------------------------------- */
#define S_UAF_RECSIZ 2048			/* max. size of UAF record */
/* UAF$K_LENGTH 1412 */
#define UAF$S_USERNAME 32

/* ------------------------------------------------------------------------- */
/* insert [FR]AB$L_STS + [FR]AB$L_STV into ar_dict */

PyObject *
pyvms__uaf_insdict (PyObject * ar_dict, unsigned long l_sts, unsigned long l_stv)
{
	PyObject * ar_intobj;

	ar_intobj = PyInt_FromLong(l_sts);
	if (ar_intobj == NULL)
	{
	    return NULL;
	}
	PyDict_SetItemString(ar_dict, "sts", ar_intobj); /*@@CHKERR*/
	Py_DECREF(ar_intobj);
	/* ---------- */

	ar_intobj = PyInt_FromLong(l_stv);
	if (ar_intobj == NULL)
	{
	    return NULL;
	}
	PyDict_SetItemString(ar_dict, "stv", ar_intobj); /*@@CHKERR*/
	Py_DECREF(ar_intobj);
	/* ---------- */

	return ar_dict;
} /* pyvms__uaf_insdict () */

/* ------------------------------------------------------------------------- */

PyObject *
pyvms_uaf_get_usernames (PyObject *self, PyObject *args)
{
	struct FAB		r_fab;
	struct RAB		r_rab;
	struct XABKEY		r_xabkey;

	char			t_uaf_recbuf[S_UAF_RECSIZ];
	char			* at_username;

	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into "   */

	PyObject		* ar_username;
	PyObject		* ar_usrnamlst;

	unsigned long		  x_read_error;
	unsigned long		  l_status_1;
	unsigned long		  l_status_2;

	/* -------------------- */
	/* no arguments are taken */
	if (!PyArg_ParseTuple(args, ""))
	{
	    return NULL;
	}

	/* -------------------- */
	/* create a dictionary object to return username-list and status */
	ar_dict = PyDict_New();
	if (ar_dict == NULL)
	{
	    return NULL;
	}

	/* -------------------- */
	/* create username list object */
	ar_usrnamlst = PyList_New(0);
	if (ar_usrnamlst == NULL)
	{
	    /* failed to create username list */
	    Py_DECREF(ar_dict);
	    return NULL;
	}

	/* -------------------- */
	/* set up RMS structures */

	r_fab = cc$rms_fab;
	r_rab = cc$rms_rab;
	r_xabkey = cc$rms_xabkey;

	r_fab.fab$b_shr = FAB$M_SHRPUT;
	r_fab.fab$b_fac = FAB$M_GET;
	r_fab.fab$l_fna = "SYSUAF";	/* allow logical name SYSUAF */
	r_fab.fab$b_fns = 6;
	r_fab.fab$l_dna = "SYS$SYSTEM:.DAT";
	r_fab.fab$b_dns = 15;
	r_fab.fab$l_xab = (void *) &r_xabkey;

	r_rab.rab$l_fab = &r_fab;
	r_rab.rab$l_ubf = (char *) &t_uaf_recbuf;
	r_rab.rab$w_usz = S_UAF_RECSIZ;

	/* ---------------------------------------- */
	/* l_step = STEP_TRY_OPEN -> ar_dict */

	/* try to open SYSUAF.DAT */
	l_status_1 = sys$open (&r_fab);
	if (l_status_1 != RMS$_NORMAL)
	{
	    /* no username read, yet - drop list */
	    Py_DECREF(ar_usrnamlst);

	    /* failed to open - return with fab$l_sts + fab$l_stv */
	    pyvms__uaf_insdict (ar_dict, r_fab.fab$l_sts, r_fab.fab$l_stv);

	    return ar_dict;
	}
	at_username = (void *) &t_uaf_recbuf[r_xabkey.xab$w_pos0];

	/* ---------------------------------------- */
	/* l_step = STEP_TRY_CONNECT -> ar_dict ... */

	/* connect record stream */
	l_status_1 = sys$connect (&r_rab);
	if (l_status_1 != RMS$_NORMAL)
	{
	    /* no username read, yet - drop list */
	    Py_DECREF(ar_usrnamlst);

	    /* failed to connect - return with rab$l_sts + rab$l_stv */
	    pyvms__uaf_insdict (ar_dict, r_rab.rab$l_sts, r_rab.rab$l_stv);

	    /* try to close file - and ignore error */
	    l_status_1 = sys$close (&r_fab);
	    return ar_dict;
	}

	/* ---------------------------------------- */
	x_read_error = 0;

	while (l_status_1 & 1)
	{
	    char		* at_usrnam_end;
	    unsigned long	  l_usrnam_idx;

	    /* read a record from SYSUAF */
	    l_status_1 = sys$get (&r_rab);
	    if (l_status_1 != RMS$_NORMAL)
	    {
		x_read_error = 1;

		/* failed to read - return with rab$l_sts + rab$l_stv */
		pyvms__uaf_insdict (ar_dict, r_rab.rab$l_sts, r_rab.rab$l_stv);
		/* @@ */
		break;
	    }

	    /* strip trailing ' ' and skip system password record */
	    /* "<System+Password>               " */
	    /* "12345678901234567890123456789012  */
	    /* "FAL$SERVER                      x */

	    at_usrnam_end = at_username;
	    for (l_usrnam_idx = 0;
		 l_usrnam_idx < UAF$S_USERNAME;	/* UAF$S_USERNAME 32 */
		 l_usrnam_idx++)
	    {
		if (*at_usrnam_end == ' ')
		{
		    *at_usrnam_end = '\0';
		}
		at_usrnam_end++;
	    }
	    *at_usrnam_end = '\0';

	    /* skip system password record */
	    if (strcmp (at_username, "<System+Password>") != 0)
	    {
		/* -------------------- */
		/* append username to username-list */
		ar_username = PyString_FromString (at_username);
                if (ar_username == NULL)
		{
		    Py_DECREF(ar_usrnamlst);
		    Py_DECREF(ar_dict);

		    /* try to close file - and ignore error */
		    l_status_1 = sys$close (&r_fab);
		    return NULL;
                }
                if (PyList_Append(ar_usrnamlst, ar_username) != 0)
		{
		    Py_DECREF(ar_username);
		    Py_DECREF(ar_usrnamlst);
		    Py_DECREF(ar_dict);

		    /* try to close file - and ignore error */
		    l_status_1 = sys$close (&r_fab);
		    return NULL;
                }
                Py_DECREF(ar_username);
	    } /* if (strcmp (at_username, "<System+Password>") != 0) */
	} /* while (l_status_1 & 1) */

	/* -------------------- */
	if (l_status_1 == RMS$_EOF)
	{
	    l_status_1 = RMS$_NORMAL;
	}

	l_status_2 = sys$close (&r_fab);

	if ( (l_status_2 != RMS$_NORMAL) && (!x_read_error) )
	{
	    /* failed to close - return with fab$l_sts + fab$l_stv */
	    pyvms__uaf_insdict (ar_dict, r_fab.fab$l_sts, r_fab.fab$l_stv);
	    /* @@ */
	}

	/* @@ insert username list into dict - unless list is empty */
	/* if (?object_len? (ar_usrnamlst) > 0) ... */
	/* { */
	    /* put username list into dictionary for return */
	    PyDict_SetItemString(ar_dict, "usernames", ar_usrnamlst);
	/* } */
	Py_DECREF(ar_usrnamlst);

	return ar_dict;

} /* pyvms_uaf_get_usernames () */

/* ------------------------------------------------------------------------- */

/* EOF: PYVMS__UAF_ROUTINES.C */
