/* PYVMS__VMSOBJ_ROUTINES.C -- 15-MAR-1999 Uwe Zessin

   20-JAN-1999 ZE. -- test-interface for vmsobj_iosb_new()
   24-JAN-1999 ZE. -- test-interface for vmsobj_fab_new()
   25-JAN-1999 ZE. -- test-interface for vmsobj_rab_new()
   03-FEB-1999 ZE. -- test-interface for vmsobj__membuf_new()
   07-FEB-1999 ZE. -- test-interface for vmsobj_xaball_new()
   10-FEB-1999 ZE. -- test-interface for vmsobj_nam_new() + vmsobj_xabdat_new()
   13-FEB-1999 ZE. -- test-interface for vmsobj_xabfhc_new()
   18-FEB-1999 ZE. -- test-interface for vmsobj_xabitm_new()
   22-FEB-1999 ZE. -- test-interface for vmsobj_xabkey_new()
   08-MAR-1999 ZE. -- test-interface for vmsobj_xabpro_new() +
			vmsobj_xabrdt_new() + vmsobj_xabsum_new()
   13-MAR-1999 ZE. -- test-interface for vmsobj_xabtrm_new()
   15-MAR-1999 ZE. -- move vmsobj_* test-interfaces to PYVMS__VMSOBJ_ROUTINES.C
   29-MAY-1999 ZE. -- test-interface for vmsobj_lksb_new()
   21-AUG-1999 ZE. -- test-interface for vmsobj__ownership_names_new()

   no doc strings available
*/


#include "python.h"
#include "vmsdef.h"

/* ------------------------------------------------------------------------- */

#include "vmsobj_fab.h"

vmsobj_fab * pyvms_vmsobj_fab (PyObject *self, PyObject *args)
{
	return vmsobj_fab_new (NULL);
} /* pyvms_vmsobj_fab () */

/* ------------------------------------------------------------------------- */

#include "vmsobj_iosb.h"

vmsobj_iosb * pyvms_vmsobj_iosb (PyObject *self, PyObject *args)
{
	return vmsobj_iosb_new (NULL);
} /* pyvms_vmsobj_iosb () */

/* ------------------------------------------------------------------------- */

#include "vmsobj_lksb.h"

vmsobj_lksb * pyvms_vmsobj_lksb (PyObject *self, PyObject *args)
{
	return vmsobj_lksb_new (NULL);
} /* pyvms_vmsobj_lksb () */

/* ------------------------------------------------------------------------- */

#include "vmsobj_nam.h"

vmsobj_nam * pyvms_vmsobj_nam (PyObject *self, PyObject *args)
{
	return vmsobj_nam_new (NULL);
} /* pyvms_vmsobj_nam () */

/* ------------------------------------------------------------------------- */

#include "vmsobj_rab.h"

vmsobj_rab * pyvms_vmsobj_rab (PyObject *self, PyObject *args)
{
	return vmsobj_rab_new (NULL);
} /* pyvms_vmsobj_rab () */

/* ------------------------------------------------------------------------- */

#include "vmsobj_xaball.h"

vmsobj_xaball * pyvms_vmsobj_xaball (PyObject *self, PyObject *args)
{
	return vmsobj_xaball_new (NULL);
} /* pyvms_vmsobj_xaball () */

/* ------------------------------------------------------------------------- */

#include "vmsobj_xabdat.h"

vmsobj_xabdat * pyvms_vmsobj_xabdat (PyObject *self, PyObject *args)
{
	return vmsobj_xabdat_new (NULL);
} /* pyvms_vmsobj_xabdat () */

/* ------------------------------------------------------------------------- */

#include "vmsobj_xabfhc.h"

vmsobj_xabfhc * pyvms_vmsobj_xabfhc (PyObject *self, PyObject *args)
{
	return vmsobj_xabfhc_new (NULL);
} /* pyvms_vmsobj_xabfhc () */

/* ------------------------------------------------------------------------- */

#include "vmsobj_xabitm.h"

vmsobj_xabitm * pyvms_vmsobj_xabitm (PyObject *self, PyObject *args)
{
	return vmsobj_xabitm_new (NULL);
} /* pyvms_vmsobj_xabitm () */

/* ------------------------------------------------------------------------- */

#include "vmsobj_xabkey.h"

vmsobj_xabkey * pyvms_vmsobj_xabkey (PyObject *self, PyObject *args)
{
	return vmsobj_xabkey_new (NULL);
} /* pyvms_vmsobj_xabkey () */

/* ------------------------------------------------------------------------- */

#include "vmsobj_xabpro.h"

vmsobj_xabpro * pyvms_vmsobj_xabpro (PyObject *self, PyObject *args)
{
	return vmsobj_xabpro_new (NULL);
} /* pyvms_vmsobj_xabpro () */

/* ------------------------------------------------------------------------- */

#include "vmsobj_xabrdt.h"

vmsobj_xabrdt * pyvms_vmsobj_xabrdt (PyObject *self, PyObject *args)
{
	return vmsobj_xabrdt_new (NULL);
} /* pyvms_vmsobj_xabrdt () */

/* ------------------------------------------------------------------------- */

#include "vmsobj_xabsum.h"

vmsobj_xabsum * pyvms_vmsobj_xabsum (PyObject *self, PyObject *args)
{
	return vmsobj_xabsum_new (NULL);
} /* pyvms_vmsobj_xabsum () */

/* ------------------------------------------------------------------------- */

#include "vmsobj_xabtrm.h"

vmsobj_xabtrm * pyvms_vmsobj_xabtrm (PyObject *self, PyObject *args)
{
	return vmsobj_xabtrm_new (NULL);
} /* pyvms_vmsobj_xabtrm () */

/* ------------------------------------------------------------------------- */

#include "vmsobj__membuf.h"

vmsobj__membuf * pyvms_vmsobj__membuf (PyObject *self, PyObject *args)
{
	PyObject	* ar_arg1;

	unsigned long	  l_bufsiz;
	char		* at_bufadr;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "O", &ar_arg1))
	{
	    return NULL;
	}

	/* -------------------- */
	/* create an 'empty' buffer (zero-filled) */
	if (PyInt_Check(ar_arg1))
	{
	    l_bufsiz = PyInt_AsLong(ar_arg1);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    return vmsobj__membuf_new (l_bufsiz, NULL);
	}

	/* -------------------- */
	/* create a pre-populated buffer (string-filled) */
	if (PyString_Check(ar_arg1))
	{
	    char		* at_string;
	    unsigned long	  l_string_len;

	    at_string    = PyString_AS_STRING(ar_arg1);
            l_string_len = PyString_Size(ar_arg1);

	    return vmsobj__membuf_new (l_string_len, at_string);
        }

	/* -------------------- */
	PyErr_SetString(PyExc_TypeError,
	    "input must be integer (buffer size) or string (data)");
	return NULL;
} /* pyvms_vmsobj__membuf () */

/* ------------------------------------------------------------------------- */

#include "vmsobj__ownership_names.h"

vmsobj__ownership_names *
pyvms_vmsobj__ownshp_nam (PyObject *self, PyObject *args)
{
	PyObject	* ar_arg1;

	unsigned long	  l_bufsiz;
	char		* at_bufadr;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, ""))
	{
	    return NULL;
	}

	/* -------------------- */
	/* create a new vmsobj__ownership_names object */
	return vmsobj__ownership_names_new (NULL, 0);
} /* pyvms_vmsobj__ownshp_nam () */

/* ------------------------------------------------------------------------- */

/* EOF: PYVMS__VMSOBJ_ROUTINES.C */
