/* PYVMS_INIT.C -- init values -- 19-SEP-1997 Uwe Zessin */

/* 18-NOV-1997 ZE. -- add initialization of pyvms_gl_keyboard_id +
		      pyvms_gl_key_table_id
   19-NOV-1997 ZE. -- add initialization of pyvms_gar_rlbuffer
   30-NOV-1997 ZE. -- alter argv[0] from VMS to Unix notation
   14-DEC-1997 ZE. -- Fix malloc() bug. Include SMG$ROUTINES.H.
*/

/* ------------------------------------------------------------------------- */
#include <descrip.h>
#include <lib$routines.h>
#include <smg$routines.h>
#include <ssdef.h>
#include <starlet.h>
#include <syidef.h>

#include "vmsdef.h"
#include "pyvms_readline.h"

#include <unixio.h>
#include <unixlib.h>
#ifdef __DECC
/* DECC on Alpha does redefine these already */
#ifndef shell$from_vms
#define shell$from_vms(_p1_,_p2_,_p3_) decc$from_vms(_p1_,_p2_,_p3_)
#endif
#ifndef shell$translate_vms
#define shell$translate_vms(_p1_) decc$translate_vms(_p1_)
#endif
#ifndef shell$to_vms
#define shell$to_vms(_p1_,_p2_,_p3_,_p4_,_p5_) decc$to_vms(_p1_,_p2_,_p3_,_p4_,_p5_)
#endif
#endif /* __DECC */

/* ------------------------------------------------------------------------- */

/* numeric value of current VMS version (PYVMS_GLOBAL.C) */
extern vmsdef_xw_vmsver vmsdef_gw_vmsver;

/* VMS version string to numeric code translation table (VMSDAT_VMSVER.MAR) */
extern struct vmsdef_xr_vmsvertbl VMSDEF_GR_VMSDAT_VMSVER[];

/* readline / SMG$ support */
extern long				pyvms_gl_keyboard_id;
extern long				pyvms_gl_key_table_id;
extern struct pyvms_xr_rlbuffer*	pyvms_gar_rlbuffer;	/* listhead */

/* flags for tracing */
extern long				pyvms_gl_trace_open;
extern long				pyvms_gl_trace_stat;

/* ------------------------------------------------------------------------- */

static char     pvi_gt_psxpath[1026];
static char*    pvi_gat_psxpath;

static int pvi_from_vms_action (char *spec)
{
    (void)strcpy (pvi_gat_psxpath, spec);
    return 1;
}

/* ---------------------------------------- */

int PyVMS_init(int *pvi_argc, char ***pvi_argv)
{
#define S_VMSVER 8
    char			t_vmsver[S_VMSVER+1];
    unsigned short int		w_vmsver_len;
    unsigned long		l_item_code;
    struct dsc$descriptor_s	r_vmsver;
    unsigned long		l_system_id;
    unsigned long		l_status;
    unsigned long		l_cpu;
    unsigned long		l_ver_index;

    int			argc = *pvi_argc;	/* Argument Count	  */
    char		**argv = *pvi_argv;	/* Argument Vector	  */
    unsigned long	l_argv0_len;
    char		*at_argv0;

    /* build string descriptor for resultant-string argument */
    r_vmsver.dsc$w_length  = S_VMSVER;
    r_vmsver.dsc$b_dtype   = DSC$K_DTYPE_T;
    r_vmsver.dsc$b_class   = DSC$K_CLASS_S;
    r_vmsver.dsc$a_pointer = &t_vmsver[0];

    /* get VMS version as a string */
    l_item_code = SYI$_VERSION;
    l_system_id = 0;			/* current system */
    l_status = lib$getsyi
		(&l_item_code, 0, &r_vmsver, &w_vmsver_len, &l_system_id, 0);
    if (l_status != SS$_NORMAL)
    {
	printf ("%%PyVMS_init(): LIB$GETSYI(SYI$_VERSION) failed\n");
	lib$stop (l_status);
    }

    /* terminate version string for strcmp() */
    t_vmsver[w_vmsver_len] = '\0';

    /* get CPU number to destinguish between VAX and ALPHA */
    l_item_code = SYI$_CPU;
    l_system_id = 0;			/* current system */
    l_status = lib$getsyi
		(&l_item_code, &l_cpu, 0, 0, &l_system_id, 0);
    if (l_status != SS$_NORMAL)
    {
	printf ("%%PyVMS_init(): LIB$GETSYI(SYI$_CPU) failed\n");
	lib$stop (l_status);
    }

    if (l_cpu < 128)
    {
	l_cpu = ITMTBL_M_ARCH_VAX;	/* CPU is a VAX */
    }
    else
    {
	l_cpu = ITMTBL_M_ARCH_ALPHA;	/* CPU is an Alpha */
    }

    /* translate from text string to internal version number */
    vmsdef_gw_vmsver = 0;
    l_ver_index = 0;
    while (VMSDEF_GR_VMSDAT_VMSVER[l_ver_index].w_vmsver != 0)
    {
        /* check VMS version */
        if (strcmp(t_vmsver,VMSDEF_GR_VMSDAT_VMSVER[l_ver_index].at_vmsver)==0)
        {
	  /* found textual match - check if valid for VAX or Alpha */
	  if ((l_cpu && ITMTBL_M_ARCH_VAX) || (l_cpu && ITMTBL_M_ARCH_ALPHA))
          {
            /* found textual match - use numerical value of item-code */
	    vmsdef_gw_vmsver = VMSDEF_GR_VMSDAT_VMSVER[l_ver_index].w_vmsver;
	    break;
          }
	}
	l_ver_index++;			/* check next version string */
    }

    if (VMSDEF_GR_VMSDAT_VMSVER[l_ver_index].w_vmsver == 0)
    {
	printf (
    "%%PyVMS_init(): version string not found in VMSDEF_GR_VMSDAT_VMSVER\n");
	printf (" \\%s\\\n", t_vmsver);
	lib$stop (SS$_ABORT);
    }

    /* -------------------- */

    /* initialize virtual keyboard for PYVMS_READLINE.C */
    l_status = smg$create_key_table (&pyvms_gl_key_table_id);
    if (l_status != SS$_NORMAL)
    {
	printf ("%%PyVMS_init(): SMG$CREATE_KEY_TABLE() failed\n");
	lib$stop (l_status);
    }

    l_status = smg$create_virtual_keyboard (&pyvms_gl_keyboard_id);
    if (l_status != SS$_NORMAL)
    {
	printf ("%%PyVMS_init(): SMG$CREATE_VIRTUAL_KEYBOARD() failed\n");
	lib$stop (l_status);
    }

    /* mark listhead for recall buffer as empty */
    pyvms_gar_rlbuffer = NULL;

    /* -------------------- */

    /* translate path in argv[0] from VMS to Unix notation */

    pvi_gat_psxpath = &pvi_gt_psxpath[0];
    (void)shell$from_vms (argv[0],pvi_from_vms_action,0);
	/* 0 = no wildcard expansion */
    /* make a copy of the string - future versions might move the translation */
    /*  to a common module */
    l_argv0_len = strlen(pvi_gat_psxpath);
    at_argv0 = malloc(l_argv0_len+1);
    if (at_argv0 == NULL)
    {
	printf ("%%PyVMS_init(): malloc(l_argv0_len+1) failed\n");
	lib$stop (4852); /* %SYSTEM-F-INSVIRMEM - def. severify = W ! */
    }
    /* copy translated buffer into new path */
    (void) strcpy (at_argv0, pvi_gat_psxpath);
    /* replace argument */
    argv[0] = at_argv0;

    /* -------------------- */

    pyvms_gl_trace_open = 1;
    pyvms_gl_trace_stat = 1;
    /* ---------------------------------------- */

    return 0;
} /* int PyVMS_init(...) */

/* ------------------------------------------------------------------------- */

/* EOF: PYVMS_INIT.C */
