/* PYVMS_READLINE.C -- 18-NOV-1997 -- Uwe Zessin */

/* VMS/DCL specific 'readline' implementation to use SMG$ for recall */

/* 20-NOV-1997 ZE. -- pyvms_xr_rlbuffer, save prompt, too */

/* Readline interface for tokenizer.c.
   By default, we have a super simple my_readline function.
   Optionally, we can use the GNU readline library (to be found in the
   bash distribution).
   my_readline() has a different return value from GNU readline():
   - NULL if an interrupt occurred or if an error occurred
   - a malloc'ed empty string if EOF was read
   - a malloc'ed string ending in \n normally
*/

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "myproto.h"
#include "mymalloc.h"
#include "intrcheck.h"

#include <descrip.h>
#include <smg$routines.h>
#include <smgdef.h>					/* SMG$x_name */
#include <smgmsg.h>					/* SMG$_name */
#include <ssdef.h>					/* SS$_NAME */

#include "pyvms_readline.h"

/* SMG$ support */
extern long				pyvms_gl_keyboard_id;	/* SMG$ */
extern long				pyvms_gl_key_table_id;	/* SMG$ */
extern struct pyvms_xr_rlbuffer*	pyvms_gar_rlbuffer;	/* listhead */

/* -------------------- */

char *
PyOS_Readline(prompt)
	char *prompt;
{
	int				  n;
	char				* p;
	struct dsc$descriptor_s		  r_input;
	struct dsc$descriptor_s		  r_prompt;
	void				* ar_prompt;
	unsigned short int		  w_resultant_length;

	struct dsc$descriptor_s		  r_initial_string;
	void				* ar_initial_string;

	unsigned long			  l_flags;
	unsigned long			  l_status;
	
	struct pyvms_xr_rlbuffer	* ar_rlbuffer;
	unsigned long			  l_linecount;
	unsigned long			  x_same_line;

	/* -------------------- */
	n = 100;
	if ((p = malloc(n)) == NULL)
		return NULL;
	fflush(stdout);

	/* set up descriptors */
	r_input.dsc$w_length  = n;
	r_input.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_input.dsc$b_class   = DSC$K_CLASS_S;
	r_input.dsc$a_pointer = p;

	if (prompt)
	{
	    r_prompt.dsc$w_length  = strlen(prompt);
	    r_prompt.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_prompt.dsc$b_class   = DSC$K_CLASS_S;
	    r_prompt.dsc$a_pointer = prompt;
	    ar_prompt = &r_prompt;
	}
	else
	{
	    ar_prompt = 0;			/* no prompt */
	}

	l_flags = 0; /* SMG$M_NOKEEP + SMG$M_NORECALL; */
	l_status = smg$read_composed_line
		(&pyvms_gl_keyboard_id		/* keyboard-id            */
		,&pyvms_gl_key_table_id		/* [key-table-id]         */
		,&r_input			/* resultant-string       */
		,ar_prompt			/* [prompt-string]        */
		,&w_resultant_length		/* [resultant-length]     */
		,0				/* [display-id]           */
		,&l_flags			/* [flags]                */
		,0				/* [initial-string]       */
		,0				/* [timeout]              */
		,0				/* [rendition-set]        */
		,0				/* [rendition-complement] */
		,0				/* [word-terminator-code] */
		);

	if ((l_status != SS$_NORMAL) &&
	    (l_status != SS$_ABORT)  &&
	    (l_status != SS$_CANCEL) &&
	    (l_status != SMG$_EOF)
	   )
	{
	    free(p);
	    return NULL;
	}

	if ((l_status == SS$_ABORT)  ||
	    (l_status == SS$_CANCEL) ||
	    (l_status == SMG$_EOF)
	   )
	{
	    *p = '\0';
	}
	else
	{
	    char * ep = p;
	    int    i;
	    for (i = 0; i< w_resultant_length; i++)
	    {
	        ep++;
	    }
	    *ep = '\n';
	    ep++;
	    *ep = '\0';
	}

	n = strlen(p);

	/* locate last element in list and count number of lines in list */
	l_linecount = 0;
	x_same_line = 0;
	if (pyvms_gar_rlbuffer != NULL)
	{
	    ar_rlbuffer = pyvms_gar_rlbuffer;		/* start at listhead */
	    while (ar_rlbuffer->ar_next_rlbuff != NULL)
	    {
		ar_rlbuffer = ar_rlbuffer->ar_next_rlbuff;
		l_linecount++;
	    }
	    if (strcmp(p,ar_rlbuffer->at_line) == 0)
	    {
		/* don't put line on list if it's equal than the last one */
		x_same_line = 1;
	    }
	}

	/* don't put empty line on list and			  */
	/* don't put line on list if it's equal than the last one */
	if ( (strcmp(p,"\n") != 0) && (x_same_line != 1) )
	{
	    /* append current line to list */
	    char		     * cb;
	    struct pyvms_xr_rlbuffer * cd;

	    cd = malloc(sizeof(pyvms_xr_rlbuffer));	/* allocate descriptor */
	    /* @@@ if (cd == NULL) return NULL; */
	    cb = malloc(n+1);				/* allocate line buffer */
	    /* @@@ if (cb == NULL) return NULL; */
	    (void) strcpy (cb, p);			/* copy buffer */

	    cd->l_line_length = n;			/* fill in descriptor */
	    cd->at_line       = cb;

	    if (prompt == NULL)
	    {
		cd->at_prompt = NULL;
	    }
	    else
	    {
		char * cp;

		cp = malloc(strlen(prompt)+1);		/* allocate prompt buffer */
		/* @@@ if (cp == NULL) return NULL; */
		(void) strcpy (cp, prompt);		/* copy buffer */
		cd->at_prompt = cp;
	    }
	    cd->ar_next_rlbuff = NULL;	/* this is the last list element */

	    /* put command line in list */
	    if (pyvms_gar_rlbuffer == NULL)
	    {
		pyvms_gar_rlbuffer = cd;		/* first line */
	    }
	    else
	    {
		/* append - ar_rlbuffer points to current last element */
		ar_rlbuffer->ar_next_rlbuff = cd;

		if (l_linecount >= 19) /* excluding last element */
		{
		    /* delete first element in list */
		    ar_rlbuffer = pyvms_gar_rlbuffer;
		    pyvms_gar_rlbuffer = ar_rlbuffer->ar_next_rlbuff;
		    (void) free (ar_rlbuffer->at_line);	/* drop line */
		    if (ar_rlbuffer->at_prompt != NULL)
		    {
			(void) free (ar_rlbuffer->at_prompt); /* drop prompt */
		    }
		    (void) free (ar_rlbuffer);		/* drop descriptor */
		}
	    }
	}

	return realloc(p, n+1);
}

/* ------------------------------------------------------------------------- */

/* EOF: PYVMS_READLINE.C */
