/* -FILE: FILE_SET_DATE.C -- 21-SEP-1997 Uwe Zessin
|
| 12-DEC-1997 ZE. -- add <namdef.h> for DEC C on OpenVMS Alpha
|                    work around a compiler warning (?.atr$l_addr)
*/

/* set creation + revision date of a file */
/*  code taken from [.VMS]VMS__UTIME.C */

#include <atrdef.h>
#include <descrip.h>
#include <errno.h>
#include <fab.h>
#include <fibdef.h>
#include <iodef.h>
#include <lib$routines.h>
#include <nam.h>
#include <rmsdef.h>
#include <ssdef.h>
#include <starlet.h>
#include <stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unixlib.h>	/* shell$to_vms / decc$to_vms */
#ifdef __DECC
#ifndef shell$to_vms	/* DECC on Alpha does redefine this already */
#define shell$to_vms(_p1_,_p2_,_p3_,_p4_) decc$to_vms(_p1_,_p2_,_p3_,_p4_)
#endif
#endif

int file__set_times (char *at_vms_path, char *at_time);

main(int argc, char *argv[])
{
char*       path;
char*	    at_vms_path;
char*	    at_time;
int	    l_status;
int	    l_save_errno;
struct stat r_st;

if (argc != 3)
{
    (void) printf
	("%%FILE_SET_DATE-F-PARAM, invalid number of parameters, need 2\n");
    exit (0x2c);
}

at_time = argv[2];	/* CDT/RDT DD-MON-YYYY:HH:MM:SS.HS */
path    = argv[1];	/* filename */
at_vms_path = malloc (strlen(path) + 11); /* "/000000" + ".DIR" */
if (at_vms_path == NULL)
{
    (void) printf ("%%FILE_SET_DATE-F-NOMEM, malloc() failed\n");
    exit (0x2c);
}
(void)strcpy (at_vms_path, path);

/* VMS_POSIX tests first _WITH_ '.DIR' !! */
(void)strcat (at_vms_path,".dir");

/* stat() the file to make sure it exists */
/* Note: stat() does not change the expiration date - good! */
l_status = stat (at_vms_path, &r_st);
if (l_status == 0)
{
    /* printf ("@1:%s\n", at_vms_path); */
    l_status = file__set_times (at_vms_path,at_time);
    l_save_errno = errno; /* free() should not clobber errno, but... */
    (void)free (at_vms_path);
    errno = l_save_errno;
    return l_status;
}

/* now check also without explicitly appending a '.DIR' */
/* it might be part of the file name */
/* VMS_POSIX does it in this order */

/* stat() the file to make sure it exists */
l_status = stat (path, &r_st);
if (l_status == 0)
{
    /* printf ("@2:%s\n", at_vms_path); */
    l_status = file__set_times (path,at_time);
    l_save_errno = errno; /* free() should not clobber errno, but... */
    (void)free (at_vms_path);
    errno = l_save_errno;
    return l_status;
}

/* now try something like /x/y -> /x/000000/y.DIR */
if (path[0] == '/')
{
    char* at_pp;
    char* at_pv;

    at_pp = path;
    at_pv = at_vms_path;
    *at_pv = *at_pp;	/* copy '/' */
    at_pp++; at_pv++;
    while ((*at_pp != '/') && (*at_pp != '\0'))
    {
	*at_pv = *at_pp;
	at_pv++; at_pp++;
    }
/* *at_pv = '\0'; printf ("0=%s\n", at_vms_path); */

    /* continue only if not end of string reached - */
    /* otherwise the path is /XXX		    */
    if (*at_pp != '\0')
    {
	/* copy /000000 */
	*at_pv++ = '/';
	*at_pv++ = '0';
	*at_pv++ = '0';
	*at_pv++ = '0';
	*at_pv++ = '0';
	*at_pv++ = '0';
	*at_pv++ = '0';

	/* copy rest of string */
	while (*at_pp != '\0')
	{
	    *at_pv = *at_pp;
	    at_pv++; at_pp++;
	}
	/* save pointer to this location */
	at_pp = at_pv;

	*at_pv = '\0';

	/* VMS_POSIX tests first _WITH_ '.DIR' !! */
	/* printf ("1=%s\n", at_vms_path); */
	(void)strcat (at_pv, ".DIR");
	/* printf ("2=%s\n\n", at_vms_path); */

	/* stat() the file to make sure it exists */
	l_status = stat (at_vms_path, &r_st);
	if (l_status == 0)
	{
	    l_status = file__set_times (at_vms_path,at_time);
	    l_save_errno = errno; /* free() should not clobber errno, but... */
	    (void)free (at_vms_path);
	    errno = l_save_errno;
	    return l_status;
	}

	/* 'remove' .DIR */
	*at_pv = '\0';

	/* now check also without explicitly appending a '.DIR' */
	/* it might be part of the file name */
	/* VMS_POSIX does it in this order */

	/* printf ("9=%s\n", at_vms_path); */

	/* stat() the file to make sure it exists */
	l_status = stat (at_vms_path, &r_st);
	if (l_status == 0)
	{
	    l_status = file__set_times (at_vms_path,at_time);
	    l_save_errno = errno; /* free() should not clobber errno, but... */
	    (void)free (at_vms_path);
	    errno = l_save_errno;
	    return l_status;
	}
	/* else - just fall through to ENOENT */
    }
    /* else - just fall through to ENOENT */
} /* if (path[0] == '/') */

/* no more tries, assume file does not exist */

(void)free (at_vms_path);
errno = ENOENT; /* No such file or directory */
return 2324; /* %SYSTEM-F-NOSUCHFILE -- SS$_NOSUCHFILE has -W- severity */
}

/* ------------------------------------------------------------------------- */

static char vms__gt_utime_file[255];

static int vms__utime_action (char *s, int type)
/* type: 0 = DECC$K_FOREIGN   - file is on a remote system not running VMS */
/*       1 = DECC$K_DIRECTORY - file is a directory */
/*       2 = DECC$K_FILE      - translation is a file */
{
    (void)strcpy (vms__gt_utime_file, s);
    return 0; /* 0 = end translation - wildcards aren't allowed anyway */
}

/* ---------------------------------------- */

int file__set_times (char *at_vms_path, char *at_time)
{
    int l_count;		/* l_count=(decc/shell)$to_vms(...) */
    int l_status;		/* VMS condition value */

    static struct FAB    r_fab;	/* file access block */
    static struct NAM    r_nam;	/* name access blovk */
    static struct fibdef r_fib;	/* file information block */
 
    /* descriptor for FIB - needed by SYS$QIOW */
    static struct dsc$descriptor r_fib_dsc =
	{sizeof(r_fib), DSC$K_DTYPE_Z, DSC$K_CLASS_S, (void *)&r_fib};

    /* descriptor for device name - needed by SYS$ASSIGN */
    static struct dsc$descriptor_s r_dev_dsc =
	{0, DSC$K_DTYPE_T, DSC$K_CLASS_S, &r_nam.nam$t_dvi[1]};

    static char t_esa[NAM$C_MAXRSS];
    static char t_rsa[NAM$C_MAXRSS];

    /* descriptor for VMS file name - needed by SYS$QIO(IO$_ACCESS) */
    static struct dsc$descriptor_s r_filnam_dsc =
	{0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};

    static short int w_chan;		/* I/O channel for disk SYS$QIOW */
    static short int r_iosb[4];		/* I/O status block for SYS$QIOW */

    static unsigned int q_modtime[2];	/* (utimbuf.actime is ignored) */

    /* attribute control list */
    static struct atrdef r_atr[] =
    {
	{sizeof(q_modtime),ATR$C_REVDATE,0},	/* revision date + time */
	{sizeof(q_modtime),ATR$C_CREDATE,0},	/* creation date + time */
	{0,0,0}					/* terminate list */
    };

    /* descriptor for SYS$BINTIM timbuf argument */
    static struct dsc$descriptor_s r_timbuf_dsc =
	{0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};

    /* ---------------------------------------- */
    /* no translation if this path is already in VMS format */
    if ((strchr(at_vms_path,'[')==NULL) && (strchr(at_vms_path,'<')==NULL))
    {
      /* translate filename from Unix to VMS format */
      l_count = shell$to_vms
	(at_vms_path		/* unix-like file specification */
	,vms__utime_action	/* action routine */
	,0			/* 1 = allow_wild */
	,1			/* prevent expansion of the string */
	);			/*  as a dirctory name */
      if (l_count == 1)
      {
	/* printf("file__set_times(1)<-=%s\n", at_vms_path); */
	/* printf("file__set_times()->=%s\n", vms__gt_utime_file); */
      }
      else
      {
	l_count = shell$to_vms
	    (at_vms_path	/* unix-like file specification */
	    ,vms__utime_action	/* action routine */
	    ,0			/* 1 = allow_wild */
	    ,0			/* prevent expansion of the string */
	    );			/*  as a dirctory name */
	if (l_count == 1)
	{
	    /* printf("file__set_times(0)<-=%s\n", at_vms_path); */
	    /* printf("file__set_times()->=%s\n", vms__gt_utime_file); */
	}
	else
	{
	    /* I have no idea what can be wrong here */
	    errno = ENOENT; /* No such file or directory */
	    return 2324; /* %SYSTEM-F-NOSUCHFILE -- SS$_NOSUCHFILE has -W- severity */
	}
      }
    }

    /* ---------------------------------------- */

    /* convert date from 'DD-MON-YYYY:HH:MM:SS.HS' to VMS 64-bit bintim */
    if (at_time == NULL)
    {
	/* rdt = current-date-and-time */
	l_status = sys$gettim (&q_modtime[0]);
    }
    else
    {
	/* build descriptor for sys$bintim */
	r_timbuf_dsc.dsc$w_length  = strlen (at_time);
	r_timbuf_dsc.dsc$a_pointer = at_time;

	/* convert ASCII date to 64-bit binary date */
	l_status = sys$bintim (&r_timbuf_dsc, &q_modtime[0]);
	if (l_status != SS$_NORMAL)
	{
	    (void) printf (
"%%FILE_SET_DATE-F-TIMCONV, failed to convert time via SYS$BINTIM()\n \\%s\\\n"
, at_time);
	    lib$stop (l_status);
	}
    }

    /* ---------------------------------------- */

    /* initialize RMS structures */
    r_fab = cc$rms_fab;
    r_fab.fab$l_fna = at_vms_path;		/* name of file */
    r_fab.fab$b_fns = strlen (at_vms_path);	/* <= 255 ! */
    r_fab.fab$l_nam = &r_nam;			/* attach NAM block */

    r_nam = cc$rms_nam;
    r_nam.nam$l_esa = t_esa;			/* expanded filename */
    r_nam.nam$b_ess = sizeof(t_esa);
    r_nam.nam$l_rsa = t_rsa;			/* resultant filename */
    r_nam.nam$b_rss = sizeof(t_rsa);
 
    /* ---------------------------------------- */

    /* do SYS$PARSE to fill in NAM block */
    l_status = sys$parse (&r_fab);
    if (l_status != RMS$_NORMAL)
    {
	(void) printf (
	    "%%FILE_SET_DATE-F-PARSFAIL, failed to SYS$PARSE()\n \\%s\\\n",
	    at_vms_path);
	lib$stop (l_status);
    }

    /* 'fix' descriptor for device name for SYS$ASSIGN() */
    r_dev_dsc.dsc$w_length = r_nam.nam$t_dvi[0]; /* ASCIC */
 
    /* assign channel to the disk */
    l_status = sys$assign (&r_dev_dsc, &w_chan, 0, 0);
    if (l_status != SS$_NORMAL)
    {
	(void) printf (
	    "%%FILE_SET_DATE-F-ASNFAIL, failed to SYS$ASSIGN()\n \\%s\\\n",
	    r_dev_dsc.dsc$a_pointer);
	lib$stop (l_status);
    }
 
    /* set up descriptor for filename for SYS$QIO */
    r_filnam_dsc.dsc$a_pointer = r_nam.nam$l_name;
    r_filnam_dsc.dsc$w_length  = r_nam.nam$b_name +
				 r_nam.nam$b_type +
				 r_nam.nam$b_ver;
 
    /* fill in the FIB */
    r_fib.fib$w_fid[0] = r_nam.nam$w_fid[0];
    r_fib.fib$w_fid[1] = r_nam.nam$w_fid[1];
    r_fib.fib$w_fid[2] = r_nam.nam$w_fid[2];
    r_fib.fib$w_did[0] = r_nam.nam$w_did[0];
    r_fib.fib$w_did[1] = r_nam.nam$w_did[1];
    r_fib.fib$w_did[2] = r_nam.nam$w_did[2];
    /* prevent expiration date from being modified */
    r_fib.fib$l_acctl = FIB$M_NORECORD;
 
    /* put address of 64-bit binary time into ATR */
#ifdef __ALPHA /* just prevent a compiler warning */
    r_atr[0].atr$l_addr = &q_modtime[0]; /* ATR$C_REVDATE */
    r_atr[1].atr$l_addr = &q_modtime[0]; /* ATR$C_CREDATE */
#else
    r_atr[0].atr$l_addr = (unsigned int) &q_modtime[0]; /* ATR$C_REVDATE */
    r_atr[1].atr$l_addr = (unsigned int) &q_modtime[0]; /* ATR$C_CREDATE */
#endif

    /* alter revision date + time of the file */
    l_status = sys$qiow (0, w_chan, IO$_MODIFY, &r_iosb, 0, 0,
                        &r_fib_dsc, &r_filnam_dsc, 0, 0, &r_atr, 0);
    if (l_status == SS$_NORMAL)
    {
	l_status = r_iosb[0]; /* do not 'optimize' away - l_status is used later */
    }

    if (l_status != SS$_NORMAL)
    {
	(void) printf (
	    "%%FILE_SET_DATE-F-QIOFAIL, failed to SYS$QIOW(IO$_MODIFY)\n \\%s\\\n",
	    r_filnam_dsc.dsc$a_pointer);
	lib$stop (l_status);
    }
 
    l_status = sys$dassgn (w_chan);
    /* ignore errors */

    return l_status; 

} /* int file__set_times (char *at_vms_path, char *at_time) */

/* ------------------------------------------------------------------------- */

/* EOF: FILE_SET_DATE.C */
