# HTML2RNO.PY - convert a (simple) .HTML file to .RNO format
# 27-JUL-1998 -- Uwe Zessin
#
# (derived from the article 'Python Insight' by Tom Schwaller
#  (german) LINUX MAGAZIN 03/96)
#
# 11-FEB-1999 ZE. -- make some adjustments to better emulate the
#                    empty-line addition of the Netscape Browser
#
import sys
from htmllib import *
from formatter import DumbWriter
from formatter import AbstractFormatter

class rno_Writer(DumbWriter):
    def __init__(self, file=None, maxcol=72):
        DumbWriter.__init__(self, file, maxcol)

    def new_font(self, font):
        pass

    def new_margin(self, margin, level):
        pass

    def send_label_data(self, data):
        print '- ',

    def send_paragraph(self, blankline):
        self.file.write('\n') #  + '\n'*blankline)
        self.col = 0

    def send_hor_rule(self, *args, **kw):
        if (self.col != 0):
               self.file.write('\n')
        self.file.write('-'*self.maxcol)
        self.file.write('\n')
        self.col = 0
        self.atbreak = 0

class rno_HTMLParser(HTMLParser):
    def __init__(self, formatter=None, verbose=0):
        HTMLParser.__init__(self, formatter, verbose)
        self.rno_literal = 0 # need to keep track, because:
        # </BODY> and </HTML> result in a call to end_pre, too

    def anchor_end(self):                               # </A>
        if self.anchor:
            # don't print "[n]" after anchors
            # self.handle_data("[%d]" % len(self.anchorlist))
            self.anchor = None

    def start_h1(self, attrs):                          # <H1>
        self.formatter.end_paragraph(0)
        self.handle_data('.hl 1 ')
        self.formatter.push_font(('h1', 0, 1, 0))

    def end_h1(self):                                   # </H1>
        self.formatter.end_paragraph(0)
        self.formatter.pop_font()

    def start_h2(self, attrs):                          # <H2>
        self.formatter.end_paragraph(0)
        self.handle_data('.hl 2 ')
        self.formatter.push_font(('h2', 0, 1, 0))

    def end_h2(self):                                   # </H2>
        self.formatter.end_paragraph(0)
        self.formatter.pop_font()

    def start_h3(self, attrs):                          # <H3>
        self.formatter.end_paragraph(0)
        self.handle_data('.hl 3 ')
        self.formatter.push_font(('h3', 0, 1, 0))

    def end_h3(self):                                   # </H3>
        self.formatter.end_paragraph(0)
        self.formatter.pop_font()

    def start_h4(self, attrs):                          # <H4>
        self.formatter.end_paragraph(0)
        self.handle_data('.hl 4 ')
        self.formatter.push_font(('h4', 0, 1, 0))

    def end_h4(self):                                   # </H4>
        self.formatter.end_paragraph(0)
        self.formatter.pop_font()

    def start_h5(self, attrs):                          # <H5>
        self.formatter.end_paragraph(0)
        self.handle_data('.hl 5 ')
        self.formatter.push_font(('h5', 0, 1, 0))

    def end_h5(self):                                   # </H5>
        self.formatter.end_paragraph(0)
        self.formatter.pop_font()

    def start_h6(self, attrs):                          # <H6>
        self.formatter.end_paragraph(0)
        self.handle_data('.hl 6 ')
        self.formatter.push_font(('h6', 0, 1, 0))

    def end_h6(self):                                   # </H6>
        self.formatter.end_paragraph(0)
        self.formatter.pop_font()

    def start_pre(self, attrs):                         # <PRE>
        self.formatter.end_paragraph(0)
        #self.handle_data('.blank') # .literal adds a blank line
        self.handle_data('.literal ;')
        self.rno_literal = self.rno_literal + 1
        #self.formatter.add_line_break()
        self.formatter.push_font((AS_IS, AS_IS, AS_IS, 1))
        self.nofill = self.nofill + 1

    def end_pre(self):                                  # </PRE>
        #if (self.rno_literal >= 1):
        #    if (self.rno_literal == 1):
        #        self.formatter.end_paragraph(1)
        #        self.handle_data('.end literal')
        #        self.formatter.add_line_break()
        #        self.formatter.pop_font()
        #        self.nofill = max(0, self.nofill - 1)
        #    self.rno_literal = self.rno_literal - 1
        #
        self.formatter.end_paragraph(1)
        self.handle_data('.end literal')
        self.formatter.add_line_break()
        self.formatter.pop_font()
        self.nofill = max(0, self.nofill - 1)

    # there was no need to modify start_title()         # <TITLE>
    def end_title(self):                                # </TITLE>
        self.title = '.subtitle ' + self.save_end()
        self.formatter.add_line_break()
        self.handle_data(self.title)
        self.formatter.add_line_break()
    
    def start_ul(self, attrs):                          # <UL>
        self.formatter.end_paragraph(not self.list_stack)
        self.formatter.push_margin('ul')
        if (len(self.list_stack) == 0):
            self.handle_data('.blank')	# only 1st level
        c = "-o*+"[len(self.list_stack)%len("-o*+")]
        self.list_stack.append(['ul', c, 0])
        self.formatter.add_line_break()
        l = '.list 0,"' + c + '"'
        self.handle_data(l)
        self.formatter.add_line_break()

    def end_ul(self):                                   # </UL>
        if self.list_stack: del self.list_stack[-1]
        self.formatter.end_paragraph(not self.list_stack)
        self.formatter.pop_margin()
        # self.formatter.add_line_break()
        self.handle_data('.end list 0')
        self.formatter.add_line_break()
        if not self.list_stack:
            self.handle_data('.blank')
            self.formatter.add_line_break()

    def start_ol(self, attrs):				# <OL>
        self.formatter.end_paragraph(not self.list_stack)
        self.formatter.push_margin('ol')
        if (len(self.list_stack) == 0):
            self.handle_data('.blank')	# only 1st level
        label = '1.'
        for a, v in attrs:
            if a == 'type':
		if len(v) == 1: v = v + '.'
		label = v
        self.list_stack.append(['ol', label, 0])
        self.formatter.add_line_break()
        l = '.list 0,"' + "*-o"[len(self.list_stack)%len("-*o")] + '"'
        self.handle_data('.display elements "",D,"."')
        self.formatter.add_line_break()
        self.handle_data('.list 0,""')
        self.formatter.add_line_break()


    def end_ol(self):					# </OL>
        if self.list_stack: del self.list_stack[-1]
        self.formatter.end_paragraph(not self.list_stack)
        self.formatter.pop_margin()
        self.handle_data('.end list 0')
        self.formatter.add_line_break()
        if not self.list_stack:
            self.handle_data('.blank')
            self.formatter.add_line_break()

    def do_li(self, attrs):                             # <LI>
        self.formatter.end_paragraph(0)
        if self.list_stack:
            [dummy, label, counter] = top = self.list_stack[-1]
            top[2] = counter = counter+1
        else:
            label, counter = '*', 0
        # self.formatter.add_label_data(label, counter)
        self.formatter.add_line_break()
        self.handle_data('.list element ;')

    def start_dl(self, attrs):                          # <DL>
        self.formatter.end_paragraph(1)
        self.list_stack.append(['dl', '', 0])
        self.formatter.add_line_break()
        self.handle_data('.blank ;')

    def end_dl(self):                                   # </DL>
        self.ddpop(1)
        if self.list_stack: del self.list_stack[-1]
        self.formatter.add_line_break()
        self.handle_data('.blank')
        self.formatter.add_line_break()

    def do_dt(self, attrs): # (unchanged)               # <DT>
        self.ddpop()

    def do_dd(self, attrs):                             # <DD>
        self.ddpop()
        self.formatter.push_margin('dd')
        self.list_stack.append(['dd', '', 0])
        self.handle_data('.lm +8;')

    def ddpop(self, bl=0):
        self.formatter.end_paragraph(bl)
        if self.list_stack:
            if self.list_stack[-1][0] == 'dd':
                del self.list_stack[-1]
                self.formatter.pop_margin()
                self.handle_data('.lm -8;')

    def do_br(self, attrs):                             # <BR>
        self.formatter.end_paragraph(0)
        self.handle_data('.break')
        self.formatter.add_line_break()

    def do_hr(self, attrs):                             # <HR>
        self.formatter.add_line_break()
        self.handle_data('.literal')
        self.formatter.add_hor_rule()
        self.handle_data('.end literal')
        self.formatter.add_line_break()

    def do_p(self, attrs):                              # <P>
        self.formatter.end_paragraph(0)
        self.handle_data('.blank')
        self.formatter.add_line_break()

    def do_rno(self, attrs):                            # <RNO>
        #self.formatter.add_line_break()
        #self.formatter.add_literal_data("@@RNO\n")
        for attrname, value in attrs:
          if attrname == 'newline':
            self.formatter.add_line_break()
          if attrname == 'inline':
            self.handle_data(value)
          if attrname == 'line':
            self.formatter.add_line_break()
            self.handle_data(value)
            self.formatter.add_line_break()
          if attrname == 'insert_literal':
            self.formatter.add_line_break()
            self.handle_data('.end literal')
            self.formatter.add_line_break()
            self.handle_data(value)
            self.formatter.add_line_break()
            self.handle_data('.literal')
            self.formatter.add_line_break()
        # else:
        #   print l[1]
        #print "@@x_HTMLParser.do_rno(",attrs,")"

    def start_center(self, attrs):                         # <CENTER>
        self.formatter.end_paragraph(0)
        self.handle_data('.center;')

    def end_center(self):                                  # </CENTER>
        self.formatter.end_paragraph(0)
        self.formatter.add_line_break()

    # Typographic Elements

    # BOLD used to implement		# <STRONG> + # </STRONG>
    #  warning: other tags use start_b/end_b, too
    # assume that '.enable bold .flags bold *' is given
    def start_b(self, attrs):
        self.formatter.push_font((AS_IS, AS_IS, 1, AS_IS)) # ??
        self.handle_data('^*')

    def end_b(self):
        self.formatter.pop_font()
        self.handle_data('\*')

    # underline used to implement <EM> </EM>
    # assume that '.enable underline' and '.flags underline &' is given
    def start_em(self, attrs):				# <EM>
        self.formatter.push_font((AS_IS, AS_IS, 1, AS_IS)) # ??
        self.handle_data('^&')

    def end_em(self):					# </EM>
        self.formatter.pop_font()
        self.handle_data('\&')

# class RNOformatter(AbstractFormatter):

def html2rno():
  fp = open (sys.argv[1], 'r')
  data = fp.read()
  fp.close()
  w = rno_Writer()
  f = AbstractFormatter (w)
  p = rno_HTMLParser (f)
  p.feed (data)
  p.close ()

if __name__ == '__main__':
  html2rno()
