$!++
$! Name:
$!   UNTAR2DATESET.COM
$!
$! Convert the output from '$VMSTAR xvf TARFILE' to a command procedure
$! which sets creation and revision date + time.
$!
$! Needs:
$!   FILE_SET_DATE utility (is located in the same directory)
$!
$! Example:
$!   $ DEFINE/USER_MODE SYS$OUTPUT name-UNTAR.LOG
$!   $ VMSTAR xvf name.TAR
$!   $ @UNTAR2DATESET name-UNTAR.LOG name-DATESET.COM
$!   $ @name-DATESET.COM/output=name-DATESET.LOG
$!   $ SEARCH name-DATESET.LOG "%" /WINDOW=(1,4)
$!
$! Warning:
$!   This procedure contains minimal error checking.
$!   It assumes a fixed output format which works with MY copy of VMSTAR
$!   which is not necessarily the latest version...
$!   (UNTAR2DATESET.COM is just a small hack...)
$!
$! 12-DEC-1997 ZE. -- uppercase month names (needed for FILE_SET_DATE on
$!			OpenVMS Alpha V6.2)
$! 09-MAR-1998 ZE. -- put UNTAR2DATESET.COM in [.VMS.TOOLS] directory.
$! 18-MAY-1998 ZE. -- set hundredth explicitly to '00'
$!--
$! ----------------------------------------
$ _DEFAULT = F$ENVIRONMENT("DEFAULT")
$ on ERROR then $ goto PROC_EXIT
$!
$ _PROCEDURE = F$ENVIRONMENT("PROCEDURE")
$ _DEVICE    = F$PARSE(_PROCEDURE,,,"DEVICE")
$ _DIRECTORY = F$PARSE(_PROCEDURE,,,"DIRECTORY")
$!
$ set DEFAULT '_DEVICE''_DIRECTORY'	! [.VMS.TOOLS]
$ set DEFAULT []	! force '[]' as directory delimiters
$ _TOOLS = F$ENVIRONMENT("DEFAULT")
$ set DEFAULT '_DEFAULT'
$! ----------------------------------------
$ close/nolog FIL_INP ! eases debugging...
$ close/nolog FIL_OUT
$ open /read  FIL_INP 'P1'
$ open /write FIL_OUT 'P2'
$!
$ write FIL_OUT "$ set noON"
$!
$! -- make architecture handling 'on-the-fly'
$ write FIL_OUT "$ if (F$GETSYI(""HW_MODEL"").ge.1024)"
$ write FIL_OUT "$ then"
$ write FIL_OUT "$   _ARCH = ""ALPHA""
$ write FIL_OUT "$ else"
$ write FIL_OUT "$   _ARCH = ""VAX""
$ write FIL_OUT "$ endif"
$!
$ write FIL_OUT "$ set VERIFY"
$ write FIL_OUT "$ FSD = ""$", _TOOLS, "FILE_SET_DATE_'","'_ARCH'.EXE"""
$LOOP:
$ read /end_of_file=FIL_EOF FIL_INP T_RECORD
$ L_POS = F$LOCATE("[",T_RECORD)
$ if (F$EDIT(F$EXTRACT(0,L_POS,T_RECORD),"COLLAPSE") .eqs. "") ! all <SPACE> 
$ then
$   goto LOOP	! just a directory, skip
$ endif
$ T_FILNAM = F$EXTRACT(30,999,T_RECORD)
$ T_YEAR   = F$EXTRACT(16,4,T_RECORD)
$ T_MONTH  = F$EXTRACT(0,3,T_RECORD)
$   T_MONTH = F$EDIT(T_MONTH,"UPCASE")	! SYS$BINTIM() on Alpha V6.2 wants it
$ T_DAY    = F$EXTRACT(4,2,T_RECORD)
$ T_TIME   = F$EXTRACT(7,8,T_RECORD)
$ !		   SYS$BINTIM doesn't allow ':' ---v--- here
$ T_DATE = T_DAY + "-" + T_MONTH + "-" + T_YEAR + " " + T_TIME + ".00"
$ write FIL_OUT "$ FSD ", T_FILNAM, " """,T_DATE,"""
$ goto LOOP
$FIL_EOF:
$ write FIL_OUT "$ SET noVERIFY"
$!
$PROC_EXIT:
$ close FIL_INP /noLOG
$ close FIL_OUT /noLOG
$!
$ set DEFAULT '_DEFAULT'
$ exit
