/* VMS__CVT.C -- 14-APR-1996 Uwe Zessin
   some conversion routines

   19-AUG-1997 ZE. -- vms__cvt_u2v_time()
   05-NOV-1997 ZE. -- vms__cvt_oct2hex() + vms__cvt_hex2oct()
   14-DEC-1997 ZE. -- include LIB$ROUTINES.H,
			add vms__cvt_v2u_time() + vms__cvt_test_t()
   10-JAN-1998 ZE. -- removed the following routines, because 64-bit and
			128-bit values are now represented as Python long
			integers through the interfaces.
		- vms__cvt_quad2hex() - vms__cvt_hex2quad() - vms__cvt_test_q()
		- vms__cvt_oct2hex() - vms__cvt_hex2oct() - vms__cvt_test_o()
*/

#include <descrip.h>		/* string descriptor support */
#include <lib$routines.h>	/* LIB$name */
#include <ots$routines.h>	/* OTS$name */
#include <ssdef.h>		/* SS$_name */
#include <stdio.h>		/* print() */
#include <time.h>

/* ------------------------------------------------------------------------- */
/* convert Unix time_t value to VMS bintim value */
void vms__cvt_u2v_time (time_t al_unixtime, unsigned int * aq_vmstime[2])
		     /* input             , output                       */
{
    unsigned long l_addend = 0;		/* -> lib$emul() */
    unsigned long l_arraylength = 2;	/* -> lib$addx() */

    /* time_t l_unixtime; */	/* time_t tick is 1 second */
    unsigned long l_multiplicant = 10000000L;
				/* VMS bintim tick is 100ns (nano-second) */
				/* 1 second = 10000000 * 100ns */

    long q_basetime[2];		/* 01-JAN-1970 00:00:00.00 in bintim format */
    long q_addstime[2];		/* add seconds in bintim format */

    q_basetime[0] = 0x4BEB4000L;	/* 01-JAN-1970 00:00:00.00 */
    q_basetime[1] = 0x007C9567L;	/* in VMS bintim format    */

    (void) lib$emul
	(&al_unixtime		/* longword-integer-multiplier   */
	,&l_multiplicant	/* longword-integer-multiplicand */
	,&l_addend		/* addend  */
	,&q_addstime[0]		/* product */
	);

    /* ignore condition value SS$_INTOVF */
    (void) lib$addx
	(&q_basetime[0]		/* addend-array		     */
	,&q_addstime[0]		/* augend-array		     */
	,aq_vmstime		/* resultant-array	     */
	,&l_arraylength		/* [,array-length] longwords */
	);
} /* vms__cvt_u2v_time() */

/* ------------------------------------------------------------------------- */
/* convert VMS bintim value to Unix time_t value */
void vms__cvt_v2u_time (long * aq_vmstime, time_t * al_unixtime)
		     /* input		 , output		*/
{
    unsigned long l_remainder   = 0;	/* -> lib$ediv() */
    unsigned long l_arraylength = 2;	/* -> lib$addx() */

    /* time_t l_unixtime; */	/* time_t tick is 1 second */
    unsigned long l_divisor = 10000000L; /* VMS bintim tick is 100ns (nano-second) */
				/* 1 second = 10000000 * 100ns */

    long q_basetime[2];		/* 01-JAN-1970 00:00:00.00 in bintim format */
    long q_substime[2];		/* substract seconds in bintim format */

    q_basetime[0] = 0x4BEB4000L;	/* 01-JAN-1970 00:00:00.00 */
    q_basetime[1] = 0x007C9567L;	/* in VMS bintim format    */

    /* ignore condition value SS$_INTOVF */
    (void) lib$subx
	(aq_vmstime		/* minuend-array	     */
	,&q_basetime[0]		/* subtrahend-array	     */
	,&q_substime[0]		/* difference-array	     */
	,&l_arraylength		/* [,array-length] longwords */
	);

    (void) lib$ediv
	(&l_divisor		/* longword-integer-divisor	*/
	,&q_substime[0]		/* quadword-integer-dividend	*/
	,al_unixtime		/* longword-integer-quotient	*/
	,&l_remainder		/* remainder	*/
	);

} /* vms__cvt_v2u_time() */

/* ------------------------------------------------------------------------- */
/* test example for bintim<->time_t conversion */
/* DBG> set module vms__cvt	   */
/* DBG> set break vms__cvt_test_t  */
/* DBG> call vms__cvt_test_t	   */
unsigned long vms__cvt_test_t (void)
{
long		q_testtime[2];	/* 29-FEB-2000 12:34:56.78 in bintim format */

time_t		l_testtime;	/* convert */
unsigned long	l_status;

q_testtime[0] = 0xD9755CC0L;	/* 29-FEB-2000 12:34:56.78 */
q_testtime[1] = 0x009E6639L;	/* in VMS bintim format    */

(void) vms__cvt_v2u_time (&q_testtime[0], &l_testtime);
(void) printf ("%s\n", ctime(&l_testtime));

	return SS$_NORMAL;
} /* vms__cvt_test_t() */

/* ------------------------------------------------------------------------- */

/* EOF: VMS__CVT.C */
