/* VMS__CVT_BIN2PY.C - 28-DEC-1998 Uwe Zessin
   Generic routine to convert binary data to a Python type.
   Can be: Byte, Word, Longword, Quadword, Octaword and tuples of BWLQO.

   09-JAN-1999 ZE. -- conversion of 128-bit octaword 'hex-string'
			to Python long integer
   05-APR-1999 ZE. -- improve error messages with PyErr-Format()
*/

#include "vmsdef.h"

/* ------------------------------------------------------------------------- */
/* size of item types - in PYVMS_GLOBAL.C */
extern unsigned long vmsdef_gl_itmtypsiz[];
/* ------------------------------------------------------------------------- */
/* function prototypes for external routines */

/* ------------------------------ */
/* input a binary quadword - output a Python long integer */
extern PyObject * vms__cvt_quad2pylong (long q_quadword[2]);

/* ------------------------------ */
/* input an unsigned binary quadword - output a Python long integer */
extern PyObject * vms__cvt_uquad2pylong (long q_quadword[2]);

/* ------------------------------ */
/* input a binary octaword - output a Python long integer */
extern PyObject * vms__cvt_octa2pylong (long q_octaword[4]);

/* ------------------------------------------------------------------------- */

PyObject *
vms__cvt_bin2py
	(char			 * ab_data_addr		/* data address */
	,unsigned short int	   w_data_type		/* data type	*/
	,unsigned short int	   w_bufsiz		/* data length	*/
	)
{
	unsigned short int	w_styp;		/* data type (w/o sign) */

	unsigned long	  l_datatypsiz;	/* size of single datatype item	   */
	unsigned long	  l_tuple_size;	/* number of items		   */
	unsigned long  	  l_data;	/* B/W/L storage		   */
	unsigned long	  loop;	/* counter to loop over elements of 1 item */
	char	* ab_data;	/* pointer to data elements in 1 item	   */

	PyObject * ar_intobj;
	PyObject * ar_tuple;

	/* -------------------- */
	ar_intobj = NULL;	/* there are some Py_XDECREFs() below !! */
	ar_tuple  = NULL;

	ab_data = ab_data_addr;		/* start address */

	/* data type - mask off the (un)signed bit */
	w_styp = w_data_type & (~ITMTYP_M_USIGN);
	if (w_styp > ITMTYP_K_MAXTYP)
	{
	    /* out of range - prevent ACCVIO at: vmsdef_gl_itmtypsiz[w_styp] */
	    return PyErr_Format(PyExc_SystemError,
		"vms__cvt_bin2py(): unsuported datatype id number:%d",
		(unsigned int)w_data_type);
	}

	l_datatypsiz = vmsdef_gl_itmtypsiz[w_styp];	/* size of 1 element */
	/* could have been given ITMTYP_K_ASCII or _ASCIC */
	if (l_datatypsiz == 0)
	{
	    return PyErr_Format(PyExc_SystemError,
		"vms__cvt_bin2py(): /0 at 'w_bufsiz / l_datatypsiz' - typ=%d",
		(unsigned int)w_styp);
	}
	l_tuple_size = w_bufsiz / l_datatypsiz;		/* # elements */

	/* -------------------- */
	/* if item has multiple data-elements a tuple is returned */
	if (l_tuple_size > 1)
	{
	    ar_tuple = PyTuple_New(l_tuple_size);	  /* build tuple */
	    if (ar_tuple == NULL)
	    {
		return NULL;
	    }
	}
	else
	{
	    if (l_tuple_size < 1)
	    {
		return PyErr_Format(PyExc_SystemError,
"vms__cvt_bin2py(): datatype(%d) bigger(%d) than buffer length(%d)",
		(unsigned int)w_styp, l_datatypsiz, (unsigned int)w_bufsiz
		    );
		return NULL;
	    }
	    /* else - exactly 1 item to return - use code in loop, too */
	}

	/* -------------------- */
	/* loop over all elements in the tuple */
	for (loop = 0; loop < l_tuple_size; loop++)
	{
	    l_data = 0;
	    if (w_styp == ITMTYP_K_BYTE)
	    {
		l_data = (*(unsigned char*)ab_data) & 0xff;
		ab_data++;	      /* ptr to next element */
	    }
	    else
	    {
		if (w_styp == ITMTYP_K_WORD)
		{
	            l_data = (*(unsigned short int*)ab_data) & 0xffff;
	            ab_data += 2;  /* ptr to next element */
		}
		else
		{
		    if (w_styp == ITMTYP_K_LONG)
		    {
			l_data = *(long*)ab_data;
			ab_data += 4;	      /* ptr to next element */
		    } /* w_styp == ITMTYP_K_LONG) */
		    /* no ELSE path - other datatypes are handled below */
		} /* w_styp == ITMTYP_K_WORD) - else */
	    } /* w_styp == ITMTYP_K_BYTE) - else */

	    /* ----- */
	    /* convert BYTE, WORD, LONG into Python (32-bit) integer object */
	    if ((w_styp == ITMTYP_K_BYTE) ||
		(w_styp == ITMTYP_K_WORD) ||
		(w_styp == ITMTYP_K_LONG)
		)
	    {
		ar_intobj = PyInt_FromLong(l_data);
		if (ar_intobj == NULL)
		{
		    Py_XDECREF(ar_tuple);     /* don't care if doesn't exist */
		    ar_tuple = NULL;
		    break;	/* @@ abort loop */
		}
	    }
	    else
	    {
		/* convert QUAD into Python long integer object */
		if (w_styp == ITMTYP_K_QUAD)
		{
		    long * aq_data;

		    aq_data = (long*)ab_data;
		    /* return unsigned or signed ? */
		    if (w_data_type & ITMTYP_M_USIGN)
		    {
			ar_intobj = vms__cvt_uquad2pylong (aq_data);
		    }
		    else
		    {
			ar_intobj = vms__cvt_quad2pylong (aq_data);
		    }

		    if (ar_intobj == NULL)
		    {
			Py_XDECREF(ar_tuple);	/* don't care if exists */
			return NULL;	/* error text already set up */
		    }
		    ab_data += 8;	/* ptr to next element */
		} /* (w_styp == ITMTYP_K_QUAD) */
		else
		{
		    /* convert OCTA into Python long integer object */
		    if (w_styp == ITMTYP_K_OCTA)
		    {
			long	      * ao_data;

			ao_data = (long*)ab_data;

			/* return unsigned or signed ? */
			if (w_data_type & ITMTYP_M_USIGN)
			{
			  /* @@ return of unsigned currently not implemented */
			    ar_intobj = vms__cvt_octa2pylong (ao_data);
			}
			else
			{
			    ar_intobj = vms__cvt_octa2pylong (ao_data);
			}

			if (ar_intobj == NULL)
			{
			    Py_XDECREF(ar_tuple); /* don't care if exists */
			    return NULL;	/* error text already set up */
			}
			ab_data += 16;	/* ptr to next element */
		    } /* (w_styp == ITMTYP_K_OCTA) */
		    else
		    {
			(void) PyErr_Format(PyExc_SystemError,
			    "vms__cvt_bin2py(): non-implemented datatype:%d",
			    (unsigned int)w_styp);
			Py_XDECREF(ar_tuple);	/* don't care if exists */
			return NULL;
		    } /* - (w_styp == ITMTYP_K_OCTA) */
		} /* - (w_styp == ITMTYP_K_QUAD) */
	    } /* - (w_styp == BWL) */

	    /* ( current element is in ar_intobj ) */

	    if (l_tuple_size == 1)
	    {
		/* only one element - return this instead of tuple */
		/* ar_tuple should be NULL */
		return ar_intobj;
	    }
	    else
	    {
		/* insert element into tuple */
		if (PyTuple_SetItem(ar_tuple, loop, ar_intobj) != 0)
		{
		    Py_DECREF(ar_intobj);
		    Py_DECREF(ar_tuple);
		    return NULL;
		}
	    } /* (l_tuple_size != 1) */
	} /* for() loop over all tuple elements */

	return ar_tuple;
} /* vms__cvt_bin2py () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS__CVT_BIN2PY.C */
