/* VMS__GETBUILDINFO.C -- Uwe Zessin
   OpenVMS specific version

   23-AUG-1999 ZE. -- update for Alpha image header
*/

#ifdef __DECC
#pragma module VMS__GETBUILDINFO "19990823"
#endif

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <time.h>

#ifndef BUILD
#define BUILD "V005"
#endif

/* ------------------------------------------------------------------------- */

#ifdef __DECC
#pragma extern_model save
#pragma extern_model strict_refdef
extern long ctl$gl_imghdrbf;
#pragma extern_model restore
#else /* VAXC */
globalref long ctl$gl_imghdrbf;
#endif

#ifdef __ALPHA
#define EIHD$L_IMGIDOFF 24
#define EIHI$Q_LINKTIME 8

#define _IMGIDOFF EIHD$L_IMGIDOFF
#define _LINKTIME EIHI$Q_LINKTIME
#else
#define IHD$W_IMGIDOFF 6
#define IHI$Q_LINKTIME 56

#define _IMGIDOFF IHD$W_IMGIDOFF
#define _LINKTIME IHI$Q_LINKTIME
#endif

long * vms__get_linktime (void)
{
long		* al_imghdrbf;

unsigned short	* aw_imgidoff;
unsigned short	  w_imgidoff;

long		* aq_linktime;

unsigned char	* ab_ihi;

	al_imghdrbf = &ctl$gl_imghdrbf;

	al_imghdrbf = (long *)*al_imghdrbf;
	al_imghdrbf = (long *)*al_imghdrbf;

	aw_imgidoff = (unsigned short *)
		((unsigned char *)al_imghdrbf + _IMGIDOFF);

	w_imgidoff = *aw_imgidoff;

	ab_ihi = (unsigned char *)al_imghdrbf + w_imgidoff;

	aq_linktime = (long *) (ab_ihi + _LINKTIME);

	return aq_linktime;
} /* vms__get_linktime (void) */

/* ------------------------------------------------------------------------- */

extern void vms__cvt_v2u_time (long * aq_vmstime, time_t * al_unixtime);
		     /* input		 , output		*/

const char *
Py_GetBuildInfo()
{
static char buildinfo[40];
time_t	    l_unixtime;

	(void) vms__cvt_v2u_time (
			vms__get_linktime (),
			&l_unixtime );

	(void) memset (buildinfo, 0, 40);
	(void) sprintf (buildinfo, "%.9s, %.24s", BUILD, ctime (&l_unixtime));
	return buildinfo;
}
