/* VMS__INS_CB_2DICT.C -- 15-OCT-1998 Uwe Zessin
   insert constants(32) and bitmasks(32/64) into (module) dictionary
*/

#include "python.h"

#include "vmsdef.h"

/* current VMS version */
extern vmsdef_xw_vmsver vmsdef_gw_vmsver;

/* ------------------------------ */
/* input a binary quadword - output an unsigned Python long integer */
PyObject * vms__cvt_uquad2pylong (unsigned long q_quadword[2]);

/* ------------------------------------------------------------------------- */
int vms__ins_cb_2dict
	(struct vmsdef_xr_conmsktbl * vmsdef_ar_cb_def /* VMSDEF_GR_CB_$xxxDEF[] */
	,PyObject		    * ar_dict
	)
{
    PyObject * ar_dictobj;
    char     * at_itm_name;

    /* ----- ----- ----- ----- */
    /* loop through table (in VMSDEF_$xxxDEF.MAR) of constants and */
    /* bitmasks and load them into module 'vms_XXXdef' */
    while (vmsdef_ar_cb_def->l_tbltyp != 0)
    {
      struct vmsdef_x_bitmsk   * ar_bitmsk32; /* and constant32 */
      struct vmsdef_x_bitmsk64 * ar_bitmsk64;

      ar_bitmsk32 = vmsdef_ar_cb_def->ar_bitmsk;

      /* loop through constants/bitmasks */
      while ((ar_bitmsk32->w_vmsvermin != 0) && (ar_bitmsk32->w_vmsvermax != 0))
      {
	/* check VMS version number */
	if ((ar_bitmsk32->w_vmsvermin <=vmsdef_gw_vmsver) &&
	    (ar_bitmsk32->w_vmsvermax >=vmsdef_gw_vmsver)   )
	{
	  if (vmsdef_ar_cb_def->l_tbltyp == CONMSKTBL_K_BITMASK64)
	  {
	    /* ar_bitmask32 + bitmask64 are equal except for */
	    /*  the second longword */
	    ar_dictobj = vms__cvt_uquad2pylong (&ar_bitmsk32->l_bit_value);
	    /*    equal to			 ar_bitmsk64->l_bit_value0 */
	  }
	  else
	  {
	    /* currently, BITMASK32 + CONSTANT32 are equal */
	    ar_dictobj = PyInt_FromLong(ar_bitmsk32->l_bit_value);
	  }
	  if (ar_dictobj == NULL)
	  {
	    return -1;				/* error */
	  }
	  at_itm_name = ar_bitmsk32->at_bit_name;

	  /* check if item already in dictionary */
	  if (PyDict_SetItemString(ar_dict, at_itm_name, ar_dictobj) < 0)
	  {
	    Py_DECREF (ar_dictobj);
	    return -1;				/* error */
	  }

	} /* VMS version check */

	/* Careful! ar_bitmsk32 + ar_bitmsk64 have different sizes! */
	if (vmsdef_ar_cb_def->l_tbltyp == CONMSKTBL_K_BITMASK64)
	{
	  ar_bitmsk64 = (struct vmsdef_x_bitmsk64 *)ar_bitmsk32;
	  ar_bitmsk64++;
	  ar_bitmsk32 = (struct vmsdef_x_bitmsk *)ar_bitmsk64;
	}
	else
	{
	  ar_bitmsk32++;	/* point to next bitmask element */
	}
      } /* loop over constants/bitmasks */
      vmsdef_ar_cb_def++;	/* next const/bitmsk table */
    } /* while (vmsdef_ar_cb_def->l_tbltyp != 0) */
    /* ----- ----- ----- ----- */

    return 0;	/* OK */
} /* vms__ins_cb_2dict () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS__INS_CB_2DICT.C */
