/* VMS__IOCTL.C -- 14-AUG-1997 Uwe Zessin
   (partial) ioctl() routine for the DCL environment
   called from SOCKETMODULE.C

   14-DEC-1997 ZE. -- include lib$routines.h, socket.h, starlet.h,
			#define name to lowercase for old file (UCX V3.3).
   21-DEC-1997 ZE. -- Don't lowercase LIB$name + SYS$name if DEC C V5.6 or
			above because this one uppercases the function names!
   29-DEC-1997 ZE. -- Don't lowercase LIB$name + SYS$name if DEC C V5.2 ...
   20-DEC-1998 ZE. -- Test with OpenVMS Alpha V7.2-EFT3
			(DEC TCP/IP Services version 5)
*/

#include <errno.h>
#include <lib$routines.h>	/* LIB$name		*/
#include <socket.h>		/* (vaxc|decc)$get_sdc	*/
#include <starlet.h>		/* SYS$name		*/
#define ioctl vms__ioctl

#ifndef __DECC_VER
#define __DECC_VER 0
#endif
#if __DECC_VER < 50200000 /* @@ might need to change for older version */
/* new versions of DEC C redefine to uppercase ! */
#define LIB$GET_EF  lib$get_ef
#define LIB$FREE_EF lib$free_ef
#define SYS$QIOW    sys$qiow
#endif

#ifdef __ALPHA
#if __VMS_VER >= 70200011 /* assume DEC TCP/IP Version 5 or higher */
#include "SYS$COMMON:[SYSHLP.EXAMPLES.TCPIP]TCPIP$IOCTL_ROUTINE.C"
#else
#include "SYS$COMMON:[SYSHLP.EXAMPLES.UCX]UCX$IOCTL_ROUTINE.C"
#endif
#else
#include "SYS$COMMON:[SYSHLP.EXAMPLES.UCX]UCX$IOCTL_ROUTINE.C"
/* I know that is UCX$EXAMPLES:, but UCX is not always started on my system */
#endif /* __ALPHA */

/* EOF: VMS__IOCTL.C */

/*
Table 3-7: Request Options for ioctl( ) | POSIX for OpenVMS

request		Description
--------------------------------------------------
	1
FIONBIO		Sets or clears nonblocking I/O. This flag has the same effect
		as the O_NONBLOCK (and the O_NDELAY) argument for the F_SETFL
		/F_GETFL commands to the fcntl( ) function.

		The argp argument can be set to a non-zero value to turn this
		flag on or to zero to turn this flag off.

	1
FIONREAD	Returns in argp the number of bytes available to read from a
		socket or from a file descriptor associated to a terminal. In
		the latter case, if the terminal is in CANONICAL mode, the
		number of bytes returned will not consider the bytes available
		in NON_CANONICAL mode and vice versa.

	2
MTIOCGET	Returns in argp a pointer to the mt_get structure, which gets
		magnetic tape characteristics and status.

	2
MTIOCTOP	Returns in argp a pointer to the mt_op structure, which gets a
		magnetic tape operation.

	1
SIOCATMARK	Returns a zero or non-zero value in argp, depending on whether
		the specified socket's read pointer is currently at the
		out-of-band mark.

1 Sockets operations
2 Magnetic tape operations
*/
