/* VMS__ITMLST_ROUTINES.C -- 06-OCT-1998 Uwe Zessin
   common routines to process VMS item lists
   - allocate item-list
   - build   input- / output-items
   - process output items after system service
   - deallocate item list and all buffers

07-OCT-1998 ZE. -- add vms__itmlst_build() - create item-list
22-NOV-1998 ZE. -- add vms__itmlst_outprc() - output item processing
		   - this version has no ASCIC support tested!
28-DEC-1998 ZE. -- support for signed/unsigned datatypes (in ->w_typ_sys)
29-DEC-1998 ZE. -- enhance vms__itmlst_build() to allow output-item to be
		   a single string 'fac$_') instead a tuple ('fac$_',None)
		-- call vms__cvt_bin2py() to build return-value of BWLQO
10-JAN-1999 ZE. -- call vms__cvt_py2bin() for conversion
22-JAN-1999 ZE. -- add support for ITMTYP_K_BOOL
18-FEB-1999 ZE. -- remove never used argument to vms__itmlst_outprc().
		   All calling routines changed, too, of course.
14-MAR-1999 ZE. -- work for: passed 'by value' / immediate
29-MAR-1999 ZE. -- add converter-function support for vms__itmlst_build()
03-APR-1999 ZE. -- add converter-function support for vms__itmlst_outprc()
05-APR-1999 ZE. -- add support for ITMTBL_M_SETRETLEN -  pre-set returned
		length address - necessary for SYS$GETQUIW + SYS$SNDJBCW
29-MAY-1999 ZE. -- replace some PyErr_SetString() with PyErr_Format()
                -- fix free-handling of BYVALUE items
30-JUN-1999 ZE. -- more arguments to output-item converter function
*/


#include "python.h"
#include "vmsdef.h"

#include "ssdef.h"

/* ------------------------------------------------------------------------- */
extern vmsdef_xw_vmsver vmsdef_gw_vmsver;
/* ------------------------------------------------------------------------- */
/* function prototypes for external routines */

/* ------------------------------ */
/* Generic routine to convert binary data to a Python type. */
extern PyObject * vms__cvt_bin2py
	(char			 * ab_data_addr		/* data address */
	,unsigned short int	   w_data_type		/* data type	*/
	,unsigned short int	   w_bufsiz		/* data length	*/
	);

/* ------------------------------ */
/* Generic routine to convert a Python type to binary data. */
extern long vms__cvt_py2bin
        (PyObject                * ar_py_data           /* Python data  */
        ,char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type    */
        ,unsigned short int        w_bufsiz             /* data length  */
        );

/* ------------------------------------------------------------------------- */
/* vms__itmlst_free() - 06-OCT-1998 Uwe Zessin			*/
/* 14-MAR-1999 ZE. -- add support for 'by value'		*/
/* 29-MAY-1999 ZE. -- fix free-handling of BYVALUE items	*/
/*  free any malloc()ed buffers for items pointed by item-list,	*/
/*       the item-list itself,					*/
/*       the back-pointer array into VMSDEF structure,		*/
/*       the returned-length array				*/

void vms__itmlst_free
	(struct vmsdef_xr_itmlst3  * ar_itemlist
	,struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef
	,unsigned short int        * aw_retlenlist )
{
  struct vmsdef_xr_itmlst3  * ar_itemlist_ptr;	/* walk along */
							/* item-list  */
  struct vmsdef_xr_itmtbl   ** ar_itm_vmsdef_ptr;

  if (ar_itemlist != NULL)
  {     
    ar_itemlist_ptr   =  ar_itemlist;
    ar_itm_vmsdef_ptr =  ar_itm_vmsdef;	/* must be non-NULL !! */

    /* failure was on first item - no buffers allocated anyway */
    if ((* ar_itm_vmsdef_ptr) != NULL)
    {
      /* loop over item-list and free allocated buffers */
      /* Warning: for boolean items W_BUFSIZ == 0 ! */
      while ((ar_itemlist_ptr->w_itmcod != 0) ||
	     (ar_itemlist_ptr->w_bufsiz != 0)   )
      {
	/* Check if 'boolean item code' or 'symbolic item' ($INIT_VOL()). */
	/* A boolean has no 'sign bit' - no need to mask.		  */
	if (! ((* ar_itm_vmsdef_ptr)->w_typ_sys == ITMTYP_K_BOOL))
	{
	    /* drop buffer, if one is allocated */
	    if (ar_itemlist_ptr->itmlst3_a_bufadr != 0)
	    {
		/* check if 'by value' */
		if (! ((* ar_itm_vmsdef_ptr)->l_flags & ITMTBL_M_BYVALUE))
		{
		    /* not passed 'by value' - deallocate buffer */
		    (void) free (ar_itemlist_ptr->itmlst3_a_bufadr);
		}
	    }
	}
	ar_itemlist_ptr++;		/* next item */
	ar_itm_vmsdef_ptr++;
      }
    }
    (void) free (ar_itemlist);	/* free the entire VMS item-list */
  }     
  if (ar_itm_vmsdef != NULL)
  {     
	(void) free (ar_itm_vmsdef);	/* free back-pointer array to VMSDEF */
  }
  if (aw_retlenlist != NULL)
  {
	(void) free (aw_retlenlist);	/* free returned length array */
  }
  return;
} /* vms__itmlst_free () */

/* ------------------------------------------------------------------------- */
/* vms__itmlst_build() -- 07-OCT-1998 Uwe Zessin
- allocate item list
- build input- / output- items

28-DEC-1998 ZE. -- support for signed/unsigned datatypes (in ->w_typ_sys)
29-DEC-1998 ZE. -- enhance vms__itmlst_build() to allow output-item to be
		a single string ('fac$_') instead a tuple ('fac$_',None)
22-JAN-1999 ZE. -- add support for ITMTYP_K_BOOL
29-MAR-1999 ZE. -- add converter-function support for vms__itmlst_build()
05-APR-1999 ZE. -- add support for ITMTBL_M_SETRETLEN -  pre-set returned
		length address - necessary for SYS$GETQUIW/ SYS$SNDJBCW
29-MAY-1999 ZE. -- replace some PyErr_SetString() with PyErr_Format()
*/

PyObject * vms__itmlst_build
	(long			      l_inpitm_msk	/* input-item bit  */
	,long			      l_outitm_msk	/* output-item bit */
	,struct vmsdef_xr_itmtbl  *   ar_vmsdef_itmtbl	/* VMSDEF_GR_$xxxDEF */
	,PyObject		  *   ar_py_item_list	/* Python itmlst obj */
	,struct vmsdef_xr_itmlst3 * * aar_itemlist
	,struct vmsdef_xr_itmtbl  ** * aar_itm_vmsdef
	,unsigned short int       * * aaw_retlenlist
	)
{
	struct vmsdef_xr_itmtbl * ar_vmsdef_itmtbl_ptr;

	unsigned long		  l_itmlst_size;	/* number of items */
	unsigned long		  l_itmlst_idx;		/* index into "    */

	/* item tuple - ('fac$_itm',data) */
	PyObject		* ar_py_item_tuple;	/* item tuple */

	PyObject		* ar_py_item_code;	/* 'fac$_itm' */
	char			* at_item_code;		/* "	      */
	unsigned short int	  w_item_code;		/* from VMSDEF_GR_... */

	unsigned short int	  w_styp_sys; /* ITMTYP_M_USIGN masked off */

	/* item 'data' */
	PyObject		* ar_py_item_data;	/* ASCI[IC]/BWLQO */

	/* VMS item-list to be passed to system routine */
	struct vmsdef_xr_itmlst3 * ar_itemlist;		/* start address */
	struct vmsdef_xr_itmlst3 * ar_itemlist_ptr;	/* walk along    */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_retlenlist;	/* start address */
	unsigned short int	 * aw_retlenlist_ptr;	/* walk along	 */

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for item processing */
	struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef;	/* start address */
	struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef_ptr;	/* walk along    */

	unsigned long		  l_malloc_bytes;	/* for malloc() */

	unsigned long		  l_status;

	/* -------------------- */
	if (!PyTuple_Check(ar_py_item_list))
	{
	    PyErr_SetString(PyExc_TypeError, "itmlst - must be a tuple");
	    return NULL;
	}

	/* -------------------- */
	l_itmlst_size = PyTuple_Size(ar_py_item_list);

	/* -------------------- */
	/* allocate memory for:
	||	- each item-list element
	||	- the item-list termination element
	*/
	l_malloc_bytes =
	    ( (l_itmlst_size * sizeof(struct vmsdef_xr_itmlst3)) + /* items */
	      sizeof(struct vmsdef_xr_itmlst3)	 /* termination of itemlist */
	    );
	ar_itemlist = malloc (l_malloc_bytes);
	if (ar_itemlist == NULL)
	{
	    return PyErr_NoMemory();
	}
	/* Set the allocated memory to 0. */
	/* This is needed if the loop to build the item-list fails and the   */
	/*  cleanup routine - vms__itmlst_free() - has to free() any buffers */
	/*  that have been malloc()ed so far. Now it is not necessary to set */
	/*  any ar_itemlist_ptr->itmlst3_a_bufadr to NULL before building    */
	/*  the list. */
	(void) memset (ar_itemlist, 0, l_malloc_bytes);

	/* ar_itemlist_ptr is used to walk along the individual elements */
	/*  in the VMS item-list */
	ar_itemlist_ptr = ar_itemlist;

	/* -------------------- */
	/* allocate memory for:
	||	- an array of pointers from the item to its corresponding
	||	  VMSDEF structure element
	||	- no space for termination is needed / allocated
	*/
	l_malloc_bytes = (l_itmlst_size * 4);	/* for VMSDEF pointers % */
					/* % - needs no termination */
	ar_itm_vmsdef = malloc (l_malloc_bytes);
	if (ar_itm_vmsdef == NULL)
	{
	    (void) free (ar_itemlist);		/* prevent memory leak */
	    return PyErr_NoMemory();
	}

	/* Set this block to 0, too. The cleanup routine - vms__itmlst_free() */
	/* - needs information from VMSDEF in some situations. */
	(void) memset (ar_itm_vmsdef, 0, l_malloc_bytes);

	ar_itm_vmsdef_ptr = ar_itm_vmsdef;	/* used to walk over array */

	/* -------------------- */
	/* allocate memory for:
	||	- an array of words to store the returned lengths of
	||	  output items
	||	- no space for termination is needed / allocated
	*/
	l_malloc_bytes = (l_itmlst_size * 2);	/* for returned length % */
					/* % - this needs no termination */
	aw_retlenlist = malloc (l_malloc_bytes);
	if (aw_retlenlist == NULL)
	{
	    (void) free (ar_itemlist);		/* prevent memory leak */
	    (void) free (ar_itm_vmsdef);
	    return PyErr_NoMemory();
	}
	/* Set the allocated memory to 0. */
	/* Returned length will by 0 by default. */
	(void) memset (aw_retlenlist, 0, l_malloc_bytes);

	aw_retlenlist_ptr = aw_retlenlist;	/* used to walk over array */

/* -------------------- */
/* loop over Python item list and build VMS item list */
/*  - fill in item code and buffer size
/*  - allocate data buffer and set pointer in itmlst3_a_bufadr
/*  - if input-item:
/*      copy data from Python object into data buffer
/*  - set back-pointer via ar_itm_vmsdef_ptr for output-item processing
/*    (need e.g. data type to create the correct Python object)
/*  - set returned length address in VMS item-list from aw_retlenlist_ptr
--*/

for (l_itmlst_idx = 0; l_itmlst_idx < l_itmlst_size; l_itmlst_idx++)
{
  /* get item-list element - ('fac$_itm',data) from Python item-list tuple */
  ar_py_item_tuple = PyTuple_GetItem(ar_py_item_list, l_itmlst_idx);
  if (ar_py_item_tuple == NULL)
  {
    goto vms__itmlst__free1;		/* item-list + malloc()ed buffers */
  }
  /* -------------------- */
  /* each Python 'item' must either be a tuple itself ('fac$_itm',data) */
  /* or a simple string ('fac$_itm') if it is an output-item or a boolean */
  /* input-item. */
  if (PyTuple_Check(ar_py_item_tuple))
  {
    /* item is a tuple, now: */
    /* get item code ('fac$_itm') from 'item' tuple ----v */
    ar_py_item_code = PyTuple_GetItem(ar_py_item_tuple, 0);
    if (PyErr_Occurred())
    {
      goto vms__itmlst__free1;		/* item-list + malloc()ed buffers */
    }
    /* -------------------- */
    /* this item code must be a string ('fac$_itm') */
    if (!PyString_Check(ar_py_item_code))
    {
      (void) PyErr_Format(PyExc_TypeError,
	"itmlst - tuple-element:%d item code must be a string",
	l_itmlst_idx);
      goto vms__itmlst__free1;		/* item-list + malloc()ed buffers */
    }
  }
  else
  {
    /* A boolean input or output item or a 'symbolic item code' can also */
    /* be a simple string ('fac$_itm'). The real check is done later.    */
    ar_py_item_code = ar_py_item_tuple;

    if (!PyString_Check(ar_py_item_code))
    {
      (void) PyErr_Format(PyExc_TypeError,
	"tuple-element:%d item code must be a string",
	l_itmlst_idx);
      goto vms__itmlst__free1;		/* item-list + malloc()ed buffers */
    }
  } /* - (PyTuple_Check(ar_py_item_tuple)) */

  /* -------------------- */
  /* convert item code string to fac$_itm numerical value */
  at_item_code = PyString_AS_STRING(ar_py_item_code);
  ar_vmsdef_itmtbl_ptr = ar_vmsdef_itmtbl; /* begin of VMSDEF_GR_$xxxDEF */

  while (ar_vmsdef_itmtbl_ptr->w_vmsvermin != 0)
  {
    /* check VMS version */
    if ((ar_vmsdef_itmtbl_ptr->w_vmsvermin <= vmsdef_gw_vmsver) &&
	(ar_vmsdef_itmtbl_ptr->w_vmsvermax >= vmsdef_gw_vmsver)  )
    {
      /* compare item name */
      if (strcmp(at_item_code,ar_vmsdef_itmtbl_ptr->at_itmnam_py) == 0)
      {
	/* look for appropriate input or output item */
	if ( (ar_vmsdef_itmtbl_ptr->l_flags && l_inpitm_msk) ||
	     (ar_vmsdef_itmtbl_ptr->l_flags && l_outitm_msk)   )
	{
	  /* found textual match - use numerical value of item code */
	  w_item_code = ar_vmsdef_itmtbl_ptr->w_itmcod;
	  /* data type - mask off the (un)signed bit */
	  w_styp_sys = (ar_vmsdef_itmtbl_ptr->w_typ_sys) & (~ITMTYP_M_USIGN);
	  break;				/* leave while() loop */
	}
      } /* item code string match */
    } /* w_vmsvermin / w_vmsvermax match with vmsdef_gw_vmsver */
    ar_vmsdef_itmtbl_ptr++;			/* check next item code */
  } /* while (ar_vmsdef_itmtbl_ptr->w_vmsvermin != 0) */

  /* -------------------- */
  if (ar_vmsdef_itmtbl_ptr->w_vmsvermin == 0)
  {
    /* item code not found - abort */
    (void) PyErr_Format(PyExc_ValueError,
	"itmlst - unknown item code: %.100s",at_item_code);
    goto vms__itmlst__free1;		/* item-list + malloc()ed buffers */
  }

  /* -------------------- */
  /* printf ("@@itm:%s=%d\n", PyString_AS_STRING(ar_py_item_code), 
	/* (int)w_item_code); */
  /* store numerical item code into VMS item-list */
  ar_itemlist_ptr->w_itmcod = w_item_code;

  /* -------------------- */
  /* always store pointer to VMSDEF entry for this item code    */
  /* because this is used in a decision to build the dictionary */
  /* which is returned to Python - e.g. $GETUAI */
  *ar_itm_vmsdef_ptr = ar_vmsdef_itmtbl_ptr;

  /* -------------------- */
  /* Put returned length address into item-list = provide storage for   */
  /* returned length. This is overwritten to 0 for ITMTYP_K_BOOL, later */
  ar_itemlist_ptr->itmlst3_aw_retlenaddr = aw_retlenlist_ptr;
  /* @@ for $PSCAN this can be item_flags ! - not implemented, yet */

  /* ----------------------------------------------------------------------- */
  /* process input items */
  if (ar_vmsdef_itmtbl_ptr->l_flags & l_inpitm_msk)
  {
    /* -------------------- */
    /* Input items of ITMTYP_K_BOOL have no data portion. The input item */
    /*  might also be a 'symbolic item code' which has no data portion,  */
    /*  too. Therefor it has the ITMTYP_K_BOOL data type, too.		 */
    /* For all others 'ar_py_item_data' gets the data portion.		 */
    if (
	(! (ar_vmsdef_itmtbl_ptr->l_flags & ITMTBL_M_INITVOL_SYMITM)) &&
	(w_styp_sys != ITMTYP_K_BOOL)
       )
    {
      if (!PyTuple_Check(ar_py_item_tuple))
      {
	(void) PyErr_Format(PyExc_TypeError,
	  "itmlst - tuple-element:%d input-item requires (itm,data) tuple",
	  l_itmlst_idx);
	goto vms__itmlst__free1;	/* item-list + malloc()ed buffers */
      }
      /* -------------------- */
      /* get data portion of the item tuple --------------v */
      ar_py_item_data = PyTuple_GetItem(ar_py_item_tuple, 1);
      if (PyErr_Occurred())
      {
	goto vms__itmlst__free1;	/* item-list + malloc()ed buffers */
      }
    } /* !ITMTBL_M_INITVOL_SYMITM & !ITMTYP_K_BOOL */
    else
    {
      ar_py_item_data = NULL;
    }

    /* --------------------------------------------------------------------- */
    /* special support for converter-function */
/* extern int vmscvf__XXX
/* 	(PyObject		* ar_py_item	/* from Python item list  */
/* 	,unsigned long		  l_itmidx	/* index into item-list   */
/* 	,char			** ar_data	/* OpenVMS memory address */
/*	,unsigned short int	* aw_length	/* size of buffer */
/* 	); */
    if (ar_vmsdef_itmtbl_ptr->l_flags & ITMTBL_M_CVTFNC)
    {
	int		     l_cvf_status;
	char		   * ab_cvf_data;   /* address of allocated buffer */
	unsigned short int   w_length;		/* buffer size */

	/* OK = 0, ERR = -1 */
	l_cvf_status = (*ar_vmsdef_itmtbl_ptr->itmtbl_ab_cvtfnci)
		(ar_py_item_data		/* from Python item list  */
		,l_itmlst_idx			/* index into item-list   */
		,&ab_cvf_data			/* OpenVMS memory address */
		,&w_length			/* size of buffer */
		);
	if (l_cvf_status != 0)
	{
	  /* assume that: */
	  /*   - converter function did not allocate a buffer	      */
	  /*   - error message has been set within converter function */
	  goto vms__itmlst__free1;	/* item-list + malloc()ed buffers */
	}

	/* store address of allocated buffer */
	ar_itemlist_ptr->itmlst3_a_bufadr = ab_cvf_data;
	/* store address of buffer size */
	ar_itemlist_ptr->w_bufsiz = w_length;
    } /* if (ar_vmsdef_itmtbl_ptr->l_flags & ITMTBL_M_CVTFNC) */
  else
  {
    /* --------------------------------------------------------------------- */
    /* check with data type from VMSDEF and Python object	  */
    /* convert data to VMS format (e.g. Python long integer to Q) */
    /* and store in buffer */
    if (w_styp_sys == ITMTYP_K_ASCII)
    {
      /* check data type with VMSDEF */
      if (!PyString_Check(ar_py_item_data))
      {
	(void) PyErr_Format(PyExc_TypeError,
	    "itmlst - tuple-element:%d item-data is not a string (ASCII)",
	    l_itmlst_idx);
	goto vms__itmlst__free1;	/* item-list + malloc()ed buffers */
      }

      /* input item: take length from object */
      /* string length must be <= 65535 to fit into string descriptor */
      if (PyString_GET_SIZE(ar_py_item_data) > 65535)
      {
	(void) PyErr_Format(PyExc_ValueError,
	   "itmlst - tuple-element:%d string size limited to 65535 characters",
	   l_itmlst_idx);
	goto vms__itmlst__free1;	/* item-list + malloc()ed buffers */
      }
      /* store string size in VMS item-list */
      ar_itemlist_ptr->w_bufsiz = PyString_GET_SIZE(ar_py_item_data);

      /* allocate a buffer and copy string - this makes it: */
      /*  a) thread-safe				    */
      /*  b) doesn't require special handling for free()    */
      /*  c) no need to take care of Py_INCREF / Py_DECREF  */
      ar_itemlist_ptr->itmlst3_a_bufadr = malloc (ar_itemlist_ptr->w_bufsiz);
      if (ar_itemlist_ptr->itmlst3_a_bufadr == NULL)
      {
	/* free item-list + malloc()ed buffers */
	(void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	return PyErr_NoMemory();
      }

      /* copy string from Python object to item buffer */
      (void) memcpy
		(ar_itemlist_ptr->itmlst3_a_bufadr
		,PyString_AS_STRING(ar_py_item_data)
		,(size_t)ar_itemlist_ptr->w_bufsiz
		);
    } /* ITMTYP_K_ASCII */
    else
    {
      /* ------------------------------------------------------------------- */
      if (w_styp_sys == ITMTYP_K_ASCIC)
      {
	/* check data type with VMSDEF */
	if (!PyString_Check(ar_py_item_data))
	{
	  (void) PyErr_Format(PyExc_TypeError,
		"itmlst - tuple-element:%d item-data is not a string(ASCIC)",
		l_itmlst_idx);
	  goto vms__itmlst__free1;	/* item-list + malloc()ed buffers */
	}
	/* input item: take length from object		   */
	/* limit is 255, because ASCIC uses a byte counter */
	if (PyString_GET_SIZE(ar_py_item_data) > 255)
	{
	  (void) PyErr_Format(PyExc_ValueError,
     "itmlst - tuple-element:%d string size limited to 255 characters (ASCIC)",
     l_itmlst_idx);
	  goto vms__itmlst__free1;	/* item-list + malloc()ed buffers */
	}		  

	/* @@ need to specify full buffer size ! */
	/* $SETUAI doesn't accept the real string size, somehow */
	ar_itemlist_ptr->w_bufsiz = ar_vmsdef_itmtbl_ptr->w_bufsiz;

	/* allocate a buffer and copy string - this makes this part: */
	/*  a) thread-safe */
	/*  b) doesn't require special handling for free() */
	/*  c) no need to take care of Py_INCREF / Py_DECREF */
	/* +1 = space for count byte */
	ar_itemlist_ptr->itmlst3_a_bufadr = malloc(ar_itemlist_ptr->w_bufsiz +1);
	if (ar_itemlist_ptr->itmlst3_a_bufadr == NULL)
	{
	  /* free item-list + malloc()ed buffers */
	  (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	  return PyErr_NoMemory();
	}
	else /* new block just for a temporary pointer */
	{			     /*	    |	*/
	  unsigned char * ax_bufptr; /* <---/	*/

	  ax_bufptr = ar_itemlist_ptr->itmlst3_a_bufadr;

	  /* store ASCIC string length (the real length) */
	  *ax_bufptr = (unsigned char) PyString_GET_SIZE(ar_py_item_data);

	  ax_bufptr++; /* move pointer behind count byte */
	  /* copy string from object to item buffer */
	  (void) memcpy
			(ax_bufptr
			,PyString_AS_STRING(ar_py_item_data)
			,(size_t)ar_itemlist_ptr->w_bufsiz
			);
	}
      } /* ITMTYP_K_ASCIC */
      else /* item-type = BWLQO */
      {
	/* ----------------------------------------------------------------- */
	if (
	    (w_styp_sys == ITMTYP_K_BYTE) || (w_styp_sys == ITMTYP_K_WORD) ||
	    (w_styp_sys == ITMTYP_K_LONG) || (w_styp_sys == ITMTYP_K_QUAD) ||
	    (w_styp_sys == ITMTYP_K_OCTA)
	   )
	{
	  /* size of item types - in PYVMS_GLOBAL.C */
	  extern long vmsdef_gl_itmtypsiz[];

	  unsigned long	  l_datatypsiz;	/* size of single datatype item */
	  unsigned long	  l_data_count;	/* number of items */
	  char		* ab_data;	/* pointer to data elements in 1 item */

	  PyObject	* ar_py_item_array;
	  unsigned long   l_array_size;
	  unsigned long   l_array_idx;

	  /* size of data type (e.g. W = 2 bytes) of this item */
	  l_datatypsiz = (unsigned long)vmsdef_gl_itmtypsiz[w_styp_sys];

	  /* calculate # data elements */
	  l_data_count = ((unsigned long)ar_vmsdef_itmtbl_ptr->w_bufsiz) /
					 l_datatypsiz;

	  /* -------------------- */
	  /* sanity-check of VMSDEF data structure */
	  if (l_data_count < 1)
	  {
	    PyErr_SetString(PyExc_SystemError,
		"vms__itmlst_build() datatype bigger than buffer length");
	    /* free item-list + malloc()ed buffers */
	    goto vms__itmlst__free1;
	  }

	  /* -------------------- */
	  /* Check if this is an ARRAY of the data type. If yes, the memory */
	  /* to allocate must be multiplied with the tuple(array) size	    */
	  if (ar_vmsdef_itmtbl_ptr->l_flags & ITMTBL_M_ARRAY)
	  {
	    /* Python 'data' array object must be a tule */
	    if (!PyTuple_Check(ar_py_item_data))
	    {
	      (void) PyErr_Format(PyExc_TypeError,
		"itmlst - data array - data of item:%d must be a tuple",
		l_itmlst_idx);
	      /* free item-list + malloc()ed buffers */
	      goto vms__itmlst__free1;
	    }
	    l_array_size = PyTuple_Size(ar_py_item_data);
	  }
	  else
	  {
	    l_array_size = 1;	/* no data array */
	  }

	  /* -------------------- */
	  /* check if data type is BWL, passed 'by value' */
	  if (ar_vmsdef_itmtbl_ptr->l_flags & ITMTBL_M_BYVALUE)
	  {
	    if (! /* must be BWL to fit into itmlst3_l_itmval */
		(
		 (w_styp_sys == ITMTYP_K_BYTE) ||
		 (w_styp_sys == ITMTYP_K_WORD) ||
		 (w_styp_sys == ITMTYP_K_LONG)
		)
	       )
	    {
	      (void) PyErr_Format(PyExc_TypeError,
		"vms__itmlst_build(), item:%d data type for 'passed by value' is not BWL",
		l_itmlst_idx);
	      /* ----- */
	      /* free item-list + malloc()ed buffers */
	      goto vms__itmlst__free1;
	    }
	    if (l_array_size != 1)
	    {
	      (void) PyErr_Format(PyExc_TypeError,
		"vms__itmlst_build(), item:%d array not allowed for 'passed by value'",
		l_itmlst_idx);
	      /* ----- */
	      /* free item-list + malloc()ed buffers */
	      goto vms__itmlst__free1;
	    }
	    /* data is directly stored in the item list */
	    ab_data = (char *)&ar_itemlist_ptr->itmlst3_a_bufadr; /* by value */

	    /* additional indicator for 'passed by value' */
	    ar_itemlist_ptr->w_bufsiz = 0;
	  }
	  else
	  {
	    /* store buffer size in VMS item-list */
	    ar_itemlist_ptr->w_bufsiz = ar_vmsdef_itmtbl_ptr->w_bufsiz *
					l_array_size;

	    /* allocate memory for buffer */
	    l_malloc_bytes = (unsigned long)ar_itemlist_ptr->w_bufsiz;

	    /* for BWL an L-buffer is always allocated */
	    l_malloc_bytes = (l_malloc_bytes < 4) ? 4 : l_malloc_bytes;
	    ab_data = malloc (l_malloc_bytes);
	    if (ab_data == NULL)
	    {
	      /* free item-list + malloc()ed buffers */
	      (void) vms__itmlst_free (ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	      return PyErr_NoMemory();
	    }

	    /* store address of buffer in VMS item-list */
	    ar_itemlist_ptr->itmlst3_a_bufadr = ab_data;
	    /* set contents of buffer to 0 */
	    (void) memset (ar_itemlist_ptr->itmlst3_a_bufadr, 0, l_malloc_bytes);
	  } /* else - ITMTBL_M_BYVALUE */

	  /* loop over all array elements (or item-data directly) */
	  ar_py_item_array = ar_py_item_data;

	  for (l_array_idx = 0; l_array_idx < l_array_size; l_array_idx++)
	  {
	    /* if this is an array */
	    if (ar_vmsdef_itmtbl_ptr->l_flags & ITMTBL_M_ARRAY)
	    {
	      ar_py_item_data = PyTuple_GetItem(ar_py_item_array, l_array_idx);
	      if (ar_py_item_data == NULL)
	      {
		/* free item-list + malloc()ed buffers */
		goto vms__itmlst__free1;
	      }
	    }

	    /* if input item has multiple data-elements - a tuple is passed */
	    if (l_data_count > 1)
	    {
	      /* Python 'data' object must be a tule */
	      if (!PyTuple_Check(ar_py_item_data))
	      {
		(void) PyErr_Format(PyExc_TypeError,
		    "itmlst - data of item:%d must be a tuple", l_itmlst_idx);
		/* free item-list + malloc()ed buffers */
		goto vms__itmlst__free1;
	      }
	    }
	    /* -------------------- */
	    l_status = vms__cvt_py2bin
		(ar_py_item_data		 /* Python data  */
		,ab_data			 /* data address */
		,ar_vmsdef_itmtbl_ptr->w_typ_sys /* data type (incl. sign-bit) */
		,ar_vmsdef_itmtbl_ptr->w_bufsiz	 /* data length  */
		);
	    if (l_status != 1)
	    {
	      /* free item-list + malloc()ed buffers */
	      goto vms__itmlst__free1;	/* error message has been set */
	    }

	    /* storage address for next array element */
	    ab_data += ar_vmsdef_itmtbl_ptr->w_bufsiz;
	  } /* for (l_array_idx = 0; l_array_idx < l_array_size; ... */
	  /* -------------------- */
	} /* datatype = BWLQO */
	else
	{
	  /* --------------------------------------------------------------- */
	  if (w_styp_sys == ITMTYP_K_BOOL)
	  {
	    /* a boolean item only uses the item code */
	    ar_itemlist_ptr->w_bufsiz              = 0;
	    ar_itemlist_ptr->itmlst3_a_bufadr      = 0;
	    ar_itemlist_ptr->itmlst3_aw_retlenaddr = 0;
	  }
	  else
	  {
	    (void) PyErr_Format(PyExc_SystemError,
		"vms__itmlst_build(): item:%d - unsupported data type",
		l_itmlst_idx);
	    /* free item-list + malloc()ed buffers */
	    goto vms__itmlst__free1;
	  } /* else- itmtyp == ITMTYP_K_BOOL */
	} /* else- datatype = BWLQO */
      } /* else- itmtyp == ITMTYP_K_ASCIC */
    } /* else- itmtyp == ITMTYP_K_ASCII */
    /* ---------------------------------------- */
  } /* else- (ar_vmsdef_itmtbl_ptr->l_flags & ITMTBL_M_CVTFNC) */
    /* ---------------------------------------- */
  } /* (ar_vmsdef_itmtbl_ptr->l_flags & l_inpitm_msk) */
  /* @@  /* !!! no ELSE here !!! -- need to check for both itm types !!! */
  /* **NEW:** XABITM I/O uses both - input+ output item */
  /* don't allocate on output item if input was specified, too */
  else
  {
    /* --------------------------------------------------------------------- */
    /* process (=allocate storage for) output items */
    if (ar_vmsdef_itmtbl_ptr->l_flags & l_outitm_msk)
    {
      /* allocate buffer space as defined by VMSDEF */
      ar_itemlist_ptr->itmlst3_a_bufadr =
				malloc (ar_vmsdef_itmtbl_ptr->w_bufsiz);
      if (ar_itemlist_ptr->itmlst3_a_bufadr == NULL)
      {
	/* free item-list + malloc()ed buffers */
	(void) vms__itmlst_free (ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	return PyErr_NoMemory();
      }

      /* Clear buffer, even for output items. XABITM has input/output items   */
      /* depending on xab$b_mode and the item-list can be retrieved any time. */
      /* By clearing the buffer no stale memory information is made available */
      (void) memset (ar_itemlist_ptr->itmlst3_a_bufadr, 0,
					ar_vmsdef_itmtbl_ptr->w_bufsiz);
      /* set buffer size */
      ar_itemlist_ptr->w_bufsiz = ar_vmsdef_itmtbl_ptr->w_bufsiz;

      /* ------------------------------------------------------------------- */
      /* some routines like SYS$GETQUIW + SYS$SNDJBCW do not set the */
      /* returned length address for some output item codes.         */
      if (ar_vmsdef_itmtbl_ptr->l_flags & ITMTBL_M_SETRETLEN)
      {
	*aw_retlenlist_ptr = ar_vmsdef_itmtbl_ptr->w_bufsiz;
      }

      /* ---------------------------------------- */
      /* put returned length address into item-list */
      /* provide storage for returned length */
      ar_itemlist_ptr->itmlst3_aw_retlenaddr = aw_retlenlist_ptr;

    } /* (ar_vmsdef_itmtbl_ptr->l_flags & l_outitm_msk) */
  } /* else - (ar_vmsdef_itmtbl_ptr->l_flags & l_inpitm_msk) */

  /* -------------------- */
  ar_itemlist_ptr++;		/* next address of itemlist element  */
  ar_itm_vmsdef_ptr++;		/* next pointer into VMSDEF	     */
  aw_retlenlist_ptr++;		/* next addr. of returned length buf.*/

} /* for (l_itmlst_idx = 0; l_itmlst_idx < l_itmlst_size; .. */

	/* terminate VMS item-list */
	ar_itemlist_ptr->w_itmcod = 0;
	ar_itemlist_ptr->w_bufsiz = 0;
	/* Note: the other pointers don't need termination	   */
	/* Warning: there is no storage allocated for termination! */

	/* setup return parameters */
	*aar_itemlist   = ar_itemlist;
	*aar_itm_vmsdef = ar_itm_vmsdef;
	*aaw_retlenlist = aw_retlenlist;

	return ar_py_item_list; /* success - return a non-NULL value */
    /* -------------------- */

vms__itmlst__free1:
	/* free item-list + malloc()ed buffers */
	(void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	return NULL;

} /* vms__itmlst_build () */

/* ------------------------------------------------------------------------- */
/* vms__itmlst_outprc() 22-NOV-1998 Uwe Zessin
  - process output items

   28-DEC-1998 ZE. -- support for signed/unsigned datatypes (in ->w_typ_sys)
   18-FEB-1999 ZE. -- remove never used argument to vms__itmlst_outprc().
		      All calling routines changed, too, of course.
   03-APR-1999 ZE. -- add converter-function support for vms__itmlst_outprc()
   30-JUN-1999 ZE. -- more arguments to output-item converter function
*/

PyObject * vms__itmlst_outprc
	(long			      l_outitm_msk	/* output-item bit   */
	,struct vmsdef_xr_itmtbl  *   ar_vmsdef_itmtbl	/* VMSDEF_GR_$xxxDEF */
	,struct vmsdef_xr_itmlst3 * * aar_itemlist
	,struct vmsdef_xr_itmtbl  *** aar_itm_vmsdef
	,unsigned short int       * * aaw_retlenlist
	,PyObject		  *   ar_dict	/* is modified! */
	)
{
	/* VMS item-list to be passed to system routine */
	struct vmsdef_xr_itmlst3 * ar_itemlist;		/* start address */
	struct vmsdef_xr_itmlst3 * ar_itemlist_ptr;	/* walk along    */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_retlenlist;	/* start address */
	unsigned short int	 * aw_retlenlist_ptr;	/* walk along	 */

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for item processing */
	struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef;	/* start address */
	struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef_ptr;	/* walk along    */
	unsigned short int	  w_styp_sys; /* ITMTYP_M_USIGN masked off */

	PyObject		* ar_tuple;
	PyObject		* ar_intobj;
	PyObject		* ar_dictobj;
	unsigned long		  l_status;

	/* -------------------- */
	ar_itemlist   = *aar_itemlist;
	ar_itm_vmsdef = *aar_itm_vmsdef;
	aw_retlenlist = *aaw_retlenlist;

	/* re-position pointers to begin of each list */
	ar_itemlist_ptr   = ar_itemlist;	/* VMS item-list	  */
	ar_itm_vmsdef_ptr = ar_itm_vmsdef;	/* ptr to item's VMSDEF   */
	aw_retlenlist_ptr = aw_retlenlist;	/* ptr to returned length */

	/* -------------------- */
  /* loop over item-list and return any output items */
  /* Warning: for boolean items W_BUFSIZ == 0 ! */
  while ((ar_itemlist_ptr->w_itmcod != 0) ||
	 (ar_itemlist_ptr->w_bufsiz != 0)   )
  {
    /* printf("itm=%s\n", (*ar_itm_vmsdef_ptr)->at_itmnam_py ); */

    /* if this is an output-item ... */
    if ((*ar_itm_vmsdef_ptr)->l_flags & l_outitm_msk) /* use argument */
    {
      /* special support for converter-function */
      if ((*ar_itm_vmsdef_ptr)->l_flags & ITMTBL_M_CVTFNC)
      {
	/* 30-JUN-1999 ZE. -- more arguments to converter function */
	ar_dictobj = ((*ar_itm_vmsdef_ptr)->itmtbl_ab_cvtfnco)
		(ar_itemlist_ptr		/* itemlist entry  */
		,ar_itm_vmsdef_ptr		/* VMSDEF entry    */
		,aw_retlenlist_ptr		/* returned length */
		);
	if (ar_dictobj == NULL)
	{
	  /* free item-list + malloc()ed buffers */
	  (void) vms__itmlst_free (ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	  Py_DECREF(ar_dict);
	  return NULL;
	}
      } /* if (ar_vmsdef_itmtbl_ptr->l_flags & ITMTBL_M_CVTFNC) */
      else
      {
       /* put it into the dictionary */

      /* data type - mask off the (un)signed bit */
      w_styp_sys = ((*ar_itm_vmsdef_ptr)->w_typ_sys) & (~ITMTYP_M_USIGN);

      if (w_styp_sys == ITMTYP_K_ASCII)
      {
	/* it's a string */
	ar_dictobj = Py_BuildValue ("s#",
			ar_itemlist_ptr->itmlst3_a_bufadr,	/* data */
			(unsigned int)*aw_retlenlist_ptr);	/* size */
	if (ar_dictobj == NULL)
	{
	  /* free item-list + malloc()ed buffers */
	  (void) vms__itmlst_free (ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	  Py_DECREF(ar_dict);
	  return NULL;
	}
      } /* w_styp_sys == ITMTYP_K_ASCII */
      else
      {
	if (w_styp_sys == ITMTYP_K_ASCIC)
	{
	  /* it's a counted string - 1st byte = count */
	  char		* at_bufadr;
	  unsigned char * ab_bufsiz;
	  unsigned long   l_bufsiz;

	  at_bufadr = ar_itemlist_ptr->itmlst3_a_bufadr;
	  at_bufadr++;			/* skip count byte */

	  ab_bufsiz = ar_itemlist_ptr->itmlst3_a_bufadr; /* count byte */
	  l_bufsiz = (unsigned char)*ab_bufsiz;

	  ar_dictobj = Py_BuildValue ("s#", at_bufadr, l_bufsiz);
	  if (ar_dictobj == NULL)
	  {
	    /* free item-list + malloc()ed buffers */
	    (void) vms__itmlst_free (ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    Py_DECREF(ar_dict);
	    return NULL;
	  }
	} /* (w_styp_sys == ITMTYP_K_ASCIC) */
	else
	{
	    /* can be BWLQO or tuple(BWLQO) */

	    /* return resultant-value (integer / boolean) */
	    /*  (argument 2: need sign bit, too) */
	    ar_dictobj = vms__cvt_bin2py
		((char*)ar_itemlist_ptr->itmlst3_a_bufadr /* data address */
		,(*ar_itm_vmsdef_ptr)->w_typ_sys	  /* data type	  */
		,(unsigned int)*aw_retlenlist_ptr	  /* data length  */
		);
	    if (ar_dictobj == NULL)
	    {
	      /* error message has already been set up */
	      /* free item-list + malloc()ed buffers */
	      (void) vms__itmlst_free (ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	      Py_DECREF(ar_dict);
	      return NULL;
	    }
	    /* -------------------- */
	} /* else- (w_styp_sys == ITMTYP_K_ASCIC) */
      } /* else- (w_styp_sys == ITMTYP_K_ASCII) */
      } /* else- if (ar_vmsdef_itmtbl_ptr->l_flags & ITMTBL_M_CVTFNC) */

      if (ar_dictobj == NULL)
      {
/* printf ("@@ar_dictobj = NULL, itm=%d\n", ar_itemlist_ptr->w_itmcod); */
	/* free item-list + malloc()ed buffers */
	(void) vms__itmlst_free (ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	Py_DECREF(ar_dict);
	return NULL;
      }

      /* store item-name ('fac$_itm') + data into dictionary */
      if (PyDict_SetItemString
	  (ar_dict, (*ar_itm_vmsdef_ptr)->at_itmnam_py, ar_dictobj) < 0)
      {
	/* free item-list + malloc()ed buffers */
	(void) vms__itmlst_free (ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	Py_DECREF(ar_dictobj); /* can be == ar_tuple */
	Py_DECREF(ar_dict);
	return NULL;
      }
      Py_DECREF(ar_dictobj);
    } /* ((*ar_itm_vmsdef_ptr)->l_flags & l_outitm_msk) */
    /* else -- @@ ignore any input-items in item-list */

    ar_itemlist_ptr++;		    /* next item */
    ar_itm_vmsdef_ptr++;
    aw_retlenlist_ptr++;
  } /* while (ar_itemlist_ptr->w_itmcod + ->w_bufsiz != 0) */

	return ar_dict;
} /* vms__itmlst_outprc() */

/* ------------------------------------------------------------------------- */

/* EOF: VMS__ITMLST_ROUTINES.C */
