#ifndef _VMS__ITMLST_ROUTINES_H_
#define _VMS__ITMLST_ROUTINES_H_

/* VMS__ITMLST_ROUTINES.H -- 19-JUL-1999 Uwe Zessin
   Move external definitions for VMS__ITMLST_ROUTINES.C into this file.
*/

/* ------------------------------------------------------------------------- */

/* free any malloc()ed buffers for items pointed by item-list,  */
/* -  the item-list itself,					*/
/* -  the back-pointer array into VMSDEF structure,		*/
/* -  the returned-length array					*/

extern void vms__itmlst_free
	(struct vmsdef_xr_itmlst3  * ar_itemlist
	,struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef
	,unsigned short int        * aw_retlenlist );

/* ---------------------------------------- */
/* - allocate item-list						*/
/* - build input- / output-items				*/

extern PyObject * vms__itmlst_build
	(long			      l_inpitm_msk	/* input-item bit  */
	,long			      l_outitm_msk	/* output-item bit */
	,struct vmsdef_xr_itmtbl (*ara_vmsdef_itmtbl)[] /* VMSDEF_GR_$xxxDEF */
	,PyObject		  *   ar_py_item_list	/* Python itmlst obj */
	,struct vmsdef_xr_itmlst3 * * aar_itemlist
	,struct vmsdef_xr_itmtbl  *** aar_itm_vmsdef
	,unsigned short int       * * aaw_retlenlist
	);

/* ---------------------------------------- */
/* vms__itmlst_outprc()						*/
/* - process output-items					*/

extern PyObject * vms__itmlst_outprc
	(long			      l_outitm_msk	/* output-item bit */
	,struct vmsdef_xr_itmtbl  (*ara_vmsdef_itmtbl)[] /* VMSDEF_GR_$xxxDEF */
	,struct vmsdef_xr_itmlst3 * * aar_itemlist
	,struct vmsdef_xr_itmtbl  *** aar_itm_vmsdef
	,unsigned short int       * * aaw_retlenlist
	,PyObject		  *   ar_dict	/* is modified! */
	);

/* ------------------------------------------------------------------------- */

#endif /* _VMS__ITMLST_ROUTINES_H_ */

/* EOF: VMS__ITMLST_ROUTINES.H */
