/* VMS__RMDIR.C -- 13-AUG-1997 Uwe Zessin */

/* rmdir() emulation for the DCL environment -- POSIXMODULE + VMSMODULE */

#include <errno.h>
#include <stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int vms__rmdir (/*const*/ char *path)
{
char*	    at_vms_path;
long	    l_status;
long	    l_save_errno;
struct stat r_st;

at_vms_path = malloc (strlen(path) + 12); /* "/000000" + ".dir\0" */
if (at_vms_path == NULL)
{
    /* errno = ENOMEM; set by malloc(), not what rmdir() usually returns ... */
    return -1;
}
(void)strcpy (at_vms_path,path);

/* VMS_POSIX tests first _WITH_ '.DIR' !! */
(void)strcat (at_vms_path,".dir");

/* stat() the file to make sure this is really a directory */
l_status = stat (at_vms_path, &r_st);
if (l_status == 0)
{
    if (r_st.st_mode & S_IFDIR) /* directory file */
    {
	/* printf ("vms__rmdir().1: S_IFDIR\n"); */
	l_status = remove (at_vms_path);
	l_save_errno = errno; /* free() should not clobber errno, but... */
	(void)free (at_vms_path);
	errno = l_save_errno;
	return l_status;
    }
    else
    {
	if (r_st.st_mode & S_IFREG) /* 'regular file' */
	{
	    /* printf ("vms__rmdir().1: S_IFREG\n\n"); */
	    (void)free (at_vms_path);

	    errno = ENOTDIR; /* 'Not a directory' */
	    return -1;
	}
    }
}

/* now check also without explicitly appending a '.DIR' */
/* it might be part of the file name */
/* VMS_POSIX does it in this order */

/* stat() the file to make sure this is really a directory */
l_status = stat (path, &r_st);
if (l_status == 0)
{
    if (r_st.st_mode & S_IFDIR) /* directory file */
    {
	/* printf ("vms__rmdir().2: S_IFDIR\n"); */
	l_status = remove (path);
	l_save_errno = errno; /* free() should not clobber errno, but... */
	(void)free (at_vms_path);
	errno = l_save_errno;
	return l_status;
    }
    else
    {
	if (r_st.st_mode & S_IFREG) /* 'regular file' */
	{
	    /* printf ("vms__rmdir().2: S_IFREG\n\n"); */
	    (void)free (at_vms_path);

	    errno = ENOTDIR; /* 'Not a directory' */
	    return -1;
	}
    }
}

/* now try something like /x/y -> /x/000000/y.DIR */

if (path[0] == '/')
{
    char* at_pp;
    char* at_pv;

    at_pp = path;
    at_pv = at_vms_path;
    *at_pv = *at_pp;	/* copy '/' */
    at_pp++; at_pv++;
    while ((*at_pp != '/') && (*at_pp != '\0'))
    {
	*at_pv = *at_pp;
	at_pv++; at_pp++;
    }
/* *at_pv = '\0'; printf ("0=%s\n", at_vms_path); */

    /* continue only if not end of string reached - */
    /* otherwise the path is /XXX		    */
    if (*at_pp != '\0')
    {
	/* copy /000000 */
	*at_pv++ = '/';
	*at_pv++ = '0';
	*at_pv++ = '0';
	*at_pv++ = '0';
	*at_pv++ = '0';
	*at_pv++ = '0';
	*at_pv++ = '0';

	/* copy rest of string */
	while (*at_pp != '\0')
	{
	    *at_pv = *at_pp;
	    at_pv++; at_pp++;
	}
	/* save pointer to this location */
	at_pp = at_pv;

	*at_pv = '\0';

	/* VMS_POSIX tests first _WITH_ '.DIR' !! */
	/* printf ("1=%s\n", at_vms_path); */
	(void)strcat (at_pv, ".DIR");
	/* printf ("2=%s\n\n", at_vms_path); */

	/* stat() the file to make sure this is really a directory */
	l_status = stat (at_vms_path, &r_st);
	if (l_status == 0)
	{
	    if (r_st.st_mode & S_IFDIR) /* directory file */
	    {
		/* printf ("vms__rmdir().3: S_IFDIR\n"); */
		l_status = remove (at_vms_path);
		l_save_errno = errno; /* free() should not clobber errno, but... */
		(void)free (at_vms_path);
		errno = l_save_errno;
		return l_status;
	    }
	    else
	    {
		if (r_st.st_mode & S_IFREG) /* 'regular file' */
		{
		    /* printf ("vms__rmdir().4: S_IFREG\n\n"); */
		    (void)free (at_vms_path);

		    errno = ENOTDIR; /* 'Not a directory' */
		    return -1;
		}
	    }
	}

	/* 'remove' .DIR */
	*at_pv = '\0';

	/* now check also without explicitly appending a '.DIR' */
	/* it might be part of the file name */
	/* VMS_POSIX does it in this order */

	/* printf ("9=%s\n", at_vms_path); */

	/* stat() the file to make sure this is really a directory */
	l_status = stat (at_vms_path, &r_st);
	if (l_status == 0)
	{
	    if (r_st.st_mode & S_IFDIR) /* directory file */
	    {
		/* printf ("vms__rmdir().5: S_IFDIR\n"); */
		l_status = remove (at_vms_path);
		l_save_errno = errno; /* free() should not clobber errno, but... */
		(void)free (at_vms_path);
		errno = l_save_errno;
		return l_status;
	    }
	    else
	    {
		if (r_st.st_mode & S_IFREG) /* 'regular file' */
		{
		    /* printf ("vms__rmdir().6: S_IFREG\n\n"); */
		    (void)free (at_vms_path);

		    errno = ENOTDIR; /* 'Not a directory' */
		    return -1;
		}
	    }
	}
	/* else - just fall through to ENOENT */
    }
    /* else - just fall through to ENOENT */
} /* if (path[0] == '/') */

/* no more tries, assume file does not exist */

(void)free (at_vms_path);
errno = ENOENT; /* No such file or directory */
return -1;
}

/* EOF: VMS__RMDIR.C */
