/* VMS__TIMES.C -- 30-AUG-1997 Uwe Zessin
   Emulate POSIX version of times() which returns a value.
   Old implementations of the DEC C RTL don't return anything.

   21-DEC-1997 ZE. -- Newer Versions of the C-RTL have a slightly different
			implementation of times(). DEC C V5.6 which has the
			new headers complains. Just prevent a compiler warning.
*/

#include <errno.h>
#include <lib$routines>
#include <ssdef.h>
#include <starlet.h>
#include <syidef.h>
#include <time.h>

/* ---------------------------------------- */

/* Note:
|  #if __CRTL_VER >= 70000000 && !defined _DECC_V4_SOURCE
|  clock_t times(struct tms *buffer);
|  #else
|  void    times(tbuffer *buffer); {in 'sys/times.h'}
|  #endif
|  |
|  |----------------v just ignore mismatch */
clock_t vms__times (void* ar_buffer)
{
    unsigned long l_status;		    /* VMS condition value */
    unsigned long l_itmcod = SYI$_BOOTTIME; /* item code: boot date+time (64bit)*/
    static unsigned int q_bootime[2];	/* system boot date + time */
    static unsigned int q_curtime[2];	/* current     date + time */
    static unsigned int q_deltime[2];	/* delta time (cur - lgi)  */
    unsigned long l_arraylength = 2;	/* -> lib$subx() */

    clock_t l_times;		/* return (clock_t)tick in 10 milliseconds */
    long l_divisor = 100000L;	/* VMS bintim tick is 100ns (nano-second) */
				/* 10 milliseconds = 100000 * 100ns */
    long l_remainder;		/* lib$ediv() */

/* 1. standard times() call */
    (void) times(ar_buffer);

/* 2. return value for VMS_POSIX compatibility */
    /* get boot time of the system (like VMS_POSIX) */
    l_status = lib$getsyi
			(&l_itmcod	/* item-code            */
			,&q_bootime[0]	/* [,resultant-value]   */
			,0		/* [,resultant-string]  */
			,0		/* [,resultant-length]  */
			,0		/* [,cluster-system-id] */
			,0		/* [,node-name]         */
			);

    if (l_status != SS$_NORMAL)
    {
	errno = EFAULT; /* compatible with VMS_POSIX */
	return -1;
    }

    /* get current date + time */
    l_status = sys$gettim (&q_curtime[0]);
    if (l_status != SS$_NORMAL)
    {
	errno = EFAULT; /* compatible with VMS_POSIX */
	return -1;
    }

    /* calculate difference (result is in 100nanosecond ticks) */
    /* VMS delta times are internally represented by a negative value */
    /* just swap boot + current time to get positive number of ticks  */
    /* Note: if current time is set before boot time the result will  */
    /*  be negative! */
    /* This doesn't happen under VMS_POSIX. @@ more research is needed */
    l_status = lib$subx
		(&q_curtime[0]	/* minuend-array    */
		,&q_bootime[0]	/* subtrahend-array */
		,&q_deltime[0]	/* difference-array */
		,&l_arraylength	/* [,array-length]  */
		);
    if ((l_status != SS$_NORMAL) && (l_status != SS$_INTOVF))
    {
	errno = EFAULT; /* compatible with VMS_POSIX */
	return -1;
    }

    /* translate from 100nanosecond into 10millisecond ticks */
    /* ignore condition value SS$_INTOVF */
    l_status = lib$ediv
	(&l_divisor	/* longword-integer-divisor  */
	,&q_deltime[0]	/* quadword-integer-dividend */
	,&l_times	/* longword-integer-quotient */
	,&l_remainder	/* remainder                 */
	);

    /* -1 means error which didn't happen */
    if (l_times == (clock_t) -1)
    {
	l_times = 1;
    }
    return (l_times);

} /* vms__times() */

/* ------------------------------------------------------------------------- */

/* EOF: VMS__TIMES.C */
