/* VMS__UTIME.C -- 21-AUG-1997 Uwe Zessin */
/* 25-AUG-1997 -- Uwe Zessin -- changes for Alpha */

/* utime() emulation for the DCL environment -- POSIXMODULE + VMSMODULE */

#include <atrdef.h>
#include <descrip.h>
#include <errno.h>
#include <fab.h>
#include <fibdef.h>
#include <iodef.h>
#include <rms.h>
#include <rmsdef.h>
#include <ssdef.h>
#include <starlet.h>
#include <stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unixlib.h>	/* shell$to_vms / decc$to_vms */
#ifdef __DECC
#ifndef shell$to_vms	/* DECC on Alpha does redefine this already */
#define shell$to_vms(_p1_,_p2_,_p3_,_p4_) decc$to_vms(_p1_,_p2_,_p3_,_p4_)
#endif
#endif
#include "vms__utime.h"	/* non-standard */

long vms__set_utime (char *at_vms_path, struct utimbuf *ar_times);

long vms__utime (char *path, struct utimbuf *ar_times)
{
char*	    at_vms_path;
long	    l_status;
long	    l_save_errno;
struct stat r_st;

at_vms_path = malloc (strlen(path) + 12); /* "/000000" + ".dir\0" */
if (at_vms_path == NULL)
{
    /* errno = ENOMEM; set by malloc(), not what utime() usually returns ... */
    return -1;
}
(void)strcpy (at_vms_path, path);

/* VMS_POSIX tests first _WITH_ '.DIR' !! */
(void)strcat (at_vms_path,".dir");

/* stat() the file to make sure it exists */
/* Note: stat() does not change the expiration date - good! */
l_status = stat (at_vms_path, &r_st);
if (l_status == 0)
{
    /* printf ("@1:%s\n", at_vms_path); */
    l_status = vms__set_utime (at_vms_path,ar_times);
    l_save_errno = errno; /* free() should not clobber errno, but... */
    (void)free (at_vms_path);
    errno = l_save_errno;
    return l_status;
}

/* now check also without explicitly appending a '.DIR' */
/* it might be part of the file name */
/* VMS_POSIX does it in this order */

/* stat() the file to make sure it exists */
l_status = stat (path, &r_st);
if (l_status == 0)
{
    /* printf ("@2:%s\n", at_vms_path); */
    l_status = vms__set_utime (path,ar_times);
    l_save_errno = errno; /* free() should not clobber errno, but... */
    (void)free (at_vms_path);
    errno = l_save_errno;
    return l_status;
}

/* now try something like /x/y -> /x/000000/y.DIR */
if (path[0] == '/')
{
    char* at_pp;
    char* at_pv;

    at_pp = path;
    at_pv = at_vms_path;
    *at_pv = *at_pp;	/* copy '/' */
    at_pp++; at_pv++;
    while ((*at_pp != '/') && (*at_pp != '\0'))
    {
	*at_pv = *at_pp;
	at_pv++; at_pp++;
    }
/* *at_pv = '\0'; printf ("0=%s\n", at_vms_path); */

    /* continue only if not end of string reached - */
    /* otherwise the path is /XXX		    */
    if (*at_pp != '\0')
    {
	/* copy /000000 */
	*at_pv++ = '/';
	*at_pv++ = '0';
	*at_pv++ = '0';
	*at_pv++ = '0';
	*at_pv++ = '0';
	*at_pv++ = '0';
	*at_pv++ = '0';

	/* copy rest of string */
	while (*at_pp != '\0')
	{
	    *at_pv = *at_pp;
	    at_pv++; at_pp++;
	}
	/* save pointer to this location */
	at_pp = at_pv;

	*at_pv = '\0';

	/* VMS_POSIX tests first _WITH_ '.DIR' !! */
	/* printf ("1=%s\n", at_vms_path); */
	(void)strcat (at_pv, ".DIR");
	/* printf ("2=%s\n\n", at_vms_path); */

	/* stat() the file to make sure it exists */
	l_status = stat (at_vms_path, &r_st);
	if (l_status == 0)
	{
	    l_status = vms__set_utime (at_vms_path,ar_times);
	    l_save_errno = errno; /* free() should not clobber errno, but... */
	    (void)free (at_vms_path);
	    errno = l_save_errno;
	    return l_status;
	}

	/* 'remove' .DIR */
	*at_pv = '\0';

	/* now check also without explicitly appending a '.DIR' */
	/* it might be part of the file name */
	/* VMS_POSIX does it in this order */

	/* printf ("9=%s\n", at_vms_path); */

	/* stat() the file to make sure it exists */
	l_status = stat (at_vms_path, &r_st);
	if (l_status == 0)
	{
	    l_status = vms__set_utime (at_vms_path,ar_times);
	    l_save_errno = errno; /* free() should not clobber errno, but... */
	    (void)free (at_vms_path);
	    errno = l_save_errno;
	    return l_status;
	}
	/* else - just fall through to ENOENT */
    }
    /* else - just fall through to ENOENT */
} /* if (path[0] == '/') */

/* no more tries, assume file does not exist */

(void)free (at_vms_path);
errno = ENOENT; /* No such file or directory */
return -1;
}

/* ------------------------------------------------------------------------- */

static char vms__gt_utime_file[255];

static int vms__utime_action (char *s, int type)
/* type: 0 = DECC$K_FOREIGN   - file is on a remote system not running VMS */
/*       1 = DECC$K_DIRECTORY - file is a directory */
/*       2 = DECC$K_FILE      - translation is a file */
{
    (void)strcpy (vms__gt_utime_file, s);
    return 0; /* 0 = end translation - wildcards aren't allowed anyway */
}

/* ---------------------------------------- */

/* in VMS__CVT.C */
void vms__cvt_u2v_time (time_t al_unixtime, unsigned long *aq_vmstime);


long vms__set_utime (char *at_vms_path, struct utimbuf *ar_times)
{
    int  l_count;		/* l_count=(decc/shell)$to_vms(...) */
    long l_status;		/* VMS condition value */

    static struct FAB    r_fab;	/* file access block */
    static struct NAM    r_nam;	/* name access blovk */
    static struct fibdef r_fib;	/* file information block */
 
    /* descriptor for FIB - needed by SYS$QIOW */
    static struct dsc$descriptor r_fib_dsc =
	{sizeof(r_fib), DSC$K_DTYPE_Z, DSC$K_CLASS_S, (void *)&r_fib};

    /* descriptor for device name - needed by SYS$ASSIGN */
    static struct dsc$descriptor_s r_dev_dsc =
	{0, DSC$K_DTYPE_T, DSC$K_CLASS_S, &r_nam.nam$t_dvi[1]};

    static char t_esa[NAM$C_MAXRSS];
    static char t_rsa[NAM$C_MAXRSS];

    /* descriptor for VMS file name - needed by SYS$QIO(IO$_ACCESS) */
    static struct dsc$descriptor_s r_filnam_dsc =
	{0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};

    static short int w_chan;		/* I/O channel for disk SYS$QIOW */
    static short int r_iosb[4];		/* I/O status block for SYS$QIOW */

    static unsigned long q_modtime[2];	/* (utimbuf.actime is ignored) */

    /* attribute control list */
    static struct atrdef r_atr[] =
    {
	{sizeof(q_modtime),ATR$C_REVDATE,0},	/* revision date + time */
     /* {sizeof(q_modtime),ATR$C_CREDATE,0}, */	/* creation date + time */
	{0,0,0}					/* terminate list */
    };

    /* ---------------------------------------- */
    /* translate filename from Unix to VMS format */
    l_count = shell$to_vms
	(at_vms_path		/* unix-like file specification */
	,vms__utime_action	/* action routine */
	,0			/* 1 = allow_wild */
	,1			/* prevent expansion of the string */
	);			/*  as a dirctory name */
    if (l_count == 1)
    {
	/* printf("vms__set_utime(1)<-=%s\n", at_vms_path); */
	/* printf("vms__set_utime()->=%s\n", vms__gt_utime_file); */
    }
    else
  {
    l_count = shell$to_vms
	(at_vms_path		/* unix-like file specification */
	,vms__utime_action	/* action routine */
	,0			/* 1 = allow_wild */
	,0			/* prevent expansion of the string */
	);			/*  as a dirctory name */
    if (l_count == 1)
    {
	/* printf("vms__set_utime(0)<-=%s\n", at_vms_path); */
	/* printf("vms__set_utime()->=%s\n", vms__gt_utime_file); */
    }
    else
    {
	/* I have no idea what can be wrong here */
	errno = ENOENT; /* No such file or directory */
	return -1;
    }
  }

    /* ---------------------------------------- */

    /* convert date from Unix time_t to VMS 64-bit bintim */
    if (ar_times == NULL)
    {
	/* rdt = current-date-and-time */
	l_status = sys$gettim (&q_modtime[0]);
    }
    else
    {
	/* rdt = ar_times->modtime */
	(void) vms__cvt_u2v_time (ar_times->modtime, &q_modtime[0]);
    }

    /* ---------------------------------------- */

    /* initialize RMS structures */
    r_fab = cc$rms_fab;
    r_fab.fab$l_fna = at_vms_path;		/* name of file */
    r_fab.fab$b_fns = strlen (at_vms_path);	/* <= 255 ! */
    r_fab.fab$l_nam = &r_nam;			/* attach NAM block */

    r_nam = cc$rms_nam;
    r_nam.nam$l_esa = t_esa;			/* expanded filename */
    r_nam.nam$b_ess = sizeof(t_esa);
    r_nam.nam$l_rsa = t_rsa;			/* resultant filename */
    r_nam.nam$b_rss = sizeof(t_rsa);
 
    /* ---------------------------------------- */

    /* do SYS$PARSE to fill in NAM block */
    l_status = sys$parse (&r_fab);
    if (l_status != RMS$_NORMAL) goto vms__utime_error;

    /* 'fix' descriptor for device name for SYS$ASSIGN() */
    r_dev_dsc.dsc$w_length = r_nam.nam$t_dvi[0]; /* ASCIC */
 
    /* assign channel to the disk */
    l_status = sys$assign (&r_dev_dsc, &w_chan, 0, 0);
    if (l_status != SS$_NORMAL) goto vms__utime_error;
 
    /* set up descriptor for filename for SYS$QIO */
    r_filnam_dsc.dsc$a_pointer = r_nam.nam$l_name;
    r_filnam_dsc.dsc$w_length  = r_nam.nam$b_name +
				 r_nam.nam$b_type +
				 r_nam.nam$b_ver;
 
    /* fill in the FIB */
    r_fib.fib$w_fid[0] = r_nam.nam$w_fid[0];
    r_fib.fib$w_fid[1] = r_nam.nam$w_fid[1];
    r_fib.fib$w_fid[2] = r_nam.nam$w_fid[2];
    r_fib.fib$w_did[0] = r_nam.nam$w_did[0];
    r_fib.fib$w_did[1] = r_nam.nam$w_did[1];
    r_fib.fib$w_did[2] = r_nam.nam$w_did[2];
    /* prevent expiration date from being modified */
    r_fib.fib$l_acctl = FIB$M_NORECORD;
 
    /* put address of 64-bit binary time into atr */
#ifdef __ALPHA /* just prevent a compiler warning */
    r_atr[0].atr$l_addr = &q_modtime[0];
#else
    r_atr[0].atr$l_addr = (unsigned int) &q_modtime[0];
#endif

    /* alter revision date + time of the file */
    l_status = sys$qiow (0, w_chan, IO$_MODIFY, &r_iosb, 0, 0,
                        &r_fib_dsc, &r_filnam_dsc, 0, 0, &r_atr, 0);
    if (l_status != SS$_NORMAL) goto vms__utime_error;
 
    l_status = r_iosb[0]; /* do not 'optimize' away - l_status is used later */
    if (l_status != SS$_NORMAL) goto vms__utime_error;
 
    l_status = sys$dassgn (w_chan);
    /* ignore errors */

    return 0; 

/* ----------------------------------------*/
vms__utime_error:
    switch (l_status)
    {
	case RMS$_FNF:
	case SS$_NOSUCHDEV:
	case SS$_NOSUCHNODE:
	case SS$_NOSUCHOBJ:
	case SS$_NOSUCHUSER:
	case SS$_NOSUCHFILE:
		errno = ENOENT;
		break;
	case RMS$_SYN:
		errno = ENOTDIR;
		break;
	default:
		errno = EACCES;
		break;
    }
    return (-1);
} /* vms__cvt_u2v_time() */

/* ------------------------------------------------------------------------- */

/* EOF: VMS__UTIME.C */
