/* VMS_KGBDEF.C -- 04-APR-1996 Uwe Zessin

   29-NOV-1997 ZE. -- changes for Python V1.5B1
*/

/* ---------------------------------------- */

#include "python.h"

#include <kgbdef.h>

/* ------------------------------------------------------------------------- */
static char* vms_kgbdef_doc_string = "$KGBDEF";

static char* vms_kgbdef_version_string = "OpenVMS VAX V6.1";

/* ------------------------------------------------------------------------- */
static struct PyMethodDef vms_kgbdef_methods[] = {
	{NULL,			NULL}
};

void
initvms_kgbdef()
{
	PyObject *m, *d, *x;

	m = Py_InitModule("vms_kgbdef", vms_kgbdef_methods);
	d = PyModule_GetDict(m);
/*	vms_kgbdef_error = PyString_FromString("vms_kgbdef.error");
/*	if (vms_kgbdef_error == NULL || PyDict_SetItemString(d, "error", vms_kgbdef_error) != 0)
/*	    Py_FatalError("can't define vms_kgbdef.error"); */

	/* ----- ----- ----- ----- */
	/* Resource may be charged to identifier */
	x = PyInt_FromLong(KGB$M_RESOURCE);
	PyDict_SetItemString(d, "KGB_M_RESOURCE", x);

	/* Identifier may be enabled or disabled */
	x = PyInt_FromLong(KGB$M_DYNAMIC);
	PyDict_SetItemString(d, "KGB_M_DYNAMIC", x);

	/* Identifier will not be used in protection checks */
	x = PyInt_FromLong(KGB$M_NOACCESS);
	PyDict_SetItemString(d, "KGB_M_NOACCESS", x);

	/* Identifier denotes active protected subsystem */
	x = PyInt_FromLong(KGB$M_SUBSYSTEM);
	PyDict_SetItemString(d, "KGB_M_SUBSYSTEM", x);

	/* Identifier can be used for impersonation */
	x = PyInt_FromLong(KGB$M_IMPERSONATE);
	PyDict_SetItemString(d, "KGB_M_IMPERSONATE", x);

	/* Holder records are restricted */
	x = PyInt_FromLong(KGB$M_HOLDER_HIDDEN);
	PyDict_SetItemString(d, "KGB_M_HOLDER_HIDDEN", x);

	/* $IDTOASC or $ASCTOID translationis restricted */
	x = PyInt_FromLong(KGB$M_NAME_HIDDEN);
	PyDict_SetItemString(d, "KGB_M_NAME_HIDDEN", x);

	/* Define the values for the optional $GRANTID/$REVOKID FLAGS argument. */
	/* local rights */
	x = PyInt_FromLong(KGB$K_PROCESS);
	PyDict_SetItemString(d, "KGB_K_PROCESS", x);

	/* system rights */
	x = PyInt_FromLong(KGB$K_SYSTEM);
	PyDict_SetItemString(d, "KGB_K_SYSTEM", x);

	/* local rights (extended) */
	x = PyInt_FromLong(KGB$K_EXTENDED);
	PyDict_SetItemString(d, "KGB_K_EXTENDED", x);

	/* image (protected subsystem) rights */
	x = PyInt_FromLong(KGB$K_IMAGE);
	PyDict_SetItemString(d, "KGB_K_IMAGE", x);

	/* image (protected subsystem) rights */
	x = PyInt_FromLong(KGB$K_SUBSYSTEM);
	PyDict_SetItemString(d, "KGB_K_SUBSYSTEM", x);

	/* ----- ----- ----- ----- */

	/* info about this module */
	PyDict_SetItemString(d, "__doc__",
			PyString_FromString(vms_kgbdef_doc_string));
	PyDict_SetItemString(d, "__version__",
			PyString_FromString(vms_kgbdef_version_string));

	/* ----- ----- ----- ----- */
	/* Check for errors */
        if (PyErr_Occurred())
                Py_FatalError("can't initialize module vms_kgbdef");
	/* ----- ----- ----- ----- */

} /* initvms_kgbdef () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_KGBDEF.C */
