/* VMS_LBR.C -- 07-JAN-1998 Uwe Zessin

   interface to (some) OpenVMS LBR$ routines

28-OCT-1998 ZE. -- cleanups, fix wrong if and bad descriptor setup
26-DEC-1998 ZE. -- fix memory leaks Py_INC/XDECREF(Python function objects)

@@ ** WARNING! This routine is not fully debugged !!
*/

/* ---------------------------------------- */

#include "python.h"
/* includes also: <string.h>, <errno.h> */

#include <lib$routines.h>	/* LIB$name */
#include <libdef.h>		/* LIB$_name */
#include <ssdef.h>		/* SS$_NAME */

#include <descrip.h>

#include "vmsdef.h"

/* ---------------------------------------- */
/* there is no LBR$ROUTINES.H */
#ifdef __DECC
#ifndef __DECC_VER	/* don't know if this is defined in all versions ... */
#define __DECC_VER 0
#endif /* __DECC_VER */
#if (__DECC_VER <= 50690003) /* @@ might need to change for newer version */
#ifndef __unknown_params
#define __unknown_params ...
#endif
#pragma __nostandard	  /* non-ANSI-Standard feature */
unsigned long lbr$output_help(__unknown_params);
#pragma __standard
#endif /* __DECC_VER <= 50600000 */
#endif /* __DECC */

/* ------------------------------------------------------------------------- */
static PyObject *vms_lbr_Error;		/* exception vms_lbr.error */

static char vms_lbr__doc__ [] =
"This is an interface to some OpenVMS LBR$ routines.\n\
See the VMS_LBR documentation for details.";

static char vms_lbr_t_cant_init [] =
"can't initialize module vms_lbr";

static char vms_lbr_t_cant_deferr [] =
"can't define vms_lbr.error";

/* ------------------------------------------------------------------------- */

/*  Output Help Messages */

/* LBR$OUTPUT_HELP  output_routine [,output_width]
                    [,line_desc] [,library_name] [,flags]
                    [,input_routine]
*/

static PyObject * vms_lbr__ar_output_routine; /* Python callback routine */
static PyObject * vms_lbr__ar_input_routine;  /* Python callback routine */

/* ---------------------------------------- */
static unsigned long vms_lbr__output_routine
    (struct dsc$descriptor_s * ar_message_string)
{
	PyObject * ar_py_message_string;
	PyObject * ar_status;

	ar_py_message_string = Py_BuildValue ("(s#)",
	    ar_message_string->dsc$a_pointer,
	    (unsigned int)ar_message_string->dsc$w_length);
	if (ar_py_message_string == NULL)
	{
	    (void) PyErr_Print();
	    return SS$_ABORT;		/* assume error has been set up */
	}
	ar_status = PyObject_CallObject
		   (vms_lbr__ar_output_routine, ar_py_message_string);
	Py_DECREF(ar_py_message_string);	/* drop this object */
	if (ar_status == NULL)
	{
	    (void) PyErr_Print();
	    return SS$_ABORT;		/* assume error has been set up */
	}
	return SS$_NORMAL;
} /* vms_lbr__output_routine() */

/* ---------------------------------------- */
static unsigned long vms_lbr__input_routine
    (struct dsc$descriptor_s * ar_resultant_string
    ,struct dsc$descriptor_s * ar_prompt_string
    ,unsigned short int	     * w_resultant_length )
{
	PyObject * ar_py_prompt_string;

	/* data from Python callback routine */
	PyObject	* ar_py_return_data;
	PyObject	* ar_py_status;
	PyObject	* ar_py_resultant_string;
	char		* at_resultant_string;
	unsigned long	  l_resultant_string_len;
	unsigned long	  l_status;

/*	printf("vms_lbr__input_routine:ar_prompt_string->dsc$a_ptr=%d\n"
..		,ar_prompt_string->dsc$a_pointer);
..	printf("vms_lbr__input_routine:ar_resultant_string->dsc$w_length=%d\n"
..		,ar_resultant_string->dsc$w_length);
..
..	printf("vms_lbr__input_routine:ar_resultant_string->dsc$a_ptr=%d\n"
..		,ar_resultant_string->dsc$a_pointer);
*/
	ar_py_prompt_string = Py_BuildValue ("(s#)",
	    ar_prompt_string->dsc$a_pointer,
	    (unsigned int)ar_prompt_string->dsc$w_length);
	if (ar_py_prompt_string == NULL)
	{
	    (void) PyErr_Print();
	    return SS$_ABORT;		/* assume error has been set up */
	}
	ar_py_return_data = PyObject_CallObject
		   (vms_lbr__ar_input_routine, ar_py_prompt_string);

	Py_DECREF(ar_py_prompt_string);
	if (ar_py_return_data == NULL)
	{
	    PyErr_SetString(PyExc_TypeError,
		"input_routine returned NULL instead tuple (integer,string)");
	    (void) PyErr_Print();
	    return SS$_ABORT;		/* assume error has been set up */
	}

	if (!PyTuple_Check(ar_py_return_data))
	{
	    PyErr_SetString(PyExc_TypeError,
		"input_routine must return tuple (integer,string)");
	    (void) PyErr_Print();
	    return SS$_ABORT;		/* assume error has been set up */
	}
	else
	{
	  unsigned long		l_tuplesize;

	  l_tuplesize = PyTuple_Size(ar_py_return_data);
	  if (l_tuplesize != 2)
	  {
	    PyErr_SetString(PyExc_TypeError,
		"input_routine must return 2-tuple (integer,string)");
	    (void) PyErr_Print();
	    return SS$_ABORT;		/* assume error has been set up */
	  }	  
	}

	ar_py_status = PyTuple_GetItem(ar_py_return_data, 0);
	if (!PyInt_Check(ar_py_status))
	{
	    PyErr_SetString(PyExc_TypeError,
		"input_routine: must return tuple (@integer,string)");
	    (void) PyErr_Print();
	    return SS$_ABORT;		/* assume error has been set up */
	}
	l_status = PyInt_AsLong(ar_py_status);
	/* @@ if (PyErr_Occurred()) */

	ar_py_resultant_string = PyTuple_GetItem(ar_py_return_data, 1);
	if (!PyString_Check(ar_py_resultant_string))
	{
	    PyErr_SetString(PyExc_TypeError,
		"input_routine: must return tuple (integer,@string)");
	    (void) PyErr_Print();
	    return SS$_ABORT;		/* assume error has been set up */
	}
	at_resultant_string    = PyString_AS_STRING(ar_py_resultant_string);
	l_resultant_string_len = PyString_Size(ar_py_resultant_string);
	at_resultant_string[l_resultant_string_len]='\0';
	printf("inp:str=%s=\n", at_resultant_string);

	/* store resultant string in descriptor provided by LBR$OUTPUT_HELP() */
	/* truncate input string, if necessary */
	(void) memcpy
	    (ar_resultant_string->dsc$a_pointer
	    ,at_resultant_string
	    ,(size_t) (l_resultant_string_len <
                       (unsigned int)ar_resultant_string->dsc$w_length)
		? l_resultant_string_len
		: (unsigned int)ar_resultant_string->dsc$w_length
	    );
	if (ar_resultant_string->dsc$w_length > l_resultant_string_len)
	{
	    ar_resultant_string->dsc$w_length = l_resultant_string_len;
	}

	Py_DECREF(ar_py_return_data);
/*	printf("vms_lbr__input_routine:ar_resultant_string=%s\n"
..		,at_resultant_string);
..	printf("vms_lbr__input_routine:l_status=%d\n"
..		,l_status);
*/
	return SS$_NORMAL;
} /* vms_lbr__input_routine() */

/* ---------------------------------------- */
static char vms_lbr_gt_helplib [] = "HELPLIB";	/* default HELP library */

static PyObject *
vms_lbr_output_help (PyObject *self, PyObject *args)
{
	PyObject		* ar_output_routine;
	unsigned long		* al_output_routine;

	PyObject		* ar_output_width;
	unsigned long		  l_output_width;
	unsigned long		* al_output_width;

	char			* at_line_desc;
	struct dsc$descriptor_s   r_line_desc;
	struct dsc$descriptor_s * ar_line_desc;
	unsigned long		  l_line_desc_len;

	char			* at_library_name;
	struct dsc$descriptor_s   r_library_name;
	struct dsc$descriptor_s * ar_library_name;
	unsigned long		  l_library_name_len;

	PyObject		* ar_flags;
	unsigned long		  l_flags;
	unsigned long		* al_flags;

	PyObject		* ar_input_routine;
	unsigned long		  l_input_routine;
	unsigned long		* al_input_routine;

	unsigned long		  l_status;

	/* -------------------- */
	ar_output_width    = Py_None;
	at_line_desc       = NULL;    l_line_desc_len    = 0;
	at_library_name    = NULL;    l_library_name_len = 0;
	ar_flags           = Py_None;
	ar_input_routine   = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "O|Oz#z#OO",
	    &ar_output_routine,
	    &ar_output_width,
	    &at_line_desc,    &l_line_desc_len,
	    &at_library_name, &l_library_name_len,
	    &ar_flags,
	    &ar_input_routine))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: output_routine */
	if (ar_output_routine == Py_None)
	{
	    /* This is a different behaviour than LBR$OUTPUT_HELP !! */
	    /* If argument 1 is None, then LIB$PUT_OUTPUT is used */
	    al_output_routine = (unsigned long *)&lib$put_output;
	    vms_lbr__ar_output_routine = NULL;
	}
	else
	{
	    /* argument must be a Python function object */
	    if (!PyFunction_Check (ar_output_routine ))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 1: output-routine - must be function or None");
		return NULL;
	    }
	    vms_lbr__ar_output_routine = ar_output_routine; /* store object */
	    al_output_routine = (unsigned long *)&vms_lbr__output_routine;
	}

	/* -------------------- */
	/* argument 2: output-width */
	if (ar_output_width == Py_None)
	{
	    al_output_width = 0;		/* skip argument */
	}
	else
	{
	    if (!PyInt_Check(ar_output_width))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: output-width - must be integer or None");
		return NULL;
	    }
	    l_output_width = PyInt_AsLong(ar_output_width);
	    if (PyErr_Occurred())
	    {
		Py_XDECREF(vms_lbr__ar_output_routine);
		return NULL;
	    }
	    al_output_width = &l_output_width;
	}

	/* -------------------- */
	/* argument 3: line-desc */
	if (at_line_desc == NULL)
	{
	    ar_line_desc = 0;
	}
	else
	{
            if (l_line_desc_len > 65535)
            {
		PyErr_SetString(PyExc_ValueError,
	    "argument 3: line-desc - string size limited to 65535 characters");
		return NULL;
	    }
	    r_line_desc.dsc$w_length  = l_line_desc_len;
	    r_line_desc.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_line_desc.dsc$b_class   = DSC$K_CLASS_S;
	    r_line_desc.dsc$a_pointer = at_line_desc;
	    ar_line_desc = &r_line_desc;
	}

	/* -------------------- */
	/* argument 4: library-name */
	if (at_library_name == NULL)
	{
	    /* provide a default */
	    at_library_name    = &vms_lbr_gt_helplib[0];
	    l_library_name_len = strlen(at_library_name);
	}
	else
	{
	    if (l_library_name_len > 65535)
            {
		PyErr_SetString(PyExc_ValueError,
	 "argument 4: library-name - string size limited to 65535 characters");
		return NULL;
	    }
	    r_library_name.dsc$w_length  = l_library_name_len;
	    r_library_name.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_library_name.dsc$b_class   = DSC$K_CLASS_S;
	    r_library_name.dsc$a_pointer = at_library_name;
	    ar_library_name = &r_library_name;
	}

	/* -------------------- */
	/* argument 5: flags */
	if (ar_flags == Py_None)
	{
	    al_flags = 0;		/* skip argument */
	}
	else
	{
	    if (!PyInt_Check(ar_flags))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 5: flags - must be integer or None");
		return NULL;
	    }
	    l_flags = PyInt_AsLong(ar_flags);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_flags = &l_flags;
	}

	/* -------------------- */
	/* argument 6: input-routine */
	if (ar_input_routine == Py_None)
	{
	    /* If argument 6 is omitted, then LIB$GET_INPUT is used */
	    al_input_routine = (unsigned long *)&lib$get_input;
	    vms_lbr__ar_input_routine = NULL;
	}
	else
	{
	    /* argument must be a Python function object */
	    if (!PyFunction_Check (ar_input_routine))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 6: input-routine - must be function or None");
		return NULL;
	    }
	    vms_lbr__ar_input_routine = ar_input_routine; /* store object */
	    al_input_routine = (unsigned long *)&vms_lbr__input_routine;
	}

	/* -------------------- */
	Py_XINCREF(vms_lbr__ar_output_routine);
	Py_XINCREF(vms_lbr__ar_input_routine);

	/* -------------------- */
	/* @@ use a dummy condition handler to trap signals */
	/*   see LIB$FIND_IMAGE_SYMBOL() */
	l_status = lbr$output_help
		(al_output_routine
		,al_output_width
		,ar_line_desc
		,ar_library_name
		,al_flags
		,al_input_routine
		);

	/* -------------------- */
	/* release Python function objects */
	Py_XDECREF(vms_lbr__ar_output_routine);
	Py_XDECREF(vms_lbr__ar_input_routine);

	/* -------------------- */
	if (l_status == SS$_ABORT)
	{
	    /* special return code from a callback-routine */
	    /* assume Python-error has been set up */
	    return NULL;
	}

	return PyInt_FromLong(l_status);
} /* vms_lbr_output_help() */

/* ------------------------------------------------------------------------- */

static struct PyMethodDef vms_lbr_methods[] = {
	{"output_help",	   (PyCFunction)vms_lbr_output_help,  METH_VARARGS},
	{NULL,		NULL}		 /* Sentinel */
};

/* ---------------------------------------- */

void
initvms_lbr()
{
	PyObject *m, *d, *l, *s, *v;
	vmsdef_xr_defdirtbl* ar_defdirtbl;

	m = Py_InitModule4("vms_lbr",
			   vms_lbr_methods,
			   vms_lbr__doc__,
			   (PyObject *)NULL,
			   PYTHON_API_VERSION);
        d = PyModule_GetDict(m);

	/* -------------------- */
        if (PyErr_Occurred())
	{
	    (void) Py_FatalError(vms_lbr_t_cant_init);
	}

	/* -------------------- */
	/* Initialize exception */
	vms_lbr_Error = PyErr_NewException("vms_lbr.error", NULL, NULL);
	if (vms_lbr_Error == NULL)
	{
	    (void) Py_FatalError(vms_lbr_t_cant_deferr);
	}

	if (PyDict_SetItemString(d, "error", vms_lbr_Error) != 0)
	{
	    (void) Py_FatalError(vms_lbr_t_cant_deferr);
	}
} /* initvms_lbr() */

/* ------------------------------------------------------------------------ */

/* EOF: VMS_LBR.C */
