/* VMS_LIB_ADD_TIMES.C -- 29-NOV-1998 Uwe Zessin
   Python interface to LIB$ADD_TIMES
*/


#include "python.h"
#include "vmsdef.h"

#include <lib$routines.h>	/* LIB$name */
#include <libdef.h>		/* LIB$_name */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */

/* input a binary quadword - output a Python long integer */
extern PyObject * vms__cvt_quad2pylong (long q_quadword[2]);

/* ------------------------------ */
/* input a Python long integer - output a binary quadword */
extern long vms__cvt_pylong2quad (PyObject * r_longint, long * q_quadword);

/* ------------------------------------------------------------------------- */

char vms_lib_add_times__doc[] =
"resultant_time = vms_lib.add_times (time1, time2)\n\
Add Two Quadword Times.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_add_times (PyObject *self, PyObject *args)
{
	PyObject	* ar_time1;
	long		  q_time1[2];

	PyObject	* ar_time2;
	long		  q_time2[2];

	long		  q_resultant_time[2];

	unsigned long	  l_status;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "OO", &ar_time1, &ar_time2))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: time1 */
	if (!PyLong_Check(ar_time1))
	{
	    PyErr_SetString(PyExc_TypeError,
		"argument 1: must be long integer");
	    return NULL;
	}

	/* convert Python long integer to binary quadword */
	l_status = vms__cvt_pylong2quad (ar_time1, &q_time1[0]);
	if (l_status == -1)
	{
	    return NULL;	/* error string has been set */
	}
	
	/* -------------------- */
	/* argument 2: time2 */
	if (!PyLong_Check(ar_time2))
	{
	    PyErr_SetString(PyExc_TypeError,
		"argument 2: must be long integer");
	    return NULL;
	}

	/* convert Python long integer to binary quadword */
	l_status = vms__cvt_pylong2quad (ar_time2, &q_time2[0]);
	if (l_status == -1)
	{
	    return NULL;	/* error string has been set */
	}

	/* -------------------- */
	l_status = lib$add_times
		(&q_time1[0]
		,&q_time2[0]
		,&q_resultant_time[0]
		);

	/* -------------------- */
	if (l_status == LIB$_NORMAL)	/* note: _not_ SS$_NORMAL !! */
	{
	    /* convert binary quadword to Python long integer */
	    return vms__cvt_quad2pylong (&q_resultant_time[0]);
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status);
} /* vms_lib_add_times () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_ADD_TIMES.C */
