/* VMS_LIB_ASN_WTH_MBX.C -- 29-NOV-1998 Uwe Zessin
   Python interface to LIB$ASN_WTH_MBX
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>		/* DSC$...   */
#include <lib$routines.h>	/* LIB$name  */
#include <ssdef.h>		/* SS$_name  */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */

char vms_lib_asn_wth_mbx__doc[] =
"device-channel, mailbox-channel = \
vms_lib.asn_wth_mbx (device-name, [maximum-message-size], [buffer-quota])\n\
Assign channel with mailbox.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_asn_wth_mbx (PyObject *self, PyObject *args)
{
	char			* at_device_name;
	struct dsc$descriptor_s   r_device_name;
	unsigned long		  l_device_name_len;

	PyObject		* ar_maximum_message_size;
	unsigned long		  l_maximum_message_size;
	unsigned long		* al_maximum_message_size;

	PyObject		* ar_buffer_quota;
	unsigned long		  l_buffer_quota;
	unsigned long		* al_buffer_quota;

	unsigned short int	  w_device_channel;
	unsigned short int	  w_mailbox_channel;

	unsigned long		  l_status;

	/* -------------------- */
	ar_maximum_message_size = Py_None;
	ar_buffer_quota		= Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#|OO",
	    &at_device_name, &l_device_name_len,
	    &ar_maximum_message_size,
	    &ar_buffer_quota))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: device-name */
	if (l_device_name_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	  "argument 1: device-name - string size limited to 65535 characters");
	    return NULL;
	}
	r_device_name.dsc$w_length  = l_device_name_len;
	r_device_name.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_device_name.dsc$b_class   = DSC$K_CLASS_S;
	r_device_name.dsc$a_pointer = at_device_name;

	/* -------------------- */
	/* argument 2: maximum-message-size */
	if (ar_maximum_message_size == Py_None)
	{
	    al_maximum_message_size = 0;	/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_maximum_message_size))
	    {
		PyErr_SetString(PyExc_TypeError,
		 "argument 2: maximum-message-size - must be integer or None");
		return NULL;
	    }

	    l_maximum_message_size = PyInt_AsLong(ar_maximum_message_size);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_maximum_message_size = &l_maximum_message_size;
	}

	/* -------------------- */
	/* argument 3: buffer-quota */
	if (ar_buffer_quota == Py_None)
	{
	    al_buffer_quota = 0;		/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_buffer_quota))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 3: buffer-quota - must be integer or None");
		return NULL;
	    }

	    l_buffer_quota = PyInt_AsLong(ar_buffer_quota);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_buffer_quota = &l_buffer_quota;
	}

	/* -------------------- */
	l_status = lib$asn_wth_mbx
		(&r_device_name
		,al_maximum_message_size
		,al_buffer_quota
		,&w_device_channel
		,&w_mailbox_channel
		);

	/* -------------------- */
	if (l_status == SS$_NORMAL)
	{
	    return Py_BuildValue ("ii",
		(unsigned int)w_device_channel,
		(unsigned int)w_mailbox_channel);
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status);
} /* vms_lib_asn_wth_mbx() */

/* ------------------------------------------------------------------------- */
/*
--  memory leak tests  --

-----

# -- check 1
import vms_lib
import vms_sys
while (1):
  devchn, mbxchn = vms_lib.asn_wth_mbx ("TT",44,33)
  vms_sys.dassgn (devchn)
  vms_sys.dassgn (mbxchn)
# -while

-----

# -- check 2
#    all channels get used - use '$ SHOW PROCESS/CONTINUOUS'
#    from a different process because CONTROL-T doesn't work
import vms_lib
import vms_sys
while (1):
  try:
    devchn, mbxchn = vms_lib.asn_wth_mbx ("TT",44,33)
    # don't deassign channels - this creates an error
  except:
    pass
# -while

-----
*/

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_ASN_WTH_MBX.C */
