/* VMS_LIB_ATTACH.C -- 31-DEC-1998 Uwe Zessin
   Python interface to LIB$ATTACH
*/


#include "python.h"
#include "vmsdef.h"

#include <lib$routines.h>	/* LIB$name  */
#include <ssdef.h>		/* SS$_name  */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */

char vms_lib_attach__doc[] =
"vms_lib.attach (pid)\n\
Attach terminal to process.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_attach (PyObject *self, PyObject *args)
{
	unsigned long	l_process_id;
	unsigned long	l_status;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "l", &l_process_id))
	{
	    return NULL;
	}

	/* -------------------- */
	l_status = lib$attach (&l_process_id);

	/* -------------------- */
	if (l_status == SS$_NORMAL)
	{
	    Py_INCREF(Py_None);
	    return Py_None;
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status);
} /* vms_lib_attach() */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_ATTACH.C */
