/* VMS_LIB_CONVERT_DATE_STRING.C -- 25-JUL-1999 Uwe Zessin
   Python interface to LIB$CONVERT_DATE_STRING

*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name  */
#include <libdef.h>		/* LIB$_name */
#include <ssdef.h>		/* SS$_name  */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */

/* input a binary quadword - output a Python long integer */
PyObject * vms__cvt_quad2pylong (long q_quadword[2]);

/* ------------------------------------------------------------------------- */

char vms_lib_convert_date_str__doc[] =
"status, context, date_time, defaulted_fields =\
 vms_lib.convert_date_string (date-string, [user-context],\
 [flags], [defaults])\n\
Convert Date String to Quadword.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_convert_date_string (PyObject *self, PyObject *args)
{
	char			* at_date_string;
	struct dsc$descriptor_s   r_date_string;
	unsigned long		  l_date_string_len;

	long			  q_date_time[2];
	PyObject		* ar_date_time;

	PyObject		* ar_user_context;
	unsigned long		  l_user_context;
	unsigned long		* al_user_context;

	PyObject		* ar_flags;
	unsigned long		  l_flags;
	unsigned long		* al_flags;

	PyObject		* ar_defaults;
	unsigned long		  l_tuple_size;
	unsigned long		  l_tuple_index;
	unsigned long		  l_tuple_element;
	PyObject		* ar_tuple_element;
	unsigned short int	  w_defaults[7]; /* LIB$CVT_VECTIM, $NUMTIM */
/* #define K_YEAR_SINCE_0         0 */
/* #define K_MONTH_OF_YEAR        1 */
/* #define K_DAY_OF_MONTH         2 */
/* #define K_HOUR_OF_DAY          3 */
/* #define K_MINUTE_OF_HOUR       4 */
/* #define K_SECOND_OF_MINUTE     5 */
/* #define K_HUNDREDTHS_OF_SECOND 6 */
	unsigned short		* aw_defaults;

	unsigned long		  l_defaulted_fields;

	unsigned long		  l_status_lib;

	PyObject		* ar_return;

	/* -------------------- */
	ar_user_context = Py_None;
	l_user_context  = 0;
	ar_flags        = Py_None;
	ar_defaults     = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#|OOO",
	    &at_date_string, &l_date_string_len,
	    &ar_user_context,
	    &ar_flags,
	    &ar_defaults ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: date_string */
	if (l_date_string_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	  "argument 1: date-string - string size limited to 65535 characters");
	    return NULL;
	}
	r_date_string.dsc$w_length  = l_date_string_len;
	r_date_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_date_string.dsc$b_class   = DSC$K_CLASS_S;
	r_date_string.dsc$a_pointer = at_date_string;

	/* -------------------- */
	/* argument 2: user-context */
	if (ar_user_context == Py_None)
	{
	    al_user_context = 0;	/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_user_context))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: user-context - must be integer or None");
		return NULL;
	    }
	    l_user_context = PyInt_AsLong(ar_user_context);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_user_context = &l_user_context;
	}

	/* -------------------- */
	/* argument 3: flags */
	if (ar_flags == Py_None)
	{
	    al_flags = 0;		/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_flags))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 3: flags - must be integer or None");
		return NULL;
	    }
	    l_flags = PyInt_AsLong(ar_flags);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_flags = &l_flags;
	}

	/* -------------------- */
	/* argument 4: defaults */
	if (ar_defaults == Py_None)
	{
	    aw_defaults = 0;		/* omitted */
	}
	else
	{
	    if (!PyTuple_Check(ar_defaults))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 4: defaults - must be a tuple of 7 integers");
		return NULL;
	    }

	    l_tuple_size = PyTuple_Size(ar_defaults);
	    if (l_tuple_size != 7)
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 4: defaults - must be a tuple of 7 integers");
		return NULL;
	    }

	    for (l_tuple_index = 0; l_tuple_index < 7; l_tuple_index++)
	    {
		ar_tuple_element = PyTuple_GetItem(ar_defaults, l_tuple_index);
		if (ar_tuple_element == NULL)
		{
		    return NULL;
		}
		if (!PyInt_Check(ar_tuple_element))
		{
		    return PyErr_Format(PyExc_TypeError,
		   "argument 4: defaults - tuple-element:%d is not an integer",
		    l_tuple_index);
		}

		l_tuple_element = PyInt_AsLong(ar_tuple_element);
		if (PyErr_Occurred())
		{
		    return NULL;
		}

		if (l_tuple_element > 65535)
		{
		    return PyErr_Format(PyExc_TypeError,
	     "argument 4: defaults - tuple-element:%d is not a 16-bit integer",
		    l_tuple_index);
		}

		w_defaults[l_tuple_index] = l_tuple_element;
	    }
	    aw_defaults = &w_defaults[0];
	}

	/* -------------------- */
	l_status_lib = lib$convert_date_string
		(&r_date_string
		,&q_date_time
		,al_user_context
		,al_flags
		,aw_defaults
		,&l_defaulted_fields
		);

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	    PyObject * ar_return;

	    /* convert binary quadword to Python long integer */
	    ar_date_time = vms__cvt_quad2pylong (&q_date_time[0]);
	    if (ar_date_time == NULL)
	    {
		return NULL;	/* error string has been set */
	    }

	    if (al_user_context == 0)
	    {
		ar_return = Py_BuildValue ("lOOl", l_status_lib,
		    Py_None, ar_date_time, l_defaulted_fields);
	    }
	    else
	    {
		ar_return = Py_BuildValue ("llOl", l_status_lib,
		    l_user_context, ar_date_time, l_defaulted_fields);
	    }
	    Py_DECREF(ar_date_time);
	    return ar_return;
	}

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	}


	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status_lib);
} /* vms_lib_convert_date_string () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_CONVERT_DATE_STRING.C */
